/*! ****************************************************************************
 * Pixi Maps v1.1.0
 *
 * A collection of SVG and Raster Maps written in vanilla Javascript.
 * Copyright (c) 2020 Mobilabs <contact@mobilabs.fr> (http://www.mobilabs.fr).
 * Released under the MIT license. You may obtain a copy of the License
 * at: http://www.opensource.org/licenses/mit-license.php).
 *
 * Pixi includes portions of code for easing equations.
 * Open source under the BSD License.
 * Copyright (c) 2001 Robert Penner
 * ************************************************************************** */
!function(t,e){"use strict";"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?module.exports=e(t):t.Pixi=e(t)}(this,t=>{"use strict";let e,r,o,i={src:{pixi:{},piximap:{},util:{deviceutil:{}},lib:{Easing:null,Messenger:null,overslash:null,SVG:null,TaskQ:null},libin:{Chart:null,Copyright:null,Keypad:null,Legend:null,Snapshot:null,Tooltip:null,Overlay:null,MapGL:null},maps:{_gmap:{main:{},renderer:{},eventsclick:{},eventsmouse:{},eventsoverlay:{},eventstouch:{},move:{},util:{}},geojson:{main:{},renderer:{},util:{}},raster:{main:{},renderer:{},util:{}},vector:{main:{}}}},extend:function(t,e){for(var r=Object.keys(e),o=0;o<r.length;o++)t[r[o]]=e[r[o]]}};return function(){const r=t.Pixi;e={_setTestMode:()=>i.src,noConflict(){return t.Pixi=r,this},load(t,e){const r=new XMLHttpRequest;r.onreadystatechange=function(){4===r.readyState&&(200===r.status||0===r.status?e(!1,r,r.responseText):e(!0,r))},r.open("GET",t,!0),r.send(null)}},e.VERSION="@mobilabs/piximaps v1.1.0"}(),function(){const t=i.src.maps.geojson.main,r=i.src.maps.raster.main,o=i.src.maps.vector.main;e.Map=function(...e){return function(...e){const[i,n,...a]=e,s="[object String]"===Object.prototype.toString.call(i)?i:"body";switch(n.type){case"geojson":return t.GeoJSON(s,n,...a);case"raster":return r.Raster(s,n,...a);case"vector":return o.Vector(s,n,...a);default:throw new Error(`The map ${n.type} is unknown!`)}}(...e)}}(),function(){let t;const e=function(){o||(window.removeEventListener("touchstart",e),o=!0)};r=function(e){o&&(null===t?t=setTimeout(()=>{t=null},250):(clearTimeout(t),t=null,e()))},window.addEventListener("touchstart",e)}(),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Easing&&(t.Easing=e(t))):t.Easing=e(t)}(i.src.lib,t=>{let e;return function(){const r=t.Easing;e={noConflict(){return t.Easing=r,this},linear:(t,e,r,o)=>r*t/o+e,swing:(t,e,r,o)=>r*(.5-Math.cos(t/o*Math.PI)/2)+e,easeInSine:(t,e,r,o)=>-r*Math.cos(t/o*(Math.PI/2))+r+e,easeOutSine:(t,e,r,o)=>r*Math.sin(t/o*(Math.PI/2))+e,easeInOutSine:(t,e,r,o)=>-r/2*(Math.cos(Math.PI*t/o)-1)+e,easeInQuad:(t,e,r,o)=>r*(t/=o)*t+e,easeOutQuad:(t,e,r,o)=>-r*(t/=o)*(t-2)+e,easeInOutQuad:(t,e,r,o)=>(t/=o/2)<1?r/2*t*t+e:-r/2*(--t*(t-2)-1)+e,easeInCubic:(t,e,r,o)=>r*(t/=o)*t*t+e,easeOutCubic:(t,e,r,o)=>r*((t=t/o-1)*t*t+1)+e,easeInOutCubic:(t,e,r,o)=>(t/=o/2)<1?r/2*t*t*t+e:r/2*((t-=2)*t*t+2)+e,easeInQuart:(t,e,r,o)=>r*(t/=o)*t*t*t+e,easeOutQuart:(t,e,r,o)=>-r*((t=t/o-1)*t*t*t-1)+e,easeInOutQuart:(t,e,r,o)=>(t/=o/2)<1?r/2*t*t*t*t+e:-r/2*((t-=2)*t*t*t-2)+e,easeInQuint:(t,e,r,o)=>r*(t/=o)*t*t*t*t+e,easeOutQuint:(t,e,r,o)=>r*((t=t/o-1)*t*t*t*t+1)+e,easeInOutQuint:(t,e,r,o)=>(t/=o/2)<1?r/2*t*t*t*t*t+e:r/2*((t-=2)*t*t*t*t+2)+e,easeInExpo:(t,e,r,o)=>0===t?e:r*Math.pow(2,10*(t/o-1))+e,easeOutExpo:(t,e,r,o)=>t===o?e+r:r*(1-Math.pow(2,-10*t/o))+e,easeInOutExpo:(t,e,r,o)=>0===t?e:t===o?e+r:(t/=o/2)<1?r/2*Math.pow(2,10*(t-1))+e:r/2*(2-Math.pow(2,-10*--t))+e,easeInCirc:(t,e,r,o)=>-r*(Math.sqrt(1-(t/=o)*t)-1)+e,easeOutCirc:(t,e,r,o)=>r*Math.sqrt(1-(t=t/o-1)*t)+e,easeInOutCirc:(t,e,r,o)=>(t/=o/2)<1?-r/2*(Math.sqrt(1-t*t)-1)+e:r/2*(Math.sqrt(1-(t-=2)*t)+1)+e,easeInBack:(t,e,r,o,i)=>(void 0===i&&(i=1.70158),r*(t/=o)*t*((i+1)*t-i)+e),easeOutBack:(t,e,r,o,i)=>(void 0===i&&(i=1.70158),r*((t=t/o-1)*t*((i+1)*t+i)+1)+e),easeInOutBack:(t,e,r,o,i)=>(void 0===i&&(i=1.70158),(t/=o/2)<1?r/2*(t*t*((1+(i*=1.525))*t-i))+e:r/2*((t-=2)*t*((1+(i*=1.525))*t+i)+2)+e),easeInElastic(t,e,r,o){var i=1.70158,n=0,a=r;return 0===t?e:1==(t/=o)?e+r:(n||(n=.3*o),a<Math.abs(r)?(a=r,i=n/4):i=n/(2*Math.PI)*Math.asin(r/a),-a*Math.pow(2,10*(t-=1))*Math.sin((t*o-i)*(2*Math.PI)/n)+e)},easeOutElastic(t,e,r,o){var i=1.70158,n=0,a=r;return 0===t?e:1==(t/=o)?e+r:(n||(n=.3*o),a<Math.abs(r)?(a=r,i=n/4):i=n/(2*Math.PI)*Math.asin(r/a),a*Math.pow(2,-10*t)*Math.sin((t*o-i)*(2*Math.PI)/n)+r+e)},easeInOutElastic(t,e,r,o){var i=1.70158,n=0,a=r;return 0===t?e:2==(t/=o/2)?e+r:(n||(n=o*(.3*1.5)),a<Math.abs(r)?(a=r,i=n/4):i=n/(2*Math.PI)*Math.asin(r/a),t<1?a*Math.pow(2,10*(t-=1))*Math.sin((t*o-i)*(2*Math.PI)/n)*-.5+e:a*Math.pow(2,-10*(t-=1))*Math.sin((t*o-i)*(2*Math.PI)/n)*.5+r+e)},easeInBounce(t,e,r,o){return r-this.easeOutBounce(o-t,0,r,o)+e},easeOutBounce:(t,e,r,o)=>(t/=o)<1/2.75?r*(7.5625*t*t)+e:t<2/2.75?r*(7.5625*(t-=1.5/2.75)*t+.75)+e:t<2.5/2.75?r*(7.5625*(t-=2.25/2.75)*t+.9375)+e:r*(7.5625*(t-=2.625/2.75)*t+.984375)+e,easeInOutBounce(t,e,r,o){return t<o/2?.5*this.easeInBounce(2*t,0,r,o)+e:.5*this.easeOutBounce(2*t-o,0,r,o)+.5*r+e}},e.VERSION="0.0.1"}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Messenger&&(t.Messenger=e(t))):t.Messenger=e(t)}(i.src.lib,t=>{let e,r;return function(){const o=t.Messenger;let i;e=function(){const t=Object.create(i);return t._db={},t},e.VERSION="0.0.1",e.noConflict=function(){return t.Messenger=o,this},i={subscribe(t,e){return r.subscribe(this._db,t,e),this},subscribeOnce(t,e){return r.subscribeOnce(this._db,t,e),this},unsubscribe(t,e){return r.unsubscribe(this._db,t,e),this},publish(t,e){return r.publish(this._db,t,e),this}}}(),function(){function t(t,e){"string"==typeof e&&function(t,e){Object.prototype.hasOwnProperty.call(t,e)||(t[e]={listeners:[],listenersOnce:[]})}(t,e)}r={subscribe(e,r,o){!function(e,r,o){t(e,r),"string"==typeof r&&"function"==typeof o&&Object.prototype.hasOwnProperty.call(e,r)&&e[r].listeners.push(o)}(e,r,o)},subscribeOnce(e,r,o){!function(e,r,o){t(e,r),"string"==typeof r&&"function"==typeof o&&Object.prototype.hasOwnProperty.call(e,r)&&e[r].listenersOnce.push(o)}(e,r,o)},unsubscribe(t,e,r){!function(t,e,r){let o;"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&(o=t[e].listeners.indexOf(r),o>=0&&t[e].listeners.splice(o,1),o=t[e].listenersOnce.indexOf(r),o>=0&&t[e].listenersOnce.splice(o,1))}(t,e,r)},publish(t,e,r){!function(t,e,r){if("string"==typeof e&&Object.prototype.hasOwnProperty.call(t,e)){for(let o=0;o<t[e].listeners.length;o++)t[e].listeners[o](r);for(let o=0;o<t[e].listenersOnce.length;o++)t[e].listenersOnce[o](r);t[e].listenersOnce.splice(0,t[e].listenersOnce.length)}}(t,e,r)}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.overslash&&(t.overslash=e(t))):t.overslash=e(t)}(i.src.lib,t=>{let e,r;return r=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},function(){const r=t.overslash;e={noConflict(){return t.overslash=r,this}},e.VERSION="1.0.0"}(),r(e,{isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isNaN(t){return this.isNumber(t)&&t!==+t},isOdd(t){const e=t%2;return t===parseFloat(t)?!!e:void 0}}),r(e,{isObject(t){const e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),isFunction:t=>"[object Function]"===Object.prototype.toString.call(t),isArray:t=>"[object Array]"===Object.prototype.toString.call(t),isMath:t=>"[object Math]"===Object.prototype.toString.call(t),isDate:t=>"[object Date]"===Object.prototype.toString.call(t),isEmpty(t){let e;if(null===t)return!0;if(this.isArray(t)||this.isString(t))return 0===t.length;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}}),r(e,{clone(t){const e=this.isArray(t)?[]:{};let r;if(this.isObject(t)){for(r in t)this.isArray(t[r])?e[r]=this.clone(t[r]):this.isObject(t[r])?e[r]=this.extend(t[r]):e[r]=t[r];return e}},extend(t){let e,r;if(!this.isObject(t))return t;for(let o=1;o<arguments.length;o++)for(r in e=arguments[o],e)this.isLiteralObject(arguments[o][r])?(t[r]=void 0!==t[r]?t[r]:{},this.extend(t[r],arguments[o][r])):hasOwnProperty.call(e,r)&&(t[r]=this.isArray(e[r])?this.clone(e[r]):e[r]);return t},keys:t=>Object.keys(t),forPropIn(t,e){this.keys(t).forEach(r=>{({}).hasOwnProperty.call(t,r)&&e(r)})},assign(){const t=arguments[0];let e,r,o;for(o=1;o<arguments.length;o++)e=arguments[o],r=Object.keys(e).reduce((t,r)=>(t[r]=Object.getOwnPropertyDescriptor(e,r),t),{});return Object.defineProperties(t,r),t}}),r(e,{contains:(t,e)=>-1!==t.indexOf(e),flatten(t,e){let r,o=[],i=0;if(this.isArray(t)){if(e)return[].concat.apply([],t);for(r=0;r<t.length;r++)this.isArray(t[r])?(o=o.concat(this.flatten(t[r])),i=o.length):o[i++]=t[r];return o}},max(t){let e,r=null;if(!this.isArray(t))return;const o=this.flatten(t);for(e=0;e<o.length;e++)(null===r||r<o[e])&&(r="number"==typeof o[e]?o[e]:r);return null!==r?r:void 0},min(t){let e,r=null;if(!this.isArray(t))return;const o=this.flatten(t);for(e=0;e<o.length;e++)(null===r||r>o[e])&&(r="number"==typeof o[e]?o[e]:r);return null!==r?r:void 0},share(t){const e=[];let r,o,i;for(o=0;o<t.length;o++)if(r=t[o],!this.contains(e,r)){for(i=1;i<arguments.length&&this.contains(arguments[i],r);i++);i===arguments.length&&e.push(r)}return e}}),r(e,{}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.SVG&&(t.SVG=e(t))):t.SVG=e(t)}(i.src.lib,t=>{const e="http://www.w3.org/2000/svg",r="http://www.w3.org/1999/xlink";let o,i;const n={Dollar:{Public:{}},SVG:{Public:{}},Anim:{Public:{}},Methods:{Static:{Public:{}},Attr:{Public:{}},Text:{Public:{}}}};return function(){const e=n.Dollar.Public,r=n.SVG.Public,a=n.Methods.Static.Public,s=t.SVG;let l;o=function(t){const n=Object.create(i.extend(l,e)),{id:a,_root:s}=r.create(t);return n.id=a,n._root=s,n._SVG=o,n},o._setTestMode=function(){return n},o.noConflict=function(){return t.SVG=s,this},o.transformAttrToObj=function(t){return a.transformAttrToObj(t)},o.transformAttrToStr=function(t){return a.transformAttrToStr(t)},o.getArc=function(t,e,r,o){return a.getArc(t,e,r,o)},o.getLine=function(t,e){return a.getLine(t,e)},o.getMultipolyline=function(t,e){return a.getMultipolyline(t,e)},l={},o.VERSION="0.0.3"}(),i={extend(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]];return t},isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isObject(t){const e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),isFunction:t=>"[object Function]"===Object.prototype.toString.call(t),isArray:t=>"[object Array]"===Object.prototype.toString.call(t),elinear:(t,e,r,o)=>r*t/o+e},function(){const t=n.Dollar.Public,o=n.Methods.Attr.Public,a=n.Methods.Text.Public;i.extend(t,{$:function(t){const{id:i}=this,{_root:n}=this;return{id:i,0:t?n.querySelector(t):n,_root:n,firstParent:function(){return this._root&&(this[0]=this._root),this},parent:function(){return this.root?this[0]!==this.root&&(this[0]=this[0].parentNode):this[0]=this[0].parentNode,this},previous:function(){return this[0]=this[0].previousElementSibling,this},next:function(){return this[0]=this[0].nextElementSibling,this},select:function(t){return this[0]=this[0].querySelector(t),this},append:function(t){const r=document.createElementNS(e,t);return this[0]=this[0].appendChild(r),this},appendBefore:function(t,r){const o=document.createElementNS(e,t),i=this[0].querySelector(r);return this[0].insertBefore(o,i),this[0]=o,this},appendAfter:function(t,r){const o=document.createElementNS(e,t),i=this[0].querySelector(r).nextElementSibling;return this[0].insertBefore(o,i),this[0]=o,this},appendHTML:function(t){if("string"!=typeof t)return this;const e=document.createElementNS("http://www.w3.org/1999/xhtml","body");return e.innerHTML=t,this[0]=this[0].appendChild(e),this},replace:function(t){const r=document.createElementNS(e,t);return this[0].parentNode.replaceChild(r,this[0]),this[0]=r,this},remove:function(){let t;return this[0]&&(t=this[0].parentNode,t.removeChild(this[0]),this[0]=t),this},removeChild:function(t){return t&&this[0].removeChild(t),this},replaceChild:function(t,e){return t&&this[0].replaceChild(t,e),this},removeAllChilds:function(){for(;this[0].firstChild;)this[0].removeChild(this[0].firstChild);return this},empty:function(){for(;this[0].firstChild;)this[0].removeChild(this[0].firstChild);return this},listen:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].addEventListener(t,e),this},listenOnce:function(t,e){const r=this[0];return"string"==typeof t&&"function"==typeof e&&r.addEventListener(t,(function o(i){r.removeEventListener(t,o),e(i)})),this},unlisten:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].removeEventListener(t,e),this},alink:function(t,e){return this[0].setAttributeNS(r,`xlink:${t}`,e),this},attr:function(t,e){return this[0]?(o.attr(this[0],t,e),this):(console.log("warning: this.svgElement is null!"),this)},rmattr:function(t){return this[0].removeAttributeNS(null,t),this},text:function(t){return a.text(this[0],t),this},addClass:function(t){let e=this[0].getAttributeNS(null,"class");return e=e?`${e} ${t}`:t,this[0].setAttributeNS(null,"class",e),this},removeClass:function(t){let e=this[0].getAttributeNS(null,"class");return e&&(e=e.replace(t,"").replace(/(^\s+|\s+$)/g,""),this[0].setAttributeNS(null,"class",e)),this},toggleClass:function(t){const e=this[0].getAttributeNS(null,"class");return e&&e.match(t)?(this.removeClass(t),this):(this.addClass(t),this)},query:function(t){return this[0].querySelector(t)},getElement:function(){return this[0]},children:function(){return this[0].children},getAttribute:function(t){return this[0]?this[0].getAttribute(t):null},getComputedStyle:function(){return window.getComputedStyle(this[0])},getPropertyValue:function(t){return this.getPropertyValue(t)},getSize:function(){return{width:this[0].getBoundingClientRect().width,height:this[0].getBoundingClientRect().height}},getBbox:function(){return{top:this[0].getBoundingClientRect().top,left:this[0].getBoundingClientRect().left,width:this[0].getBoundingClientRect().width,height:this[0].getBoundingClientRect().height}}}}})}(),function(){const t=n.Anim.Public;i.extend(t,{rotateRun(t,e){!function(t,e){const r={a:0,t:0,start:i.isNumber(e.start)?e.start:null,stop:i.isNumber(e.stop)?e.stop:180,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3};if(i.isNull(r.start)){const e=o.transformAttrToObj(t.getAttribute("transform"));r.start=i.isObject(e.scale)&&i.isNumber(e.scale.a)?e.scale.a:180}const n=setInterval(()=>{r.t+=r.period,(r.t>r.duration||r.stop===r.start)&&(r.t=r.duration),r.a=r.easing(r.t,r.start,r.stop-r.start,r.duration);const e=o.transformAttrToObj(t.getAttribute("transform"));e.rotate.a=r.a,t.setAttributeNS(null,"transform",o.transformAttrToStr(e)),r.t===r.duration&&clearInterval(n)},r.period)}(t,e)},scaleRun(t,e){!function(t,e){const r={x:0,y:0,t:0,x0:i.isObject(e.start)&&i.isNumber(e.start.x)?e.start.x:null,y0:i.isObject(e.start)&&i.isNumber(e.start.y)?e.start.y:null,x1:i.isObject(e.stop)&&i.isNumber(e.stop.x)?e.stop.x:1,y1:i.isObject(e.stop)&&i.isNumber(e.stop.y)?e.stop.y:1,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3},n=o.transformAttrToObj(t.getAttribute("transform"));(i.isNull(r.x0)||i.isNull(r.y0))&&(r.x0=i.isObject(n.scale)&&i.isNumber(n.scale.x)?n.scale.x:0,r.y0=i.isObject(n.scale)&&i.isNumber(n.scale.y)?n.scale.y:0);const a=setInterval(()=>{r.t+=r.period,r.t>r.duration&&(r.t=r.duration),r.x=r.easing(r.t,r.x0,r.x1-r.x0,r.duration),r.y=r.easing(r.t,r.y0,r.y1-r.y0,r.duration);const e=o.transformAttrToObj(t.getAttribute("transform"));e.scale.x=r.x,e.scale.y=r.y,t.setAttributeNS(null,"transform",o.transformAttrToStr(e)),r.t===r.duration&&clearInterval(a)},r.period)}(t,e)},translateRun(t,e){!function(t,e){const r={x:0,y:0,t:0,length:null,arc:null,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3};let n,a;if(e.start&&i.isNumber(e.start.x)&&i.isNumber(e.start.y))n=e.start.x,a=e.start.y;else{const e=o.transformAttrToObj(t.getAttribute("transform"));n=i.isObject(e.translate)&&i.isNumber(e.translate.x)?e.translate.x:0,a=i.isObject(e.translate)&&i.isNumber(e.translate.y)?e.translate.x:0}r.length=Math.sqrt(Math.pow(e.stop.x-n,2)+Math.pow(e.stop.y-a,2)),r.arc=Math.atan((e.stop.y-a)/(e.stop.x-n)),e.stop.x-n<0&&(r.arc+=-Math.PI),0===r.length&&(r.arc=0);const s=setInterval(()=>{r.t+=r.period,r.t>r.duration&&(r.t=r.duration),r.x=r.easing(r.t,0,r.length,r.duration)*Math.cos(r.arc)+n,r.y=r.easing(r.t,0,r.length,r.duration)*Math.sin(r.arc)+a;const e=o.transformAttrToObj(t.getAttribute("transform"));e.translate.x=r.x,e.translate.y=r.y,t.setAttributeNS(null,"transform",o.transformAttrToStr(e)),r.t===r.duration&&clearInterval(s)},r.period)}(t,e)},textRun(t,e){!function(t,e){const r={period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,value:0,start:i.isNumber(e.start)?e.start:0,stop:i.isNumber(e.stop)?e.stop:0,t:0,duration:i.isNumber(e.duration)?e.duration:2e3},o=setInterval(()=>{r.t+=r.period,(r.t>r.duration||r.stop===r.start)&&(r.t=r.duration),r.value=r.easing(r.t,r.start,r.stop-r.start,r.duration),0===r.duration&&(r.value=r.start),t.textContent=r.value.toFixed(0),r.t===r.duration&&clearInterval(o)},r.period)}(t,e)}})}(),function(){const t=n.Methods.Attr.Public,e=n.Anim.Public;i.extend(t,{attr(t,r,o){!function(t,r,o){switch(typeof o){case"string":case"number":t.setAttributeNS(null,r,o);break;case"object":switch(r){case"transform":switch(o.type){case"rotate":e.rotateRun(t,o);break;case"scale":e.scaleRun(t,o);break;case"translate":e.translateRun(t,o);break;default:throw new Error(`The animation is not supported for the transform ${o.type}!`)}break;default:throw new Error(`The animation is not supported for the attribute ${r}!`)}}}(t,r,o)}})}(),function(){const t=n.Methods.Static.Public;i.extend(t,{transformAttrToObj:t=>(function(t){const e="string"==typeof t?t:"",r=/[+-]?((?:[1-9]\d*|0)(?:\.\d*)?|\.\d+)([eE][+-]?\d+)?/g,o=/translate(.*?)\)/,i=/scale(.*?)\)/,n=/rotate(.*?)\)/,a=/skewX(.*?)\)/,s=/skewY(.*?)\)/,l=null===e.match(o)?null:function(){let t,i;const n=e.match(o)[0].match(r);return n?1===n.length?(t=parseFloat(n[0],10),i=t):(t=parseFloat(n[0],10),i=parseFloat(n[1],10)):(t=null,i=null),{x:t,y:i}}(),c=null===e.match(i)?null:function(){let t,o;const n=e.match(i)[0].match(r);return n?1===n.length?(t=parseFloat(n[0],10),o=t):(t=parseFloat(n[0],10),o=parseFloat(n[1],10)):(t=null,o=null),{x:t,y:o}}(),u=null===e.match(n)?null:function(){let t,o,i;const a=e.match(n)[0].match(r);return a?1===a.length?(t=parseFloat(a[0],10),o=null,i=null):2===a.length?(t=parseFloat(a[0],10),o=parseFloat(a[1],10),i=o):(t=parseFloat(a[0],10),o=parseFloat(a[1],10),i=parseFloat(a[2],10)):(t=null,o=null,i=null),{a:t,cx:o,cy:i}}(),h=null===e.match(a)?null:e.match(a)[0].match(r)?parseFloat(e.match(a)[0].match(r)[0],10):null,d=null===e.match(s)?null:e.match(s)[0].match(r)?parseFloat(e.match(s)[0].match(r)[0],10):null;return{translate:l,scale:c,rotate:u,matrix:(e.match(/matrix(.*?)\)/),null),skewX:h,skewY:d}})(t),transformAttrToStr:t=>(function(t){let e="";return t.translate&&"number"==typeof t.translate.x&&("number"==typeof t.translate.y?e+="translate("+t.translate.x+", "+t.translate.y+") ":e+="translate("+t.translate.x+", 0) "),t.scale&&"number"==typeof t.scale.x&&("number"==typeof t.scale.y?e+="scale("+t.scale.x+", "+t.scale.y+") ":e+="scale("+t.scale.x+", "+t.scale.x+") "),t.rotate&&"number"==typeof t.rotate.a&&("number"==typeof t.rotate.cx&&"number"==typeof t.rotate.cy?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cy+") ":"number"==typeof t.rotate.cx?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cx+") ":e+="rotate("+t.rotate.a+") "),"number"==typeof t.skewX&&(e+="skewX("+t.skewX+") "),"number"==typeof t.skewY&&(e+="skewY("+t.skewY+") "),e.replace(/(^\s+|\s+$)/g,"")})(t),getArc:(t,e,r,o)=>(function(t,e,r,o){t=void 0!==t?t:0,e=void 0!==e?e:0,r=void 0!==r?r:0,(t%=2*Math.PI)>2*Math.PI&&(t%=2*Math.PI),e>2*Math.PI&&(e%=2*Math.PI);let i=0;Math.abs(e-t)>Math.PI&&(i=1);const n=Math.cos(t),a=Math.sin(t),s=Math.cos(e),l=Math.sin(e);let c="";return void 0!==o&&(c="L"+s*o+","+l*o+"A"+o+","+o+" 0 "+i+",0 "+n*o+","+a*o+"Z"),"M"+n*r+","+a*r+"A"+r+","+r+" 0 "+i+",1 "+s*r+","+l*r+c})(t,e,r,o),getLine:(t,e)=>(function(t,e){let r="";return t.forEach(t=>{null!==t.x&&null!==t.y&&(""===r?r=`M${t.x}, ${t.y}`:r+=`L${t.x},${t.y}`)}),!0===e&&(r+="Z"),r})(t,e),getMultipolyline:(t,e)=>(function(t,e){let r,o,i,n;for(r="",i=0;i<t.length;i++){for(o="",n=0;n<t[i].length;n++)null!==t[i][n].x&&null!==t[i][n].y&&(""===o?o=`M${t[i][n].x},${t[i][n].y}`:o+=`L${t[i][n].x}, ${t[i][n].y}`);!0===e&&(o+="z"),r+=o}return r})(t,e)})}(),function(){const t=n.SVG.Public;i.extend(t,{create:t=>(function(t){const o="string"==typeof t?t:"body",i=document.querySelector(o)||document.querySelector("body");let n,a=`i${Math.random().toString(36).substr(2,7)}`;const s=i.getElementsByTagNameNS(e,"svg")[0];if(s&&0!==s.length)a=s.getAttributeNS(null,"id"),n=s;else{const t=document.createElementNS(e,"svg");t.setAttributeNS(null,"id",a),t.setAttributeNS(null,"version","1.1"),t.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",e),t.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink",r),i.appendChild(t),n=t}return{id:a,_root:n}})(t)})}(),function(){const t=n.Methods.Text.Public,e=n.Anim.Public;i.extend(t,{text(t,r){!function(t,r){switch(typeof r){case"number":case"string":t.textContent=r;break;case"object":e.textRun(t,r)}}(t,r)}})}(),o}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.TaskQ&&(t.TaskQ=e(t))):t.TaskQ=e(t)}(i.src.lib,t=>{let e,r={src:{taskq:{},private:{taskq:{}}},extend:function(t,e){for(var r=Object.keys(e),o=0;o<r.length;o++)t[r[o]]=e[r[o]]}};return function(){const o=r.src.private.taskq,i=t.TaskQ;let n;e=function(){const t=Object.create(n);return t._dQ={},t},e.VERSION="0.0.2",e.noConflict=function(){return t.TaskQ=i,this},n={pushQ(t,e){return o.pushQ(this._dQ,t,e),this},popQ(t,e){return o.popQ(this._dQ,t,e),this}}}(),function(){function t(t,e){"string"!=typeof e||Object.prototype.hasOwnProperty.call(t,e)||(t[e]={firing:!1,listeners:[]})}const e={pushQ(e,r,o){t(e,r),"string"==typeof r&&"function"==typeof o&&(e[r].listeners.push(o),e[r].firing||function(t,e,r){const o=t[e].listeners;t[e].firing=!0,function i(){o.length>0?o.shift().apply(r||{},[i].concat(Array.prototype.slice.call(arguments,0))):t[e].firing=!1}()}(e,r))},popQ(e,r,o){t(e,r),"string"==typeof r&&"function"==typeof o&&(e[r].listeners.push(o),e[r].firing||function(t,e,r){const o=t[e].listeners;t[e].firing=!0,function i(){if(o.length>0){for(;o.length>1;)o.shift();o.shift().apply(r||{},[i].concat(Array.prototype.slice.call(arguments,0)))}else t[e].firing=!1}()}(e,r))}};r.extend(r.src.private.taskq,e)}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Chart&&(t.Chart=e(t))):t.Chart=e(t)}(i.src.libin,t=>{let e;return function(){const r=t.Chart;e={noConflict(){return t.Chart=r,this},extend(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]}},e.VERSION="0.0.4",e.extend(e,{data:{},dom:{},util:{}})}(),e.extend(e.data,{copySeries:(t,e,r,o)=>(function(t,e,r,o){const i=o.clone(t[0]);switch(r){case"area":case"bar":case"column":case"line":case"pie":case"polar":case"radar":case"barchartrace":case"waterfall":case"map":return!(!o.isArray(e)||o.isEmpty(e)||(t.splice(0),e.forEach((e,r)=>{t[r]=o.extend({},i,e)}),0));case"circle":case"gauge":return!!o.isNumber(e)&&(t[0]=o.extend({},i,{label:"Item 1",type:r,value:e}),!0);default:throw new Error(`_copySeries: the chart ${r} is not recognized!`)}})(t,e,r,o),computeGenericSettings(t){!function(t){const{chart:e}=t,{title:r}=t,{subtitle:o}=t,{legend:i}=t;r.x=null===r.x?e.width/2:r.x,r.y=null===r.y?15:r.y,o.x=null===o.x?e.width/2:o.x,o.y=null===o.y?35:o.y,i.enabled=null===i.enabled||i.enabled,i.floating=null===i.floating||i.floating,i.layout=null===i.layout?"vertical":i.layout,i.align.horizontal=null===i.align.horizontal?"right":i.align.horizontal,i.align.vertical=null===i.align.vertical?"top":i.align.vertical,i.shift.x=null===i.shift.x?0:i.shift.x,i.shift.y=null===i.shift.y?0:i.shift.y,i.icon.width=null===i.icon.width?10:i.icon.width,i.icon.height=null===i.icon.height?10:i.icon.height,i.icon.gap.x=null===i.icon.gap.x?.5*i.icon.width:i.icon.gap.x,i.icon.gap.y=null===i.icon.gap.y?.5*i.icon.height:i.icon.gap.y}(t)},computeGridSize(t,e,r){!function(t,e,r){const{chart:o}=t,{horizontal:i}=e.align,{vertical:n}=e.align;e.enabled&&!e.floating?"left"!==i||"top"!==n&&"middle"!==n&&"bottom"!==n?"middle"===i&&"top"===n?(o.grid.x=null===o.grid.x?o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?e.background.y+e.background.height+o.grid.margin.bottom:o.grid.y,o.grid.width=null===o.grid.width?o.width-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?o.height-o.grid.y-o.grid.margin.bottom:t.chart.grid.height):"middle"===i&&"middle"===n?(o.grid.x=null===o.grid.x?o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?o.grid.margin.top:o.grid.y,o.grid.width=null===o.grid.width?o.width-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?o.height-o.grid.y-o.grid.margin.bottom:o.grid.height):"middle"===i&&"bottom"===n?(o.grid.x=null===o.grid.x?o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?o.grid.margin.top:o.grid.y,o.grid.width=null===o.grid.width?o.width-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?e.background.y-o.grid.y-o.grid.margin.bottom:o.grid.height):(o.grid.x=null===o.grid.x?o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?o.grid.margin.top:o.grid.y,o.grid.width=null===o.grid.width?e.background.x-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?o.height-o.grid.y-o.grid.margin.bottom:o.grid.height):(o.grid.x=null===o.grid.x?e.background.x+e.background.width+o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?o.grid.margin.top:o.grid.y,o.grid.width=null===o.grid.width?o.width-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?o.height-o.grid.y-o.grid.margin.bottom:o.grid.height):(o.grid.x=null===o.grid.x?o.grid.margin.left:o.grid.x,o.grid.y=null===o.grid.y?o.grid.margin.top:o.grid.y,o.grid.width=null===o.grid.width?o.width-o.grid.x-o.grid.margin.right:o.grid.width,o.grid.height=null===o.grid.height?o.height-o.grid.y-o.grid.margin.bottom:o.grid.height),"charts"===r&&(o.grid.y+=o.grid.height)}(t,e,r)},setChartType(t,e){!function(t,e){switch(e){case"area":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type||"percent"===t.chart.type?`${t.chart.type} area`:"basic area";break;case"bar":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?`${t.chart.type} bar`:"basic bar";break;case"circle":t.chart.type="circle";break;case"column":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?`${t.chart.type} column`:"basic column";break;case"gauge":t.chart.type="gauge";break;case"line":t.chart.type="line";break;case"pie":t.chart.type="pie";break;case"polar":t.chart.type="polar";break;case"radar":t.chart.type="radar";break;case"barchartrace":t.chart.type="barchartrace";break;case"waterfall":t.chart.type="waterfall";break;case"map":t.chart.type="map";break;default:throw new Error(`_setChartType: this type "${e}" is unknown!`)}}(t,e)},normalizeSeries(t,e,r,o){!function(t,e){let r,o,i;if(!(e.xAxis&&e.xAxis.plot&&e.xAxis.plot.type)){if(e.xAxis.categories)r=e.xAxis.categories;else{if(!e.yAxis.categories)return;r=e.yAxis.categories}o=r.data.length;for(let e=0;e<t.length;e++)for(let o=0;o<r.data.length;o++)t[e].data[o]||(t[e].data[o]=0);0===o&&(r.data.push("???"),o=r.data.length);for(let e=0;e<t.length;e++)i=t[e].data.length,t[e].data.splice(o,i-o)}}(t,e)},setActiveArea:t=>(function(t){const e=t.xAxis.type||t.yAxis.type;switch(e){case"categories":return{x0:t.chart.grid.x,y0:t.chart.grid.y-t.chart.grid.height,width:t.chart.grid.width,height:t.chart.grid.height};case"plot":return{x0:t.chart.grid.x+t.xAxis.data.min,y0:t.chart.grid.y-t.chart.grid.height,width:t.xAxis.data.max-t.xAxis.data.min,height:t.chart.grid.height};default:throw new Error(`Pix.chart._setActiveArea: the type "${e}" is unknown!`)}})(t)}),e.extend(e.dom,{set(t,e,r,o){!function(t,e,r,o){t.$().attr("class",e).attr("width",r).attr("height",o)}(t,e,r,o)},fill(t){!function(t){t.$().append("defs").parent().append("g").attr("class","grid").parent().append("g").attr("class","series").parent().append("g").attr("class","header").parent().append("g").attr("class","legend").parent().append("g").attr("class","cursor").parent().append("g").attr("class","highlight").parent().append("g").attr("class","tooltip").parent().append("g").attr("class","activearea").parent().append("g").attr("class","copyright").parent().append("g").attr("class","footer").parent()}(t)},fillmap(t,e){!function(t,e){const{grid:r}=e.chart,{width:o}=r,{height:i}=r,n=r.x,a=r.y;t.$().select(".grid").remove().select(".cursor").remove().select(".highlight").remove(),t.$().appendAfter("g",".activearea").attr("class","keypad").parent().select(".series").attr("transform",`translate(${n}, ${a})`).append("svg").attr("class","maps").attr("width",o).attr("height",i).append("g").attr("class","geojson").attr("transform","translate(0, 0) scale(0, 0)").parent().append("g").attr("class","raster").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","vector").attr("transform","translate(0, 0) scale(1, 1)")}(t,e)}}),e.extend(e.dom,{drawGrid(t,e,r,o,i){switch(r.chart.type){case"basic bar":case"stacked bar":case"barchartrace":!function(t,e,r,o){const i=e.chart.grid.x,n=e.chart.grid.y,{length:a}=e.yAxis.categories.data,s=e.chart.grid.height/a,l=t.$();l.select(".grid").attr("transform",`translate(${i}, ${n}) scale(1, 1)`);for(let t=0;t<=e.xAxis.interval.number;t++)l.append("line").attr("class","x-axis").attr("x1",e.xAxis.interval.width*t).attr("y1",0).attr("x2",e.xAxis.interval.width*t).attr("y2",-e.chart.grid.height).parent().append("text").attr("class","x-axis").attr("x",e.xAxis.interval.width*t).attr("y",e.constants.gap.x).text(o.toRound(e.xAxis.minor*t+e.xAxis.min,e.xAxis.exp)).parent();for(let t=0;t<=a;t++)l.append("line").attr("class","-axis").attr("x1",0).attr("y1",s*t*-1).attr("x2",-3).attr("y2",s*t*-1).parent();for(let t=0;t<a;t++)l.append("text").attr("class","y-axis").attr("x",e.constants.gap.y).attr("y",s*(t+.5)*-1).text(e.yAxis.categories.data[t]).parent();l.append("text").attr("class","x-axis title").attr("transform","rotate(0)").attr("x",e.xAxis.title.x).attr("y",-1*e.xAxis.title.y).text(e.xAxis.title.label)}(t,r,0,i);break;default:!function(t,e,r,o,i){const n=r.chart.grid.x,a=r.chart.grid.y,{type:s}=r.xAxis;let l,c,u,h,d,p,g,y,m,f,b;const x=t.$();switch(x.select(".grid").attr("transform",`translate(${n}, ${a}) scale(1, 1)`),s){case"categories":l=r.xAxis.categories.data.length,c=r.chart.grid.width/l,h=3;for(let t=0;t<=l;t++)x.append("line").attr("class","x-axis").attr("x1",c*t).attr("y1",0).attr("x2",c*t).attr("y2",h).parent();!function(t,e){const{length:r}=e.xAxis.categories.data,o=e.chart.grid.width/r;let i,n;for(let a=0;a<r;a++){const r=e.xAxis.categories.data[a].split(" ");if(t.append("text").attr("class","x-axis").attr("x",o*(a+.5)).attr("y",e.constants.gap.x).text(e.xAxis.categories.data[a]),n=t.getSize(),n.width<o||1===r.length)t.parent();else{i=r[0];for(let e=1;e<r.length;e++)if(i+=` ${r[e]}`,t.text(i),n=t.getSize(),n.width>o){const i=r.slice(0,e).join(" "),s=r.slice(e).join(" ");t.text("").append("tspan").attr("x",o*(a+.5)).text(i).parent().append("tspan").attr("x",o*(a+.5)).attr("dy",n.height).text(s).parent().parent();break}}}}(x,r);break;case"plot":switch(d=6,h=5,p=r.xAxis.data.min,g=r.xAxis.data.max,y=r.xAxis.plot.start,m=e[0].data.length*r.xAxis.plot.increment,f=(g-p)/m,u=r.xAxis.plot.type,u){case"number":b=o.buildMarkers(y,m,6);break;case"datetime":b=o.buildDateMarkers(y,m,6);break;default:throw new Error(`Pix.chart._drawGrid: the subtype "${u}" is not supported!`)}for(let t=0;t<b.pos.length;t++)x.append("line").attr("class","x-axis").attr("x1",b.pos[t]*f+p).attr("y1",0).attr("x2",b.pos[t]*f+p).attr("y2",h).parent().append("text").attr("class","x-axis").attr("x",b.pos[t]*f+p).attr("y",18).text(b.label[t]).parent();break;default:throw new Error(`Pix.chart._drawGrid: the type "${s}" is not supported!`)}for(let t=0;t<=r.yAxis.interval.number;t++)x.append("line").attr("class","x-axis").attr("x1",0).attr("y1",-r.yAxis.interval.height*t).attr("x2",r.chart.grid.width).attr("y2",-r.yAxis.interval.height*t).parent().append("text").attr("class","y-axis").attr("x",r.constants.gap.y).attr("y",-r.yAxis.interval.height*t).text(i.toRound(r.yAxis.minor*t+r.yAxis.min,r.yAxis.exp)).parent();x.append("text").attr("class","y-axis title").attr("transform","rotate(-90)").attr("x",r.yAxis.title.y).attr("y",-1*r.yAxis.title.x).text(r.yAxis.title.label).parent(),x.parent()}(t,e,r,o,i)}}}),e.extend(e.dom,{drawHeader(t,r){return function(t){const{chart:e}=t,{title:r}=t,{subtitle:o}=t;r&&(r.x=r.x?r.x:e.width/2,r.y=r.y?r.y:15),o&&(o.x=o.x?o.x:e.width/2,o.y=o.y?o.y:35)}(r),function(t,e,r){r.title&&r.title.label&&e.$().select(".header").append("text").attr("class","title").attr("style",t.getStyle(r.title.style)).attr("x",r.title.x).attr("y",r.title.y).text(r.title.label),r.subtitle&&r.subtitle.label&&e.$().select(".header").append("text").attr("class","subtitle").attr("style",t.getStyle(r.subtitle.style)).attr("x",r.subtitle.x).attr("y",r.subtitle.y).text(r.subtitle.label)}(e.util,t,r),this},drawFooter(t,r){return function(t){const{footer:e}=t;e&&(e.x=e.x?e.x:0,e.y=e.y?e.y:t.chart.height-2)}(r),function(t,e,r){r.footer&&r.footer.label&&e.$().select(".footer").append("text").attr("class","text").attr("style",t.getStyle(r.footer.style)).attr("x",r.footer.x).attr("y",r.footer.y).text(r.footer.label)}(e.util,t,r),this}}),e.extend(e.dom,{addVerticalCursor(t,e){!function(t,e){e.cursor.enabled&&t.$().select(".cursor").attr("transform",`translate(${e.chart.grid.x}, ${e.chart.grid.y})`).attr("display","none").append("line").attr("class","cursorline").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",-e.yAxis.max*e.yAxis.scale)}(t,e)},moveVerticalCursor(t,e,r){!function(t,e,r){e.cursor.enabled&&t.$().select(".cursor").select(".cursorline").attr("x1",r).attr("y1",0).attr("x2",r).attr("y2",(e.yAxis.max-e.yAxis.min)*e.yAxis.scale*-1).parent().attr("display","inherit")}(t,e,r)},turnVerticalCursorOff(t){!function(t){t.$().select(".cursor").attr("display","none")}(t)}}),e.extend(e.dom,{highlightSelectedPoints(t,e,r){!function(t,e,r){if(!e.highlight.enabled)return;const o=t.$();o.select(".highlight").replace("g").attr("class","highlight").attr("transform",`translate(${e.chart.grid.x}, ${e.chart.grid.y})`).attr("display","none");for(let t=0;t<r.length;t++)o.append("circle").attr("class","outer").attr("style",`stroke: ${r[t].color}`).attr("cx",r[t].x).attr("cy",r[t].y).attr("r",6).parent().append("circle").attr("class","inner").attr("style",`fill: ${r[t].color}`).attr("cx",r[t].x).attr("cy",r[t].y).attr("r",3).parent();o.attr("display","inherit")}(t,e,r)},turnLightsOff(t,e){!function(t,e){e.highlight.enabled&&t.$().select(".highlight").attr("display","none")}(t,e)}}),e.extend(e.dom,{drawActiveArea(t,e){!function(t,e){t.$().select(".activearea").attr("transform",`translate(${e.x0}, ${e.y0})`)}(t,e)},drawActiveAreaMap(t,e){!function(t,e){const{grid:r}=e.chart,{width:o}=r,{height:i}=r,n=r.x,a=r.y;t.$().select(".activearea").attr("transform",`translate(${n}, ${a})`).append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",o).attr("height",i)}(t,e)},addEvents2ActiveArea(t,e,r,o){!function(t,e,r,o){t.$().select(".activearea").append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",e.width).attr("height",e.height).listen("mouseover",r).listen("mouseout",o)}(t,e,r,o)},addClickEvents2ActiveArea(t,e,r){!function(t,e,r){t.$().select(".activearea").append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",e.width).attr("height",e.height).listen("click",r)}(t,e,r)},addEvents2ActiveAreaMap(t,e,r){!function(t,e,r){e.$().select(".activearea").listenOnce("mousemove",r.firstmousemove.bind(t)).listen("mousemove",r.mousemove.bind(t)).listen("wheel",r.zoom.bind(t)).listen("mousedown",r.drag.bind(t)).listenOnce("touchstart",r.firsttouchstart.bind(t)).listen("touchstart",r.touchstart.bind(t)).listen("touchmove",r.touchmove.bind(t),{passive:!1}).listen("touchend",r.touchend.bind(t)).listen("click",r.click.bind(t)).listen("dblclick",r.dblClick.bind(t)).firstParent()}(t,e,r)}}),e.extend(e.util,{getStyle:t=>(function(t){let e="";return"[object Object]"!==Object.prototype.toString.call(t)?"inherit":(e+=t.fillColor?`fill:${t.fillColor};`:"",e+=t.fillOpacity?`fill-opacity:${t.fillOpacity};`:"",e+=t.stroke?`stroke:${t.stroke};`:"",e+=t.strokeOpacity?`stroke-opacity:${t.strokeOpacity};`:"",e+=t.strokeWidth?`stroke-width:${t.strokeWidth};`:"",e||"inherit")})(t)}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Copyright&&(t.Copyright=e(t))):t.Copyright=e(t)}(i.src.libin,t=>{let e,r;return function(){const o=t.Copyright;e={noConflict(){return t.Copyright=o,this},draw(t){r.draw(t)},fill(t,e,o){r.fill(t,e,o),r.place(t,e),r.addBackground(t,e,o)},shift(t,e,o){r.shift(t,e,o)}},e.VERSION="0.0.3"}(),function(){function t(t,e){void 0!==e.copyleft.text&&t.$().select(".copyright").select(".text").select(".xlink1").select(".t1").text(e.copyleft.text),void 0!==e.copyleft.url&&t.$().select(".copyright").select(".text").select(".xlink1").alink("href",e.copyleft.url),void 0!==e.copyright.text&&t.$().select(".copyright").select(".text").select(".xlink2").select(".t2").text(e.copyright.text),void 0!==e.copypost&&void 0!==e.copypost.text&&t.$().select(".copyright").select(".text").select(".t3").text(e.copypost.text),void 0!==e.copyright.url&&t.$().select(".copyright").select(".text").select(".xlink2").alink("href",e.copyright.url),void 0!==e.title&&t.$().select(".copyright").select(".text").select(".title").text(e.title)}r={draw(t){!function(t){const e=t.$();e.select(".copyright").attr("transform","translate(0, 0)"),e.append("rect").attr("class","background").attr("rx",0).attr("ry",0).attr("x",0).attr("y",0).attr("width",0).attr("height",0).parent(),e.append("text").attr("class","text"),e.append("a").alink("href","#").attr("class","xlink1").append("tspan").attr("class","t1").text("").parent().parent(),e.append("a").alink("href","#").attr("class","xlink2").append("tspan").attr("class","t2").attr("dx","5").text("").parent().parent(),e.append("tspan").attr("class","t3").attr("dx","5").text("").parent(),e.append("title").attr("class","title").text("")}(t)},fill(e,r,o){!function(e,r,o){switch(o){case"classic":t(e,{copyleft:{text:"Pixi Charts",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Artelsys",url:"http://www.artelsys.com"},title:"Copyright (c) 2020 Artelsys. All Rights Reserved."});break;case"naturalearth":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Natural Earth",url:"http://www.naturalearthdata.com"},title:"Copyright (c) 2020 Artelsys. Made with free vector and raster map data @ naturalearthdata.com."});break;case"openstreetmap":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© OpenStreetMap",url:"http://www.openstreetmap.org/copyright"},copypost:{text:"contributors"},title:"Copyright (c) 2020 Artelsys. Made with raster map data @ openstreetmap.com."});break;case"datagouv":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Data.Gouv.fr",url:"https://www.data.gouv.fr/en/"},copypost:{text:"contributors"},title:"Copyright (c) 2020 Artelsys. Made with data @ data.gouv.fr - licence ODbl."});break;default:throw new Error(`Pix.Libs.Copyright.fill: this "${o}" is unknown!`)}}(e,0,o)},place(t,e){!function(t,e){const r=t._SVG,o=t.$(),i=o.select(".copyright").getSize(),n=r.transformAttrToObj(o.getAttribute("transform"));n.translate.x=e.chart.width+n.translate.x-i.width-2,n.translate.y=e.chart.height+n.translate.y-2,o.attr("transform",r.transformAttrToStr(n))}(t,e)},addBackground(t,e,r){!function(t,e,r){const o=t._SVG,i=t.$();if("openstreetmap"===r){const t={x:-2},e=i.select(".copyright").getSize();t.y=2-e.height,t.width=e.width+4,t.height=e.height+2;const r=o.transformAttrToObj(i.getAttribute("transform"));r.translate.x-=2,r.translate.y-=4,i.attr("transform",o.transformAttrToStr(r)).select(".background").attr("rx",2).attr("ry",2).attr("x",t.x).attr("y",t.y).attr("width",t.width).attr("height",t.height)}}(t,0,r)},shift(t,e,r){!function(t,e,r){const o=t._SVG,i=t.$();i.select(".copyright");const n=o.transformAttrToObj(i.getAttribute("transform"));n.translate.x+=e,n.translate.y+=r,i.attr("transform",o.transformAttrToStr(n))}(t,e,r)}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Keypad&&(t.Keypad=e(t))):t.Keypad=e(t)}(i.src.libin,t=>{let e,r,o;return function(){const o=t.Keypad;let i;e=function(t,e){const r=Object.create(i);return r._ehandlers={map:t||null,default:null,shift:null,zoom:null},r._svg=e||null,r},e.VERSION="0.0.2",e.noConflict=function(){return t.Keypad=o,this},i={draw(t,e,o){return"touch"===t?r.drawTouch(this._svg,e,o):r.drawClassic(this._svg,e,o),this},attachEventListeners(t,e,o,i){return this._ehandlers={map:t,default:e,shift:o,zoom:i},r.attachEventListeners(this,this._svg),this},getSize:t=>r.getSize(t)}}(),r={drawClassic(t,e,r){!function(t,e,r){const o=t._SVG,i=t.$();if(!1===e.keypad)return;const n=3,a=3,s=17,l=76.5+2*n,c=51+2*a,u={zup:[8.5+n,s+a,"zup"],zdown:[8.5+n,34+a,"zdown"],left:[34+n,25.5+a,"left"],up:[51+n,8.5+a,"up"],center:[51+n,25.5+a,"center"],down:[51+n,42.5+a,"down"],right:[68+n,25.5+a,"right"]},h={zup:[[{x:u.zup[0]-4,y:u.zup[1]},{x:u.zup[0]+4,y:u.zup[1]}],[{x:u.zup[0],y:u.zup[1]-4},{x:u.zup[0],y:u.zup[1]+4}]],zdown:[[{x:u.zdown[0]-4,y:u.zdown[1]},{x:u.zdown[0]+4,y:u.zdown[1]}]],left:[[{x:u.left[0]+3,y:u.left[1]-4},{x:u.left[0]-3,y:u.left[1]},{x:u.left[0]+3,y:u.left[1]+4}]],up:[[{x:u.up[0]-4,y:u.up[1]+3},{x:u.up[0],y:u.up[1]-3},{x:u.up[0]+4,y:u.up[1]+3}]],center:[[{x:u.center[0]-4,y:u.center[1]-4},{x:u.center[0]+4,y:u.center[1]+4}],[{x:u.center[0]+4,y:u.center[1]-4},{x:u.center[0]-4,y:u.center[1]+4}]],down:[[{x:u.down[0]-4,y:u.down[1]-3},{x:u.down[0],y:u.down[1]+3},{x:u.down[0]+4,y:u.down[1]-3}]],right:[[{x:u.right[0]-3,y:u.right[1]-4},{x:u.right[0]+3,y:u.right[1]},{x:u.right[0]-3,y:u.right[1]+4}]]},d=r.chart.width-l-2,p=r.chart.height-c-2;i.select(".keypad").attr("transform",`translate(${d}, ${p})`),i.append("rect").attr("class","background").attr("x",.5).attr("y",0).attr("rx",2).attr("ry",2).attr("width",l+.5).attr("height",c+.5).parent();const g=Object.keys(u);for(let t=0;t<g.length;t++)i.append("rect").attr("class",`key ${u[g[t]][2]}`).attr("x",u[g[t]][0]-7.5).attr("y",u[g[t]][1]-7.5).attr("rx",2).attr("ry",2).attr("width",15).attr("height",15).parent().append("path").attr("class",`icon ${g[t]}`).attr("d",o.getMultipolyline(h[u[g[t]][2]])).parent()}(t,e,r)},drawTouch(t,e,r){!function(t,e,r){const o=20,i=t._SVG,n=t.$(),a=r.chart.width-22,s=r.chart.height-135+o;if(!1===e.keypad)return;const l={zup:{cx:0,cy:0,r:o,class:"zup"},center:{cx:0,cy:45,r:o,class:"center"},zdown:{cx:0,cy:90,r:o,class:"zdown"}},c={zup:[[{x:l.zup.cx-8,y:l.zup.cy},{x:l.zup.cx+8,y:l.zup.cy}],[{x:l.zup.cx,y:l.zup.cy-8},{x:l.zup.cx,y:l.zup.cy+8}]],center:[[{x:l.center.cx-8,y:l.center.cy-8},{x:l.center.cx+8,y:l.center.cy+8}],[{x:l.center.cx+8,y:l.center.cy-8},{x:l.center.cx-8,y:l.center.cy+8}]],zdown:[[{x:l.zdown.cx-8,y:l.zdown.cy},{x:l.zdown.cx+8,y:l.zdown.cy}]]};n.select(".keypad").attr("transform",`translate(${a}, ${s})`).removeAllChilds();const u=Object.keys(l);for(let t=0;t<u.length;t++)n.append("circle").attr("class",`touch ${l[u[t]].class}`).attr("cx",l[u[t]].cx).attr("cy",l[u[t]].cy).attr("r",l[u[t]].r).parent().append("path").attr("class",`etching ${u[t]}`).attr("d",i.getMultipolyline(c[u[t]])).parent()}(t,e,r)},attachEventListeners(t,e){!function(t,e){e.$().select(".keypad").listen("click",o.onKeypadClick.bind(t))}(t,e)},getSize:t=>(function(t){return t.$().select(".keypad").getSize()})(t)},o={onKeypadClick(t){!function(t,e){const{map:r}=t._ehandlers,o=t._ehandlers.default,{shift:i}=t._ehandlers,{zoom:n}=t._ehandlers;let a;const s=[/\szup/,/\szdown/,/\sup/,/\sleft/,/\sdown/,/\sright/,/\scenter/],l=e.target.getAttribute("class");for(let t=0;t<s.length;t++)if(null!==l.match(s[t])){a=l.match(s[t]);break}if(a)switch(a=a[0].trim(),a){case"center":o?o(r,a):console.log('warning: the keypad event handler "default" does not exist!');break;case"left":case"right":case"up":case"down":i?i(r,a):console.log('warning: the keypad event handler "shift" does not exist!');break;case"zup":case"zdown":n?n(r,a):console.log('warning: the keypad event handler "zoom" does not exist!');break;default:throw new Error(`_onKeypadClick: what is this key "${a}"!`)}}(this,t)}},e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Legend&&(t.Legend=e(t))):t.Legend=e(t)}(i.src.libin,t=>{let e,r,o,i;return function(){const i=t.Legend;let n;e=function(){const t=Object.create(n);return t._params=null,t},e.VERSION="0.0.2",e.noConflict=function(){return t.Legend=i,this},n={set(t,e,o,i,n){return this._params=r.set(t,e,o,i,n),this},get(){return this._params},draw(t){return o.draw(t,this._params),this}}}(),r={set(t,e,r,n,a){const s=e.extend(i.getParams(r.length),n.legend);return function(t,e,r){switch(r){case"area":case"bar":case"circle":case"column":case"gauge":case"line":case"pie":case"polar":case"radar":case"waterfall":case"barchartrace":for(let r=0;r<t.data.length;r++)t.data[r].label=e[r].label;break;case"map":for(let r=0;r<t.data.length;r++)t.data[r].label=e[r].title;break;default:throw new Error(`_addLabel: the type "${r}" is unknown!`)}!function(t,e,r){switch(r){case"area":case"bar":case"column":case"pie":case"barchartrace":for(let r=0;r<t.data.length;r++)t.data[r].color=e[r].style.fillColor;break;case"line":for(let r=0;r<t.data.length;r++)t.data[r].color=e[r].style.stroke;break;case"polar":for(let r=0;r<t.data.length;r++)"line"===e[r].type?t.data[r].color=e[r].style.stroke:t.data[r].color=e[r].style.fillColor;break;case"radar":for(let r=0;r<t.data.length;r++)"area"===e[r].type?t.data[r].color=e[r].style.fillColor:t.data[r].color=e[r].style.stroke;break;case"map":for(let r=0;r<t.data.length;r++)e&&e[r]&&e[r].style&&(t.data[r].color=e[r].style.fillColor)}}(t,e,r);for(let e=t.data.length-1;e>=0;e--)void 0===t.data[e].label&&t.data.splice(e,1)}(s,r,a),o.getBbox(t,s),function(t,e){const r=t.background,{icon:o}=t,{layout:i}=t,{align:n}=t;if(!1!==t.enabled){r.width=0,r.height=0;for(let e=0;e<t.data.length;e++)"horizontal"===i?(r.width+=o.width+o.gap.x+t.data[e].bbox.width+4*o.gap.x,r.height=t.data[e].bbox.height):(r.width<o.width+o.gap.x+t.data[e].bbox.width&&(r.width=o.width+o.gap.x+t.data[e].bbox.width),r.height+=o.height+o.gap.y);"horizontal"===i?(r.width-=4*o.gap.x,r.width+=r.padding.left+r.padding.right,r.height+=r.padding.bottom):(r.height-=o.gap.y,r.width+=r.padding.left+r.padding.right,r.height+=r.padding.top+r.padding.bottom),r.width=Math.round(r.width),r.height=Math.round(r.height),"left"===n.horizontal?r.x=1:"middle"===n.horizontal?r.x=(e.chart.width-r.width)/2:r.x=e.chart.width-r.width-1,"top"===n.vertical?r.y=1:"middle"===n.vertical?r.y=(e.chart.height-r.height)/2:r.y=e.chart.height-r.height-1,r.x+=t.shift.x,r.y+=t.shift.y}}(s,n),s}},o={getBbox(t,e){!function(t,e){if(!e.enabled)return;const r=t.$().append("g");for(let t=0;t<e.data.length;t++)r.append("text").attr("x",0).attr("y",0).text(e.data[t].label).parent(),e.data[t].bbox=r.getSize();r.remove("g")}(t,e)},draw(t,e){!function(t,e){const{background:r}=e,{icon:o}=e,{layout:i}=e;let n,a;if(!e.enabled)return;const s=t.$();s.select(".legend").attr("transform",`translate(${r.x}, ${r.y})`).append("rect").attr("class","background").attr("x",.5).attr("y",.5).attr("width",r.width).attr("height",r.height).parent(),n=r.padding.left,a=r.padding.top;for(let t=0;t<e.data.length;t++)s.append("rect").attr("style",`fill: ${e.data[t].color}`).attr("x",n).attr("y",a).attr("width",o.width).attr("height",o.height).parent().append("text").attr("x",n+o.width+o.gap.x).attr("y",a+o.height).text(e.data[t].label).parent(),"horizontal"===i?n+=o.width+o.gap.x+e.data[t].bbox.width+4*o.gap.x:a+=o.height+o.gap.y}(t,e)}},i={getParams:t=>(function(t){const e={enabled:null,floating:null,layout:null,align:{horizontal:null,vertical:null},shift:{x:null,y:null},icon:{width:null,height:null,gap:{x:null,y:null}},background:{x:null,y:null,width:null,height:null,padding:{top:5,left:5,bottom:5,right:5}},data:[]};for(let r=0;r<t;r++)e.data.push({label:null,color:null,bbox:{width:null,height:null}});return e})(t)},e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Snapshot&&(t.Snapshot=e(t))):t.Snapshot=e(t)}(i.src.libin,t=>{let e,r;return function(){const o=t.Snapshot;e={noConflict(){return t.Snapshot=o,this},take(...t){return r.takeSnapshot(...t),this}},e.VERSION="0.0.2"}(),function(){function t(){const t=arguments[0],e=arguments[1],r=arguments[2],o=arguments[3],i=arguments[4],n=document.createElement("canvas"),a=n.getContext("2d");n.setAttribute("width",256),n.setAttribute("height",256),a.drawImage(e,0,0,256,256);const s=n.toDataURL("image/png",1);t.setAttribute("xlink:href",s),r.push("a"),r.length>=o&&i()}function e(e,r,o){let i,n;const a=function(t,e){const r="http://www.w3.org/2000/svg",o=t.$().getElement(),i=document.createElementNS(r,"svg");i.setAttributeNS(null,"version","1.1"),i.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",r),i.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),i.setAttribute("class",o.getAttribute("class")),i.setAttribute("width",o.getAttribute("width")),i.setAttribute("height",o.getAttribute("height"));for(let t=0;t<e.length;t++)null!==o.querySelector(e[t])?i.appendChild(o.querySelector(e[t]).cloneNode(!0)):console.log(`_createSVG warning: the node ${e[t]} does not exist!`);return i}(e,r),s=function(t,e){let r,o,i,n,a,s,l;o="",n="";const c=document.styleSheets;for(s=0;s<c.length;s++)for(r=c[s].cssRules,l=0;l<r.length;l++)i=r[l],i.selectorText===e&&(o=`svg { ${i.style.cssText} }\n`),void 0!==i.selectorText&&(a=t.querySelectorAll(i.selectorText.replace(`${e} `,"")),a.length>0&&(n+=`${i.selectorText.replace(e,"")} { ${i.style.cssText} }\n`));return o.concat(n)}(a,".pixi");!function(t,e){const r=document.createElement("style");r.setAttribute("xmlns","http://www.w3.org/1999/xhtml"),r.setAttribute("type","text/css"),r.innerHTML=`${e}>`,t.insertBefore(r,t.firstChild)}(a,s),function(e,r){let o,i,n,a,s;if(e.querySelector(".series")&&e.querySelector(".series").querySelector(".maps")&&e.querySelector(".series").querySelector(".maps").querySelector(".raster"))if(o=e.querySelector(".series").querySelector(".maps").querySelector(".raster").children,o.length>0){for(i=[],s=0;s<o.length;s++)o[s].getAttribute("xlink:href")&&i.push(o[s]);for(n=[],s=0;s<i.length;s++)a=document.createElement("img"),a.crossOrigin="Anonymous",a.addEventListener("load",t.bind(this,i[s],a,n,i.length,r),!1),a.src=i[s].getAttribute("xlink:href")}else r();else r()}(a,()=>{i=(new XMLSerializer).serializeToString(a),n=new Image,n.src=`data:image/svg+xml;base64,${window.btoa(unescape(encodeURIComponent(i)))}`,o(n,a)})}function o(...t){const r=function(){if(arguments.length<2)return null;const t={chart:arguments[0],format:"png",quality:"high",pause:1,nodes:[".series"],callback:null};for(let e=1;e<arguments.length;e++)"[object String]"===Object.prototype.toString.call(arguments[e])?"png"===arguments[e]||"jpeg"===arguments[e]?t.format=arguments[e]:"high"!==arguments[e]&&"medium"!==arguments[e]&&"low"!==arguments[e]||(t.quality=arguments[e]):"[object Number]"===Object.prototype.toString.call(arguments[e])?t.pause=arguments[e]:"[object Array]"===Object.prototype.toString.call(arguments[e])?t.nodes=arguments[e]:"[object Function]"===Object.prototype.toString.call(arguments[e])&&(t.callback=arguments[e]);return t.callback?t:null}(...t),o=1e3*r.pause;r&&setTimeout(()=>{e(r.chart,r.nodes,(t,e)=>{!function(t,e,r,o,i){t.onload=function(){let n,a;const s=document.createElement("canvas");s.width=e.getAttribute("width"),s.height=e.getAttribute("height"),s.getContext("2d").drawImage(t,0,0),n="jpeg"===r||"jpg"===r?"jpeg":"png",a="high"===o?1:"medium"===o?.5:"low"===o?.1:.5;const l=s.toDataURL(`image/${n}`,a);i(l)}}(t,e,r.format,r.quality,r.callback)})},o)}r={takeSnapshot(...t){return o(...t),this}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Tooltip&&(t.Tooltip=e(t))):t.Tooltip=e(t)}(i.src.libin,t=>{let e,r,o,i;return function(){const n=t.Tooltip;let a;e=function(t,e){const r=Object.create(a);return r._svg=t||null,r._taskQ=e||null,r._tip={params:null,frame:i.getFrameParams(),x:0,y:0},r},e.VERSION="0.0.4",e.noConflict=function(){return t.Tooltip=n,this},a={set(t,e){return t.extend(this._tip.params,e),this},get:()=>i.getDefaultParams(),draw(t,e){return this._tip.params=t,o.draw(this._svg,this._tip,e),this},moveTo(t,e){return this._taskQ.popQ("tooltip",o=>{r.moveTo(this._svg,this._tip,t,e,o)}),this},move(t,e,o){return this._tip.params.anchor.x=e,this._tip.params.anchor.y=o,this._taskQ.popQ("tooltip",e=>{r.moveTo(this._svg,this._tip,this._tip.params,t,e)}),this},remove(){return this._tip.params&&this._taskQ.popQ("tooltip",t=>{r.remove(this._svg,this._tip,t)}),this},hide(){o.hide(this._svg)},release(){o.release(this._svg)}}}(),function(){function t(t,e,r,i){if(0===r.duration)return e.x=r.end.x,e.y=r.end.y,o.move(t,e.x,e.y),void(i&&i());const n=setInterval(()=>{r.t+=r.frequency,r.t>r.duration&&(r.t=r.duration),e.x=r.easing(r.t,r.start.x,r.end.x-r.start.x,r.duration),e.y=r.easing(r.t,r.start.y,r.end.y-r.start.y,r.duration),o.move(t,e.x,e.y),r.t===r.duration&&(clearInterval(n),i&&i())},r.frequency)}r={move(e,r,o,i){t(e,r,o,i)},moveTo(e,r,i,n,a){!function(e,r,i,n,a){const{frame:s}=r,{animate:l}=i,{duration:c}=i.animation,{easing:u}=i.animation,h=1e3/i.animation.framesPerSecond;r.params=i,o.draw(e,r,n),t(e,r,{start:{x:r.x,y:r.y},end:{x:Math.round(n.chart.grid.x+i.anchor.x+s.shift.x),y:Math.round(n.chart.grid.y+i.anchor.y+s.shift.y)},t:0,easing:u,duration:l?c:0,frequency:h},a)}(e,r,i,n,a)},remove(e,r,i){!function(e,r,i){const n={start:{x:r.x,y:r.y},end:{x:r.x,y:r.y},t:0,easing:r.params.animation.easing,duration:r.params.animation.duration/2,frequency:1e3/r.params.animation.framesPerSecond};t(e,r,n,()=>{o.remove(e),i()})}(e,r,i)}}}(),o={draw(t,e,r){e.params.custom?function(t,e){const{params:r}=e,{frame:o}=e,{custom:i}=r;t.$().select(".tooltip").removeAllChilds().append("foreignObject").attr("class","foreign").attr("width",i.width).attr("height",i.height).appendHTML(i.xmlString),o.bbox.width=parseInt(i.width,10),o.bbox.height=parseInt(i.height,10),"[object Function]"===Object.prototype.toString.call(r.anchor.x)&&(r.anchor.x=r.anchor.x(o)),"[object Function]"===Object.prototype.toString.call(r.anchor.y)&&(r.anchor.y=r.anchor.y(o)),o.shift.x=-parseInt(i.width,10)/2,o.shift.y=-(parseInt(i.height,10)+5)}(t,e):function(t,e,r){const o=t._SVG,{frame:n}=e,{params:a}=e;!function(t,e,r){t.$().select(".tooltip").attr("transform",`translate(${e}, ${r})`).removeAllChilds().append("path").attr("class","shadow1").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.05").attr("stroke-width","5").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow2").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.1").attr("stroke-width","3").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow3").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.15").attr("stroke-width","1").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","frame").attr("stroke-width","1").attr("d","M0,0L1,0L1,1L0,1L0,0").parent()}(t,e.x,e.y);const s=function(t,e){let r=0;return null!==e&&(t.$().select(".tooltip").append("text").attr("class","title").attr("x",5).attr("y",15).text(e).parent(),r=15),r}(t,e.params.title);!function(t,e,r){const o=t.$().select(".tooltip");function i(t){const e=typeof t;return("function"===e||"object"===e)&&!!t}for(let t=0;t<e.length;t++)i(e[t])?(o.append("circle").attr("cx",8).attr("cy",15*(t+1)-3+r).attr("r",3),e[t].color&&o.attr("style",`fill: ${e[t].color}`),o.parent().append("text").attr("class",`label n${t}`).attr("x",16).attr("y",15*(t+1)+r).append("tspan").attr("class","item").text(`${e[t].label}: `).parent().append("tspan").attr("class","value").text(e[t].value).parent().parent()):o.append("text").attr("class",`label n${t}`).attr("x",10).attr("y",15*(t+1)+r).append("tspan").attr("class","item").text("").parent().append("tspan").attr("class","value").text(e[t]).parent().parent(),e[t].suffix&&(e[t].suffix.first&&o.select(`.label.n${t}`).append("tspan").attr("class","firstsuffix").text(e[t].suffix.first).parent().parent(),e[t].suffix.second&&o.select(`.label.n${t}`).append("tspan").attr("class","secondsuffix").text(e[t].suffix.second).parent().parent())}(t,e.params.content,s),n.bbox=t.$().select(".tooltip").getSize(),n.bbox.width*=1.1,n.bbox.height*=1.1,i.computePosition(e,r,a.x,a.y),t.$().select(".tooltip").select(".shadow1").attr("d",o.getLine(n.coord,!0)).parent().select(".shadow2").attr("d",o.getLine(n.coord,!0)).parent().select(".shadow3").attr("d",o.getLine(n.coord,!0)).parent().select(".frame").attr("stroke",a.frameColor).attr("d",o.getLine(n.coord,!0))}(t,e,r)},move(t,e,r){!function(t,e,r){t.$().select(".tooltip").attr("transform",`translate(${e}, ${r})`)}(t,e,r)},remove(t){!function(t){t.$().select(".tooltip").removeAllChilds()}(t)},hide(t){!function(t){t.$().select(".tooltip").attr("style","visibility: hidden")}(t)},release(t){!function(t){t.$().select(".tooltip").attr("style","visibility: visible")}(t)}},function(){function t(t){const{params:e}=t,{frame:r}=t,o=[{x:0,y:0},{x:r.bbox.width,y:0},{x:r.bbox.width,y:r.bbox.height},{x:r.bbox.width/2+7.5,y:r.bbox.height},{x:r.bbox.width/2,y:r.bbox.height+7.5},{x:r.bbox.width/2-7.5,y:r.bbox.height},{x:0,y:r.bbox.height}],i=[{x:0,y:0},{x:r.bbox.width,y:0},{x:r.bbox.width,y:r.bbox.height},{x:0,y:r.bbox.height},{x:0,y:r.bbox.height/2+7.5},{x:-7.5,y:r.bbox.height/2},{x:0,y:r.bbox.height/2-7.5}];switch(e.orientation.type){case"horizontal":r.coord=o,"horizontal"===e.orientation.symmetry?(r.coord.forEach(t=>{t.y=r.bbox.height-t.y}),r.shift.x=-r.bbox.width/2,r.shift.y=7.5):(r.shift.x=-r.bbox.width/2,r.shift.y=-(r.bbox.height+7.5+2)),"left"===e.orientation.shift?(r.coord[3].x=30,r.coord[4].x=22.5,r.coord[5].x=15,r.shift.x=-22.5):"right"===e.orientation.shift&&(r.coord[3].x=r.bbox.width-15,r.coord[4].x=r.bbox.width-22.5,r.coord[5].x=r.bbox.width-30,r.shift.x=-(r.bbox.width-22.5)),r.outerbbox={x:r.bbox.width,y:r.bbox.height+7.5};break;case"vertical":r.coord=i,"vertical"===e.orientation.symmetry?(r.coord.forEach(t=>{t.x=r.bbox.width-t.x}),r.shift.x=-(r.bbox.width+7.5+3),r.shift.y=-r.bbox.height/2):(r.shift.x=7.5,r.shift.y=-r.bbox.height/2),"top"===e.orientation.shift?(r.coord[4].y=30,r.coord[5].y=22.5,r.coord[6].y=15,r.shift.y=-22.5):"bottom"===e.orientation.shift&&(r.coord[4].y=r.bbox.height-15,r.coord[5].y=r.bbox.height-15-7.5,r.coord[6].y=r.bbox.height-15-7.5-7.5,r.shift.y=-(r.bbox.height-15-7.5)),r.outerbbox={x:r.bbox.width+7.5,y:r.bbox.height};break;default:throw new Error(`_createGeometry: the type "${e.orientation.type}" is unknown!`)}for(let t=0;t<r.coord.length;t++)r.coord[t]={x:Math.round(r.coord[t].x)+.5,y:Math.round(r.coord[t].y)+.5}}i={getFrameParams:()=>({coord:[],outerbbox:{x:null,y:null},bbox:{width:null,height:null},shift:{x:null,y:null}}),getDefaultParams:()=>({visible:!1,frameColor:"slategrey",title:null,content:[],custom:null,animate:!1,animation:{easing:(t,e,r,o)=>r*t/o+e,framesPerSecond:50,duration:1e3},orientation:{type:null,symmetry:null,shift:null},anchor:{x:null,y:null},limits:{min:{x:0,y:0},max:{x:0,y:0}}}),computePosition(e,r,o,i){!function(e,r,o,i){const{params:n}=e,{frame:a}=e;switch(r.chart.type){case"basic column":case"stacked column":case"basic bar":case"stacked bar":case"line":case"basic area":case"stacked area":case"percent area":case"radar":case"pie":case"polar":case"waterfall":case"map":t(e),"[object Function]"===Object.prototype.toString.call(n.anchor.x)&&(n.anchor.x=n.anchor.x(a)),"[object Function]"===Object.prototype.toString.call(n.anchor.y)&&(n.anchor.y=n.anchor.y(a)),"horizontal"===n.orientation.type?(n.anchor.x+a.outerbbox.x/2>n.limits.max.x?n.orientation.shift="right":n.anchor.x-a.outerbbox.x/2<n.limits.min.x&&(n.orientation.shift="left"),Math.abs(n.anchor.y)+a.outerbbox.y>n.limits.max.y&&(n.orientation.symmetry="horizontal")):(n.anchor.x+a.outerbbox.x>n.limits.max.x&&(n.orientation.symmetry="vertical"),Math.abs(n.anchor.y)+a.outerbbox.y/2>n.limits.max.y?n.orientation.shift="top":Math.abs(n.anchor.y)-a.outerbbox.y/2<n.limits.min.y&&(n.orientation.shift="bottom")),null===n.orientation.symmetry&&null===n.orientation.shift||t(e),0===o&&0===i&&(e.animate=!1);break;default:throw n.anchor.x=0,n.anchor.y=0,t(e),new Error(`_computePosition: the type "${r.chart.type}" is unknown!`)}}(e,r,o,i)}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Overlay&&(t.Overlay=e(t))):t.Overlay=e(t)}(i.src.libin,t=>{let e,r,o,i;const n={_Plus:{},Db:{Public:{},Poly:{},Point:{},Icon:{},PolyUtil:{},Util:{}},Renderer:{Public:{Blink:{}},Poly:{},Point:{},Icon:{},Util:{}}};return function(){const o=n.Db.Public,a=n.Renderer.Public,{_Plus:s}=n,l=t.Overlay;let c;e=function(t,e,r){const o=Object.create(c);return o._init(t,e,r),o},e.VERSION="0.0.2",e.noConflict=function(){return t.Overlay=l,this},c={_init(t,e,n){return r=n||!1,this._isInitFullyDone=!1,this._mess=t||null,this._mapgl=e||null,this._svg=e?e._getsvg():null,this._handlers=null,i=e?e._get_():null,i&&i.extend(i,s),this._db=o.init(),this._blink={timer:null,running:!1,list:[]},t.subscribe("mapgl:layerUpdated",()=>{this.refresh()}),this},_getOverlay(t){return o.getOverlay(this._db,t)},init(){return this._isInitFullyDone||(o.updateViewport(this._mapgl,this._db),a.fill(this._svg),this._isInitFullyDone=!0),this},attachEventListeners(t,e,r,o){return this._handlers={mouseOver:t,mouseOut:e,click:r,dblClick:o},this},validate(t){return o.validate(this._db,t)},get(t){return o.getOverlay(this._db,t)},getList(){return o.getList(this._db)},getCenter(t){return o.getCenter(this._db,t)},append(t){this._isInitFullyDone||this.init();const e=o.append(this._mapgl,this._db,t);return a.add(this._svg,this._mapgl,this._db,this._handlers,e),e},update(t){const e=o.update(this._mapgl,this._db,t);return a.update(this._svg,this._mapgl,this._db,this._handlers,e),e},remove(t){let e=this.validate(t);return e?(a.Blink.remove(this._svg,this._blink,this._db,e),e=o.remove(this._db,t),a.remove(this._svg,e.ids),e.items):null},delete(){const t=this.getList();return a.Blink.remove(this._svg,this._blink,this._db,t),o.delete(this._db),a.delete(this._svg),t},blink(t){const e=this.validate(t);return a.Blink.add(this._svg,this._blink,this._db,e),e},unblink(t){const e=this.validate(t);return a.Blink.remove(this._svg,this._blink,this._db,e),e},setVisible(t){const e=o.setVisible(this._db,t,this._mapgl.getZoom()),r=[];for(let t=0;t<e.length;t++)r.push(o.get(this._db,e[t]));return this.update(r)},setInvisible(t){const e=o.setInvisible(this._db,t);return a.turnOff(this._svg,this._db,e),e},attachTooltip(t,e,r,i){return o.attachTooltip(this._db,t,e,r,i),this},highlight(t){const e=o.highlight(this._db,t);return e&&a.highlight(this._svg,this._mapgl,this._getOverlay(e)),this},tunedown(t){const e=o.tunedown(this._db,t);return e&&a.tunedown(this._svg,this._mapgl,this._getOverlay(e)),this},deactivate(){const t=o.getActiveOverlay(this._db);return i.isString(t)&&a.deactivate(this._svg,this._getOverlay(t),"mouseout"),this},isHighlighted(t){return o.isHighlighted(this._db,t)},refresh(){a.update(this._svg,this._mapgl,this._db,this._handlers,o.refresh(this._svg,this._mapgl,this._db))}}}(),o=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},o(n._Plus,{pull(t,...e){const r=Array.isArray(e[0])?e[0]:e,o=[];let i;r.forEach(e=>{i=t.indexOf(e),i>-1&&o.push(t.splice(i,1)[0])})},include:(t,...e)=>(Array.isArray(e[0])?e[0]:e).filter(e=>t.indexOf(e)>-1)}),function(){const t=n.Db.Public,{Util:e}=n.Db,r=n.Db.Poly,a=n.Db.Point,s=n.Db.Icon;function l(t,e){const r=[];let o,n;o=i.isNumber(e)?[e.toString()]:i.isString(e)?[e]:i.isArray(e)?e:[];for(let e=0;e<o.length;e++)n=t.index.indexOf(o[e]),n>-1&&r.push(o[e]);return 0===r.length?null:r.length>1?r:r[0]}function c(t,e,o){let n=null;const l=Object.keys(o)[0];if(l&&-1===e.index.indexOf(l)){const c=function(t){if(t&&t.geometry)switch(t.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":return r.set(t);case"Point":return a.set(t);case"Icon":return s.set(t);default:return null}return null}(o[l]);if(c){switch(c._id=i.isNumber(l)?l.toString():l,c._domid=`i${c._id}`,c.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":r.init(t,e.viewport,c);break;case"Point":a.init(t,e.viewport,c);break;case"Icon":s.init(t,e.viewport,c)}e.index.push(l),e.overlays.push(c),n=c._isEnabled?l:null}}return n}o(t,{init:()=>({viewport:{"φ":{top:null,bottom:null},"λ":{left:null,right:null}},index:[],overlays:[]}),validate:(t,e)=>l(t,e),get:(t,e)=>(function(t,e){const r=l(t,e);if(r){const e=t.index.indexOf(r);if(e>-1){const o={},n=i.clone(t.overlays[e]);return delete n._id,delete n._domid,delete n._on,delete n._isVisible,delete n._isEnabled,delete n._isHighlighted,o[r]=n,o}}return null})(t,e),getOverlay(t,e){const r=l(t,e);return r?t.overlays[t.index.indexOf(r)]:null},getList:t=>i.clone(t.index),getCenter(t,r){const o=this.validate(t,r);return o?e.getCenter(this.getOverlay(t,o)):null},append:(t,e,r)=>(function(t,e,r){const o=[];let n;if(i.isArray(r))for(let i=0;i<r.length;i++)n=c(t,e,r[i]),n&&o.push(n);else i.isLiteralObject(r)&&(n=c(t,e,r),n&&o.push(n));return o})(t,e,r),update:(t,e,o)=>(function(t,e,o){const n=[];let l,c,u;l=i.isArray(o)?o:i.isLiteralObject(o)?[o]:[];for(let o=0;o<l.length;o++)if([u]=Object.keys(l[o]),c=e.overlays[e.index.indexOf(u)],c)switch(n.push(u),c._isEnabled=!0,c.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":r.update(t,e.viewport,c,l[o][u]);break;case"Point":a.update(t,e.viewport,c,l[o][u]);break;case"Icon":s.update(t,e.viewport,c,l[o][u])}return n})(t,e,o),remove:(t,e)=>(function(t,e){const r=[],o=[];let n,a,s;a=i.isString(e)?[e]:i.isArray(e)?e:[];for(let e=0;e<a.length;e++)n=t.index.indexOf(a[e]),n>-1&&([s]=t.overlays.splice(n,1),t.index.splice(n,1),r.push(a[e]),o.push(s._id));return r.length>0?{items:r,ids:o}:null})(t,e),delete:t=>(function(t){return t.overlays.splice(0,t.overlays.length),t.index.splice(0,t.index.length)})(t),setVisible:(t,r,o)=>(function(t,r,o){const n=[];let a,s,c;const u=l(t,r);a=i.isString(u)?[u]:i.isArray(u)?u:[];for(let r=0;r<a.length;r++)s=t.index.indexOf(a[r]),s>-1&&(c=t.overlays[s],c._on||(c._on=!0,c._isVisible=e.isVisible(c,t.viewport,o),c._isVisible&&c._isEnabled&&n.push(c._id)));return n})(t,r,o),setInvisible:(t,e)=>(function(t,e){const r=[];let o,n,a;const s=l(t,e);o=i.isString(s)?[s]:i.isArray(s)?s:[];for(let e=0;e<o.length;e++)n=t.index.indexOf(o[e]),n>-1&&(a=t.overlays[n],a._on&&(a._on=!1,r.push(a._id)));return r})(t,e),attachTooltip(t,e,r,o,i){return function(t,e,r,o,i){const n=l(t,e);if(n){t.overlays[t.index.indexOf(n)]._customTooltip={xmlString:r,width:o,height:i}}}(t,e,r,o,i),this},highlight(t,e){const r=l(t,e);return r&&(t.overlays[t.index.indexOf(r)]._isHighlighted=!0),r},tunedown(t,e){const r=l(t,e);return r&&(t.overlays[t.index.indexOf(r)]._isHighlighted=!1),r},isHighlighted(t,e){const r=l(t,e);return r?t.overlays[t.index.indexOf(r)]._isHighlighted:null},updateViewport(t,r){return e.updateViewport(t,r),this},refresh(t,e,o){return this.updateViewport(e,o),function(t,e,o){const i=[];let n;for(let t=0;t<o.index.length;t++)if(n=o.overlays[t],n._isEnabled){switch(n.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":r.refresh(e,o.viewport,n);break;case"Point":a.refresh(e,o.viewport,n);break;case"Icon":s.refresh(e,o.viewport,n)}i.push(o.index[t])}return i}(0,e,o)},getActiveOverlay(t){for(let e=0;e<t.overlays.length;e++)if(t.overlays[e]._isHighlighted)return t.overlays[e]._id;return null}})}(),function(){const t=n.Db.Icon,{Util:e}=n.Db;function r(t,r,o){if(o){const n=e.extend(t,r,o);return r.style&&(r.style.backgroundColor&&i.isString(r.style.backgroundColor)&&(n.style.backgroundColor=r.style.backgroundColor),r.style.backgroundOpacity&&i.isNumber(r.style.backgroundOpacity)&&(n.style.backgroundOpacity=r.style.backgroundOpacity)),r.over&&(r.over.backgroundColor&&i.isString(r.over.backgroundColor)&&(n.over.backgroundColor=r.over.backgroundColor),r.over.backgroundOpacity&&i.isNumber(r.over.backgroundOpacity)&&(n.over.backgroundOpacity=r.over.backgroundOpacity)),[...n.geometry.coordinates]=r.geometry.coordinates,n.geometry.shape.width=r.geometry.shape.width,n.geometry.shape.height=r.geometry.shape.height,n.geometry.shape.viewBox=i.clone(r.geometry.shape.viewBox),n.geometry.shape.path=r.geometry.shape.path,n}return e.extend(t,r),r.style&&(r.style.backgroundColor&&i.isString(r.style.backgroundColor)&&(t.style.backgroundColor=r.style.backgroundColor),r.style.backgroundOpacity&&i.isNumber(r.style.backgroundOpacity)&&(t.style.backgroundOpacity=r.style.backgroundOpacity)),r.over&&(r.over.backgroundColor&&i.isString(r.over.backgroundColor)&&(t.over.backgroundColor=r.over.backgroundColor),r.over.backgroundOpacity&&i.isNumber(r.over.backgroundOpacity)&&(t.over.backgroundOpacity=r.over.backgroundOpacity)),r.geometry&&r.geometry.coordinates&&([...t.geometry.coordinates]=r.geometry.coordinates),null}function a(t,r,o){o._isVisible=e.isVisible(o,r,t.getZoom())}function s(t,e){const{x:r,y:o}=t.getXYFromLatLon(e.geometry.coordinates[0],e.geometry.coordinates[1]);e.geometry._coord={x:r-e.geometry.shape.width/2,y:o-e.geometry.shape.height/2}}function l(t,e,r){a(t,e,r),r._isVisible&&s(t,r)}function c(t){return function(t){return!!(i.isLiteralObject(t)&&t.geometry&&t.geometry.type&&"Icon"===t.geometry.type)&&(!!(t.geometry.coordinates&&i.isArray(t.geometry.coordinates)&&2===t.geometry.coordinates.length&&i.isNumber(t.geometry.coordinates[0])&&i.isNumber(t.geometry.coordinates[1]))&&!!(t.geometry.shape&&i.isLiteralObject(t.geometry.shape)&&t.geometry.shape.height&&i.isNumber(t.geometry.shape.height)&&t.geometry.shape.width&&i.isNumber(t.geometry.shape.width)&&t.geometry.shape.path&&i.isString(t.geometry.shape.path)))}(t)?r({title:null,style:{},over:{},geometry:{type:"Icon",coordinates:[],shape:{height:null,width:null,viewBox:[],path:""},_coord:{x:null,y:null}}},t,!0):(console.log("warning: this overlay is not valid!"),null)}o(t,{set:t=>c(t),init(t,e,r){return a(t,e,r),s(t,r),this},update(t,e,o,i){return r(o,i),l(t,e,o),this},refresh(t,e,r){return l(t,e,r),this}})}(),function(){const t=n.Db.Point,{Util:e}=n.Db;function r(t,r,o){if(o){const i=e.extend(t,r,o);return[...i.geometry.coordinates]=r.geometry.coordinates,i.geometry.radius=r.geometry.radius,i}return e.extend(t,r),r.geometry&&(r.geometry.coordinates&&([...t.geometry.coordinates]=r.geometry.coordinates),r.geometry.radius&&(t.geometry.radius=r.geometry.radius)),null}function a(t,r,o){o._isVisible=e.isVisible(o,r,t.getZoom())}function s(t,e){e.geometry._coord=t.getXYFromLatLon(e.geometry.coordinates[0],e.geometry.coordinates[1])}function l(t,e,r){a(t,e,r),r._isVisible&&s(t,r)}function c(t){return function(t){return!!(i.isLiteralObject(t)&&t.geometry&&t.geometry.type&&"Point"===t.geometry.type)&&(!(!t.geometry.radius||!i.isNumber(t.geometry.radius))&&!!(t.geometry.coordinates&&i.isArray(t.geometry.coordinates)&&2===t.geometry.coordinates.length&&i.isNumber(t.geometry.coordinates[0])&&i.isNumber(t.geometry.coordinates[1])))}(t)?r({title:null,style:{},over:{},geometry:{type:"Point",coordinates:[],radius:null,_coord:{x:null,y:null}}},t,!0):(console.log("warning: this overlay is not valid!"),null)}o(t,{set:t=>c(t),init(t,e,r){return a(t,e,r),s(t,r),this},update(t,e,o,i){return r(o,i),l(t,e,o),this},refresh(t,e,r){return l(t,e,r),this}})}(),function(){const t=n.Db.Poly,{Util:e}=n.Db,r=n.Db.PolyUtil;function a(t,r,o){if(o){const i=e.extend(t,r,o);return i.geometry.type=r.geometry.type,r.geometry._unit&&(i.geometry._unit=r.geometry._unit),{}.propertyIsEnumerable.call(r,"_isEnabled")&&(i._isEnabled=r._isEnabled),{}.propertyIsEnumerable.call(r,"_isGeoJSON")&&(i._isGeoJSON=r._isGeoJSON),[...i.geometry.coordinates]=r.geometry.coordinates,i}return e.extend(t,r),r.geometry&&r.geometry.coordinates&&([...t.geometry.coordinates]=r.geometry.coordinates),null}function s(t,r,o){o._isVisible=e.isVisible(o,r,t.getZoom())}function l(t,e){e.geometry._path=r.getPath(t,e.geometry)}function c(t,e,r){s(t,e,r),r._isVisible&&l(t,r)}function u(t){return function(t){if(!i.isLiteralObject(t)||!t.geometry||!t.geometry.type||"MultiPolygon"!==t.geometry.type&&"Polygon"!==t.geometry.type&&"Polyline"!==t.geometry.type)return!1;if(!t.geometry.coordinates||!i.isArray(t.geometry.coordinates))return!1;switch(t.geometry.type){case"MultiPolygon":for(let e=0;e<t.geometry.coordinates.length;e++)for(let r=0;r<t.geometry.coordinates[e].length;r++)for(let o=0;o<t.geometry.coordinates[e][r].length;o++)if(2!==t.geometry.coordinates[e][r][o].length||!i.isNumber(t.geometry.coordinates[e][r][o][0])||!i.isNumber(t.geometry.coordinates[e][r][o][1]))return!1;break;case"Polygon":for(let e=0;e<t.geometry.coordinates.length;e++)for(let r=0;r<t.geometry.coordinates[e].length;r++)if(2!==t.geometry.coordinates[e][r].length||!i.isNumber(t.geometry.coordinates[e][r][0])||!i.isNumber(t.geometry.coordinates[e][r][1]))return!1;break;case"Polyline":for(let e=0;e<t.geometry.coordinates.length;e++)if(2!==t.geometry.coordinates[e].length||!i.isNumber(t.geometry.coordinates[e][0])||!i.isNumber(t.geometry.coordinates[e][1]))return!1}return!0}(t)?a({title:null,style:{},over:{},geometry:{type:null,coordinates:[],_bbox:{"φ":{top:null,bottom:null},"λ":{left:null,right:null}},_path:""}},t,!0):(console.log("warning: this overlay is not valid!"),null)}o(t,{set:t=>u(t),init(t,e,o){return r.setBbox(t,o),s(t,e,o),l(t,o),this},update(t,e,r,o){return a(r,o),c(t,e,r),this},refresh(t,e,r){return c(t,e,r),this}})}(),function(){const t=n.Db.PolyUtil;function e(t,e){let r,o,i,n="";for(let a=0;a<e.length;a++)i=t.getXYFromLatLon(e[a][0],e[a][1]),r=i.x,o=i.y,""===n?n=`M${r},${o}`:n+=`L${r},${o}`;return n}function r(t,r){let o="";for(let i=0;i<r.length;i++)o+=e(t,r[i]),o+="z";return o}o(t,{getPath:(t,o)=>(function(t,o){let i;switch(o.type){case"Polyline":i=e(t,o.coordinates);break;case"Polygon":i=r(t,o.coordinates);break;case"MultiPolygon":i="";for(let e=0;e<o.coordinates.length;e++)i+=r(t,o.coordinates[e]);break;default:throw new Error(`@Overlay _getPath: the type "${o.type}" is unknown!`)}return i})(t,o),setBbox(t,e){!function(t,e){const r=e._isGeoJSON?t.getOverlayBbox(e._id):t.getOverlayBbox(e);e.geometry._bbox={"φ":{top:r.maxφ,bottom:r.minφ},"λ":{left:r.minλ,right:r.maxλ}}}(t,e)}})}(),function(){const t=n.Db.Util;o(t,{extend:(t,e,r)=>(function(t,e,r){let o;if(r?(o=i.extend({title:null,style:{},over:{},geometry:{type:null,coordinates:null},properties:null,visibilityRange:{minZoom:null,maxZoom:null},_customTooltip:null,_id:null,_domid:null,_on:!0,_isVisible:null,_isHighlighted:!1,_isGeoJSON:!1,_isEnabled:!0},t),o.title=i.isString(e.title)?e.title:"Unknown"):(o=t,o.title=e.title&&i.isString(e.title)?e.title:o.title),e.style&&(e.style.fillColor&&i.isString(e.style.fillColor)&&(o.style.fillColor=e.style.fillColor),e.style.fillOpacity&&i.isNumber(e.style.fillOpacity)&&(o.style.fillOpacity=e.style.fillOpacity),e.style.strokeColor&&i.isString(e.style.strokeColor)&&(o.style.strokeColor=e.style.strokeColor),e.style.strokeOpacity&&i.isNumber(e.style.strokeOpacity)&&(o.style.strokeOpacity=e.style.strokeOpacity),e.style.strokeWidth&&i.isNumber(e.style.strokeWidth)&&(o.style.strokeWidth=e.style.strokeWidth)),e.over&&(e.over.fillColor&&i.isString(e.over.fillColor)&&(o.over.fillColor=e.over.fillColor),e.over.fillOpacity&&i.isNumber(e.over.fillOpacity)&&(o.over.fillOpacity=e.over.fillOpacity),e.over.strokeColor&&i.isString(e.over.strokeColor)&&(o.over.strokeColor=e.over.strokeColor),e.over.strokeOpacity&&i.isNumber(e.over.strokeOpacity)&&(o.over.strokeOpacity=e.over.strokeOpacity),e.over.strokeWidth&&i.isNumber(e.over.strokeWidth)&&(o.over.strokeWidth=e.over.strokeWidth)),e.properties)if(i.isArray(e.properties)){o.properties=[];for(let t=0;t<e.properties.length;t++)i.isString(e.properties[t])?o.properties.push(e.properties[t]):i.isObject(e.properties[t])&&o.properties.push(i.clone(e.properties[t]))}else i.isObject(e.properties)&&(o.properties=i.clone(e.properties));return e.visibilityRange&&(o.visibilityRange.minZoom=i.isNumber(e.visibilityRange.minZoom)?e.visibilityRange.minZoom:o.visibilityRange.minZoom,o.visibilityRange.maxZoom=i.isNumber(e.visibilityRange.maxZoom)?e.visibilityRange.maxZoom:o.visibilityRange.maxZoom,null===o.visibilityRange.minZoom||null===o.visibilityRange.maxZoom?(o.visibilityRange.minZoom=null,o.visibilityRange.maxZoom=null):o.visibilityRange.minZoom>o.visibilityRange.maxZoom&&(o.visibilityRange.minZoom=o.visibilityRange.maxZoom)),o})(t,e,r),updateViewport(t,e){return function(t,e){const{viewport:r}=e,o=t.getViewportCoord(),i=.1*(o.φ.top-o.φ.bottom),n=o.λ.right>=o.λ.left?.1*(o.λ.right-o.λ.left):.1*(360-(o.λ.right-o.λ.left));r.φ.top=o.φ.top+i,r.φ.bottom=o.φ.bottom-i,r.λ.left=o.λ.left-n,r.λ.right=o.λ.right+n}(t,e),this},isVisible:(t,e,r)=>(function(t,e){let r,o,i;switch(e.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":return r=e.geometry._bbox,!(r.φ.bottom>t.φ.top)&&(!(r.φ.top<t.φ.bottom)&&(!(r.λ.right<t.λ.left)&&!(r.λ.left>t.λ.right)));case"Point":case"Icon":return[o,i]=e.geometry.coordinates,function(t,e,r){return!(e>t.φ.top||e<t.φ.bottom)&&(t.λ.right>=t.λ.left?!(r<t.λ.left||r>t.λ.right):r>=0?r>=t.λ.left:r<=t.λ.right)}(t,o,i);default:throw new Error(`@Overlay _isInsideViewport: the type "${e.geometry.type}" is unknown!`)}})(e,t)&&function(t,e){return!(t.visibilityRange&&t.visibilityRange.minZoom&&t.visibilityRange.maxZoom)||!!(e>=t.visibilityRange.minZoom&&e<=t.visibilityRange.maxZoom)}(t,r),getCenter:t=>(function(t){const e=t.geometry._bbox;let r;switch(t.geometry.type){case"Icon":case"Point":return{"φ":t.geometry.coordinates[0],"λ":t.geometry.coordinates[1]};case"MultiPolygon":case"Polygon":case"Polyine":return r=e.λ.right>=e.λ.left?e.λ.right-e.λ.left:360-(e.λ.right-e.λ.left),{"φ":e.φ.bottom+(e.φ.top-e.φ.bottom)/2,"λ":e.λ.left+r/2,bbox:i.clone(t.geometry._bbox)};default:throw new Error(`@Overlay _getCenter: the type "${t.geometry.type}" is unknown!`)}})(t)})}(),function(){const t=n.Renderer.Public,e=n.Renderer.Poly,r=n.Renderer.Point,i=n.Renderer.Icon,a=n.Db.Public;function s(t,o,n,s,l,c){const u=[],h=[],d=[],p=[],g=[],y=[],m=[];let f;for(let t=0;t<l.length;t++)switch(f=a.getOverlay(n,l[t]),f.geometry.type){case"MultiPolygon":f._isGeoJSON&&c?h.push(l[t]):u.push(l[t]);break;case"Polygon":f._isGeoJSON&&c?p.push(l[t]):d.push(l[t]);break;case"Polyline":g.push(l[t]);break;case"Point":y.push(l[t]);break;case"Icon":m.push(l[t]);break;default:throw new Error(`@Overlay _add: the type "${f.geometry.type}" is unknown!`)}c?(u.length>0&&e.update(t,n,u,"MultiPolygon"),h.length>0&&e.geoupdate(t,o,n,s,h,"MultiPolygon"),d.length>0&&e.update(t,n,d,"Polygon"),p.length>0&&e.geoupdate(t,o,n,s,p,"Polygon"),g.length>0&&e.update(t,n,g,"Polyline"),y.length>0&&r.update(t,n,y),m.length>0&&i.update(t,n,m)):(u.length>0&&e.add(t,n,s,u,"Multipolygon"),d.length>0&&e.add(t,n,s,d,"Polygon"),g.length>0&&e.add(t,n,s,g,"Polyline"),y.length>0&&r.add(t,n,s,y),m.length>0&&i.add(t,n,s,m))}o(t,{fill(t){return function(t){let e;e=t.$(".series").getElement(),e?(e=t.$(".series .overlay").getElement(),e||t.$().select(".series").append("g").attr("class","overlay"),t.$().select(".series").select(".overlay").removeAllChilds().append("g").attr("class","multipolygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polyline").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","point").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","icon").attr("transform","translate(0, 0) scale(1, 1)").parent()):console.log('@Overlay _fill: the group ".series" does not exit!')}(t),function(t){let e;e=t.$(".activearea").getElement(),e?(e=t.$(".activearea .activezone").getElement(),e||t.$().select(".activearea").append("g").attr("class","activezone").attr("transform","translate(0, 0) scale(1, 1)"),t.$().select(".activearea").select(".activezone").removeAllChilds().append("g").attr("class","multipolygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polyline").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","point").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","icon").attr("transform","translate(0, 0) scale(1, 1)").parent()):console.log('@Overlay _fill: the group ".activearea" does not exit!')}(t),this},add(t,e,r,o,i){return s(t,e,r,o,i,!1),this},update(t,e,r,o,i){return s(t,e,r,o,i,!0),this},remove(t,e){return function(t,e){const r=t.$();r.select(".series .overlay");for(let t=0;t<e.length;t++)r.query(`#i${e[t]}`)&&r.select(`#i${e[t]}`).remove().parent();r.firstParent().select(".activearea .activezone");for(let t=0;t<e.length;t++)r.query(`#i${e[t]}`)&&r.select(`#i${e[t]}`).remove().parent()}(t,e),this},delete(t){return function(t){t.$().select(".series").select(".overlay").select(".multipolygon").removeAllChilds().parent().select(".polygon").removeAllChilds().parent().select(".polyline").removeAllChilds().parent().select(".point").removeAllChilds().parent().select(".icon").removeAllChilds(),t.$().select(".activearea").select(".activezone").select(".multipolygon").removeAllChilds().parent().select(".polygon").removeAllChilds().parent().select(".polyline").removeAllChilds().parent().select(".point").removeAllChilds().parent().select(".icon").removeAllChilds()}(t),this},highlight(t,o,n){return function(t,o,n){if(n)switch(n.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":e.highlight(t,n);break;case"Point":r.addHalo(t,n);break;case"Icon":i.highlight(t,n);break;default:throw new Error(`@Overlay _highlight: the type "${n.geometry.type}" is unknown!`)}}(t,0,n),this},tunedown(t,o,n){return function(t,o,n){if(n)switch(n.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":e.tunedown(t,n);break;case"Point":r.removeHalo(t);break;case"Icon":i.tunedown(t,n);break;default:throw new Error(`@Overlay _highlight: the type "${n.geometry.type}" is unknown!`)}}(t,0,n),this},turnOn(t,e,r){return function(t,e,r){let o;for(let i=0;i<r.length;i++)o=a.getOverlay(e,r[i]),t.$().select(".series").select(".overlay").select(`.${o.geometry.type.toLowerCase()}`).select(`#${o._domid}`).attr("style",o._isVisible&&o._on?"visibility: visible":"visibility: hidden").firstParent().select(".activearea").select(".activezone").select(`.${o.geometry.type.toLowerCase()}`).select(`#${o._domid}`).attr("style",o._isVisible&&o._on?"visibility: visible":"visibility: hidden")}(t,e,r),this},turnOff(t,e,r){return function(t,e,r){let o;for(let i=0;i<r.length;i++)o=a.getOverlay(e,r[i]),t.$().select(".series").select(".overlay").select(`.${o.geometry.type.toLowerCase()}`).select(`#${o._domid}`).attr("style","visibility: hidden").firstParent().select(".activearea").select(".activezone").select(`.${o.geometry.type.toLowerCase()}`).select(`#${o._domid}`).attr("style","visibility: hidden")}(t,e,r),this},deactivate(t,e,r){return function(t,e,r){const o=t.$();if(o.select(".activearea").select(".activezone").select(`.${e.geometry.type.toLowerCase()}`).select(`#${e._domid}`),o[0]){const t=new Event(r);o[0].dispatchEvent(t)}}(t,e,r),this}})}(),function(){const t=n.Renderer.Public.Blink,e=n.Renderer.Public,r=500;function a(t,o,n,a){if(a){i.isString(a)&&(a=[a]);for(let t=0;t<a.length;t++)-1===o.list.indexOf(a[t])&&o.list.push(a[t]);o.list.length>0&&!o.running&&(o.running=!0,o.timer=function(t,o,i){let n=!0;return setInterval(()=>{n?(n=!1,e.turnOff(t,o,i)):(n=!0,e.turnOn(t,o,i))},r)}(t,n,o.list))}}o(t,{add(t,e,r,o){return a(t,e,r,o),this},remove(t,r,o,n){return function(t,r,o,n){if(!n)return;i.isString(n)&&(n=[n]);const a=[];let s;for(let t=0;t<n.length;t++)s=r.list.indexOf(n[t]),s>-1&&(r.list.splice(s,1),a.push(n[t]));e.turnOn(t,o,a),0===r.list.length&&(clearInterval(r.timer),r.running=!1,r.timer=null)}(t,r,o,n),this}})}(),function(){const t=n.Renderer.Icon,e=n.Db.Public;function r(t,e,r){t.$().select(".series").select(".overlay").select(".icon").select(`#${e._domid}`).select(".r").attr("fill",r.backgroundColor).attr("fill-opacity",r.backgroundOpacity).parent().select(".ic").attr("fill",r.fillColor).attr("fill-opacity",r.fillOpacity).attr("stroke",r.strokeColor).attr("stroke-opacity",r.strokeOpacity).attr("stroke-width",r.strokeWidth)}o(t,{add(t,r,o,i){return function(t,r,o){const i=t.$();if(0!==o.length){i.select(".series").select(".overlay").select(".icon").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<o.length;t++){const n=e.getOverlay(r,o[t]),a=n.style||{},{x:s}=n.geometry._coord,{y:l}=n.geometry._coord;i.query(`#${n._domid}`)||i.append("g").attr("id",n._domid).attr("transform",`translate(${s}, ${l})`).append("rect").attr("class","r").attr("x",0).attr("y",0).attr("width",n.geometry.shape.width+4).attr("height",n.geometry.shape.height+4).attr("fill",a.backgroundColor).attr("fill-opacity",a.backgroundOpacity).parent().append("path").attr("class","ic").attr("transform","translate(2, 2)").attr("d",n.geometry.shape.path).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).parent().attr("style",n._isVisible?"visibility: visible":"visibility: hidden").parent()}}}(t,r,i),function(t,r,o,i){const n=t.$();if(0!==i.length){n.select(".activearea").select(".activezone").select(".icon").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<i.length;t++){const a=e.getOverlay(r,i[t]),s=a.style||{},{x:l}=a.geometry._coord,{y:c}=a.geometry._coord;n.query(`#${a._domid}`)||(n.append("rect").attr("id",a._domid).attr("x",l-2).attr("y",c-2).attr("width",a.geometry.shape.width+4).attr("height",a.geometry.shape.height+4).attr("stroke-width",s.strokeWidth).attr("style",a._isVisible?"visibility: visible":"visibility: hidden"),o&&n.listen("mouseover",o.mouseOver).listen("mouseout",o.mouseOut).listen("click",o.click).listen("dblclick",o.dblClick),n.parent())}}}(t,r,o,i),this},update(t,r,o){return function(t,r,o){const i=t.$();if(0!==o.length){i.select(".series").select(".overlay").select(".icon").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<o.length;t++){const n=e.getOverlay(r,o[t]),a=n.style||{},{x:s}=n.geometry._coord,{y:l}=n.geometry._coord;i.query(`#${n._domid}`)&&(n._isVisible?i.select(`#${n._domid}`).attr("transform",`translate(${s}, ${l})`).select(".r").attr("width",n.geometry.shape.width+4).attr("height",n.geometry.shape.height+4).attr("fill",a.backgroundColor).attr("fill-opacity",a.backgroundOpacity).parent().select(".ic").attr("d",n.geometry.shape.path).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).parent().attr("style","visibility: visible").parent():i.select(`#${n._domid}`).attr("style","visibility: hidden").parent())}}}(t,r,o),function(t,r,o){const i=t.$();if(0!==o.length){i.select(".activearea").select(".activezone").select(".icon").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<o.length;t++){const n=e.getOverlay(r,o[t]),a=n.style||{},{x:s}=n.geometry._coord,{y:l}=n.geometry._coord;i.query(`#${n._domid}`)&&(n._isVisible?i.select(`#${n._domid}`).attr("x",s-2).attr("y",l-2).attr("width",n.geometry.shape.width+4).attr("height",n.geometry.shape.height+4).attr("stroke-width",a.strokeWidth).attr("style","visibility: visible").parent():i.select(`#${n._domid}`).attr("style","visibility: hidden").parent())}}}(t,r,o),this},highlight(t,e){return r(t,e,e.over),this},tunedown(t,e){return r(t,e,e.style),this}})}(),function(){const t=n.Renderer.Point,e=n.Db.Public;o(t,{add(t,o,i,n){return function(t,r,o){const i=t.$();if(0!==o.length){i.select(".series").select(".overlay").select(".point").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<o.length;t++){const n=e.getOverlay(r,o[t]),a=n.style||{};i.query(`#${n._domid}`)||i.append("circle").attr("id",n._domid).attr("cx",n.geometry._coord.x).attr("cy",n.geometry._coord.y).attr("r",n.geometry.radius).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).attr("style",n._isVisible?"visibility: visible":"visibility: hidden").parent()}}}(t,o,n),function(t,o,i,n){const a=r?20:10,s=t.$();if(0!==n.length){s.select(".activearea").select(".activezone").select(".point").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<n.length;t++){const r=e.getOverlay(o,n[t]),l=r.style||{};s.query(`#${r._domid}`)||(s.append("circle").attr("id",r._domid).attr("cx",r.geometry._coord.x).attr("cy",r.geometry._coord.y).attr("r",r.geometry.radius>=a?r.geometry.radius:a).attr("stroke-width",l.strokeWidth).attr("style",r._isVisible?"visibility: visible":"visibility: hidden"),i&&s.listen("mouseover",i.mouseOver).listen("mouseout",i.mouseOut).listen("click",i.click).listen("dblclick",i.dblClick),s.parent())}}}(t,o,i,n),this},update(t,o,i){return function(t,r,o){const i=t.$();if(0!==o.length){i.select(".series").select(".overlay").select(".point").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<o.length;t++){const n=e.getOverlay(r,o[t]),a=n.style||{};i.query(`#${n._domid}`)&&(n._isVisible?i.select(`#${n._domid}`).attr("cx",n.geometry._coord.x).attr("cy",n.geometry._coord.y).attr("r",n.geometry.radius).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).attr("style","visibility: visible").parent():i.select(`#${n._domid}`).attr("style","visibility: hidden").parent())}}}(t,o,i),function(t,o,i){const n=r?20:10,a=t.$();if(0!==i.length){a.select(".activearea").select(".activezone").select(".point").attr("transform","translate(0, 0) scale(1, 1)");for(let t=0;t<i.length;t++){const r=e.getOverlay(o,i[t]),s=r.style||{};a.query(`#${r._domid}`)&&(r._isVisible?a.select(`#${r._domid}`).attr("cx",r.geometry._coord.x).attr("cy",r.geometry._coord.y).attr("r",r.geometry.radius>=n?r.geometry.radius:n).attr("stroke-width",s.strokeWidth).attr("style","visibility: visible").parent():a.select(`#${r._domid}`).attr("style","visibility: hidden").parent())}}}(t,o,i),this},addHalo(t,e){return function(t,e){const r=t.$(),o={style:{fillColor:"transparent",strokeWidth:4,strokeColor:e.style.fillColor,strokeOpacity:.35},geometry:{type:"Point",radius:e.geometry.radius+3,coordinates:e.geometry.coordinates,_coord:e.geometry._coord}};r.select(".series").select(".overlay").select(".point").append("circle").attr("id","halo").attr("cx",o.geometry._coord.x).attr("cy",o.geometry._coord.y).attr("r",o.geometry.radius).attr("fill",o.style.fillColor).attr("stroke-width",o.style.strokeWidth).attr("stroke",o.style.strokeColor).attr("stroke-opacity",o.style.strokeOpacity)}(t,e),this},removeHalo(t){return function(t){const e=t.$(".series .overlay .point");for(;e.query("#halo");)e.select("#halo").remove()}(t),this}})}(),function(){const t=n.Renderer.Poly,e=n.Db.Public;function r(t,e,r){t.$().select(".series").select(".overlay").select(`.${e.geometry.type.toLowerCase()}`).select(`#${e._domid}`).attr("fill",r.fillColor).attr("fill-opacity",r.fillOpacity).attr("stroke",r.strokeColor).attr("stroke-opacity",r.strokeOpacity).attr("stroke-width",r.strokeWidth)}o(t,{add(t,r,o,i,n){return function(t,r,o,i){const n=t.$();if(0!==o.length){n.select(".series").select(".overlay").select(`.${i.toLowerCase()}`);for(let t=0;t<o.length;t++){const i=e.getOverlay(r,o[t]),a=i.style||{};n.query(`#${i._domid}`)||n.append("path").attr("id",i._domid).attr("d",i.geometry._path).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).attr("style",i._isVisible?"visibility: visible":"visibility: hidden").parent()}}}(t,r,i,n),function(t,r,o,i,n){const a=t.$();if(0!==i.length){a.select(".activearea").select(".activezone").select(`.${n.toLowerCase()}`);for(let t=0;t<i.length;t++){const n=e.getOverlay(r,i[t]);a.query(`#${n._domid}`)||(a.append("path").attr("id",n._domid).attr("d",n.geometry._path).attr("style",n._isVisible?"visibility: visible":"visibility: hidden"),o&&a.listen("mouseover",o.mouseOver).listen("mouseout",o.mouseOut).listen("click",o.click).listen("dblclick",o.dblClick),a.parent())}}}(t,r,o,i,n),this},update(t,r,o,i){return function(t,r,o,i){const n=t.$();if(0!==o.length){n.select(".series").select(".overlay").select(`.${i.toLowerCase()}`);for(let t=0;t<o.length;t++){const i=e.getOverlay(r,o[t]),a=i.style||{};n.query(`#${i._domid}`)&&(i._isVisible?n.select(`#${i._domid}`).attr("d",i.geometry._path).attr("fill",a.fillColor).attr("fill-opacity",a.fillOpacity).attr("stroke",a.strokeColor).attr("stroke-opacity",a.strokeOpacity).attr("stroke-width",a.strokeWidth).attr("style","visibility: visible").parent():n.select(`#${i._domid}`).attr("style","visibility: hidden").parent())}}}(t,r,o,i),function(t,r,o,i){const n=t.$();if(0!==o.length){n.select(".activearea").select(".activezone").select(`.${i.toLowerCase()}`);for(let t=0;t<o.length;t++){const i=e.getOverlay(r,o[t]);n.query(`#${i._domid}`)&&(i._isVisible?n.select(`#${i._domid}`).attr("d",i.geometry._path).attr("style","visibility: visible").parent():n.select(`#${i._domid}`).attr("style","visibility: hidden").parent())}}}(t,r,o,i),this},geoupdate(t,r,o,i,n,a){!function(t,r,o,i,n,a){const s=t.$(),l=t.$(),c=r.getGeoJSONTransform(),u=r.isMapLayerUpdated();s.select(`.series .overlay .${a.toLowerCase()}`),l.select(`.activearea .activezone .${a.toLowerCase()}`);for(let t=0;t<n.length;t++){const a=e.getOverlay(o,n[t]),c=a.style||{};s.query(`#${a._domid}`)||s.append("path").attr("id",a._domid).attr("d",r.getSVGPath(a._id)).attr("fill",c.fillColor).attr("fill-opacity",c.fillOpacity).attr("stroke",c.strokeColor).attr("stroke-opacity",c.strokeOpacity).attr("stroke-width",c.strokeWidth).parent(),u&&s.select(`#${a._domid}`).attr("d",r.getSVGPath(a._id)).parent(),l.query(`#${a._domid}`)||l.append("path").attr("id",a._domid).attr("d",r.getSVGPath(a._id)).listen("mouseover",i.mouseOver).listen("mouseout",i.mouseOut).listen("click",i.click).listen("dblclick",i.dblClick).parent(),u&&l.select(`#${a._domid}`).attr("d",r.getSVGPath(a._id)).parent()}s.attr("transform",`translate(${c.x}, ${c.y}), scale(${c.zoom}, ${c.zoom})`),l.attr("transform",`translate(${c.x}, ${c.y}), scale(${c.zoom}, ${c.zoom})`)}(t,r,o,i,n,a)},highlight(t,e){return r(t,e,e.over),this},tunedown(t,e){return r(t,e,e.style),this}})}(),function(){const t=n.Renderer.Util;o(t,{})}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.MapGL&&(t.MapGL=e(t))):t.MapGL=e(t)}(i.src.libin,t=>{let e,r,o;return r={LRU:null,overslash:null,Proj:null,SHP:null,WebGL:null,MapGL:{GMapGL:{Public:{},Renderer:{},Util:{}},GeoJSON:{Public:{},Renderer:{},Map:{},SHP:{},Util:{}},Raster:{Public:{},Renderer:{},Util:{}},Vector:{Public:{},Renderer:{},Drawer:{},Util:{},Source:{Earcut:{},Geo:{},GlyphAtlas:{},RPoint:{},RPolygon:{},RPolyline:{},RText:{},Sprite:{},Styler:{}},Workers:{Public:{},Model:{},Tile:{}}},Common:{Public:{},Util:{}},Geo:{Public:{}}},PBF:{Public:{},Source:{Font:{},Tile:{},Util:{}}},Source:{Color:{},Load:{}},Tiler:{Public:{},Map:{},Util:{}}},function(){const o=r.MapGL.GeoJSON.Public,i=r.MapGL.Raster.Public,n=r.MapGL.Vector.Public,a=r.Source.Load,s=t.MapGL;e=function(...t){return function(...t){const[e,r,a]=t;let s,l;switch("object"==typeof r?(s=r,l=a):"string"==typeof r&&(s=null,l=r),l){case"geojson":return o.GeoJSON(e,s);case"raster":return i.Raster(e,s);case"vector":return n.Vector(e,s);default:throw new Error(`MapGL: the type "${l}" is not supported!`)}}(...t)},e.VERSION="0.1.4",e._setTestMode=function(){return r},e.noConflict=function(){return t.MapGL=s,this},e.load=function(t,e,r){a.load(t,e,r)}}(),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.LRU&&(t.LRU=e(t))):t.LRU=e(t)}(r,t=>{let e,r,o;const i={Public:{}};return r=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},o={isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isNaN(t){return this.isNumber(t)&&t!==+t},isOdd(t){const e=t%2;return t===parseFloat(t)?!!e:void 0}},function(){const t=i.Public;function e(t){for(;t.lru<t.mru&&void 0===t.list[t.lru];)t.lru+=1}function o(t,e){return new Date-t.cache[e].birth<=t.maxAge}function n(t,e){return{value:t.cache[e].value,age:new Date-t.cache[e].birth}}r(t,{set(t,r,o,i){let a;return t.cache[r]?(i&&!0===i.force&&(a=t.cache[r].stamp,t.cache[r]={value:o,stamp:t.mru,birth:new Date},t.list[t.cache[r].stamp]=r,delete t.list[a],t.mru+=1),n(t,r)):(t.cache[r]={value:o,stamp:t.mru,birth:new Date},t.list[t.cache[r].stamp]=r,t.mru+=1,t.items+=1,function(t){let r;for(;t.items>t.maxItems;)e(t),r=t.list[t.lru],delete t.cache[r],delete t.list[t.lru],t.items-=1,e(t)}(t),n(t,r))},get(t,e){let r;return t.cache[e]?o(t,e)?(r=n(t,e),t.cache[e].birth=new Date):(this.remove(t,e),r=null):r=null,r},has(t,e){return t.cache[e]&&o(t,e)?n(t,e):(this.remove(t,e),null)},remove(t,r){if(!t.cache[r])return null;const{stamp:o}=t.cache[r];return delete t.cache[r],delete t.list[o],t.items-=1,parseInt(o,10)===t.lru&&(t.lru=-1,e(t)),!0},empty(t){t.cache={},t.list={},t.lru=0,t.mru=0,t.items=0},dump(t){const e=Object.keys(t.list),r=[];for(let o=0;o<e.length;o++){const i=t.list[e[o]];r.push({key:i,value:t.cache[i].value,age:new Date-t.cache[i].birth})}return r},prune(t){const e={};let r;r=Object.keys(t.list);for(let e=0;e<r.length;e++){const i=t.list[r[e]];o(t,i)||this.remove(t,i)}r=Object.keys(t.list);for(let o=0;o<r.length;o++){const i=t.list[r[o]],n=o.toString();e[n]=i,t.cache[i].stamp=n}t.list=e},renew:(t,e)=>t.cache[e]?(t.cache[e].birth=new Date,n(t,e)):null})}(),function(){const r=i.Public,n=t.LRU;let a,s,l;function c(){l=!1,setTimeout(()=>{l=!0},s)}function u(t){s&&l&&(l=!1,c(),t.prune())}e=function(t){const e=Object.create(a);e.db={};const{db:r}=e;return r.cache={},r.list={},r.lru=0,r.mru=0,r.items=0,r.maxItems=t&&o.isNumber(t.maxItems)&&t.maxItems>0?Math.ceil(t.maxItems):1e3,r.maxAge=t&&o.isNumber(t.maxAge)&&t.maxAge>=100?Math.ceil(t.maxAge):36e5,s=t&&o.isNumber(t.prune)&&t.prune>=1e3?Math.ceil(t.prune):null,s&&c(),e},e.VERSION="0.0.1",e._=o,e.noConflict=function(){return t.LRU=n,this},a={set(t,e,i){return u(this),o.isString(t)?r.set(this.db,t,e,i):null},get(t){return u(this),o.isString(t)?r.get(this.db,t):null},has(t){return u(this),o.isString(t)?r.has(this.db,t):null},remove(t){return u(this),o.isString(t)?r.remove(this.db,t):null},empty(){return r.empty(this.db),this},dump(){return u(this),r.dump(this.db)},prune(){r.prune(this.db)},count(){return u(this),this.db.items},renew(t){return u(this),o.isString(t)?r.renew(this.db,t):null}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.overslash&&(t.overslash=e(t))):t.overslash=e(t)}(r,t=>{let e,r;return r=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},function(){const r=t.overslash;e={noConflict(){return t.overslash=r,this}},e.VERSION="1.0.0"}(),r(e,{isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isNaN(t){return this.isNumber(t)&&t!==+t},isOdd(t){const e=t%2;return t===parseFloat(t)?!!e:void 0}}),r(e,{isObject(t){const e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),isFunction:t=>"[object Function]"===Object.prototype.toString.call(t),isArray:t=>"[object Array]"===Object.prototype.toString.call(t),isMath:t=>"[object Math]"===Object.prototype.toString.call(t),isDate:t=>"[object Date]"===Object.prototype.toString.call(t),isEmpty(t){let e;if(null===t)return!0;if(this.isArray(t)||this.isString(t))return 0===t.length;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}}),r(e,{clone(t){const e=this.isArray(t)?[]:{};let r;if(this.isObject(t)){for(r in t)this.isArray(t[r])?e[r]=this.clone(t[r]):this.isObject(t[r])?e[r]=this.extend(t[r]):e[r]=t[r];return e}},extend(t){let e,r;if(!this.isObject(t))return t;for(let o=1;o<arguments.length;o++)for(r in e=arguments[o],e)this.isLiteralObject(arguments[o][r])?(t[r]=void 0!==t[r]?t[r]:{},this.extend(t[r],arguments[o][r])):hasOwnProperty.call(e,r)&&(t[r]=this.isArray(e[r])?this.clone(e[r]):e[r]);return t},keys:t=>Object.keys(t),forPropIn(t,e){this.keys(t).forEach(r=>{({}).hasOwnProperty.call(t,r)&&e(r)})},assign(){const t=arguments[0];let e,r,o;for(o=1;o<arguments.length;o++)e=arguments[o],r=Object.keys(e).reduce((t,r)=>(t[r]=Object.getOwnPropertyDescriptor(e,r),t),{});return Object.defineProperties(t,r),t}}),r(e,{contains:(t,e)=>-1!==t.indexOf(e),flatten(t,e){let r,o=[],i=0;if(this.isArray(t)){if(e)return[].concat.apply([],t);for(r=0;r<t.length;r++)this.isArray(t[r])?(o=o.concat(this.flatten(t[r])),i=o.length):o[i++]=t[r];return o}},max(t){let e,r=null;if(!this.isArray(t))return;const o=this.flatten(t);for(e=0;e<o.length;e++)(null===r||r<o[e])&&(r="number"==typeof o[e]?o[e]:r);return null!==r?r:void 0},min(t){let e,r=null;if(!this.isArray(t))return;const o=this.flatten(t);for(e=0;e<o.length;e++)(null===r||r>o[e])&&(r="number"==typeof o[e]?o[e]:r);return null!==r?r:void 0},share(t){const e=[];let r,o,i;for(o=0;o<t.length;o++)if(r=t[o],!this.contains(e,r)){for(i=1;i<arguments.length&&this.contains(arguments[i],r);i++);i===arguments.length&&e.push(r)}return e}}),r(e,{}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),t.Proj||(t.Proj=e(t))):t.Proj=e(t)}(r,t=>{let e,r;return r=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},function(){const o=t.Proj;e={noConflict(){return t.Proj=o,this}},e.VERSION="0.0.1",r(e,{})}(),r(e,{aziequi(t,e,r,o,i){const n=r||1,a=Math.PI/180,s=t*a,l=e*a,c=o?o*a:0*a,u=i?i*a:0*a,h=Math.sin(c)*Math.sin(s)+Math.cos(c)*Math.cos(s)*Math.cos(l-u),d=Math.acos(h),p=d/Math.sin(d);let g=p*Math.cos(s)*Math.sin(l-u),y=p*(Math.cos(c)*Math.sin(s)-Math.sin(c)*Math.cos(s)*Math.cos(l-u));return g*=45,y*=45,[g*n,y*n]},iaziequi(t,e,r,o,i){const n=r||1,a=Math.PI/180,s=o?o*a:0*a,l=i?i*a:0*a,c=t/n/45,u=e/n/45,h=Math.sqrt(c**2+u**2),d=Math.asin(Math.cos(h)*Math.sin(s)+u*Math.sin(h)*Math.cos(s)/h)/a;let p;if(90===o)p=l+Math.atan(-c/u);else if(-90===o)p=l+Math.atan(c/u);else{const t=c*Math.sin(h)/(h*Math.cos(s)*Math.cos(h)-u*Math.sin(s)*Math.sin(h));p=l+Math.atan(t)}return[d,p/a]}}),function(){const t=180;r(e,{cea(e,r,o,i,n){const a=o||1,s=Math.PI/180,l=e*s,c=i?i*s:0*s;let u=(r*s-(n?n*s:0*s))*Math.cos(c),h=Math.sin(l)/Math.cos(c);return u*=t,h*=t,[u*a,h*a]},icea(e,r,o,i,n){const a=o||1,s=Math.PI/180,l=i?i*s:0*s,c=n?n*s:0*s,u=e/a/t,h=r/a/t;return[Math.asin(h*Math.cos(l))/s,(u/Math.cos(l)+c)/s]}})}(),r(e,{mercator(t,e,r,o){const i=r||1,n=Math.PI/180,a=t*n,s=e-(o||0);let l;return l=t>85.05?180:t<-85.05?-180:Math.log(Math.tan(.25*Math.PI+.5*a))/n,[s*i,l*i]},imercator(t,e,r,o){const i=r||1,n=Math.PI/180,a=o?o*n:0*n,s=t/i*n,l=e/i*n;return[Math.atan(Math.sinh(l))/n,(s+a)/n]}}),function(){const t=180;r(e,{orthographic(e,r,o,i,n){const a=o||1,s=Math.PI/180,l=e*s,c=r*s,u=i?i*s:0*s,h=n?n*s:0*s;let d=Math.cos(l)*Math.sin(c-h),p=Math.cos(u)*Math.sin(l)-Math.sin(u)*Math.cos(l)*Math.cos(c-h);return d*=t,p*=t,[d*a,p*a]},iorthographic(e,r,o,i,n){const a=o||1,s=Math.PI/180,l=i?i*s:0*s,c=n?n*s:0*s,u=e/a/t,h=r/a/t,d=Math.sqrt(u**2+h**2),p=Math.asin(d);let g=Math.cos(p)*Math.sin(l)+h*Math.sin(p)*Math.cos(l)/d;const y=Math.asin(g)/s;return g=u*Math.sin(p)/(d*Math.cos(l)*Math.cos(p)-h*Math.sin(l)*Math.sin(p)),[y,(c+Math.atan(g))/s]}})}(),r(e,{veper(t,e,r,o,i){const n=r||1,a=Math.PI/180,s=t*a,l=e*a,c=o?o*a:0*a,u=i?i*a:0*a,h=4/(5-(Math.sin(c)*Math.sin(s)+Math.cos(c)*Math.cos(s)*Math.cos(l-u)));let d=h*Math.cos(s)*Math.sin(l-u),p=h*(Math.cos(c)*Math.sin(s)-Math.sin(c)*Math.cos(s)*Math.cos(l-u));return d*=180,p*=180,[d*n,p*n]},iveper(){}}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),t.SHP||(t.SHP=e(t))):t.SHP=e(t)}(r,t=>{let e,r;const o={};return r={readString(t,e,r){let o="";for(let i=e;i<r;i++)o+=String.fromCharCode(t[i]);return o.replace(/\u0000/g,"")},readUTF8String:(t,e,r)=>(function(t,e,r){const o=r-e;let i,n,a,s="",l=0;for(;l<o;)if(i=t[e+l],i<128)s+=String.fromCharCode(i),l+=1;else if(i>191&&i<224){if(l+1>=o)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");n=t[e+l+1],s+=String.fromCharCode((31&i)<<6|63&n),l+=2}else{if(l+2>=o)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");n=t[e+l+1],a=t[e+l+2],s+=String.fromCharCode((15&i)<<12|(63&n)<<6|63&a),l+=3}return s})(t,e,r),readUInt8:(t,e)=>t[e],readUInt16LE:(t,e)=>256*t[e+1]+t[e],readUInt32LE:(t,e)=>t[e+3]*2**32+65536*t[e+2]+256*t[e+1]+t[e],readUInt32BE:(t,e)=>t[e]*2**32+65536*t[e+1]+256*t[e+2]+t[e+3],readDoubleLE(t,e){const r=new ArrayBuffer(8),o=new DataView(r);for(let r=0;r<8;r++)o.setUint8(7-r,t[e+r]);return o.getFloat64(0)}},function(){const t=function(t,e,r){const o=new window.XMLHttpRequest;switch(o.onreadystatechange=function(){let t;if(4===o.readyState)if(200===o.status||0===o.status)switch(e){case"json":r(!1,o,o.responseText);break;case"bin":t=new Uint8Array(o.response),r(!1,o,t);break;default:throw new Error(`load: the type "${e}" is unknown!`)}else r(!0,o)},e){case"json":o.open("GET",t,!0),o.send(null);break;case"bin":o.open("GET",t,!0),o.responseType="arraybuffer",o.send(null);break;default:throw new Error(`_load: the type "${e}" is unknown!`)}};o.Util={load(e,r){!function(e,r){const o=e.split("/").pop();t(`${e}/${o}.dbf`,"bin",(i,n,a)=>{t(`${e}/${o}.shp`,"bin",(i,n,s)=>{t(`${e}/${o}.VERSION.txt`,"json",(t,e,i)=>{r([a,s,{db:o,version:i.replace(/[^\d.]/gi,"")}])})})})}(e,r)}}}(),function(){function t(t,e,o,i){const n={};let a,s=e.startRecordSection+e.numberOfBytesInRecord*i;if(32!==r.readUInt8(t,s)&&42!==r.readUInt8(t,s))throw new Error(`The first byte of the record should be "0x20" or "0x2A" instead of: ${r.readUInt8(t,s).toString(16)}`);s+=1;for(let i=0;i<e.numberOfFieldsArray;i++){switch(a=r.readUTF8String(t,s,s+o[i].length),o[i].type){case"C":n[o[i].name]=a.replace(/^\s+|\s+$/g,"");break;case"D":throw new Error('Field Data Type "D" not processed yet!');case"N":n[o[i].name]=parseInt(a.replace(/^\s+|\s+$/g,""),10);break;case"F":n[o[i].name]=parseFloat(a);break;case"L":throw new Error('Field Data Type "L" not processed yet!');case"M":throw new Error('Field Data Type "M" not processed yet!');default:throw new Error(`Field Data Type ${o[i].type} is not supported!`)}s+=o[i].length}return n}o.DBF={decode(t){t.header=function(t){const e={dbaseVersion:r.readUInt8(t.buf,0),numberOfRecords:r.readUInt32LE(t.buf,4),numberOfBytesInHeader:r.readUInt16LE(t.buf,8),numberOfBytesInRecord:r.readUInt16LE(t.buf,10),bytes12_14:"Reserved bytes.",bytes15_27:"Reserved for dBASE III PLUS on a LAN.",bytes28_31:"Reserved bytes.",bytes32_n:"Field Descriptor Array",terminator:"0x0D stored as the Field Descriptor terminator.",numberOfFieldsArray:0,startRecordSection:0};return e.numberOfFieldsArray=(e.numberOfBytesInHeader-1)/32-1,e.startRecordSection=e.numberOfBytesInHeader,e}(t),t.fieldDescriptorArray=function(t,e){const o=[];let i=32;for(let n=0;n<e.numberOfFieldsArray;n++)o[n]={},o[n].name=r.readString(t,i,i+11),o[n].type=String.fromCharCode(r.readUInt8(t,i+11)),o[n].dataAddress=r.readUInt32LE(t,i+12),o[n].length=r.readUInt8(t,i+16),o[n].count=r.readUInt8(t,i+17),o[n].workArreaID=r.readUInt8(t,i+20),o[n].flag=r.readUInt8(t,i+23),i+=32;if(13!==r.readUInt8(t,i))throw new Error("Field Descriptor terminator 0x0D not found!");return o}(t.buf,t.header)},getRecord:(e,r)=>(function(e,r){const o=[];if("[object Number]"!==Object.prototype.toString.call(r)){for(let r=0;r<e.header.numberOfRecords;r++)o[r]=t(e.buf,e.header,e.fieldDescriptorArray,r);return o}if(r%1==0&&r>0&&r<=e.header.numberOfRecords){return t(e.buf,e.header,e.fieldDescriptorArray,r-1)}return null})(e,r)}}(),function(){const t=100,e=8;function i(t,o){return[r.readDoubleLE(t,o+e+12),r.readDoubleLE(t,o+e+4)]}function n(t,o){const i=[];let n,a,s;r.readDoubleLE(t,o+e+4),r.readDoubleLE(t,o+e+12),r.readDoubleLE(t,o+e+20),r.readDoubleLE(t,o+e+28);const l=r.readUInt32LE(t,o+e+36),c=r.readUInt32LE(t,o+e+40),u=(r.readUInt32LE(t,o+e+44),o+e+44+4*l);for(let h=0;h<l;h++){n=r.readUInt32LE(t,o+e+44+4*h),a=h+1<l?r.readUInt32LE(t,o+e+44+4*(h+1))-1:c-1,s=[];for(let e=n;e<=a;e++)s[e-n]=[r.readDoubleLE(t,u+16*e+8),r.readDoubleLE(t,u+16*e)];i.push(s)}return i}function a(o,a){const s=function(o,a){const s=[];let l=t;for(let t=0;l<a.fileLength;t++){switch(s[t]={recordNumber:r.readUInt32BE(o,l),contentLength:r.readUInt32BE(o,l+4),shape:r.readUInt32LE(o,l+e),type:"",coordinates:[]},s[t].shape){case 0:throw new Error('The Shape Type "Null Shape" is not supported yet!');case 1:s[t].type="Point",s[t].coordinates=i(o,l);break;case 3:s[t].type="PolyLine",s[t].coordinates=n(o,l);break;case 5:s[t].type="Polygon",s[t].coordinates=n(o,l);break;case 8:throw new Error('The Shape Type "MultiPoint" is not supported yet!');case 11:throw new Error('The Shape Type "PointZ" is not supported yet!');case 13:throw new Error('The Shape Type "PolyLineZ" is not supported yet!');case 15:throw new Error('The Shape Type "PolygonZ" is not supported yet!');case 18:throw new Error('The Shape Type "MultiPointZ" is not supported yet!');case 21:throw new Error('The Shape Type "PointM" is not supported yet!');case 23:throw new Error('The Shape Type "PolyLineM" is not supported yet!');case 25:throw new Error('The Shape Type "PolygonM" is not supported yet!');case 28:throw new Error('The Shape Type "MultiPointM" is not supported yet!');case 31:throw new Error('The Shape Type "MultiPatch" is not supported yet!');default:throw new Error(`The Shape Type "${s[t].shape}" is unknown!`)}l+=2*s[t].contentLength+e}return s}(o.buf,o.header);if(!a)return s;if(a%1!=0||a<1)throw new Error(`This record number "${a}" does not match!`);return s[a-1]?s[a-1]:null}o.SH={decode(t){t.header=function(t){const e={code:r.readUInt32BE(t,0),byte4:"Unused",byte8:"Unused",byte12:"Unused",byte16:"Unused",byte20:"Unused",fileLength:2*r.readUInt32BE(t,24),version:r.readUInt32LE(t,28),shape:r.readUInt32LE(t,32),Xmin:r.readDoubleLE(t,36),Ymin:r.readDoubleLE(t,44),Xmax:r.readDoubleLE(t,52),Ymax:r.readDoubleLE(t,60),Zmin:r.readDoubleLE(t,68),Zmax:r.readDoubleLE(t,76),Mmin:r.readDoubleLE(t,84),Mmax:r.readDoubleLE(t,92)};if(9994!==e.code)throw new Error(`This is not a SHP file! The first four bytes are: "${e.code}" instead of "9994"`);if(0!==e.Zmin||0!==e.Zmax)throw new Error("SHP files with Z type != zero are not supported!");if(0!==e.Mmin||0!==e.Mmax)throw new Error("SHP files with points having M Measure are not supported!");return e}(t.buf)},getRecord:(t,e)=>a(t,e)}}(),function(){const{Util:r}=o,{DBF:i}=o,{SH:n}=o,a=t.SHP;let s;e=function(){const t=Object.create(s);return t._dbf={buf:null,header:null,fieldDescriptorArray:null},t._shp={buf:null,header:null},t},e.VERSION="0.0.2",e.noConflict=function(){return t.SHP=a,this},s={_getDbfRecord(t){return i.getRecord(this._dbf,t)},_getDbfHeader(){return this._dbf.header},_getDbfFieldDescriptor(){return this._dbf.fieldDescriptorArray},_getShpRecord(t){return n.getRecord(this._shp,t)},_getShpHeader(){return this._shp.header},load(t,e){return new Promise(o=>{r.load(t,t=>{[this._dbf.buf]=t,[,this._shp.buf]=t,[,,this._source]=t,i.decode(this._dbf),n.decode(this._shp),o(),e&&e()})})},getCollection(){const{header:t}=this._shp,e=this._getDbfRecord(),r=this._getShpRecord(),o={bbox:[t.Xmin,t.Ymin,t.Xmax,t.Ymax],type:"FeatureCollection",features:[]};for(let t=0;t<this._dbf.header.numberOfRecords;t++)o.features[t]={type:"Feature",properties:e[t],geometry:{type:r[t].type,coordinates:r[t].coordinates}};return o},getFeature(t){if("number"!=typeof t||t%1!=0||t<=0||t>this._dbf.header.numberOfRecords)throw new Error(`The record Number "${t}" does not match!`);const e=n.getRecord(this._shp,t);return{type:"Feature",properties:i.getRecord(this._dbf,t),geometry:{type:e.type,coordinates:e.coordinates}}},getSource(){return{name:this._source.db,version:this._source.version}}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?module.exports=e(t):t.WebGL=e(t)}(r,t=>{let e,r;const o={MATH:{Matrix:{M3:{},M4:{}}},Canvas:{},Font:{},Geometry:{},Glyph:{},Image:{},Polyline:{},Shaders:{},Util:{}};return function(){const{Canvas:r}=o,{Shaders:i}=o,{Geometry:n}=o,{Image:a}=o,{Glyph:s}=o,l=t.WebGL;let c;e=function(...t){const e=Object.create(c);return r.make(e,...t),e.init(),e},e.VERSION="0.0.0",e.noConflict=function(){return t.WebGL=l,this},c={init(){const t=this._gl;return this._shader=i.get(),this._shader.geometry=n.getShader(),this._shader.image=a.getShader(),this._shader.glyph=s.getShader(),n.init(t,this._shader),a.init(t,this._shader),s.init(t,this._shader),t.viewport(0,0,t.canvas.width,t.canvas.height),this.empty(),this.setTransform(0,0,1),this},empty(){const t=this._gl;return t.clearColor(.97,.97,.97,1),t.clear(t.COLOR_BUFFER_BIT),t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE),t.enable(t.BLEND),this},fillBackground(t){return this._gl.clearColor(t[0]/255,t[1]/255,t[2]/255,t[3]),this._gl.clear(this._gl.COLOR_BUFFER_BIT),this},fillStyle(t){return this._shader.color=[t[0]/255,t[1]/255,t[2]/255,t[3]],this},shift(t,e){const{transform:r}=this._shader;return r.translate.x=t,r.translate.y=e,this.shader.transform.modified=!0,this},zoom(t){const{transform:e}=this._shader;return e.scale.x=t/this._ratio,e.scale.y=t/this._ratio,this._shader.transform.modified=!0,this},setTransform(t,e,r){const{transform:o}=this._shader;return o.translate.x=t,o.translate.y=e,o.scale.x=r/this._ratio,o.scale.y=r/this._ratio,this._shader.transform.modified=!0,this},fillLines(t){return n.drawLines(this._gl,this._shader,t),this},fillStripLines(t){return n.drawStripLines(this._gl,this._shader,t),this},fillLoopLines(t){return n.drawLoopLines(this._gl,this._shader,t),this},fillTriangles(t){return n.drawTriangles(this._gl,this._shader,t),this},fillRect(t,e,r,o){const i=[t,e,t+r,e,t+r,e+o,t+r,e+o,t,e+o,t,e];return this.fillTriangles(i),this},fillPolygon(t){return n.drawPolygon(this._gl,this._shader,t),this},drawImage(t,e,r,o,i,n,s,l,c){return a.drawImage(this._gl,this._shader,this._ratio,t,e,r,o,i,n,s,l,c),this},font(t,e){return this._shader.glyph.font.family=t,this._shader.glyph.font.size=e,this},textAlign(t){return["left","right","center","start","end"].indexOf(t)>-1&&(this._shader.glyph.text.align=t),this},textBaseline(t){return["top","hanging","middle","alphabetic","ideographic","bottom"].indexOf(t)>-1&&(this._shader.glyph.text.baseline=t),this},textRotate(t){return this._shader.glyph.text.angle=t,this},haloColor(t){return this._shader.glyph.halo.color=[t[0]/255,t[1]/255,t[2]/255,t[3]],this},haloWidth(t){return this._shader.glyph.halo.width=t,this},drawGlyph(t,e,r,o,i,n,a){return s.drawGlyph(this._gl,this._shader,this._ratio,t,e,r,o+n*this._ratio,i+a*this._ratio),this}}}(),r=function(t,e){const r=Object.keys(e);for(let o=0;o<r.length;o++)t[r[o]]=e[r[o]]},r(o.Canvas,{make(t,...e){return function(t,...e){const[r,o,i]=e,n="number"==typeof o?o:1024,a="number"==typeof o?i:1024;if("CANVAS"!==r.tagName)throw new Error("This node does not have a Canvas tag!");const s=r.getContext("webgl");if(!s)throw new Error("Unable to initialize WebGL. Your browser or machine may not support it!");r.width=2*n,r.height=2*a,r.style.width=`${n}px`,r.style.height=`${n}px`,t[0]=r,t._gl=s,t._pixelRatio=2,t._ratio=4}(t,...e),this}}),r(o.Font,{}),function(){const t=o.Geometry,{Shaders:e}=o,{M3:i}=o.MATH.Matrix,n=function(t,e){let r;return r=i.projection(t.canvas.clientWidth,t.canvas.clientHeight),r=i.translate(r,e.translate.x,e.translate.y),r=i.rotate(r,e.rotate),r=i.scale(r,e.scale.x,e.scale.y),r},a=function(t,e,r,o){e.transform.modified&&(e.geometry.matrix=n(t,e.transform),e.transform.modified=!1),t.useProgram(e.geometry.program),t.bindBuffer(t.ARRAY_BUFFER,e.geometry.buffer),t.vertexAttribPointer(e.geometry.attribs.a_position,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.geometry.attribs.a_position),t.uniform4fv(e.geometry.uniforms.u_color,e.color),t.uniformMatrix3fv(e.geometry.uniforms.u_matrix,!1,e.geometry.matrix),t.bufferData(t.ARRAY_BUFFER,new Float32Array(o),t.STATIC_DRAW),t.drawArrays(r,0,o.length/2)};r(t,{getShader:()=>({program:null,buffer:null,matrix:null,attribs:{a_position:null},uniforms:{u_color:null,u_matrix:null}}),init(t,r){!function(t,r){const{geometry:o}=r,i=["attribute vec2 a_position;","","uniform mat3 u_matrix;","","void main() {","  // Multiply the position by the matrix.","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","}"].join("\n"),a=["precision mediump float;","","uniform vec4 u_color;","","void main() {","  gl_FragColor = u_color;","}"].join("\n");o.program=e.createAndCompileShaderProgram(t,i,a),o.attribs.a_position=t.getAttribLocation(o.program,"a_position"),o.uniforms.u_color=t.getUniformLocation(o.program,"u_color"),o.uniforms.u_matrix=t.getUniformLocation(o.program,"u_matrix"),o.buffer=t.createBuffer(),o.matrix=n(t,r.transform)}(t,r)},drawLines(t,e,r){a(t,e,t.LINES,r)},drawStripLines(t,e,r){a(t,e,t.LINE_STRIP,r)},drawLoopLines(t,e,r){a(t,e,t.LINE_LOOP,r)},drawTriangles(t,e,r){a(t,e,t.TRIANGLES,r)},drawStripTriangles(t,e,r){a(t,e,t.TRIANGLE_STRIP,r)},drawFanTriangles(t,e,r){a(t,e,t.TRIANGLE_FAN,r)},drawPolygon(t,e,r){a(t,e,t.TRIANGLES,r)}})}(),function(){const t=o.Glyph,{Shaders:e}=o,{M3:i}=o.MATH.Matrix;r(t,{getShader:()=>({program:null,font:{defaultSize:24,size:24,family:"sans-serif",buffer:1,gamma:1},text:{align:"start",baseline:"alphabetic",angle:0},halo:{color:[1,1,1,1],blur:0,width:0},quad:{buffer:null,matrix:null,attribs:{},uniforms:{}},texture:{buffer:null,tex:null,attribs:{},uniforms:{}}}),init(t,r){!function(t,r){const o=["attribute vec2 a_position;","attribute vec2 a_texcoord;","","uniform mat3 u_matrix;","uniform vec2 u_texsize;","","varying vec2 v_texcoord;","","void main() {","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","  v_texcoord = a_texcoord / u_texsize;","}"].join("\n"),i=["precision mediump float;","","uniform sampler2D u_texture;","uniform vec4 u_color;","uniform float u_buffer;","uniform float u_gamma;","","varying vec2 v_texcoord;","","void main() {","  float dist = texture2D(u_texture, v_texcoord).r;","  float alpha = smoothstep(u_buffer - u_gamma, u_buffer + u_gamma, dist);","  gl_FragColor = vec4(u_color.rgb, alpha * u_color.a);","}"].join("\n"),{quad:n}=r.glyph,{texture:a}=r.glyph,s=e.createAndCompileShaderProgram(t,o,i);r.glyph.program=s,n.buffer=t.createBuffer(),n.attribs.a_position=t.getAttribLocation(s,"a_position"),n.uniforms.u_matrix=t.getUniformLocation(s,"u_matrix"),a.buffer=t.createBuffer(),a.tex=t.createTexture(),a.attribs.a_texcoord=t.getAttribLocation(s,"a_texcoord"),a.uniforms.u_texture=t.getUniformLocation(s,"u_texture"),a.uniforms.u_color=t.getUniformLocation(s,"u_color"),a.uniforms.u_buffer=t.getUniformLocation(s,"u_buffer"),a.uniforms.u_gamma=t.getUniformLocation(s,"u_gamma"),a.uniforms.u_texsize=t.getUniformLocation(s,"u_texsize")}(t,r)},drawGlyph(t,e,r,o,n,a,s,l){!function(t,e,r,o,n,a,s,l){const{translate:c}=e.transform,u=e.glyph.font.size,{color:h}=e,d=e.glyph.font.size/e.glyph.font.defaultSize,{angle:p}=e.glyph.text,g=e.glyph.halo.color,y=e.glyph.halo.width,{gamma:m}=e.glyph.font;let f;t.useProgram(e.glyph.program),t.bindBuffer(t.ARRAY_BUFFER,e.glyph.quad.buffer),t.bufferData(t.ARRAY_BUFFER,new Float32Array(n),t.STATIC_DRAW),t.enableVertexAttribArray(e.glyph.quad.attribs.a_position),t.vertexAttribPointer(e.glyph.quad.attribs.a_position,2,t.FLOAT,!1,0,0),f=i.orthographic(0,t.canvas.clientWidth,t.canvas.clientHeight,0,0,0),f=i.translate(f,c.x+s/r,c.y+l/r),f=i.rotate(f,p),f=i.scale(f,d,d),t.uniformMatrix3fv(e.glyph.quad.uniforms.u_matrix,!1,f),function(t,e,r){const o=r.data,{width:i}=r,{height:n}=r;t.bindTexture(t.TEXTURE_2D,e.glyph.texture.tex),t.texImage2D(t.TEXTURE_2D,0,t.RGBA,i,n,0,t.RGBA,t.UNSIGNED_BYTE,o),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR)}(t,e,o),t.bindBuffer(t.ARRAY_BUFFER,e.glyph.texture.buffer),t.bufferData(t.ARRAY_BUFFER,new Float32Array(a),t.STATIC_DRAW),t.enableVertexAttribArray(e.glyph.texture.attribs.a_texcoord),t.vertexAttribPointer(e.glyph.texture.attribs.a_texcoord,2,t.FLOAT,!1,0,0),t.uniform2f(e.glyph.texture.uniforms.u_texsize,o.width,o.height),t.uniform1i(e.glyph.texture.uniforms.u_texture,0),t.uniform4fv(e.glyph.texture.uniforms.u_color,g),t.uniform1f(e.glyph.texture.uniforms.u_buffer,function(t){let e;return e=t<=.5?-.8*t+1:t>.5&&t<=1?-.2*t+.7:t>1&&t<=1.25?-.1*t+.65:t>1.25&&t<=5?-.0266*t+.533:0,e}(y)),t.drawArrays(t.TRIANGLES,0,n.length/2),t.uniform4fv(e.glyph.texture.uniforms.u_color,h),t.uniform1f(e.glyph.texture.uniforms.u_buffer,.75),t.uniform1f(e.glyph.texture.uniforms.u_gamma,1.4142*m/u),t.drawArrays(t.TRIANGLES,0,a.length/2)}(t,e,r,o,n,a,s,l),e.image.texture.loaded=!1}})}(),function(){const t=o.Image,{Shaders:e}=o,{M3:i}=o.MATH.Matrix;r(t,{getShader:()=>({program:null,matrix:null,quad:{buffer:null,attribs:{a_position:null},uniforms:{u_matrix:null}},texture:{buffer:null,tex:null,loaded:null,attribs:{a_texcoord:null},uniforms:{u_textureMatrix:null,u_texture:null}}}),init(t,r){return function(t,r){const o=["attribute vec2 a_position;","attribute vec2 a_texcoord;","","uniform mat3 u_matrix;","uniform mat3 u_textureMatrix;","","varying vec2 v_texcoord;","","void main() {","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","  v_texcoord = (u_textureMatrix * vec3(a_texcoord, 1)).xy;","}"].join("\n"),i=["precision mediump float;","","uniform sampler2D u_texture;","","varying vec2 v_texcoord;","","void main() {","  gl_FragColor = texture2D(u_texture, v_texcoord);","}"].join("\n"),{quad:n}=r.image,{texture:a}=r.image,s=e.createAndCompileShaderProgram(t,o,i);r.image.program=s,n.buffer=t.createBuffer(),n.attribs.a_position=t.getAttribLocation(s,"a_position"),n.uniforms.u_matrix=t.getUniformLocation(s,"u_matrix"),t.bindBuffer(t.ARRAY_BUFFER,n.buffer);t.bufferData(t.ARRAY_BUFFER,new Float32Array([0,0,0,1,1,0,1,0,0,1,1,1]),t.STATIC_DRAW),a.buffer=t.createBuffer(),a.tex=t.createTexture(),a.attribs.a_texcoord=t.getAttribLocation(s,"a_texcoord"),a.uniforms.u_textureMatrix=t.getUniformLocation(s,"u_textureMatrix"),a.uniforms.u_texture=t.getUniformLocation(s,"u_texture"),t.bindBuffer(t.ARRAY_BUFFER,a.buffer);t.bufferData(t.ARRAY_BUFFER,new Float32Array([0,0,0,1,1,0,1,0,0,1,1,1]),t.STATIC_DRAW)}(t,r),this},drawImage(t,e,r,o,n,a,s,l,c,u,h,d){return function(t,e,r,o,n,a,s,l,c,u,h,d){const{translate:p}=e.transform;let g,y;t.useProgram(e.image.program),t.bindBuffer(t.ARRAY_BUFFER,e.image.quad.buffer),t.vertexAttribPointer(e.image.quad.attribs.a_position,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.image.quad.attribs.a_position),g=i.orthographic(0,t.canvas.clientWidth,t.canvas.clientHeight,0,0,0),g=i.translate(g,p.x+c/r,p.y+u/r),g=i.scale(g,h,d),t.uniformMatrix3fv(e.image.quad.uniforms.u_matrix,!1,g),t.bindBuffer(t.ARRAY_BUFFER,e.image.texture.buffer),t.vertexAttribPointer(e.image.texture.attribs.a_texcoord,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.image.texture.attribs.a_texcoord),t.bindTexture(t.TEXTURE_2D,e.image.texture.tex),o.width?t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,o):t.texImage2D(t.TEXTURE_2D,0,t.RGBA,s,l,0,t.RGBA,t.UNSIGNED_BYTE,o),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),y=i.translation(n/o.width,a/o.height),y=i.scale(y,s/o.width,l/o.height),t.uniformMatrix3fv(e.image.texture.uniforms.u_textureMatrix,!1,y),t.uniform1i(e.image.texture.uniforms.u_texture,0),t.drawArrays(t.TRIANGLES,0,6)}(t,e,r,o,n,a,s,l,c,u,h,d),this}})}(),r(o.Polyline,{}),function(){const t=function(t,e,r){const o=t.createShader(e);if(t.shaderSource(o,r),t.compileShader(o),!t.getShaderParameter(o,t.COMPILE_STATUS))throw new Error(`could not compile shader: ${t.getShaderInfoLog(o)}`);return o};r(o.Shaders,{get:()=>({type:null,transform:{modified:!0,translate:{x:0,y:0},scale:{x:1,y:1},rotate:0},color:null,geometry:null,image:null,glyph:null}),createAndCompileShaderProgram:(e,r,o)=>(function(e,r,o){const i=t(e,e.VERTEX_SHADER,r),n=t(e,e.FRAGMENT_SHADER,o),a=e.createProgram();if(e.attachShader(a,i),e.attachShader(a,n),e.linkProgram(a),!e.getProgramParameter(a,e.LINK_STATUS))throw new Error(`could not link shaders: ${e.getProgramInfoLog(a)}`);return a})(e,r,o)})}(),r(o.Util,{}),function(){const t=o.MATH.Matrix.M3;function e(t,e){return[1,0,0,0,1,0,t,e,1]}function i(t,e){const r=t[0],o=t[1],i=t[2],n=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=e[0],d=e[1],p=e[2],g=e[3],y=e[4],m=e[5],f=e[6],b=e[7],x=e[8];return[h*r+d*n+p*l,h*o+d*a+p*c,h*i+d*s+p*u,g*r+y*n+m*l,g*o+y*a+m*c,g*i+y*s+m*u,f*r+b*n+x*l,f*o+b*a+x*c,f*i+b*s+x*u]}r(t,{orthographic:(t,e,r,o,i,n)=>(function(t,e,r,o,i,n){return[2/(e-t),0,0,0,2/(r-o)*-1,0,i,n,1]})(t,e,r,o,i,n),projection:(t,e)=>(function(t,e){return[2/t,0,0,0,-2/e,0,0,0,0]})(t,e),translation:(t,r)=>e(t,r),translate:(t,r,o)=>i(t,e(r,o)),rotate:(t,e)=>i(t,function(t){const e=Math.cos(t),r=Math.sin(t);return[e,-r,0,r,e,0,0,0,1]}(e)),scale:(t,e,r)=>i(t,function(t,e){return[t,0,0,0,e,0,0,0,1]}(e,r))})}(),e}),o=r.overslash,function(){const t=r.MapGL.GMapGL.Public,e=r.MapGL.GMapGL.Renderer,i=r.MapGL.Geo.Public;let n;n={_ginit(){return this._timer=null,this._db={map:null,tiles:null},this},_fill(t,r){return e.fill(this._svg,t,r),this},_getsvg(){return this._svg},_get_:()=>o,_init(){return this},_drawOneTile(){return this},_shift(){return this},_zoom(){return this},_updateLayer(){return this},_draw(){return this},update(){return this},zoom(){return this},getXYFromLatLon(){return this},getXYOnMapFromLatLon(){return this},getLatLonFromXY(){return this},getViewportCoord(){return this},reconcile(){return this},getOptimalZoom(){return this},setAsNewOrigin(){return this},getSVGPath(){return this},draw(...t){return e.fillmap(this._svg),this._draw(...t),this},getOverlayBbox:t=>i.getOverlayBbox(t),getBbox(){return{width:this._db.map.viewport.width,height:this._db.map.viewport.height}},getZoom(){return this._db.map.zoom},getXYOnMapFromCurrentLatLon(){return this.getXYOnMapFromLatLon(this._db.map.viewport.φ,this._db.map.viewport.λ)},fire(t,e){return this._mess&&this._mess.publish(t,e),this}},o.extend(t,{GMapGL:function(t,e,r,i){const a=Object.create(o.extend({},n,r));return a.type=i,a._svg=t,a._mess=e,a._ginit(),a}})}(),function(){const t=r.MapGL.GMapGL.Renderer;function e(t){t.$().select(".series").select(".maps").removeAllChilds().append("g").attr("class","geojson").attr("transform","translate(0, 0) scale(1, 1)").append("g").attr("class","multipolygon").parent().append("g").attr("class","polygon").parent().append("g").attr("class","polyline").parent().append("g").attr("class","point").parent().parent().append("g").attr("class","raster").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","vector").attr("transform","translate(0, 0) scale(1, 1)")}o.extend(t,{fill(t,r,o){return function(t,e,r){let o;o=t.$(".series").getElement(),o||t.$().attr("class","map").attr("width",e).attr("height",r).append("g").attr("class","series").attr("transform","translate(0, 0)").append("svg").attr("class","maps"),o=t.$(".series .maps").getElement(),o||t.$().attr("class","map").attr("width",e).attr("height",r).select(".series").append("svg").attr("class","maps"),t.$().attr("class","map").attr("width",e).attr("height",r)}(t,r,o),e(t),this},fillmap(t){return e(t),this}})}(),function(){const t=r.MapGL.GeoJSON.Public,e=r.MapGL.GeoJSON.Renderer,{Map:i}=r.MapGL.GeoJSON,{SHP:n}=r.MapGL.GeoJSON,{Util:a}=r.MapGL.GeoJSON,s=r.MapGL.Geo.Public,l=r.MapGL.GMapGL.Public;let c;c={_startTimer(){return this._timer=setTimeout(()=>{e.updateLayer(this._svg,this._db.map),this.fire("mapgl:layerUpdated","done")},500),this},_stopTimer(){return clearTimeout(this._timer),this},_init(){return this._shp=r.SHP(),this},_addPoint(t,r){return e.addPoint(this._svg,t,r),this},_getCollection(){return this._db.map.data?this._db.map.data:this._db.map._collection},_loadGeoJSON(t){return this._db.map=a.initSettings(t),new Promise(t=>{this._shp.load(this._db.map.url,()=>{this._db.map._collection=this._shp.getCollection(),this._db.map._source=this._shp.getSource(),this._db.map._copyright=n.getNECopyright(),t([this._db.map._collection,this._db.map._source])})})},_getMap(t){const{map:e}=this._db;return t.include&&(e.include=t.include),t.exclude&&(e.exclude=t.exclude),n.setCoordPath(e,e._collection,e._source,e._copyright)},_draw(t){return this._db.map=a.initSettings(t),n.load(this._shp,this._db.map,t=>{this._db.map.data=t,this.fire("mapgl:maploaded","Done!"),e.draw(this._svg,this._db.map)}),this},update(t,r,o){return this._stopTimer(),e.update(this._svg,this._db.map,t,r,o),this._startTimer(),this},zoom(t,r){return this._stopTimer(),e.zoom(this._svg,this._db.map,t,r),this._startTimer(),this},getXYFromLatLon(t,e){return i.getXYFromLatLon(this._db.map,t,e)},getXYOnMapFromLatLon(t,e){return i.getXYOnMapFromLatLon(this._db.map,t,e)},getLatLonFromXY(t,e){return i.getLatLonFromXY(this._db.map,t,e)},getViewportCoord(){return i.getViewportCoord(this._db.map)},reconcile(){return a.reconcile(this._db.map.viewport)},getOptimalZoom(t,e,r){return i.getOptimalZoom(this._db.map,t,e,r)},setAsNewOrigin(){return a.setAsNewOrigin(this._db.map),this},getOverlayBbox(t){return o.isString(t)?s.getGeoJSONOverlayBbox(this._db.map.data,t):s.getGeoJSONOverlayBbox(t)},getGeoJSONTransform(){const{viewport:t}=this._db.map;return{x:t._shift.x?t._shift.x:0,y:t._shift.y?t._shift.y:0,zoom:this._db.map.zoom/this._db.map.layer}},getPotentialOverlays(){return a.getPotentialOverlays(this._db.map.data)},getSVGPath(t){return s.getSVGPathFromMap(this._db.map.data,t)},getCopyright(){return this._db.map.data&&this._db.map.data._copyright?this._db.map.data._copyright:"undefined"},isMapLayerUpdated(){return this._db.map._isLayerUpdated}},o.extend(t,{GeoJSON:function(t,e){const r=l.GMapGL(t,e,c,"geojson");return r._init(),r}})}(),function(){const t=r.MapGL.GeoJSON.Renderer,e=r.MapGL.Geo.Public,{Map:i}=r.MapGL.GeoJSON;function n(t,r,o){const i=t.$();i.select(".series").select(".maps").select(".geojson").select(".multipolygon").empty().parent().select(".polygon").empty().parent().select(".polyline").empty().parent();for(let t=0;t<r.length;t++)switch(r[t].geometry.type){case"MultiPolygon":case"Polygon":case"PolyLine":r[t].geometry._path=e.getSVGPath(r[t].geometry.type,r[t].geometry._coord,0,0,o),i.select(`.${r[t].geometry.type.toLowerCase()}`).append("path").attr("id",r[t]._id).attr("title",r[t]._title).attr("class",r[t]._class).attr("d",r[t].geometry._path).parent().parent();break;case"Point":i.select(".point").append("circle").attr("id",r[t]._id).attr("title",r[t]._title).attr("class",r[t]._class).attr("r",r[t].geometry._r).attr("cx",r[t].geometry._coord[0]).attr("cy",r[t].geometry._coord[1]).parent().parent()}}function a(t,e,r,o,n){const a=t.$(),{viewport:s}=e;e.zoom=n;const l=e.zoom/e.layer;s.x+=r,s.y+=o;const c=i.getLatLonFromXYOnMap(s.x,s.y);s.φ=c.φ,s.λ=c.λ,s._shift.x=s.width/2-s.x*e.zoom,s._shift.y=s.height/2+s.y*e.zoom,a.select(".series").select(".maps").select(".geojson").attr("transform",`translate(${s._shift.x}, ${s._shift.y}) scale(${l}, ${l})`)}o.extend(t,{addPoint(t,e,r){return function(t,e,r){t.$().query(".series .overlay")||t.$().select(".series").append("g").attr("transform","translate(0, 0) scale(1, 1)").attr("class","overlay").append("g").attr("class","point"),t.$().select(".series").select(".overlay").select(".point").append("circle").attr("cx",e).attr("cy",r).attr("r",2).attr("fill","red")}(t,e,r),this},draw(t,e){return function(t,e){t.$().select(".series").select(".maps").select(".geojson").attr("transform","translate(0, 0) scale(0, 0)"),n(t,e.data.features,e.layer)}(t,e),this},update(t,e,r,o,i){return a(t,e,r,o,i),this},zoom(t,e,r,o){return function(t,e,r,o){const n=i.getXYOnMapFromLatLon(e,o.φ,o.λ);e.viewport.x=n.x-(o.x-e.viewport.width/2)/r,e.viewport.y=n.y+(o.y-e.viewport.height/2)/r,a(t,e,0,0,r)}(t,e,r,o),this},updateLayer(t,e){return function(t,e){e.zoom-e.layer>=1?(e.layer=Math.floor(e.zoom),n(t,e.data.features,e.layer),e._isLayerUpdated=!0):e.zoom-e.layer<=-1?(e.layer=Math.floor(e.zoom)>0?Math.floor(e.zoom):1,n(t,e.data.features,e.layer),e._isLayerUpdated=!0):e._isLayerUpdated=!1,a(t,e,0,0,e.zoom)}(t,e),this}})}(),function(){const t=r.MapGL.GeoJSON.Map,{Proj:e}=r;function i(t,r,o){const i=e.mercator(r,o);return{x:i[0],y:i[1]}}function n(t,r){const o=e.imercator(t,r);return{"φ":o[0],"λ":o[1]}}function a(t,r,o){const i=(r-t.viewport.width/2)/t.zoom+t.viewport.x,n=(t.viewport.height/2-o)/t.zoom+t.viewport.y,a=e.imercator(i,n);return{"φ":a[0],"λ":a[1]}}function s(t,e,r,o,a){const s=i(0,t,e),l=s.x-r/2/a,c=s.c+r/2/a,u=s.y+o/2/a,h=s.y-o/2/a,d=n(l,u),p=n(c,h);return{"φ":{top:d.φ,bottom:p.φ},"λ":{left:d.λ,right:p.λ}}}function l(t,e){return!(t.φ.top>e.φ.top)&&(!(t.φ.bottom<e.φ.bottom)&&(!(t.λ.left<e.λ.left)&&!(t.λ.right>e.λ.right)))}o.extend(t,{getXYFromLatLon:(t,r,o)=>(function(t,r,o){const i=e.mercator(r,o);return{x:(i[0]-t.viewport.x)*t.zoom+t.viewport.width/2,y:t.viewport.height/2-(i[1]-t.viewport.y)*t.zoom}})(t,r,o),getXYOnMapFromLatLon:(t,e,r)=>i(0,e,r),getLatLonFromXYOnMap:(t,e)=>n(t,e),getLatLonFromXY:(t,e,r)=>a(t,e,r),getViewportCoord:t=>(function(t){const e=a(t,0,0),r=a(t,t.viewport.width,t.viewport.height);return{"φ":{top:e.φ,bottom:r.φ},"λ":{left:e.λ,right:r.λ}}})(t),getOptimalZoom:(t,e,r,o)=>(function(t,e,r,o){const{viewport:i}=t,{width:n}=i,{height:a}=i;let c=t.zoom,u=1,h=!1;for(l(o,s(e,r,n,a,c))||(u=-1,h=!0);;)if(c+=u,l(o,s(e,r,n,a,c))===h){c=u>0?c-1:c;break}return c})(t,e,r,o)})}(),function(){const t=r.MapGL.GeoJSON.SHP,e=r.MapGL.Geo.Public,i="Made with Natural Earth. Free vector and raster map data @ naturalearthdata.com.";function n(t,e){if(!t.exclude&&!o.isLiteralObject(t.exclude))return!0;const r=Object.keys(t.exclude);for(let i=0;i<r.length;i++){const n=t.exclude[r[i]];if(o.isArray(n)){for(let t=0;t<n.length;t++)if(e[r[i]]===n[t])return!1}else if(e[r[i]]===n)return!1}return!0}function a(t,e){if(!t.include&&!t.exclude)return!0;if(t.include&&!o.isLiteralObject(t.include))return!0;if(t.include){const r=Object.keys(t.include);for(let i=0;i<r.length;i++){const a=t.include[r[i]];if(o.isArray(a)){for(let o=0;o<a.length;o++)if(e[r[i]]===a[o])return n(t,e)}else if(e[r[i]]===a)return n(t,e)}return!1}return n(t,e)}function s(t,e){switch(e){case"ne_110m_admin_0_countries":t._id=`${t.properties.ADM0_A3}-${t.properties.POSTAL}`,t._title=t.properties.NAME;break;case"ne_110m_admin_0_boundary_lines_land":t._class="landborder";break;case"ne_110m_populated_places":t._id=t.properties.ADM0_A3,t._title=t.properties.NAME,t.geometry._r=1;break;case"ne_110m_rivers_lake_centerlines":t._title=t.properties.name,t._class="lakeriver";break;case"ne_110m_lakes":t._title=t.properties.name,t._class="lake";break;case"ne_50m_admin_0_countries":t._id=`${t.properties.ADM0_A3}-${t.properties.POSTAL}`,t._title=t.properties.NAME;break;case"ne_50m_ports":t._title=t.properties.name,t.geometry._r=1,t._class="port";break;case"ne_50m_urban_areas":t._class="urbanarea";break;case"ne_10m_admin_1_states_provinces":t._id=`${t.properties.adm0_a3}-${t.properties.iso_3166_2}`,t._title=t.properties.name;break;case"ne_10m_urban_areas":t._class="urbanarea";break;case"ne_10m_time_zones":t._title=t.properties.name;break;case"ne_10m_roads":t._class="road";break;case"ne_10m_graticules_10":t._title=t.properties.display,t._class="grid";break;case"ne_10m_bathymetry_A_10000":case"ne_10m_bathymetry_F_5000":case"ne_10m_bathymetry_J_1000":t._class=`bath ${t.properties.depth}`;break;case"data.gouv.fr":t._id=t.id,t._title=t.title;break;default:console.log(`warning: the db ${e} is not supported yet!`)}}function l(t,r,i,n){const l=function(t,e,r){return{bbox:null,type:t,_copyright:r||"undefined copyright!",_index:[],_source:{name:e.name,version:e.version},features:[]}}(r.type,i,n),c={"minλ":180,"maxλ":-180,"minφ":90,"maxφ":-90};let u,h,d;for(let n=0;n<r.features.length;n++)switch(r.features[n].geometry.type){case"MultiPolygon":a(t,r.features[n].properties)&&([h,d]=e.getCoordPath("MultiPolygon",r.features[n].geometry.coordinates,c),u=o.clone(r.features[n]),s(u,i.name),u.geometry._coord=h,u.geometry._path=d,l.features.push(u),l._index.push(u._id),l.bbox=c);break;case"Polygon":a(t,r.features[n].properties)&&([h,d]=e.getCoordPath("Polygon",r.features[n].geometry.coordinates,c),u=o.clone(r.features[n]),s(u,i.name),u.geometry._coord=h,u.geometry._path=d,l.features.push(u),l._index.push(u._id),l.bbox=c);break;case"PolyLine":a(t,r.features[n].properties)&&([h,d]=e.getCoordPath("PolyLine",r.features[n].geometry.coordinates,c),u=o.clone(r.features[n]),s(u,i.name),u.geometry._coord=h,u.geometry._path=d,l.features.push(u),l.bbox=c);break;case"Point":a(t,r.features[n].properties)&&([h,d]=e.getCoordPath("Point",r.features[n].geometry.coordinates,c),u=o.clone(r.features[n]),s(u,i.name),u.geometry._coord=h,l.features.push(u),l._index.push(u._id),l.bbox=c);break;default:throw new Error(`_draw: the type "${r.features[n].geometry.type}" is unknown!`)}return l}function c(t,e,r){e.url.match(/.json/)?function(t,e){const r=new window.XMLHttpRequest;r.onreadystatechange=function(){4===r.readyState&&(200===r.status||0===r.status?e(!1,r,r.responseText):e(!0,r))},r.open("GET",t,!0),r.send(null)}(e.url,(t,o,i)=>{const n=JSON.parse(i),a=l(e,n,n._source,n._copyright);r&&r(a)}):t.load(e.url,()=>{const o=l(e,t.getCollection(),t.getSource(),i);r&&r(o)})}o.extend(t,{setCoordPath:(t,e,r,o)=>l(t,e,r,o),load(t,e,r){return c(t,e,t=>{r&&r(t)}),this},getNECopyright:()=>i})}(),function(){const t=r.MapGL.GeoJSON.Util,e=r.MapGL.Common.Public,{Map:i}=r.MapGL.GeoJSON;o.extend(t,{initSettings:t=>(function(t){const r=o.extend(e.getTemplate(),{});o.isString(t.url)&&(r.url=t.url),r.type=o.isString(t.type)?t.type:"???",o.isLiteralObject(t.include)&&(r.include=o.clone(t.include)),o.isLiteralObject(t.exclude)&&(r.exclude=o.clone(t.exclude)),r.initial.zoom=o.isNumber(t.zoom)?t.zoom:0,r.viewport.initial.φ=t.coord&&o.isNumber(t.coord[0])?t.coord[0]:0,r.viewport.initial.λ=t.coord&&o.isNumber(t.coord[1])?t.coord[1]:0,r.viewport.initial.width=t.bbox&&o.isNumber(t.bbox.width)?t.bbox.width:1e3,r.viewport.initial.height=t.bbox&&o.isNumber(t.bbox.height)?t.bbox.height:1e3,r.zoom=r.initial.zoom,r.layer=Math.floor(r.zoom)>0?Math.floor(r.zoom):1,r.viewport.φ=r.viewport.initial.φ,r.viewport.λ=r.viewport.initial.λ,r.viewport.width=r.viewport.initial.width,r.viewport.height=r.viewport.initial.height;const n=i.getXYOnMapFromLatLon(r,r.viewport.φ,r.viewport.λ);return r.viewport.initial.x=n.x,r.viewport.initial.y=n.y,r.viewport.x=r.viewport.initial.x,r.viewport.y=r.viewport.initial.y,delete r.ext,delete r.kz,delete r.tile,delete r.token,delete r.viewport.limits,r})(t),reconcile:t=>(function(t){return{start:{x:t.x,y:t.y},end:{x:t.initial.x,y:t.initial.y}}})(t),setAsNewOrigin(t){return function(t){const{viewport:e}=t;t.initial.zoom=t.zoom,e.initial.x=e.x,e.initial.y=e.y,e.initial.φ=e.φ,e.initial.λ=e.λ}(t),this},getPotentialOverlays:t=>(function(t){const e=[];let r,o;for(let i=0;i<t.features.length;i++)r=t.features[i],o={},"Polygon"!==r.geometry.type&&"MultiPolygon"!==r.geometry.type||(o[r._id]={title:r._title,geometry:{type:r.geometry.type,coordinates:[]},_isGeoJSON:!0,_isEnabled:!1},e.push(o));return e})(t)})}(),function(){const t=r.MapGL.Raster.Public,e=r.MapGL.Raster.Renderer,i=r.MapGL.Common.Public,n=r.MapGL.GMapGL.Public,{LRU:a}=r,s=r.Tiler.Public;let l;l={_init(){return this._db.tiles=a({maxItems:1e3,maxAge:36e5}),this},_startTimer(){return this._timer=setTimeout(()=>{e.updateLayer(this._svg,this._db.map,this._db.tiles)},500),this},_stopTimer(){return clearTimeout(this._timer),this},_drawOneTile(t){return this._db.map=i.initSettings(this.type,t),e.drawCenterTile(this._svg,this._db.map),this},_shift(t,r){return e.shift(this._svg,this._db.map,this._db.tiles,t,r),this},_zoom(t){return this._stopTimer(),e.zoom(this._svg,this._db.map,this._db.tiles,t),this._startTimer(),this},draw(t){return this._db.map=i.initSettings(this.type,t),e.draw(this._svg,this._db.map,this._db.tiles),this},update(t,r,o,i){return this._stopTimer(),e.update(this._svg,this._db.map,this._db.tiles,t,r,o,i),this._startTimer(),this},zoom(t,e){const{map:r}=this._db;return r.viewport.φ=e.φ,r.viewport.λ=e.λ,r.viewport.top=e.y,r.viewport.left=e.x,s.updateViewport(r),this.update(0,0,t),this},getXYFromLatLon(t,e){const{map:r}=this._db,o=s.getXYFromLatLon(r,t,e);return i.fromPlanarMap2Chart(r,o.x,o.y)},getXYOnMapFromLatLon(t,e){return s.getXYFromLatLon(this._db.map,t,e)},getLatLonFromXY(t,e){const{map:r}=this._db,o={width:r.tile.width,height:r.tile.height},n=i.fromChart2PlanarMap(r,t,e);return s.getLatLonFromXY(n.x,n.y,o,r.layer)},getViewportCoord(){return s.getViewportCoord(this._db.map)},reconcile(){return s.getShiftToOrigin(this._db.map)},getOptimalZoom(t,e,r){return s.getOptimalZoom(this._db.map,t,e,r)},setLayer(){return this._stopTimer(),e.updateLayer(this._svg,this._db.map,this._db.tiles),this},setAsNewOrigin(){const{map:t}=this._db,{viewport:e}=t;return t.initial.zoom=t.zoom,e.initial.x=e.x,e.initial.y=e.y,e.initial.φ=e.φ,e.initial.λ=e.λ,this}},o.extend(t,{Raster:function(t,e){const r=n.GMapGL(t,e,l,"raster");return r._init(),r}})}(),function(){const t=r.MapGL.Raster.Renderer,e=r.MapGL.Common.Public,i=r.Tiler.Public;function n(t,e){t.$().select(".series").select(".maps").select(".raster").attr("transform","translate(0, 0) scale(1, 1)").empty().append("rect").attr("x",0).attr("y",0).attr("width",e.viewport.width).attr("height",e.viewport.height).attr("fill","#E8E8E8").parent().append("g").attr("transform","translate(0, 0) scale(1, 1)").attr("class","tiles")}function a(t,e){const r=new Image;let o=0;t.setAttributeNS(null,"style",`opacity:${o}`),r.addEventListener("load",()=>{const e=setInterval(()=>{o+=.05,t.setAttributeNS(null,"style",`opacity:${o}`),o>=1&&(t.setAttributeNS(null,"style","opacity:1"),clearInterval(e))},20)}),r.src=e.url}function s(t,r,o,i){const n=t.$();let s,l,c,u,h,d;n.select(".series").select(".maps").select(".raster").select(".tiles");const p=[],g=n.children();for(let t=0;t<g.length;t++)u=g[t].getAttribute("id"),u&&p.push(u);const y=[];for(let t=0;t<i.length;t++)s=o.get(i[t].id),s?l=s.value.url:(l=i[t].url,o.set(i[t].id,{url:l}),c=!0),y.push(i[t].id),d=e.fromPlanarMap2Chart(r,i[t].x,i[t].y),-1===p.indexOf(i[t].id)?(n.append("image").attr("id",i[t].id).alink("href",l).attr("x",d.x).attr("y",d.y).attr("width",i[t].width+.2).attr("height",i[t].height+.2),c&&(h=n.getElement(),a(h,i[t])),n.parent()):n.select(`#${i[t].id}`).attr("x",d.x).attr("y",d.y).attr("width",i[t].width+.2).attr("height",i[t].height+.2).parent();for(let t=0;t<p.length;t++)-1===y.indexOf(p[t])&&n.select(`#${p[t]}`).remove()}function l(t,r,o){const n=Math.round(r.zoom);if(n!==r.layer){r.layer=n,i.updateViewport(r),function(t,r,o,i){const n=t.$();let s,l,c,u,h;n.select(".series").select(".maps").select(".raster").select(".tiles");const d=[],p=n.children();for(let t=0;t<p.length;t++)c=p[t].getAttribute("id"),c&&d.push(c);for(let t=0;t<i.length;t++)s=o.get(i[t].id),s?l=s.value.url:(l=i[t].url,o.set(i[t].id,{url:l})),h=e.fromPlanarMap2Chart(r,i[t].x,i[t].y),n.append("image").attr("id",i[t].id).alink("href",l).attr("x",h.x).attr("y",h.y).attr("width",i[t].width+.2).attr("height",i[t].height+.2),u=n.getElement(),a(u,i[t]),n.parent();setTimeout(()=>{for(let t=0;t<d.length;t++)n.query(`#${d[t]}`)&&n.select(`#${d[t]}`).remove()},1500)}(t,r,o,i.getVisibleTiles(r))}}o.extend(t,{drawCenterTile(t,r){return n(t,r),function(t,r){const{url:o}=r,{tile:n}=r;i.getVisibleTiles(r);const a=e.fromPlanarMap2Chart(r,n.x*r.kz,n.y*r.kz);let s=`${o.protocol}${o.subdomains[0]}.`;s+=o.body.replace(/\{z\}/,Math.floor(r.layer)).replace(/\{x\}/,n.n.x).replace(/\{y\}/,n.n.y).replace(/\{retina\}/,o.retina),t.$().select(".series").select(".maps").select(".raster").select(".tiles").empty().append("image").attr("id",n.id).alink("href",s).attr("x",a.x).attr("y",a.y).attr("width",n.width*r.kz).attr("height",n.height*r.kz)}(t,r),this},draw(t,e,r){return function(t,e,r){const o=i.getVisibleTiles(e);n(t,e),s(t,e,r,o)}(t,e,r),this},shift(t,e,r,o,n){return function(t,e,r,o,n){i.shiftViewport(e,o,n),s(t,e,r,i.getVisibleTiles(e))}(t,e,r,o,n),this},zoom(t,e,r,o){return function(t,e,r,o){e.zoom=o,s(t,e,r,i.getVisibleTiles(e))}(t,e,r,o),this},update(t,e,r,o,n,a){return function(t,e,r,o,n,a,l){e.zoom=a,i.shiftViewport(e,o,n,l),s(t,e,r,i.getVisibleTiles(e))}(t,e,r,o,n,a),this},updateLayer(t,e,r){return l(t,e,r),this}})}(),function(){const t=r.MapGL.Raster.Util;o.extend(t,{})}(),function(){const t=r.MapGL.Vector.Public,e=r.MapGL.Vector.Renderer,{Util:i}=r.MapGL.Vector,n=r.MapGL.Common.Public,a=r.MapGL.GMapGL.Public,{LRU:s}=r,l=r.MapGL.Vector.Workers.Public;let c;c={_init(){this._taskQ=null,this._webGL=null,this._db={tiles:s({maxItems:10,maxAge:36e5}),symbol:[],scene:[],workers:{model:{processors:null},tile:{processors:null}}},e.addCanvas(this._svg),l.createWorkers(this._db.workers);const t=document.querySelector("#chart").firstElementChild;return this._webGL=r.WebGL(t,1024,1024),this},_drawOneTile(t,r){return this._db.map=n.initSettings(this.type,t),i.getData(this._db.map.style,(t,o,i)=>{this._db.style=t,this._db.icon=o,this._db.fonts=i,e.drawOneTile(this._webGL,this._db,r)}),this},_drawOneTileW(t,r){return this._db.map=n.initSettings(this.type,t),i.getData(this._db.map.style,(t,o,i)=>{this._db.style=t,this._db.icon=o,this._db.fonts=i,l.initWorkers(this._db.workers,this._db.style,this._db.icon,this._db.fonts),e.drawOneTileW(this._webGL,this._db,r)}),this},_shift(){return this},_zoom(){return this},draw(){return this},update(){return this},updateLayer(){return this},getXYFromLatLon(){},getLatLonFromXY(){}},o.extend(t,{Vector:function(t,e){const r=a.GMapGL(t,e,c,"vector");return r._init(),r}})}(),function(){const t=r.MapGL.Vector.Renderer;o.extend(t,{addCanvas(t){return function(t){const e=t.$().getElement().parentNode,r=document.createElement("canvas");e.insertBefore(r,e.childNodes[0]),e.style.position="relative";const o=e.firstElementChild,i=o.nextElementSibling;o.style.position="absolute",o.style.top=0,o.style.left=0,i.style.position="absolute",i.style.top=0,i.style.left=0}(t),this}})}(),function(){const t=r.MapGL.Vector.Renderer,e=r.PBF.Public,i=r.Source.Load,{Geo:n}=r.MapGL.Vector.Source,{Styler:a}=r.MapGL.Vector.Source,{RPolygon:s}=r.MapGL.Vector.Source,{RPolyline:l}=r.MapGL.Vector.Source,{RPoint:c}=r.MapGL.Vector.Source,{Drawer:u}=r.MapGL.Vector;function h(t,e,r,o,i,n){const{iLayers:a}=t.index(e.layers,i),s=[];let l;switch(r.type){case"POLYGON":l=t.extract(i,a,o,"Polygon",r.properties,n);break;case"LINESTRING":l=t.extract(i,a,o,"LineString",r.properties,n);break;case"POINT":l=t.extract(i,a,o,"Point",r.properties,n)}for(let t=0;t<l.length;t++)s[t]=i.layers[l[t]];return s}function d(t,r,o){i.load(r.url,"bin",(i,u,d)=>{r.layers=e.Tile.decode(d),function(t,e){const r=n.create(),o=a.create(),i=s.create(),u=l.create(),d=c.create(),{style:p}=e,{fonts:g}=e,{icon:y}=e;let m,f;for(let e=0;e<t.layers.length;e++){m=t.layers[e];for(let e=0;e<m.features.length;e++)switch(f=m.features[e],f.properties=r.getProperties(f,m.keys,m.values),f.styles=h(o,t,f,m.name,p,t.zoom),f.type){case"POLYGON":i.process(f);break;case"LINESTRING":f.polygons=[];for(let t=0;t<f.styles.length;t++)switch(f.styles[t].type){case"line":u.process(f,f.styles[t]);break;case"symbol":console.log("symbol")}break;case"POINT":d.process(f,g,y,t.zoom);break;default:throw new Error(`worker.process: the type "${f.type}" is unsupported!`)}}}(r,t),o(r)})}function p(t,e){u.drawScene(t,e)}o.extend(t,{drawOneTile(t,e,r){return function(t,e,r){const{map:o}=e,i=/(\/\d+.*\d\.)/.exec(r)[0].match(/\d+/g).map(Number),n={id:`z${i[0]}x${i[1]}y${i[2]}`,url:r,x:-512,y:512,width:o.tile.width,height:o.tile.height,zoom:o.zoom};d(e,n,r=>{e.tiles.set(r.id,r),e.scene=[],e.scene.push(r.id),p(t,e)})}(t,e,r),this},drawOneTileW(t,e,r){return function(t,e,r){const{map:o}=e,{workers:i}=e,n=/(\/\d+.*\d\.)/.exec(r)[0].match(/\d+/g).map(Number),a={id:`z${n[0]}x${n[1]}y${n[2]}`,url:r,x:-512,y:512,width:o.tile.width,height:o.tile.height,zoom:o.zoom};i.tile.processors[0].w.onmessage=function(r){e.tiles.set(r.data.payload.id,r.data.payload),e.scene=[],e.scene.push(r.data.payload.id),p(t,e)},i.tile.processors[0].w.postMessage({wid:0,method:"process",payload:a})}(t,e,r),this}})}(),function(){const t=r.MapGL.Vector.Drawer,{Styler:e}=r.MapGL.Vector.Source,{Sprite:i}=r.MapGL.Vector.Source,{Color:n}=r.Source;o.extend(t,{drawScene(t,r){!function(t,r){const o=e.create(),a=n.create(),s=i.create(),{viewport:l}=r.map,c=o.getBackgroundStyle(r.style,r.map.zoom),u=r.scene,h=1+r.map.zoom%1;let d,p,g,y,m,f,b,x,_,w;for(t.empty().fillBackground(c?a.toRGBA(o.getColor(c)):"white"),b=0;b<u.length;b++)for(d=r.tiles.get(u[b]).value,t.setTransform(d.x-l.x,-(d.y-l.y),h),x=0;x<d.layers.length;x++)for(_=0;_<d.layers[x].features.length;_++)switch(p=d.layers[x].features[_],p.type){case"POLYGON":if(!p.styles)break;for(w=0;w<p.styles.length;w++)t.fillStyle(a.toRGBA(p.color[w])).fillPolygon(p.vertices);break;case"LINESTRING":if(!p.styles)break;for(w=0;w<p.styles.length;w++)switch(p.styles[w].type){case"line":t.fillStyle(a.toRGBA(p.polygons[w].color)).fillPolygon(p.polygons[w].vertices)}break;case"POINT":if(!p.styles)break;for(w=0;w<p.styles.length&&(g=p.symbol[w],y=g.icon,m=g.text,f=p.styles[w],!(g.x<-.03*g.tileSize||g.y<-.03*g.tileSize||g.x>1.03*g.tileSize||g.y>1.03*g.tileSize));w++)y.name&&(y.image||(y.image=s.getIcon(r.icon.image.atlas,{x:y.sx,y:y.sy,width:y.swidth,height:y.sheight}),y.sx=0,y.sy=0),t.drawImage(y.image,y.sx,y.sy,y.swidth,y.sheight,y.dx,y.dy,y.dwidth,y.dheight)),m.value&&t.textAlign(m.align).textBaseline(m.baseline).font(m.font.family,m.font.size).fillStyle(a.toRGBA(m.color)).haloColor(a.toRGBA(f.rpaint["text-halo-color"])).haloWidth(f.rpaint["text-halo-width"]).drawGlyph(m.glyph.image,m.glyph.vertex,m.glyph.texture,m.x,m.y,m.glyph.dx,m.glyph.dy);break;default:throw new Error(`_drawScene: the geometry "${p.type}" does not exist!`)}}(t,r)}})}(),function(){const t=r.MapGL.Vector.Util,e=r.Source.Load,i=r.MapGL.Vector.Source.Styler,n=r.MapGL.Vector.Source.Sprite,a=r.PBF.Public;function s(t,r){return new Promise(o=>{e.load(t,r,(t,e,r)=>{o(r)})})}async function l(t,e){const r={url:null,style:null,image:new Image};let o=await s(t,"json");o=JSON.parse(o);const l=i.create(),c=n.create();l.extendStyle(o);const u=await s(`${o.sprite}/sprite@2x.json`,"json");r.style=JSON.parse(u),r.url=`${window.location.origin}${o.sprite}/sprite@2x.json`;const h=await s(`${o.sprite}/sprite@2x.png`,"blob");await function(t,e){return new Promise(r=>{t.image.addEventListener("load",()=>{r()}),t.image.src=e})}(r,h),c.createAtlas(r.image);const d=await s(`${o.sprite}/fonts/DIN Offc Pro Medium/0-255.pbf`,"bin"),p={};p.default={"0-255":a.Font.decode(d)[0]},p["DIN Offc Pro Medium"]=p.default,e(o,r,p)}o.extend(t,{getData(t,e){l(t,e)}})}(),function(){const t=r.MapGL.Vector.Source.Earcut;function e(){function t(t,i,n){n=n||2;var a,s,u,d,p,g,y,m=i&&i.length,f=m?i[0]*n:t.length,b=e(t,0,f,n,!0),x=[];if(!b)return x;if(m&&(b=function(t,o,i,n){var a,s,u,d,p,g=[];for(a=0,s=o.length;a<s;a++)u=o[a]*n,d=a<s-1?o[a+1]*n:t.length,(p=e(t,u,d,n,!1))===p.next&&(p.steiner=!0),g.push(h(p));for(g.sort(l),a=0;a<g.length;a++)c(g[a],i),i=r(i,i.next);return i}(t,i,b,n)),t.length>80*n){a=u=t[0],s=d=t[1];for(var _=n;_<f;_+=n)(p=t[_])<a&&(a=p),(g=t[_+1])<s&&(s=g),p>u&&(u=p),g>d&&(d=g);y=0!==(y=Math.max(u-a,d-s))?1/y:0}return o(b,x,n,a,s,y),x}function e(t,e,r,o,i){var n,a;if(i===v(t,e,r,o)>0)for(n=e;n<r;n+=o)a=x(n,t[n],t[n+1],a);else for(n=r-o;n>=e;n-=o)a=x(n,t[n],t[n+1],a);return a&&y(a,a.next)&&(_(a),a=a.next),a}function r(t,e){if(!t)return t;e||(e=t);var r,o=t;do{if(r=!1,o.steiner||!y(o,o.next)&&0!==g(o.prev,o,o.next))o=o.next;else{if(_(o),(o=e=o.prev)===o.next)break;r=!0}}while(r||o!==e);return e}function o(t,e,l,c,h,d,p){if(t){!p&&d&&function(t,e,r,o){var i=t;do{null===i.z&&(i.z=u(i.x,i.y,e,r,o)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,o,i,n,a,s,l,c=1;do{for(r=t,t=null,n=null,a=0;r;){for(a++,o=r,s=0,e=0;e<c&&(s++,o=o.nextZ);e++);for(l=c;s>0||l>0&&o;)0!==s&&(0===l||!o||r.z<=o.z)?(i=r,r=r.nextZ,s--):(i=o,o=o.nextZ,l--),n?n.nextZ=i:t=i,i.prevZ=n,n=i;r=o}n.nextZ=null,c*=2}while(a>1)}(i)}(t,c,h,d);for(var g,y,m=t;t.prev!==t.next;)if(g=t.prev,y=t.next,d?n(t,c,h,d):i(t))e.push(g.i/l),e.push(t.i/l),e.push(y.i/l),_(t),t=y.next,m=y.next;else if((t=y)===m){p?1===p?o(t=a(t,e,l),e,l,c,h,d,2):2===p&&s(t,e,l,c,h,d):o(r(t),e,l,c,h,d,1);break}}}function i(t){var e=t.prev,r=t,o=t.next;if(g(e,r,o)>=0)return!1;for(var i=t.next.next;i!==t.prev;){if(d(e.x,e.y,r.x,r.y,o.x,o.y,i.x,i.y)&&g(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function n(t,e,r,o){var i=t.prev,n=t,a=t.next;if(g(i,n,a)>=0)return!1;for(var s=i.x<n.x?i.x<a.x?i.x:a.x:n.x<a.x?n.x:a.x,l=i.y<n.y?i.y<a.y?i.y:a.y:n.y<a.y?n.y:a.y,c=i.x>n.x?i.x>a.x?i.x:a.x:n.x>a.x?n.x:a.x,h=i.y>n.y?i.y>a.y?i.y:a.y:n.y>a.y?n.y:a.y,p=u(s,l,e,r,o),y=u(c,h,e,r,o),m=t.prevZ,f=t.nextZ;m&&m.z>=p&&f&&f.z<=y;){if(m!==t.prev&&m!==t.next&&d(i.x,i.y,n.x,n.y,a.x,a.y,m.x,m.y)&&g(m.prev,m,m.next)>=0)return!1;if(m=m.prevZ,f!==t.prev&&f!==t.next&&d(i.x,i.y,n.x,n.y,a.x,a.y,f.x,f.y)&&g(f.prev,f,f.next)>=0)return!1;f=f.nextZ}for(;m&&m.z>=p;){if(m!==t.prev&&m!==t.next&&d(i.x,i.y,n.x,n.y,a.x,a.y,m.x,m.y)&&g(m.prev,m,m.next)>=0)return!1;m=m.prevZ}for(;f&&f.z<=y;){if(f!==t.prev&&f!==t.next&&d(i.x,i.y,n.x,n.y,a.x,a.y,f.x,f.y)&&g(f.prev,f,f.next)>=0)return!1;f=f.nextZ}return!0}function a(t,e,r){var o=t;do{var i=o.prev,n=o.next.next;!y(i,n)&&m(i,o,o.next,n)&&f(i,n)&&f(n,i)&&(e.push(i.i/r),e.push(o.i/r),e.push(n.i/r),_(o),_(o.next),o=t=n),o=o.next}while(o!==t);return o}function s(t,e,i,n,a,s){var l=t;do{for(var c=l.next.next;c!==l.prev;){if(l.i!==c.i&&p(l,c)){var u=b(l,c);return l=r(l,l.next),u=r(u,u.next),o(l,e,i,n,a,s),void o(u,e,i,n,a,s)}c=c.next}l=l.next}while(l!==t)}function l(t,e){return t.x-e.x}function c(t,e){if(e=function(t,e){var r,o=e,i=t.x,n=t.y,a=-1/0;do{if(n<=o.y&&n>=o.next.y&&o.next.y!==o.y){var s=o.x+(n-o.y)*(o.next.x-o.x)/(o.next.y-o.y);if(s<=i&&s>a){if(a=s,s===i){if(n===o.y)return o;if(n===o.next.y)return o.next}r=o.x<o.next.x?o:o.next}}o=o.next}while(o!==e);if(!r)return null;if(i===a)return r.prev;var l,c=r,u=r.x,h=r.y,p=1/0;o=r.next;for(;o!==c;)i>=o.x&&o.x>=u&&i!==o.x&&d(n<h?i:a,n,u,h,n<h?a:i,n,o.x,o.y)&&((l=Math.abs(n-o.y)/(i-o.x))<p||l===p&&o.x>r.x)&&f(o,t)&&(r=o,p=l),o=o.next;return r}(t,e)){var o=b(e,t);r(o,o.next)}}function u(t,e,r,o,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*i)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-o)*i)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function h(t){var e=t,r=t;do{e.x<r.x&&(r=e),e=e.next}while(e!==t);return r}function d(t,e,r,o,i,n,a,s){return(i-a)*(e-s)-(t-a)*(n-s)>=0&&(t-a)*(o-s)-(r-a)*(e-s)>=0&&(r-a)*(n-s)-(i-a)*(o-s)>=0}function p(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&m(r,r.next,t,e))return!0;r=r.next}while(r!==t);return!1}(t,e)&&f(t,e)&&f(e,t)&&function(t,e){var r=t,o=!1,i=(t.x+e.x)/2,n=(t.y+e.y)/2;do{r.y>n!=r.next.y>n&&r.next.y!==r.y&&i<(r.next.x-r.x)*(n-r.y)/(r.next.y-r.y)+r.x&&(o=!o),r=r.next}while(r!==t);return o}(t,e)}function g(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function y(t,e){return t.x===e.x&&t.y===e.y}function m(t,e,r,o){return!!(y(t,e)&&y(r,o)||y(t,o)&&y(r,e))||g(t,e,r)>0!=g(t,e,o)>0&&g(r,o,t)>0!=g(r,o,e)>0}function f(t,e){return g(t.prev,t,t.next)<0?g(t,e,t.next)>=0&&g(t,t.prev,e)>=0:g(t,e,t.prev)<0||g(t,t.next,e)<0}function b(t,e){var r=new w(t.i,t.x,t.y),o=new w(e.i,e.x,e.y),i=t.next,n=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,o.next=r,r.prev=o,n.next=o,o.prev=n,o}function x(t,e,r,o){var i=new w(t,e,r);return o?(i.next=o.next,i.prev=o,o.next.prev=i,o.next=i):(i.prev=i,i.next=i),i}function _(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function w(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function v(t,e,r,o){for(var i=0,n=e,a=r-o;n<r;n+=o)i+=(t[a]-t[n])*(t[n+1]+t[a+1]),a=n;return i}return t.deviation=function(t,e,r,o){var i=e&&e.length,n=i?e[0]*r:t.length,a=Math.abs(v(t,0,n,r));if(i)for(var s=0,l=e.length;s<l;s++){var c=e[s]*r,u=s<l-1?e[s+1]*r:t.length;a-=Math.abs(v(t,c,u,r))}var h=0;for(s=0;s<o.length;s+=3){var d=o[s]*r,p=o[s+1]*r,g=o[s+2]*r;h+=Math.abs((t[d]-t[g])*(t[p+1]-t[d+1])-(t[d]-t[p])*(t[g+1]-t[d+1]))}return 0===a&&0===h?0:Math.abs((h-a)/a)},t.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},o=0,i=0;i<t.length;i++){for(var n=0;n<t[i].length;n++)for(var a=0;a<e;a++)r.vertices.push(t[i][n][a]);i>0&&(o+=t[i-1].length,r.holes.push(o))}return r},{earcut:t,flatten:t.flatten,deviation:t.deviation}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.MapGL.Vector.Source.Geo;function e(){const t=function(t){let e=0,r=t.length-1;for(let o=0;o<t.length;o++)e+=(t[r][0]-t[o][0])*(t[r][1]+t[o][1]),r=o;return e>0};return{getProperties:function(t,e,r){return function(t,e,r){const o={};let i,n,a;a=0;do{i=t.tags[a],a+=1,n=t.tags[a],a+=1,o[e[i]]=r[n]}while(a<t.tags.length);return o}(t,e,r)},isClockwise:function(e){return t(e)},fromGeom2Multipolygon:function(e){return function(e){const r=[];let o,i,n,a,s,l,c,u=0,h=0,d=[],p=[];l=0;do{switch(i=7&e[l],n=e[l]>>3,l+=1,i){case 1:c=0;do{a=e[l+c]>>1^-(1&e[l+c]),s=e[l+c+1]>>1^-(1&e[l+c+1]),u+=a,h+=s,c+=2}while(c<2*n);0===p.length?p.push([u,h]):(t(p)?0===d.length?d.push(p):(r.push(d),d=[],d.push(p)):d.push(p),p=[],p.push([u,h])),l+=2*n;break;case 2:c=0;do{a=e[l+c]>>1^-(1&e[l+c]),s=e[l+c+1]>>1^-(1&e[l+c+1]),u+=a,h+=s,p.push([u,h]),c+=2}while(c<2*n);l+=2*n;break;case 7:o=!0,t(p)?0===d.length?d.push(p):(r.push(d),d=[],d.push(p)):d.push(p),p=[];break;default:throw new Error(`_fromGeom2Multipolygon: the command id "${i}" is unknown!`)}}while(l<e.length);if(0!==p.length)throw new Error("_fromGeom2Multipolygon: ring not empty!");return 0!==d.length&&r.push(d),{multi:r,closedPath:o}}(e)},coord2Multipolygon:function(e){return function(e){const r=[];let o=[];for(let i=0;i<e.length;i++)t(e[i])&&0!==o.length?(r.push(o),o=[],o.push(e[i])):o.push(e[i]);return o.length>0&&r.push(o),r}(e)},fromGeom2Coord:function(t){return function(t){const e=[];let r,o,i,n,a,s,l,c=0,u=0,h=[];s=0;do{switch(o=7&t[s],i=t[s]>>3,s+=1,o){case 1:l=0;do{n=t[s+l]>>1^-(1&t[s+l]),a=t[s+l+1]>>1^-(1&t[s+l+1]),c+=n,u+=a,l+=2}while(l<2*i);0===h.length?h.push([c,u]):(e.push(h),h=[],h.push([c,u])),s+=2*i;break;case 2:l=0;do{n=t[s+l]>>1^-(1&t[s+l]),a=t[s+l+1]>>1^-(1&t[s+l+1]),c+=n,u+=a,h.push([c,u]),l+=2}while(l<2*i);s+=2*i;break;case 7:r=!0,e.push(h),h=[];break;default:throw new Error(`_fromGeom2Coord: the command id "${o}" is unknown!`)}}while(s<t.length);return 0!==h.length&&e.push(h),{coord:e,closedPath:r}}(t)}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.MapGL.Vector.Source.GlyphAtlas;function e(){return{width:0,height:0,data:new Uint8Array(0),set:function(t,e){!function(t,e,r){t.width=e,t.height=r,t.data=new Uint8Array(4*t.width*t.height)}(this,t,e)},add:function(t,e){!function(t,e,r){const o=e.width*e.height*4;let i=96*r,n=0;do{for(let r=0;r<4*e.width;r+=4)t.data[i+r+0]=e.data[n+r+0],t.data[i+r+1]=e.data[n+r+1],t.data[i+r+2]=e.data[n+r+2],t.data[i+r+3]=e.data[n+r+3];n+=4*e.width,i+=4*t.width}while(n<o)}(this,t,e)}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.MapGL.Vector.Source.RPoint,{Styler:e}=r.MapGL.Vector.Source,{Geo:i}=r.MapGL.Vector.Source,{Sprite:n}=r.MapGL.Vector.Source,{RText:a}=r.MapGL.Vector.Source;function s(t,e,r,o){const i=t||StylerLibrary(),n=e||GeoLibrary(),a=r||SpriteLibrary(),s=o||RTextLibrary(),l=function(t,e,r,o,n){const l=1+n%1;let c;t.x=t.coord[0][0]*l,t.y=t.coord[0][1]*l,e.rlayout["icon-image"]&&(c=function(t,e,r){const o=r.style[e.rlayout["icon-image"]],i=e.rlayout["icon-anchor"],n=[];let s,l;if(!o)return null;switch(i){case"center":s=t.x-o.width*o.pixelRatio/2,l=t.y-o.height*o.pixelRatio/2,n[0]=o.width*o.pixelRatio/2+e.rlayout["icon-padding"],n[1]=o.height*o.pixelRatio/2+e.rlayout["icon-padding"]}return self?(t.icon.image=null,t.icon.sx=o.x,t.icon.sy=o.y):(t.icon.image=a.getIcon(r.image.atlas,o),t.icon.sx=0,t.icon.sy=0),t.icon.name=e.rlayout["icon-image"],t.icon.swidth=o.width,t.icon.sheight=o.height,t.icon.dx=s,t.icon.dy=l,t.icon.dwidth=o.width/o.pixelRatio,t.icon.dheight=o.height/o.pixelRatio,n}(t,e,o)),e.rlayout["text-field"]&&function(t,e,r,o){const n=e.rlayout["text-offset"],a=o||[0,0],l=e.rlayout["text-padding"];switch(t.text.align=e.rlayout["text-justify"],"uppercase"===e.rlayout["text-transform"]?t.text.value=e.rlayout["text-field"].toUpperCase():"lowercase"===e.rlayout["text-transform"]?t.text.value=e.rlayout["text-field"].toLowerCase():t.text.value=e.rlayout["text-field"],t.text.font.family=e.rlayout["text-font"],t.text.font.size=e.rlayout["text-size"],t.text.color=i.getColor(e),e.rlayout["text-anchor"]){case"center":t.text.align="center",t.text.baseline="middle",t.text.x=t.x,t.text.y=t.y;break;case"left":t.text.align="left",t.text.baseline="middle",t.text.x=t.x+a[0]+n[0]+l,t.text.y=t.y+n[1]+l;break;case"right":t.text.align="right",t.text.baseline="middle",t.text.x=t.x-a[0]+n[0]+l,t.text.y=t.y+n[1]+l;break;case"top":t.text.baseline="top",t.text.x=t.x,t.text.y=t.y+a[1]+n[1]+l;break;case"bottom":t.text.baseline="bottom",t.text.x=t.x+n[0]+l,t.text.y=t.y-a[1]+n[1]+l;break;case"top-left":t.text.align="left",t.text.baseline="top",t.text.x=t.x+a[0]+n[0]+l,t.text.y=t.y-a[1]+n[1]+l;break;case"top-right":t.text.align="right",t.text.baseline="top",t.text.x=t.x-a[0]+n[0]+l,t.text.y=t.y+a[1]+n[1]+l;break;case"bottom-left":t.text.align="left",t.text.baseline="bottom",t.text.x=t.x+a[0]+n[0]+l,t.text.y=t.y-a[1]+n[1]+l;break;case"bottom-right":t.text.align="right",t.text.baseline="bottom",t.text.x=t.x-a[0]+n[0]+l,t.text.y=t.y-a[1]+n[1]+l;break;default:throw new Error(`_drawText: the text-anchor "${e.rlayout["text-anchor"]}" is illegal!`)}t.text.glyph=s.process(r,t.text)}(t,e,r,c)};return{process:function(t,e,r,o){!function(t,e,r,o){const i=n.fromGeom2Coord(t.geometry).coord[0];t.symbol=[];for(let n=0;n<t.styles.length;n++)t.symbol[n]={tileSize:null,coord:null,x:null,y:null,icon:{name:null,image:null,sx:null,sy:null,swidth:null,sheight:null,dx:null,dy:null,dwidth:null,dheight:null},text:{value:"",baseline:null,align:null,color:null,x:null,y:null,font:{family:null,size:null}}},t.symbol[n].tileSize=4096*(1+o%1),t.symbol[n].coord=i,l(t.symbol[n],t.styles[n],e,r,o)}(t,e,r,o)}}}o.extend(t,{getSource:()=>s.toString(),create:()=>s(e.create(),i.create(),n.create(),a.create())})}(),function(){const t=r.MapGL.Vector.Source.RPolygon,{Styler:e}=r.MapGL.Vector.Source,{Geo:i}=r.MapGL.Vector.Source,{Earcut:n}=r.MapGL.Vector.Source;function a(t,e,r){const o=t||StylerLibrary(),i=e||GeoLibrary(),n=r||EarcutLibrary(),a=function(t){const e=[];for(let r=0;r<t.styles.length;r++)e.push(o.getColor(t.styles[r]));return e};return{process:function(t){!function(t){const e=i.fromGeom2Multipolygon(t.geometry).multi;let r,o;t.vertices=[];for(let i=0;i<e.length;i++){r=n.flatten(e[i]),o=n.earcut(r.vertices,r.holes,r.dimensions);for(let e=0;e<o.length;e++)t.vertices.push(r.vertices[o[e]*r.dimensions]),t.vertices.push(r.vertices[o[e]*r.dimensions+1])}t.color=a(t)}(t)},update:function(t){!function(t){t.color=a(t)}(t)}}}o.extend(t,{getSource:()=>a.toString(),create:()=>a(e.create(),i.create(),n.create())})}(),function(){const t=r.MapGL.Vector.Source.RPolyline,{Styler:e}=r.MapGL.Vector.Source,{Geo:i}=r.MapGL.Vector.Source;function n(t,e){const r=t||StylerLibrary(),o=e||GeoLibrary(),i=function(t,e,r){const o=Math.atan2(e,t);return 0===t?{x:r,y:0}:0===e?{x:0,y:r}:{x:Math.sin(o)*r,y:Math.cos(o)*r}},n=function(t,e,r){const o=[],n=e*r;let a,s,l,c,u;for(let e=0;e<t.length;e++)for(let r=0;r<t[e].length-1;r++)[a,s]=t[e][r],[l,c]=t[e][r+1],u=i(l-a,c-s,n/2),o.push(a-u.x,s+u.y,l-u.x,c+u.y,l+u.x,c-u.y,l+u.x,c-u.y,a+u.x,s-u.y,a-u.x,s+u.y);return o};return{process:function(t,e){!function(t,e){const{coord:i}=o.fromGeom2Coord(t.geometry),a=e.rpaint["line-width"]+e.rpaint["line-gap-width"];t.polygons.push({coord:i,vertices:n(i,a,4),color:r.getColor(e),width:a})}(t,e)},update:function(t,e,o){!function(t,e,o){const i=e[o],a=i.rpaint["line-width"]+i.rpaint["line-gap-width"];if(a!==t.polygons[o].width){const{coord:e}=t.polygons[o];t.polygons[o].vertices=n(e,a,4),t.polygons[o].width=a}t.polygons[o].color=r.getColor(i)}(t,e,o)}}}o.extend(t,{getSource:()=>n.toString(),create:()=>n(e.create(),i.create())})}(),function(){const t=r.MapGL.Vector.Source.RText,{GlyphAtlas:e}=r.MapGL.Vector.Source;function i(t){const e=t||GlyphAtlasLibrary();return{process:function(t,r){return function(t,r){const{align:o}=r,{baseline:i}=r,n=r.font.size/24,a=[],s=[];let l,c,u,h,d,p,g,y,m,f,b,x,_,w=-3;for(t[r.font.family[0]]?l=t[r.font.family[0]]["0-255"]:(t.missing||(t.missing=[]),-1===t.missing.indexOf(r.font.family[0])&&t.missing.push(r.font.family[0]),l=t.default["0-255"]),l.index||function(t){let e;t.index=[];for(let r=0;r<t.glyphs.length;r++)e=t.glyphs[r].id,t.index[r]=e}(l),e.set(24*r.value.length,24),x=0;x<r.value.length;x++)u=r.value.slice(x,x+1),_=l.index.indexOf(u.charCodeAt(0)),c=l.glyphs[_]?l.glyphs[_]:l.glyphs["?".charCodeAt(0)],e.add(c.bitmap,x),h=24*x,d=0,p=c.bitmap.width,g=c.bitmap.height,y=w+c.metrics.left,m=1.5-(24+c.metrics.top+6),f=c.bitmap.width,b=c.bitmap.height,a.push(y,m,y+f,m,y,m+b,y+f,m,y,m+b,y+f,m+b),s.push(h,0,h+p,0,h,0+g,h+p,0,h,0+g,h+p,0+g),w+=c.metrics.advance;const v=function(t,e,r,o,i,n){let a,s;switch(e){case"left":a=0;break;case"right":a=-(t+i)*o;break;case"center":a=-(t+i/2)*(o/2);break;case"start":a=0;break;case"end":a=-(t+i)*o;break;default:a=0}switch(r){case"top":s=.75*n*o;break;case"hanging":s=.5*n*o;break;case"middle":s=.25*n*o;break;case"alphabetic":case"ideographic":s=0;break;case"bottom":s=-.25*n*o;break;default:s=0}return{x:a,y:s}}(w,o,i,n,3,24);return{image:{width:e.width,height:e.height,data:e.data},vertex:a,texture:s,dx:v.x,dy:v.y}}(t,r)}}}o.extend(t,{getSource:()=>i.toString(),create:()=>i(e.create())})}(),function(){const t=r.MapGL.Vector.Source.Sprite;function e(){return{createAtlas:function(t){!function(t){const e=document.createElement("canvas"),r=e.getContext("2d");e.width=t.naturalWidth,e.height=t.naturalHeight,r.drawImage(t,0,0),t.atlas=r}(t)},drawIcon:function(t,e){!function(t,e){const r=document.getElementById("canvas").getContext("2d"),o=t.getImageData(e.x,e.y,e.width,e.height);r.putImageData(o,0,0)}(t,e)},getIcon:function(t,e){return t.getImageData(e.x,e.y,e.width,e.height)}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.MapGL.Vector.Source.Styler,e=r.Source.Color;function i(t){const r=t||e(),o={isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),hasProperty(t,e){return!(!this.isLiteralObject(t)||!this.isString(e))&&Object.prototype.hasOwnProperty.call(t,e)}},i=function(t,e){let r,i,n,a=e;if(o.isString(e)){if(r=e.match(/{(.*?)}/g),r){for(n=0;n<r.length;n++)i=r[n].replace(/{|}/g,""),a=a.replace(r[n],t[i]?t[i]:"");return a}return e}return e},n=function(t,e,r,o){const i=r.x-e.x,n=o-e.x;let a;return o<=e.x?e.y:o>=r.x?r.y:1===t?(a=n/i,e.y+(r.y-e.y)*a):(a=(Math.pow(t,n)-1)/(Math.pow(t,i)-1),e.y*(1-a)+r.y*a)},a=function(t,e,i){const a=["background-color","background-opacity","fill-opacity","fill-color","fill-outline-color","fill-translate","line-miter-limit","line-round-limit","line-opacity","line-color","line-translate","line-width","line-gap-width","line-offset","line-blur","symbol-spacing","icon-size","icon-tex-fit-padding","icon-rotate","icon-padding","icon-offset","text-size","text-max-width","text-line-height","text-letter-spacing","text-max-angle","text-rotate","text-padding","text-offset","icon-opacity","icon-color","icon-halo-color","icon-halo-width","icon-halo-blur","icon-translate","text-opacity","text-color","text-halo-color","text-halo-width","text-halo-blur","text-translate"],s={"background-color":"c","background-opacity":1,"fill-opacity":1,"fill-color":"c","fill-outline-color":"c","fill-translate":[],"line-miter-limit":1,"line-round-limit":1,"line-opacity":1,"line-color":"c","line-translate":[],"line-width":1,"line-gap-width":1,"line-offset":1,"line-blur":1,"symbol-spacing":1,"icon-size":1,"icon-text-fit-padding":[],"icon-rotate":1,"icon-padding":1,"icon-offset":[],"text-size":1,"text-max-width":1,"text-line-height":1,"text-letter-spacing":1,"text-max-angle":1,"text-rotate":1,"text-padding":1,"text-offset":[],"icon-opacity":1,"icon-color":"c","icon-halo-color":"c","icon-halo-width":1,"icon-halo-blur":1,"icon-translate":[],"text-opacity":1,"text-color":"c","text-halo-color":"c","text-halo-width":1,"text-halo-blur":1,"text-translate":[]}[t],l=e.base||1;let c;const u=function(t,e){let r,i,n,a;if(!o.isArray(t))throw new Error("_findInterval: first argument must be an array!");for(i=!0,a=0;a<t.length;a++){if(e===t[a][0]){n=a;break}if(e<t[a][0])break}return n||0===n?r=t[n][1]:0===a?r=t[0][1]:a===t.length?r=t[a-1][1]:(i=!1,r=t.slice(a-1,a+1)),{match:i,val:r}}(e.stops,i);if(u.match)return u.val;if(-1===a.indexOf(t))return u.val[0][1];if(o.isNumber(s))c=n(l,{x:u.val[0][0],y:u.val[0][1]},{x:u.val[1][0],y:u.val[1][1]},i);else if(o.isString(s)&&"c"===s)c=function(t,e,o,i){const a=r.getHSL(e.y),s=r.getHSL(o.y),l=n(t,{x:e.x,y:a[0]},{x:o.x,y:s[0]},i),c=n(t,{x:e.x,y:a[1]},{x:o.x,y:s[1]},i),u=n(t,{x:e.x,y:a[2]},{x:o.x,y:s[2]},i);return`hsl(${Math.round(l)}, ${Math.round(c)}%, ${Math.round(u)}%`}(l,{x:u.val[0][0],y:u.val[0][1]},{x:u.val[1][0],y:u.val[1][1]},i);else{if(!o.isArray(s))throw new Error(`_computePropertyValue: the type "${s}" is unknown!`);c=function(t,e,r,o){const i=[];for(let a=0;a<e.y.length;a++)i.push(n(t,{x:e.x,y:e[a]},{x:r.x,y:r[a]},o));return i}(l,{x:u.val[0][0],y:u.val[0][1]},{x:u.val[1][0],y:u.val[1][1]},i)}return c},s=function(t,e,r){const n=function(t){switch(t){case"background":case"fill":return{visibility:"visible"};case"line":return{"line-cap":"butt","line-join":"miter","line-miter-limit":2,"line-round-limit":1.05,visibility:"visible"};case"symbol":return{"symbol-placement":"point","symbol-spacing":250,"symbol-avoid-edges":!1,"icon-allow-overlap":!1,"icon-ignore-placement":!1,"icon-optional":!1,"icon-rotation-alignment":"auto","icon-size":1,"icon-text-fit":"none","icon-text-fit-padding":[0,0,0,0],"icon-image":null,"icon-rotate":0,"icon-padding":2,"icon-keep-upright":!1,"icon-offset":[0,0],"icon-anchor":"center","icon-pitch-alignment":"auto","text-pitch-alignment":"auto","text-rotation-alignment":"auto","text-field":"","text-font":["Open Sans Regular","Arial Unicode MS Regular"],"text-size":16,"text-max-width":10,"text-line-height":1.2,"text-letter-spacing":0,"text-justify":"center","text-anchor":"center","text-max-angle":45,"text-rotate":0,"text-padding":2,"text-keep-upright":!0,"text-transform":"none","text-offset":[0,0],"text-allow-overlap":!1,"text-ignore-placement":!1,"text-optional":!1,visibility:"visible"};default:throw new Error(`_getLayoutTemplate: "${t}" is not implemented yet!`)}}(e.type),s=Object.keys(n);for(let l=0;l<s.length;l++)e.layout[s[l]]&&!o.isLiteralObject(e.layout[s[l]])?n[s[l]]=e.layout[s[l]]:(o.hasProperty(e.layout[s[l]],"base")||o.hasProperty(e.layout[s[l]],"stops"))&&(n[s[l]]=a(s[l],e.layout[s[l]],r)),n[s[l]]=i(t,n[s[l]]);return n},l=function(t,e,r){const n=function(t){switch(t){case"background":return{"background-color":"#000000","background-pattern":null,"background-opacity":1};case"fill":return{"fill-antialias":!0,"fill-opacity":1,"fill-color":"#000000","fill-outline-color":null,"fill-translate":[0,0],"fill-translate-anchor":"map","fill-pattern":null};case"line":return{"line-opacity":1,"line-color":"#000000","line-translate":[0,0],"line-translate-anchor":"map","line-width":1,"line-gap-width":0,"line-offset":0,"line-blur":0,"line-dasharray":null,"line-pattern":null};case"symbol":return{"icon-opacity":1,"icon-color":"#000000","icon-halo-color":"rgba(0, 0, 0, 0)","icon-halo-width":0,"icon-halo-blur":0,"icon-translate":[0,0],"icon-translate-anchor":"map","text-opacity":1,"text-color":"#000000","text-halo-color":"rgba(0, 0, 0, 0)","text-halo-width":0,"text-halo-blur":0,"text-translate":[0,0],"text-translate-anchor":"map"};default:throw new Error(`_getPaintTemplate: "${t}" is not implemented yet!`)}}(e.type),s=Object.keys(n);for(let l=0;l<s.length;l++)e.paint[s[l]]&&!o.isLiteralObject(e.paint[s[l]])?n[s[l]]=e.paint[s[l]]:(o.hasProperty(e.paint[s[l]],"base")||o.hasProperty(e.paint[s[l]],"stops"))&&(n[s[l]]=a(s[l],e.paint[s[l]],r)),n[s[l]]=i(t,n[s[l]]);return n},c=function(t,e,r){switch(e.type){case"background":case"fill":case"line":case"symbol":e.rlayout=s(t,e,r),e.rpaint=l(t,e,r);break;case"raster":case"circle":case"fill-extrusion":case"heatmap":case"hillshade":throw new Error(`_computeLayout: the type "${e.type}" is not processed yet!`)}},u=function(t,e,r,o){let i,n,a;if("all"===e)return!0;if("all"===e[0]){if(i=[],i=e.slice(1),0===i.length)return!0;for(a=0;a<i.length&&(n=u(t,i[a],r,o),n);a++);return n}return n=function(t,e,r){const o=t[0],i="$type"===t[1]?e:r[t[1]];let n=!1;if("$type"===t[1]&&"=="!==o&&"!="!==o&&"in"!==o&&"!in"!==o)return!1;switch(o){case"has":n=i;break;case"!has":n=void 0===i;break;case"==":n=i===t[2];break;case"!=":n=i!==t[2];break;case">":n=i>t[2];break;case">=":n=i>=t[2];break;case"<":n=i<t[2];break;case"<=":n=i<=t[2];break;case"in":for(let e=2;e<t.length;e++)if(i===t[e]){n=!0;break}break;case"!in":n=!0;for(let e=2;e<t.length;e++)if(i===t[e]){n=!1;break}}return n}(e,r,o),n},h=function(t,e,r,i){const{filter:n}=t;let a,s;if(t.maxzoom||(t.maxzoom=22),t.minzoom||(t.minzoom=0),i<t.minzoom||i>=t.maxzoom)return!1;if(!n||!o.isArray(n))return!0;o.isString(n[0])&&"all"!==n[0]?(a=[],a.push(n)):a=n;for(let o=0;o<a.length&&(s=u(t,a[o],e,r),s);o++);return s};return{extendStyle:function(t){!function(t){let e,r,o;for(let i=0;i<t.length;i++)if(t[i].ref){o=!1;for(let n=0;n<t.length;n++)if(t[i].ref===t[n].id){e=t[i],r=t[n],r.type&&(e.type=r.type),r.source&&(e.source=r.source),r["source-layer"]&&(e["source-layer"]=r["source-layer"]),r.minzoom&&(e.minzoom=r.minzoom),r.maxzoom&&(e.maxzoom=r.maxzoom),r.filter&&(e.filter=r.filter),r.layout&&(e.layout=r.layout),o=!0;break}if(!o)throw new Error(`_extendStyle: the ref "${t[i].ref}" was not found!`)}}(t.layers)},index:function(t,e){return function(t,e){const r={},o=[];for(let i=0;i<t.length;i++){r[t[i].name]=[],o.push(t[i].name);for(let o=0;o<e.layers.length;o++)e.layers[o]["source-layer"]===t[i].name&&r[t[i].name].push(o)}return{iLayers:r,lRank:o}}(t,e)},getBackgroundStyle:function(t,e){return function(t,e){for(let r=0;r<t.length;r++)if("background"===t[r].id)return t[r].rlayout=s({},t[r],e),t[r].rpaint=l({},t[r],e),t[r];return null}(t.layers,e)},extract:function(t,e,r,o,i,n){return function(t,e,r,o,i,n){const a=[],s=e[r];let l;for(let e=0;e<s.length;e++)l=h(t.layers[s[e]],o,i,n),l&&(c(i,t.layers[s[e]],n),a.push(s[e]));return a}(t,e,r,o,i,n)},getColor:function(t){return function(t){let e,o;switch(t.type){case"background":return e=t.rpaint["background-color"],o=t.rpaint["background-opacity"],r.addColorAlphaChannel(e,o);case"fill":return e=t.rpaint["fill-color"],o=t.rpaint["fill-opacity"],r.addColorAlphaChannel(e,o);case"line":return e=t.rpaint["line-color"],o=t.rpaint["line-opacity"],r.addColorAlphaChannel(e,o);case"symbol":return e=t.rpaint["text-color"],o=t.rpaint["text-opacity"],r.addColorAlphaChannel(e,o);default:throw new Error(`_getColor: the type "${t.type}" is illegal!`)}}(t)}}}o.extend(t,{getSource:()=>e.getSource()+i.toString(),create:()=>i(e.create())})}(),function(){const t=r.MapGL.Vector.Workers.Public,e=r.MapGL.Vector.Workers.Model,i=r.MapGL.Vector.Workers.Tile;o.extend(t,{createWorkers(t){return function(t){t.processors=[];for(let r=0;r<1;r++)t.processors.push({id:r,free:!0,w:e.create()})}(t.model),function(t){t.processors=[];for(let e=0;e<1;e++)t.processors.push({id:e,free:!0,w:i.create()})}(t.tile),this},initWorkers(t,e,r,o){return function(t){for(let e=0;e<t.processors.length;e++)t.processors[e].w.postMessage({wid:e,method:"init",payload:"payload"})}(t.model),function(t,e,r,o){for(let i=0;i<t.processors.length;i++)t.processors[i].w.postMessage({wid:i,method:"init",payload:[e,{url:r.url,style:r.style,image:null},o]})}(t.tile,e,r,o),this}})}(),function(){const t=r.MapGL.Vector.Workers.Model,{Color:e}=r.Source;function i(){const t=ColorLibrary(),e=function(e){return t.toRGBA(e)};addEventListener("message",t=>{switch(t.data.method){case"getColor":postMessage({wid:t.data.wid,payload:e(t.data.payload)});break;default:console.log(`warning from ModelWorker: the method "${t.data.method}" isn't implemented!`)}})}o.extend(t,{createBlobURL(){const t=`${e.getSource()}`,r=i.toString(),o=new Blob([t,"(",r,")()"],{type:"application/javascript"});this.blobURL=URL.createObjectURL(o)},create(){return this.blobURL||this.createBlobURL(),new Worker(this.blobURL)},destroy(){URL.revokeObjectURL(this.blobURL),this.blobURL=void 0}})}(),function(){const t=r.MapGL.Vector.Workers.Tile,{Load:e}=r.Source,{Tile:i}=r.PBF.Source,{Geo:n}=r.MapGL.Vector.Source,{Color:a}=r.Source,{Earcut:s}=r.MapGL.Vector.Source,{Styler:l}=r.MapGL.Vector.Source,{Sprite:c}=r.MapGL.Vector.Source,{GlyphAtlas:u}=r.MapGL.Vector.Source,{RText:h}=r.MapGL.Vector.Source,{RPolygon:d}=r.MapGL.Vector.Source,{RPolyline:p}=r.MapGL.Vector.Source,{RPoint:g}=r.MapGL.Vector.Source;function y(){const t=XMLHTTPLibrary(),e=PBFTileLibrary(),r=GeoLibrary(),o=StylerLibrary(),i=RPolygonLibrary(),n=RPolylineLibrary(),a=RPointLibrary(),s=function(t,e,r,i,n){const{iLayers:a}=o.index(t.layers,i),s=[];let l;switch(e.type){case"POLYGON":l=o.extract(i,a,r,"Polygon",e.properties,n);break;case"LINESTRING":l=o.extract(i,a,r,"LineString",e.properties,n);break;case"POINT":l=o.extract(i,a,r,"Point",e.properties,n)}for(let t=0;t<l.length;t++)s[t]=i.layers[l[t]];return s},l=function(o,l,c,u,h){t.load(o.url,"bin",(t,d,p)=>{o.layers=e.decode(p),function(t,e,o,l){let c,u;for(let h=0;h<t.layers.length;h++){c=t.layers[h];for(let h=0;h<c.features.length;h++)switch(u=c.features[h],u.properties=r.getProperties(u,c.keys,c.values),u.styles=s(t,u,c.name,e,t.zoom),u.type){case"POLYGON":i.process(u);break;case"LINESTRING":u.polygons=[];for(let t=0;t<u.styles.length;t++)switch(u.styles[t].type){case"line":n.process(u,u.styles[t]);break;case"symbol":console.log("symbol")}break;case"POINT":a.process(u,l,o,t.zoom);break;default:throw new Error(`worker.process: the type "${u.type}" is unsupported!`)}}}(o,l,c,u),h(o)})};addEventListener("message",t=>{switch(t.data.method){case"init":[self.style,self.icon,self.fonts]=t.data.payload;break;case"process":l(t.data.payload,self.style,self.icon,self.fonts,e=>{postMessage({wid:t.data.wid,payload:e})});break;default:console.log(`warning from TileWorker: the method "${t.data.method}" isn't implemented!`)}})}o.extend(t,{createBlobURL(){const t=`\n            ${e.getSource()}${i.getSource()}${n.getSource()}\n            ${a.getSource()}${s.getSource()}${l.getSource()}\n            ${c.getSource()}${u.getSource()}${h.getSource()}\n            ${d.getSource()}${p.getSource()}${g.getSource()}\n          `,r=y.toString(),o=new Blob([t,"(",r,")()"],{type:"application/javascript"});this.blobURL=URL.createObjectURL(o)},create(){return this.blobURL||this.createBlobURL(),new Worker(this.blobURL)},destroy(){URL.revokeObjectURL(this.blobURL),this.blobURL=void 0}})}(),function(){const t=r.MapGL.Common.Public,{Util:e}=r.MapGL.Common;o.extend(t,{getTemplate:()=>e.getTemplate(),initSettings:(t,r)=>e.initSettings(t,r),fromPlanarMap2Chart:(t,e,r)=>(function(t,e,r){const{viewport:o}=t,{kz:i}=t;return{x:e-o.x*i+o.left,y:o.y*i-r+o.top}})(t,e,r),fromChart2PlanarMap:(t,e,r)=>(function(t,e,r){const{viewport:o}=t,{kz:i}=t;return{x:o.x+(e-o.left)/i,y:o.y+(o.top-r)/i}})(t,e,r)})}(),function(){const t=r.MapGL.Common.Util,e=r.Tiler.Public;function i(t,r){const i={url:null,token:null,ext:null,zoom:null,height:null,layer:null,kz:null,viewport:{x:null,y:null,"φ":null,"λ":null,top:null,left:null,width:null,height:null,_shift:{x:null,y:null},initial:{x:null,y:null,"φ":null,"λ":null,width:null,height:null},limits:{x:{min:null,max:null},y:{min:null,max:null}}},initial:{zoom:null},tile:{n:{x:null,y:null},x:null,y:null,width:null,height:null}};i.url=function(t,e,r,i){if(e.match(/\{s\}/)){if(!o.isArray(r))throw new Error("_decodeUrl: you must define an array of subdomains!");if(o.isEmpty(r))throw new Error("_decodeUrl: the list of subdomains could not be empty!")}if("raster"===t){if(!e.match(/\{z\}/))throw new Error("_decodeUrl: the url must contain the pattern {z}!");if(!e.match(/\{x\}/))throw new Error("_decodeUrl: the url must contain the pattern {x}!");if(!e.match(/\{y\}/))throw new Error("_decodeUrl: the url must contain the pattern {y}!");if(e.match(/\{retina\}/)&&!o.isString(i))throw new Error("_decodeUrl: you must define a retina pattern!")}const n=e.match(/http:/)?"http://":"https://";return{protocol:n,body:e.match(/\{s\}/)?e.replace(`${n}{s}.`,""):e.replace(n,""),subdomains:e.match(/\{s\}/)?r:null,retina:i}}(t,r.url,r.subdomains,r.retina),i.token=o.isString(r.token)?r.token:"",i.type=o.isString(r.type)?r.type:"???",i.ext=o.isString(r.ext)?r.ext:"pbf",i.style=o.isString(r.ext)?r.style:null,i.initial.zoom=o.isNumber(r.zoom)?r.zoom:0,i.viewport.initial.φ=r.coord&&o.isNumber(r.coord[0])?r.coord[0]:0,i.viewport.initial.λ=r.coord&&o.isNumber(r.coord[1])?r.coord[1]:0,i.viewport.initial.width=r.bbox&&o.isNumber(r.bbox.width)?r.bbox.width:1e3,i.viewport.initial.height=r.bbox&&o.isNumber(r.bbox.height)?r.bbox.height:1e3,i.tile.width=r.tile&&o.isNumber(r.tile.width)?r.tile.width:1024,i.tile.height=r.tile&&o.isNumber(r.tile.height)?r.tile.height:1024,i.layer=Math.floor(i.initial.zoom),i.zoom=i.layer,i.height=i.tile.height*2**i.layer;const n=e.getXYFromLatLon(i,i.viewport.initial.φ,i.viewport.initial.λ);return i.viewport.initial.x=n.x,i.viewport.initial.y=n.y,i.zoom=i.initial.zoom,i.viewport.x=i.viewport.initial.x,i.viewport.y=i.viewport.initial.y,i.viewport.φ=i.viewport.initial.φ,i.viewport.λ=i.viewport.initial.λ,i.viewport.width=i.viewport.initial.width,i.viewport.height=i.viewport.initial.height,i.viewport.limits.y.max=i.height/2-i.viewport.height/2,i.viewport.limits.y.min=-i.viewport.limits.y.max,i.viewport.top=i.viewport.height/2,i.viewport.left=i.viewport.width/2,i}o.extend(t,{getTemplate:()=>({url:null,token:null,ext:null,zoom:null,height:null,layer:null,kz:null,viewport:{x:null,y:null,"φ":null,"λ":null,top:null,left:null,width:null,height:null,_shift:{x:null,y:null},initial:{x:null,y:null,"φ":null,"λ":null,width:null,height:null},limits:{x:{min:null,max:null},y:{min:null,max:null}}},initial:{zoom:null},tile:{n:{x:null,y:null},x:null,y:null,width:null,height:null}}),initSettings:(t,e)=>i(t,e)})}(),function(){const t=r.MapGL.Geo.Public,{Proj:e}=r;function i(t,r){const o=[];let i,n,a,s,l="";for(let c=0;c<t.length;c++)[i,n]=t[c],[a,s]=e.mercator(t[c][0],t[c][1]),o.push([a,s]),""===l?l=`M${a},${-s}`:l+=`L${a},${-s}`,r&&(r.minφ=i<r.minφ?i:r.minφ,r.maxφ=i>r.maxφ?i:r.maxφ,r.minλ=n<r.minλ?n:r.minλ,r.maxλ=n>r.maxλ?n:r.maxλ);return[o,l]}function n(t,e){const r=[];let o,n,a="";for(let s=0;s<t.length;s++)[o,n]=i(t[s],e),r.push(o),a+=n,a+="z";return[r,a]}function a(t,r,o){switch(t){case"MultiPolygon":return function(t,e){let r,o,i;const a=[];r="";for(let s=0;s<t.length;s++)[o,i]=n(t[s],e),a.push(o),r+=i;return[a,r]}(r,o);case"Polygon":return n(r,o);case"PolyLine":return function(t,e){let r,o,n="";const a=[];for(let s=0;s<t.length;s++)[r,o]=i(t[s],e),a.push(r),n+=o;return[a,n]}(r,o);case"Point":return[e.mercator(r[0],r[1]),""];default:throw new Error(`mapgl.__getCoordPath: the type ${t} is unknown!`)}}function s(t,e,r,o){let i,n,a="";for(let s=0;s<t.length;s++)i=e+t[s][0]*o,n=r-t[s][1]*o,""===a?a=`M${i},${n}`:a+=`L${i},${n}`;return a}function l(t,e,r,o){let i="";for(let n=0;n<t.length;n++)i+=s(t[n],e,r,o),i+="z";return i}function c(t,e,r,o,i){switch(t){case"MultiPolygon":return function(t,e,r,o){let i="";for(let n=0;n<t.length;n++)i+=l(t[n],e,r,o);return i}(e,r,o,i);case"Polygon":return l(e,r,o,i);case"PolyLine":return s(e,r,o,i);default:throw new Error(`mapgl._getPath: the type ${t} is unknown!`)}}function u(t,e){for(let r=0;r<t.length;r++)e.minφ=t[r][0]<e.minφ?t[r][0]:e.minφ,e.maxφ=t[r][0]>e.maxφ?t[r][0]:e.maxφ,e.minλ=t[r][1]<e.minλ?t[r][1]:e.minλ,e.maxλ=t[r][1]>e.maxλ?t[r][1]:e.maxλ}function h(t){const e={"minλ":180,"maxλ":-180,"minφ":90,"maxφ":-90};switch(t.geometry.type){case"MultiPolygon":for(let r=0;r<t.geometry.coordinates.length;r++)for(let o=0;o<t.geometry.coordinates[r].length;o++)u(t.geometry.coordinates[r][o],e);break;case"Polygon":for(let r=0;r<t.geometry.coordinates.length;r++)u(t.geometry.coordinates[r],e);break;case"PolyLine":case"Polyline":u(t.geometry.coordinates,e);break;default:throw new Error(`mapgl._getOverlayBbox: this type "${t.geometry.type}" is unknown!`)}return e}o.extend(t,{getSVGPath:(t,e,r,o,i)=>c(t,e,r,o,i),getCoordPath:(t,e,r)=>a(t,e,r),getSVGPathFromMap:(t,e)=>(function(t,e){for(let r=0;r<t.features.length;r++)if(t.features[r]._id===e)return t.features[r].geometry._path;return null})(t,e),getOverlayBbox:t=>h(t),getGeoJSONOverlayBbox:(t,e)=>(function(t,e){const r=t._index.indexOf(e);if(r>-1)return h(t.features[r]);throw new Error(`mapgl._getGeoJSONOverlayBbox: this id "${e}" is unknown!`)})(t,e)})}(),function(){const t=r.PBF.Public,{Tile:e}=r.PBF.Source,{Font:i}=r.PBF.Source;o.extend(t,{Tile:{decode:t=>e.create().decode(t)},Font:{decode:t=>i.create().decode(t)}})}(),function(){const t=r.PBF.Source.Font,e=r.PBF.Source.Util;function i(t){const r=t||e(),o=function(t,e,r){const o=new Uint8Array(e*r*4);if(t){if(t.length!==e*r)throw new Error("_image: mismatched image size!")}else t=new Uint8Array(e*r);for(let i=0;i<e*r;i++)o[4*i+0]=t[i],o[4*i+1]=t[i],o[4*i+2]=t[i],o[4*i+3]=255;return{width:e,height:r,data:o}},i=function(t){let e,i=0,n=null,a=null,s=0,l=0,c=0,u=0,h=0;do{switch(e=r.readVarint(t,i),i=e.pos,e.tag){case 1:e=r.readVarint(t,i),i=e.pos,n=e.val;break;case 2:e=r.readBytes(t,i),i=e.pos,a=e.val;break;case 3:e=r.readVarint(t,i),i=e.pos,s=e.val;break;case 4:e=r.readVarint(t,i),i=e.pos,l=e.val;break;case 5:e=r.readSVarint(t,i),i=e.pos,c=e.val;break;case 6:e=r.readSVarint(t,i),i=e.pos,u=e.val;break;case 7:e=r.readVarint(t,i),i=e.pos,h=e.val;break;default:throw new Error(`_extractGlyph: the type "${e.tag}" is not supported!`)}}while(i<t.length);return{id:n,bitmap:o(a,s+6,l+6),metrics:{top:u,left:c,width:s,height:l,advance:h}}},n=function(t){let e,o=0;const n={name:null,range:null,glyphs:[]};do{switch(e=r.readVarint(t,o),o=e.pos,e.tag){case 1:e=r.readString(t,o),o=e.pos,n.name=e.val;break;case 2:e=r.readString(t,o),o=e.pos,n.range=e.val;break;case 3:e=r.readBuffer(t,o),o=e.pos,n.glyphs.push(i(e.val));break;default:throw new Error(`_readFontStack: the type "${e.tag}" is not supported!`)}}while(o<t.length);return n};return{decode:function(t){return function(t){const e=[];let o,i=0;do{if(o=r.readVarint(t,i),2!==o.type||1!==o.tag)throw new Error(`This is not a correct glyphs font. glyphs = ${o.type}, tag = ${o.tag}!`);i=o.pos,o=r.readBuffer(t,i),i=o.pos,e.push(n(o.val))}while(i<t.length);return e}(t)}}}o.extend(t,{getSource:()=>`${e.getSource()}\n${i.toString()}`,create:()=>i(e.create())})}(),function(){const t=r.PBF.Source.Tile,e=r.PBF.Source.Util;function i(t){const r=t||e(),o=function(t){const e=[];let o,i=0;do{o=r.readVarint(t,i),i=o.pos,e.push(o.val)}while(i<t.length);return e},i=function(t){let e;switch(t){case 0:e="UNKNOWN";break;case 1:e="POINT";break;case 2:e="LINESTRING";break;case 3:e="POLYGON";break;default:throw new Error(`_decodeFeatureType: the type "${t}" is unknown!`)}return e},n=function(t){let e,n=0;const a={id:null,tags:[],type:null,geometry:null};do{switch(e=r.readVarint(t,n),n=e.pos,e.tag){case 1:e=r.readVarint(t,n),n=e.pos,a.id=e.val;break;case 2:e=r.readBuffer(t,n),n=e.pos,a.tags=o(e.val);break;case 3:e=r.readVarint(t,n),n=e.pos,a.type=i(e.val);break;case 4:e=r.readBuffer(t,n),n=e.pos,a.geometry=o(e.val);break;default:throw new Error(`_extractFeature: the tag "${e.tag}" is unknown!`)}}while(n<t.length);return a},a=function(t){let e,o=0;switch(e=r.readVarint(t,o),o=e.pos,e.tag){case 1:return e=r.readString(t,o),o=e.pos,e.val;case 2:return r.ieee754.read(t,o,!0,23,4);case 3:return r.ieee754.read(t,o,!0,52,8);case 4:return e=r.readVarint(t,o),o=e.pos,e.val;case 5:case 6:case 7:throw new Error(`_extractValue: the tag "${e.tag}" is not implemented yet!`);default:throw new Error(`_extractValue: the tag "${e.tag}" is unknown!`)}},s=function(t){let e,o=0;const i={version:1,name:null,features:[],keys:[],values:[],extend:4096};do{switch(e=r.readVarint(t,o),o=e.pos,e.tag){case 15:if(e=r.readVarint(t,o),o=e.pos,i.version=e.val,1===i.version)throw new Error("_readLayer: vector-tile spec v1 is not implemented!");break;case 1:e=r.readString(t,o),o=e.pos,i.name=e.val;break;case 2:e=r.readBuffer(t,o),o=e.pos,i.features.push(n(e.val));break;case 3:e=r.readString(t,o),o=e.pos,i.keys.push(e.val);break;case 4:e=r.readBuffer(t,o),o=e.pos,i.values.push(a(e.val));break;case 5:e=r.readVarint(t,o),o=e.pos,i.extend=e.val;break;default:throw new Error(`_readLayer: the tag "${e.tag}" is unknown!`)}}while(o<t.length);return i};return{decode:function(t){return function(t){const e=[];let o,i=0;do{if(o=r.readVarint(t,i),2!==o.type||3!==o.tag)throw new Error(`This is not a correct vector tile. type_wire = ${o.type}, tag = ${o.tag}!`);i=o.pos,o=r.readBuffer(t,i),i=o.pos,e.push(s(o.val))}while(i<t.length);return e}(t)}}}o.extend(t,{getSource:()=>`${e.getSource()}\n${i.toString()}`,create:()=>i(e.create())})}(),function(){const t=r.PBF.Source.Util;function e(){const t=function(t,e){let r,o,i=e;return r=t[i++],o=127&r,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(127&r)<<7,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(127&r)<<14,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(127&r)<<21,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<28,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<35,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<42,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<49,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<56,r<128?{val:o,pos:i,type:7&o,tag:o>>3}:(r=t[i++],o|=(15&r)<<73,{val:o,pos:i,type:7&o,tag:o>>3})))))))))},e=function(e,r){const o=t(e,r);return{val:e.slice(o.pos,o.pos+o.val),pos:o.pos+o.val}};return{ieee754:{read(t,e,r,o,i){const n=8*i-o-1,a=(1<<n)-1,s=a>>1,l=r?-1:1;let c,u,h=-7,d=r?i-1:0,p=t[e+d];for(d+=l,c=p&(1<<-h)-1,p>>=-h,h+=n;h>0;c=256*c+t[e+d],d+=l,h-=8);for(u=c&(1<<-h)-1,c>>=-h,h+=o;h>0;u=256*u+t[e+d],d+=l,h-=8);if(0===c)c=1-s;else{if(c===a)return u?NaN:1/0*(p?-1:1);u+=Math.pow(2,o),c-=s}return(p?-1:1)*u*Math.pow(2,c-o)}},readVarint:t,readSVarint:function(e,r){const o=t(e,r),i=o.val;return o.val=i%2==1?(i+1)/-2:i/2,o},readBuffer:e,readBytes:function(t,r){return e(t,r)},readString:function(t,r){const o=e(t,r),i=o.val;let n,a,s,l="",c=0;for(;c<i.length;)if(n=i[c],n<128)l+=String.fromCharCode(n),c+=1;else if(n>191&&n<224){if(c+1>=i.length)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");a=t[c+1],l+=String.fromCharCode((31&n)<<6|63&a),c+=2}else{if(c+2>=i.length)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");a=t[c+1],s=t[c+2],l+=String.fromCharCode((15&n)<<12|(63&a)<<6|63&s),c+=3}return{val:l,pos:o.pos}}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.Source.Color;function e(){const t=function(t){return t.match(/[+-]?\d+(\.\d+)?/g).map(Number)},e=function(t){let e=t.slice(1).toString();return 3===e.length?e=e.slice(0,1)+e.slice(0,1)+e.slice(1,2)+e.slice(1,2)+e.slice(2,3)+e.slice(2,3):6!==e.length&&(e="000000"),[parseInt(e.slice(0,2),16),parseInt(e.slice(2,4),16),parseInt(e.slice(4,6),16)]},r=function(t){let e,r,o;const i=t[0]/255,n=t[1]/255,a=t[2]/255,s=Math.max(i,n,a),l=Math.min(i,n,a),c=(s+l)/2;if(s===l)r=0,o=0;else switch(e=s-l,o=c>.5?e/(2-s-l):e/(s+l),s){case i:r=(n-a)/e+(n<a?6:0);break;case n:r=(a-i)/e+2;break;case a:r=(i-n)/e+4}return[60*r,100*o,100*c]},o=function(e){if("rgb"!==e.slice(0,3)&&"hsl"!==e.slice(0,3))throw new Error(`_getRGBValues: "${e}" is illegal!`);const r=t(e);return[r[0],r[1],r[2]]};return{toRGBA:function(r){return function(r){const o="#"===r.slice(0,1)?"#":r.slice(0,3);let i,n,a;switch(o){case"#":return a=e(r),[a[0],a[1],a[2],1];case"rgb":return i=t(r),n=r.slice(4,5),"a"===n?[i[0],i[1],i[2],i[3]]:[i[0],i[1],i[2],1];case"hsl":return i=t(r),n=r.slice(3,4),a=function(t,e,r){function o(t,e,r){return r<0&&(r+=1),r>1&&(r-=1),r<1/6?t+6*(e-t)*r:r<.5?e:r<2/3?t+(e-t)*(2/3-r)*6:t}if(0===e)return[255*r,255*r,255*r];const i=r<.5?r*(1+e):r+e-r*e,n=2*r-i;return[255*o(n,i,t+1/3),255*o(n,i,t),255*o(n,i,t-1/3)]}(i[0]/360,i[1]/100,i[2]/100),"a"===n?[a[0],a[1],a[2],i[3]]:[a[0],a[1],a[2],1];default:throw new Error(`_toRGBA: the type "${o}" is illegal!`)}}(r)},addColorAlphaChannel:function(t,r){return function(t,r){const i="#"===t.slice(0,1)?"#":t.slice(0,3);let n;switch(i){case"#":return n=e(t),`rgba(${n[0]}, ${n[1]}, ${n[2]}, ${r})`;case"rgb":return n=o(t),`rgba(${n[0]}, ${n[1]}, ${n[2]}, ${r})`;case"hsl":return n=o(t),`hsla(${n[0]}, ${n[1]}%, ${n[2]}%, ${r})`;default:throw new Error(`_colorAlphaChannel: the type "${i}" is illegal!`)}}(t,r)},getHSL:function(t){return function(t){const i="#"===t.slice(0,1)?"#":t.slice(0,3);let n;switch(i){case"#":return n=e(t),r(n);case"rgb":return n=o(t),r(n);case"hsl":return o(t);default:throw new Error(`_fromHexOrRbg2Hsl: the type "${i}" is illegal!`)}}(t)}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e()})}(),function(){const t=r.Source.Load;function e(){return{load:function(t,e,r){const o=new XMLHttpRequest;switch(o.onreadystatechange=function(){let t,i;if(4===o.readyState)if(200===o.status||0===o.status)switch(e){case"json":r(!1,o,o.responseText);break;case"bin":t=new Uint8Array(o.response),r(!1,o,t);break;case"blob":i=self?self.URL.createObjectURL(o.response):window.URL.createObjectURL(o.response),r(!1,o,i);break;default:throw new Error(`_load: the type "${e}" is unknown!`)}else r(!0,o)},e){case"json":o.open("GET",t,!0),o.send(null);break;case"bin":o.open("GET",t,!0),o.responseType="arraybuffer",o.send(null);break;case"blob":o.open("GET",t,!0),o.responseType="blob",o.send(null);break;default:throw new Error(`_load: the type "${e}" is unknown!`)}}}}o.extend(t,{getSource:()=>e.toString(),create:()=>e(),load(t,e,r){this.create().load(t,e,r)}})}(),function(){const t=r.Tiler.Public,{Map:e}=r.Tiler,{Util:i}=r.Tiler;o.extend(t,{getXYFromLatLon:(t,r,o)=>e.getXYFromLatLon(t,r,o),getLatLonFromXY:(t,r,o,i)=>e.getLatLonFromXY(t,r,o,i),getVisibleTiles:t=>e.getVisibleTiles(t),shiftViewport(t,r,o,i){return e.shiftViewport(t,r,o,i),this},updateViewport(t){return e.updateViewport(t),this},getShiftToOrigin:t=>e.getShiftToOrigin(t),getViewportCoord:t=>e.getViewportCoord(t),getOptimalZoom:(t,e,r,o)=>i.getOptimalZoom(t,e,r,o),getMercatorProjection:(t,r)=>e.getMercatorProjection(t,r),getMercatorInverse:(t,r)=>e.getMercatorInverse(t,r)})}(),function(){const t=r.Tiler.Map,{Proj:e}=r;function i(t){const e=t.zoom-t.layer;return t.zoom>=t.layer?2**Math.floor(e)*(1+e%1):1/(2**Math.floor(-e)*(1+-e%1))}function n(t,r,o,i){const n=2**t.layer,a=t.tile.width*n,s=t.tile.height*n,l=e.mercator(r,o),c=i||1;return{x:l[0]/180*(a/2)*c,y:l[1]/180*(s/2)*c}}function a(t,r,o,i){const n=2**i,a=t/(o.width*n/2)*180,s=r/(o.height*n/2)*180,l=e.imercator(a,s);return{"φ":l[0],"λ":l[1]}}function s(t,e,r){const o=function(t,e){const r=2**e*(t+180)/360;return Math.floor(r)}(r,t.layer),i=function(t,e){const r=(1-Math.log(Math.tan(t*Math.PI/180)+1/Math.cos(t*Math.PI/180))/Math.PI)/2*Math.pow(2,e);return Math.floor(r)}(e,t.layer),a=(l=o,c=t.layer,l/2**c*360-180),s=n(t,function(t,e){const r=Math.PI-2*Math.PI*t/2**e;return 180/Math.PI*Math.atan(.5*(Math.exp(r)-Math.exp(-r)))}(i,t.layer),a,1);var l,c;return{n:{x:o,y:i},x:s.x,y:s.y}}function l(t,e,r,o,i){let n;return"vector"===t.type?(n=t.url.subdomains?`${t.url.protocol}${t.url.subdomains[i]}.${t.url.body}`:t.url.protocol+t.url.body,n+=`/${e}/${e}/${o}.${t.ext}`):(n=t.url.subdomains?`${t.url.protocol}${t.url.subdomains[i]}.`:t.url.protocol,n+=t.url.body.replace(/\{z\}/,e).replace(/\{x\}/,r).replace(/\{y\}/,o).replace(/\{retina\}/,t.url.retina)),n+=t.token?`?access_token=${t.token}`:"",n}function c(t){const{tile:e}=t,{viewport:r}=t,{layer:o}=t,n=2**o,a=i(t),c=s(t,r.φ,r.λ);return e.n.x=c.n.x,e.n.y=c.n.y,e.x=c.x,e.y=c.y,t.kz=a,function(t,e,r){const o=r<=1?2:0,{viewport:i}=t,{tile:n}=t,{layer:a}=t,s=n.width*(e/2),c=n.height*(e/2),u=[],h=n.n.x*n.width+(i.x-n.x),d=h-i.left,p=Math.floor(d/n.width)-o,g=h+(i.width-i.left),y=Math.ceil(g/n.width)+o,m=n.n.y*n.height+(n.y-i.y),f=m-i.top;let b=Math.floor(f/n.height)-o;b=b>=0?b:0;const x=m+(i.height-i.top);let _=Math.ceil(x/n.height)+o;_=_<e?_:e;let w,v,k=0;for(let o=b;o<_;o++)for(let i=p;i<y;i++)v=i>=0?i%e:(e+i%e)%e,w=l(t,a,v,o,k),k=t.url.subdomains&&k+1<t.url.subdomains.length?k+1:0,u.push({id:`z${a}x${i}y${o}`,url:w,x:(n.width*i-s)*r,y:(c-n.height*o)*r,width:n.width*r,height:n.height*r});return u}(t,n,a)}o.extend(t,{getXYFromLatLon:(t,e,r)=>n(t,e,r,i(t)),getLatLonFromXY:(t,e,r,o)=>a(t,e,r,o),getVisibleTiles:t=>c(t),shiftViewport(t,e,r,i){return function(t,e,r){const{viewport:i}=t,{tile:n}=t,s=o.isNumber(e)?e:0,l=o.isNumber(r)?r:0,c={width:n.width,height:n.height};i.x+=s,i.y+=l,i.height>t.height?-i.y+t.height/2>i.height/2?i.y=-(i.height/2-t.height/2):i.y+t.height/2>i.height/2&&(i.y=i.height/2-t.height/2):i.y>i.limits.y.max?i.y=i.limits.y.max:i.y<i.limits.y.min&&(i.y=i.limits.y.min);const u=a(i.x,i.y,c,t.layer);i.φ=u.φ,i.λ=u.λ}(t,e,r),this},updateViewport(t){return function(t){const{viewport:e}=t,r=n(t,e.φ,e.λ,1);e.x=r.x,e.y=r.y,t.height=t.tile.height*2**t.layer,t.kz=i(t),e.limits.y.max=t.height/2-e.height/2,e.limits.y.min=-e.limits.y.max}(t),this},getShiftToOrigin:t=>(function(t){const e=n(t,t.viewport.initial.φ,t.viewport.initial.λ,1);return t.viewport.left=t.viewport.width/2,t.viewport.top=t.viewport.height/2,{start:{x:t.viewport.x,y:t.viewport.y},end:{x:e.x,y:e.y}}})(t),getViewportCoord:t=>(function(t){const{layer:e}=t,{kz:r}=t,{width:o}=t.viewport,{height:i}=t.viewport,n=t.viewport.x||0,s=t.viewport.y||0,l=o/r,c=i/r,u=t.viewport.left/r,h=t.viewport.top/r,d={width:t.tile.width,height:t.tile.height},p=a(n-u,s+h,d,e),g=a(n+(l-u),s-(c-h),d,e);return{"φ":{top:p.φ,bottom:g.φ},"λ":{left:p.λ,right:g.λ}}})(t)})}(),function(){const t=r.Tiler.Util,{Map:e}=r.Tiler,{Proj:i}=r;function n(t,r,o,n,a,s){const l=function(t,e,r,o){const n=2**o,a=i.mercator(t,e);return{x:a[0]/180*(r.width*n/2),y:a[1]/180*(r.height*n/2)}}(t,r,a,s),c=l.x-o/2,u=l.c+o/2,h=l.y+n/2,d=l.y-n/2,p=e.getLatLonFromXY(c,h,a,s),g=e.getLatLonFromXY(u,d,a,s);return{"φ":{top:p.φ,bottom:g.φ},"λ":{left:p.λ,right:g.λ}}}function a(t,e){return!(t.φ.top>e.φ.top)&&(!(t.φ.bottom<e.φ.bottom)&&(!(t.λ.left<e.λ.left)&&!(t.λ.right>e.λ.right)))}o.extend(t,{getOptimalZoom:(t,e,r,o)=>(function(t,e,r,o){const{viewport:i}=t,{width:s}=i,{height:l}=i,c={width:t.tile.width,height:t.tile.height};let u=t.layer,h=1,d=!1;for(a(o,n(e,r,s,l,c,u))||(h=-1,d=!0);;)if(u+=h,a(o,n(e,r,s,l,c,u))===d){u=h>0?u-1:u;break}return u})(t,e,r,o)})}(),e}),function(){const{Messenger:t}=i.src.lib,e=i.src.lib.overslash,{SVG:r}=i.src.lib,{TaskQ:o}=i.src.lib,{Keypad:n}=i.src.libin,{Legend:a}=i.src.libin,{Snapshot:s}=i.src.libin,{Tooltip:l}=i.src.libin,c=i.src.maps._gmap.eventsclick,u=i.src.maps._gmap.eventsmouse,h=i.src.maps._gmap.eventsoverlay,d=i.src.maps._gmap.eventstouch,p=i.src.maps._gmap.move,g=i.src.maps._gmap.renderer,y=i.src.maps._gmap.util;let m;m={_ginit(){if(!document.querySelector(this.sel))throw new Error("The map can't be created. There is no DOM element to attach it!");return this._mess=t(),this._svg=r(this.sel),this._taskQ=o(),this._keypad=n(this,this._svg),this._legend=a(),this._mapgl=null,this._tooltip=l(this._svg,this._taskQ),this._overlay=null,this._db=y.init(),this},_render(...t){return g.render(this,...t),this},_init(){return this},_addDemo(){return this},_initMapSettings(){return this},_getKeypadZoomSettings(){return this},_getEventHandlers:()=>e.extend({},c,u,h,d),moveTo(...t){return this._db.params._loaded?(p.moveTo(this._svg,this._mapgl,this._overlay,this._taskQ,this._db,...t),this):(this._mess.subscribeOnce("maploaded",()=>{p.moveTo(this._svg,this._mapgl,this._overlay,this._taskQ,this._db,...t)}),this)},overlayAppend(t){return this._db.params._loaded?this._overlay.append(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.append(t)}),null)},overlayUpdate(t){return this._db.params._loaded?this._overlay.update(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.update(t)}),null)},overlayRemove(t){return this._db.params._loaded?this._overlay.remove(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.remove(t)}),null)},overlayDelete(){return this._db.params._loaded?this._overlay.delete():(this._mess.subscribeOnce("maploaded",()=>{this._overlay.delete()}),null)},overlayBlink(t){return this._db.params._loaded?this._overlay.blink(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.blink(t)}),null)},overlayUnblink(t){return this._db.params._loaded?this._overlay.unblink(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.unblink(t)}),null)},overlaySetVisible(t){return this._db.params._loaded?this._overlay.setVisible(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.setVisible(t)}),null)},overlaySetInvisible(t){return this._db.params._loaded?this._overlay.setInvisible(t):(this._mess.subscribeOnce("maploaded",()=>{this._overlay.setInvisible(t)}),null)},overlayAttachTooltip(t,e,r,o){return this._overlay.attachTooltip(t,e,r,o),this},addEventListener(t,e){return this._mess.subscribe(t,e),this},addOneTimeEventListener(t,e){return this._mess.subscribeOnce(t,e),this},dispatchEvent(t,e){return this._mess.publish(t,e),this},removeEventListener(t,e){return this._mess.unsubscribe(t,e),this},on(t,e){return this.addEventListener(t,e)},one(t,e){return this.addOneTimeEventListener(t,e)},fire(t,e){return this.dispatchEvent(t,e)},off(t,e){return this.removeEventListener(t,e)},takeSnapshot(...t){s.take(this._svg,...t)}},i.extend(i.src.maps._gmap.main,{GMap:function(t,r,o){const i=Object.create(e.extend({},m,r));return i.sel=t,i.type=o,i._ginit(),i}})}(),function(){const t=i.src.lib.overslash,{Chart:e}=i.src.libin,{Copyright:r}=i.src.libin;const o={render(o,...i){!function(o,...i){const[n,a]=i,s=o._svg,l=o._legend,c=o._keypad,u=o._overlay,{_db:h}=o,d=o._getEventHandlers(),p=t.isArray(n)?n:[];let g={};t.isLiteralObject(a)?g=a:t.isLiteralObject(n)&&(g=n);const y=e.data.copySeries(h.series,p,"map",t);t.extend(h.opts,g),y||o._addDemo(h.params,h.series,h.opts),o._initMapSettings(h.params,h.opts),e.data.computeGenericSettings(h.opts),l.set(s,t,h.series,h.opts,"map"),e.data.computeGridSize(h.opts,l.get(),"map"),e.data.setChartType(h.opts,"map"),e.dom.set(s,"map",h.opts.chart.width,h.opts.chart.height);const m=s.$().getBbox();h.opts.chart.boundingBoxes={left:m.left+window.pageXOffset,top:m.top+window.pageYOffset},e.dom.fill(s),e.dom.fillmap(s,h.opts),e.dom.drawHeader(s,h.opts),e.dom.drawFooter(s,h.opts),l.draw(s),e.dom.drawActiveAreaMap(s,h.opts),e.dom.addEvents2ActiveAreaMap(o,s,d),c.attachEventListeners(o,d.keypadToDefault,d.keypadShift,d.keypadZoom),r.draw(s),u.attachEventListeners(d.mouseOver.bind(o),d.mouseOut.bind(o),d.oclick.bind(o),d.odblClick.bind(o)),o._draw()}(o,...i)}};i.extend(i.src.maps._gmap.renderer,o)}(),function(){const{Easing:t}=i.src.lib,e=i.src.maps._gmap.util;function o(e){const r=t.easeInOutCubic,o=e.constants.timeToScale,i=1e3/e.constants.framesPerSecond||40;return{shift:{start:{x:0,y:0},end:{x:0,y:0},t:0,easing:r,duration:o,period:i},zoom:{start:{x:0,y:0},end:{x:0,y:0},t:0,easing:r,duration:o,period:i}}}function n(t,e,r,o,i,n){const{params:a}=o,{_actual:s}=a,l={x:i.shift.start.x,y:i.shift.start.y};let c,u,h,d;if(i.shift.start.x===i.shift.end.x&&i.shift.start.y===i.shift.end.y&&i.zoom.start.x===i.zoom.end.x&&i.zoom.start.y===i.zoom.end.y)return void(n&&n());const p=setInterval(()=>{i.shift.t+=i.shift.period,i.shift.t>i.shift.duration&&(i.shift.t=i.shift.duration),c=i.shift.easing(i.shift.t,i.shift.start.x,i.shift.end.x-i.shift.start.x,i.shift.duration),u=i.shift.easing(i.shift.t,i.shift.start.y,i.shift.end.y-i.shift.start.y,i.shift.duration),s.zoom=i.shift.easing(i.shift.t,i.zoom.start.x,i.zoom.end.x-i.zoom.start.x,i.shift.duration),h=c-l.x,d=u-l.y,e.update(h,d,s.zoom),l.x=c,l.y=u,r.refresh(),i.shift.t===i.shift.duration&&(clearInterval(p),n&&n())},i.shift.period)}function a(t,o,i){const n=t._svg,a=t._mapgl,s=t._db,{params:l}=s,{opts:c}=s,u=e.getMouseOrFingerPositionOnMap(n,o,l,c),h=a.getLatLonFromXY(u.x,u.y),d={x:u.x,y:u.y,latitude:h.φ,longitude:h.λ};t.fire(i,{chart:{id:t.sel},overlay:null,cursor:d}),"click"===i&&r(()=>{t.fire("dblclick",{chart:{id:t.sel},overlay:null,cursor:d})})}const s={click(t){a(this,t,"click")},dblClick(t){a(this,t,"dblclick")},keypadToDefault(t){!function(t){t._svg;const e=t._mapgl,r=t._taskQ,i=t._overlay,a=t._db,{params:s}=a,{opts:l}=a,{_actual:c}=s;r.pushQ("moveto",t=>{const r=o(l);let u;switch(r.shift.start={x:c.x,y:c.y},r.shift.end={x:0,y:0},r.zoom.start={x:c.zoom,y:c.zoom},r.zoom.end={x:s.zoom,y:s.zoom},s.type){case"vector":n(0,e,i,a,r,t);break;case"geojson":case"raster":u=e.reconcile(),r.shift.start.x=u.start.x,r.shift.start.y=u.start.y,r.shift.end.x=u.end.x,r.shift.end.y=u.end.y,n(0,e,i,a,r,t);break;default:throw new Error(`_keypadToDefault: the type "${s.type}" is unknown!`)}})}(t)},keypadZoom(t,e){!function(t,e){t._svg;const r=t._mapgl,i=t._taskQ,a=t._overlay,s=t._db,{params:l}=s,{opts:c}=s,{_actual:u}=l;i.pushQ("moveto",t=>{const i=o(c);switch(i.zoom.start={x:u.zoom,y:u.zoom},i.zoom.end={x:u.zoom,y:u.zoom},e){case"zup":u.zoom+1<=l.maxZoom&&(i.zoom.end.x=i.zoom.start.x+1,i.zoom.end.y=i.zoom.start.y+1);break;case"zdown":u.zoom-1>=l.minZoom&&(i.zoom.end.x=i.zoom.start.x-1,i.zoom.end.y=i.zoom.start.y-1);break;default:throw new Error(`keypadZoom: the direction "${e}" is unknown!`)}n(0,r,a,s,i,t)})}(t,e)},keypadShift(t,e){!function(t,e){t._svg;const r=t._mapgl,i=t._taskQ,a=t._overlay,s=t._db,{params:l}=s,{opts:c}=s,{_actual:u}=l,{grid:h}=c.chart;i.pushQ("moveto",i=>{const l=o(c);let d;switch(l.shift.start={x:0,y:0},l.zoom.start={x:u.zoom,y:u.zoom},l.zoom.end={x:u.zoom,y:u.zoom},t.type){case"geojson":d=.05/u.zoom;break;case"vector":case"raster":d=.05}switch(e){case"up":l.shift.end.y=h.height*d;break;case"down":l.shift.end.y=-h.height*d;break;case"left":l.shift.end.x=-h.width*d;break;case"right":l.shift.end.x=h.width*d;break;default:throw new Error(`_keypadShift: the direction "${e}" is unknown!`)}switch(t.type){case"vector":break;case"geojson":case"raster":n(0,r,a,s,l,i)}})}(t,e)},getAnimTemplate:t=>o(t),smoothMove(t,e,r,o,i,a){n(0,e,r,o,i,a)}};i.extend(i.src.maps._gmap.eventsclick,s)}(),function(){const{Copyright:t}=i.src.libin,e=i.src.maps._gmap.util;function r(t,e,r,o){t.$().select(".activearea").listen(e,r,o)}function o(t,e,r,o){t.$().select(".activearea").unlisten(e,r,o)}const n={firstmousemove(){if("touch"!==this.device){this.device="mouse",this._keypad.draw(this,this._db.params,this._db.opts);const e=this._keypad.getSize(this._svg);t.shift(this._svg,-e.width,0)}},zoom(t){!function(t,r){const o=t._svg,i=t._mapgl,n=t._overlay,a=t._db,{params:s}=a,{opts:l}=a,{origin:c}=s,{_actual:u}=s;let h="geojson"===t.type?-r.deltaY/10:-r.deltaY/100;if(!s.scrollwheel)return;r.preventDefault(),u.zoom+h>s.maxZoom?h=s.maxZoom-u.zoom:u.zoom+h<s.minZoom&&(h=s.minZoom-u.zoom);const d=e.getMouseOrFingerPositionOnMap(o,r,s,l);switch(u.x+=-(d.x-u.x)/u.zoom*h,u.y+=-(d.y-u.y)/u.zoom*h,u.zoom+=h,t.type){case"vector":i.update(c.x+u.x,c.y+u.y,u.zoom);break;case"geojson":case"raster":i.zoom(u.zoom,u.mouse),n.refresh();break;default:throw new Error(`_zoom: the type "${t.type}" is unknown!'`)}}(this,t)},drag(t){!function(t,i){const n=i.type.match(/touch/)?"touch":"mouse",a=t._svg,s=t._mapgl,l=t._overlay,c=t._db,u=t._tooltip,{params:h}=c,{opts:d}=c,{_actual:p}=h,g=d.chart.grid.width,y=d.chart.grid.height;let m;const f=function(r){const o=e.getMouseOrFingerPositionOnChart(a,r,t,d),i=o.x-m.mouse.x,n=o.y-m.mouse.y;switch(m.mouse.x=o.x,m.mouse.y=o.y,t.type){case"vector":break;case"geojson":s.update(-i/p.zoom,n/p.zoom,p.zoom),l.refresh();break;case"raster":s.update(-i,n,p.zoom),l.refresh();break;default:throw new Error(`_drag: the type "${t.type}" is unknown!'`)}},b=function(){o(a,"mouseup",b),o(a,"mousemove",f),o(a,"mouseout",x),u.release()},x=function(r){const o=e.getMouseOrFingerPositionOnChart(a,r,t,d);(o.x<=0||o.x>=g||o.y<=0||o.y>=y)&&b()};h.draggable&&("mouse"===n&&i.preventDefault(),r(a,"mouseup",b),r(a,"mousemove",f),r(a,"mouseout",x),u.hide(),m={mouse:{}},m.mouse=e.getMouseOrFingerPositionOnChart(a,i,t,d))}(this,t)},mousemove(t){!function(t,r){const o=t._svg,i=t._mapgl,{params:n}=t._db,{opts:a}=t._db,{_actual:s}=n,l=e.getMouseOrFingerPositionOnMap(o,r,n,a),c=i.getLatLonFromXY(l.x,l.y);s.mouse={x:l.x,y:l.y,"φ":c.φ,"λ":c.λ}}(this,t)}};i.extend(i.src.maps._gmap.eventsmouse,n)}(),function(){const{Easing:t}=i.src.lib,e=i.src.lib.overslash,r=i.src.maps._gmap.util;function o(t,o,i){const n=t._svg,a=t._overlay,s=t._mapgl,{_db:l}=t,{opts:c}=l,{target:u}=o,h=u.id.slice(1);o.stopPropagation();const d=n.$().getBbox();c.chart.boundingBoxes.left=d.left,c.chart.boundingBoxes.top=d.top;const p=r.getMouseOrFingerPositionOnChart(n,o,l.params,c),g=s.getLatLonFromXY(p.x,p.y),y={x:p.x,y:p.y,latitude:g.φ,longitude:g.λ},m=a.get(h),f={id:h,title:m.title,style:m.style?e.clone(m.style):{},over:m.over?e.clone(m.over):{},geometry:e.clone(m.geometry),properties:e.clone(m.properties)};delete f.geometry._coord,delete f.geometry._bbox,delete f.geometry._path,t.fire(i,{chart:{id:t.sel},overlay:f,cursor:y})}const n={oclick(t){o(this,t,"click")},odblClick(t){o(this,t,"dblclick")},mouseOver(i){!function(i,n){const a=i._svg,s=i._overlay,l=i._tooltip,{_db:c}=i,{opts:u}=c,{target:h}=n,d=h.id.slice(1),p=u.tooltip.animated,g=t.easeOutBack,y=a.$().getBbox();u.chart.boundingBoxes.left=y.left,u.chart.boundingBoxes.top=y.top,s.highlight(d);const m=s.get(d);o(i,n,"overlayover");const f=l.get();if(f.animate=p,f.animation.easing=g,f.animation.framesPerSecond=50,f.animation.duration=750,f.orientation.type="horizontal",f.title=m.title,f.frameColor="Polyline"===m.geometry.type?m.style.strokeColor:m.style.fillColor,e.isArray(m.properties))for(let t=0;t<m.properties.length;t++)f.content.push(m.properties[t]);else if(e.isLiteralObject(m.properties)){const t=Object.keys(m.properties);for(let e=0;e<t.length;e++)f.content.push({label:t[e],value:m.properties[t[e]],color:m.style.fillColor})}f.limits={max:{x:u.chart.width,y:1.5*u.chart.grid.height},min:{x:0,y:0}},m._customTooltip&&(f.custom={xmlString:m._customTooltip.xmlString,width:m._customTooltip.width,height:m._customTooltip.height}),h.onmousemove=function(t){if(!u.tooltip.enabled||!s.isHighlighted(d))return;const e=r.getMouseOrFingerPositionOnChart(a,t,c.params,u);f.anchor.x=e.x,f.anchor.y=e.y-5,l.moveTo(f,u)}}(this,i)},mouseOut(t){!function(t,e){const r=t._overlay,i=t._tooltip,n=e.target.id.slice(1);r.tunedown(n),o(t,e,"overlayout"),i.remove()}(this,t)}};i.extend(i.src.maps._gmap.eventsoverlay,n)}(),function(){const{Copyright:t}=i.src.libin,e=i.src.maps._gmap.util,r=.01;function o(t){return Math.hypot(t[0].pageX-t[1].pageX,t[0].pageY-t[1].pageY)}const n={firsttouchstart(){this.device="touch",this._db.params._touch={dragInfo:null,zoomInfo:null},this._keypad.draw(this.device,this._db.params,this._db.opts),t.shift(this._svg,-this._keypad.getSize(this._svg).width,0)},touchstart(t){1===t.touches.length?function(t,r){const o=t._svg,i=t._db,{params:n}=i,{opts:a}=i,s=n._touch;s.dragInfo={enabled:!1,mapmoved:!1,deactivated:!1,ipos:{mouse:null,map:{x:null,y:null}}},n.draggable&&(s.dragInfo.enabled=!0,s.dragInfo.ipos.mouse=e.getMouseOrFingerPositionOnChart(o,r,t,a),s.dragInfo.ipos.map.x=n._actual.x,s.dragInfo.ipos.map.y=n._actual.y)}(this,t):2===t.touches.length&&function(t,r){const i=t._svg,n=t._mapgl,a=t._db,{params:s}=a,{opts:l}=a,c=s._touch;if(!s.draggable)return;const u=e.getMouseOrFingerPositionOnChart(i,r,t,l),h=n.getLatLonFromXY(u.x,u.y);c.zoomInfo={enabled:!1,mapzoomed:!1,deactivated:!1,d1:o(r.touches),d0:o(r.touches),mouse:{x:u.x,y:u.y,"φ":h.φ,"λ":h.λ}},c.zoomInfo.enabled=!0}(this,t)},touchmove(t){1===t.touches.length?function(t,r){const o=t._svg,i=t._mapgl,n=t._overlay,{opts:a}=t._db,{_actual:s}=t._db.params,{dragInfo:l}=t._db.params._touch;if(!l.enabled)return;r.preventDefault(),l.deactivated||(n.deactivate(),l.deactivated=!0);const c=e.getMouseOrFingerPositionOnChart(o,r,t,a),u=c.x-l.ipos.mouse.x,h=c.y-l.ipos.mouse.y;switch(l.ipos.mouse.x=c.x,l.ipos.mouse.y=c.y,t.type){case"vector":break;case"geojson":i.update(-u/s.zoom,h/s.zoom,s.zoom),n.refresh();break;case"raster":i.update(-u,h,s.zoom),n.refresh();break;default:throw new Error(`_drag: the type "${t.type}" is unknown!'`)}}(this,t):2===t.touches.length&&function(t,e){const i=t._mapgl,n=t._overlay,{params:a}=t._db,{zoomInfo:s}=t._db.params._touch;let l;if(s.enabled)switch(e.preventDefault(),s.deactivated||(n.deactivate(),s.deactivated=!0),s.d1=o(e.touches),l=(s.d1-s.d0)*r,s.d0=s.d1,a._actual.zoom+l>a.maxZoom?l=a.maxZoom-a._actual.zoom:a._actual.zoom+l<a.minZoom&&(l=a.minZoom-a._actual.zoom),s.mapzoomed=!0,t.type){case"geojson":case"raster":a._actual.zoom+=l,i.zoom(a._actual.zoom,s.mouse),n.refresh();break;case"vector":break;default:throw new Error(`_zoom: the type "${t.type}" is unknown!'`)}}(this,t)},touchend(){this._tooltip,this._db.params._touch}};i.extend(i.src.maps._gmap.eventstouch,n)}(),function(){const t=i.src.lib.overslash,e=i.src.maps._gmap.eventsclick;function r(r,o,i,n,a,...s){const{params:l}=a,c=function(e,...r){let o,i,n;return t.isString(r[0])?([o]=r,i=null):t.isArray(r[0])?(o=null,[i]=r,t.isNumber[i[0]]||t.isNumber(i[1])||(i=[0,0])):(o=null,i=null),t.isNumber(r[1])?([,n]=r,n>e.maxZoom?n=e.maxZoom:n<e.minZoom&&(n=e.minZoom)):n="auto"===r[1]?"auto":null,{id:o,coord:i,zoom:n}}(a.params,...s);let u,h;c.id?(u=i.getCenter(c.id),h="auto"===c.zoom?u&&u.bbox?o.getOptimalZoom(u.φ,u.λ,u.bbox):l.maxZoom:c.zoom):c.coord&&(u={"φ":c.coord[0],"λ":c.coord[1]},h=t.isNumber(c.zoom)?c.zoom:l.zoom),u&&n.pushQ("moveto",t=>{const n=e.getAnimTemplate(a.opts),s=o.getXYOnMapFromCurrentLatLon(),c=o.getXYOnMapFromLatLon(u.φ,u.λ);n.shift.start.x=s.x,n.shift.start.y=s.y,n.shift.end.x=c.x,n.shift.end.y=c.y,n.zoom.start.x=l.zoom,n.zoom.start.y=l.zoom,n.zoom.end.x=h,n.zoom.end.y=h,e.smoothMove(r,o,i,a,n,()=>{switch(a.params.type){case"raster":o.setLayer()}l.zoom=l._actual.zoom,o.setAsNewOrigin(),t()})})}const o={moveTo(t,e,o,i,n,...a){return r(t,e,o,i,n,...a),this}};i.extend(i.src.maps._gmap.move,o)}(),function(){function t(t,e,r,o){let i,n;return o.chart.boundingBoxes=t.$().getBbox(),e.type.match(/touch/)?2===e.touches.length?(i=e.touches[0].clientX+(e.touches[1].clientX-e.touches[0].clientX)/2,n=e.touches[0].clientY+(e.touches[1].clientY-e.touches[0].clientY)/2):(i=e.touches[0].clientX,n=e.touches[0].clientY):(i=e.clientX,n=e.clientY),{x:i-o.chart.boundingBoxes.left,y:n-o.chart.boundingBoxes.top}}const e={init:()=>({params:{url:null,subdomains:null,retina:null,style:null,coordinates:null,origin:{x:null,y:null},zoom:null,maxZoom:null,minZoom:null,draggable:null,scrollwheel:null,keypad:null,tooltip:null,_type:null,_zoomRange:{max:null,min:null},_viewport:{width:null,height:null,x:null,y:null},_actual:{zoom:null,x:null,y:null,scale:null,"φ":null,"λ":null},_loaded:!1,_wheelingTimeout:!1,_overlay:{blinkingPeriod:750},_tile:{width:null,height:null}},series:[{name:null,label:null,suffix:{first:null,second:null},type:"map",data:[],color:null}],opts:{chart:{type:"map",width:600,height:420,grid:{x:null,y:null,width:null,height:null,margin:{top:0,left:0,right:0,bottom:0}},boundingBoxes:{},viewport:{"φ":{top:null,bottom:null},"λ":{left:null,right:null}}},title:{label:null,x:null,y:20},subtitle:{label:null,x:null,y:35},legend:{enabled:null,floating:null,layout:null,align:{horizontal:null,vertical:null},shift:{x:null,y:null},icon:{width:null,height:null,gap:{x:null,y:null}}},tooltip:{enabled:!0,animated:!0},xAxis:{type:null,cursor:{enabled:!1},plot:{type:null,start:null,increment:null,suffix:"",margin:{left:5,right:5}},categories:{data:[]},data:{min:null,max:null,width:null,scale:null,numberOfElements:null}},yAxis:{min:null,max:null,minor:null,exp:null,scale:null,title:{label:"Label here",x:null,y:null},interval:{number:null,height:null}},constants:{timeToScale:1e3,framesPerSecond:50,gap:{x:12,y:-5}}}}),getMouseOrFingerPositionOnChart:(e,r,o,i)=>t(e,r,0,i),getMouseOrFingerPositionOnMap:(e,r,o,i)=>(function(e,r,o,i){const n=t(e,r,0,i);return{x:n.x-o.origin.x,y:n.y-o.origin.y}})(e,r,o,i)};i.extend(i.src.maps._gmap.util,e)}(),function(){const{MapGL:t}=i.src.libin,{Overlay:e}=i.src.libin,r=i.src.maps._gmap.main,n=i.src.maps.geojson.renderer,a=i.src.maps.geojson.util;let s;s={_init(r){return a.init(this._db.params,r),this._mapgl=t(this._svg,this._mess,"geojson"),this._overlay=e(this._mess,this._mapgl,o),this},_initMapSettings(t){return a.initMapSettings(t),this},_draw(){return n.draw(this),this},_getKeypadZoomSettings:(t,e,r,o)=>a.getKeypadZoomSettings(t,e,r,o)},i.extend(i.src.maps.geojson.main,{GeoJSON:function(t,e,...o){const i=r.GMap(t,s,e.type);return i._init(e),i._render(...o),i}})}(),function(){const{Copyright:t}=i.src.libin;const e={draw(e){return function(e){const r=e._svg,o=e._mapgl,i=e._mess,n=e._taskQ,a=e._overlay,s=e._db,l=e._getEventHandlers(),{params:c}=s,{opts:u}=s;e.one("mapgl:maploaded",()=>{const i=o.getCopyright();i.match(/Natural Earth/)?t.fill(r,u,"naturalearth"):i.match(/data\.gouv\.fr/)&&t.fill(r,u,"datagouv"),a.append(o.getPotentialOverlays()),e.fire("maploaded","Done!"),c._loaded=!0}),function(t,e,r,o,i,n,a){const{params:s}=n,{opts:l}=n;s._actual.zoom=0,s._actual.x=0,s._actual.y=0;const c=a.getAnimTemplate(l);c.shift.start.x=s._actual.x,c.shift.start.y=s._actual.y,c.shift.end.x=s._actual.x,c.shift.end.y=s._actual.y,c.zoom.start.x=s._actual.zoom,c.zoom.start.y=s._actual.zoom,c.zoom.end.x=s.zoom,c.zoom.end.y=s.zoom,e.subscribeOnce("maploaded",()=>{r.pushQ("moveto",e=>{a.smoothMove(t,o,i,n,c,()=>{e()})})})}(r,i,n,o,a,s,l),c._viewport.width=u.chart.width,c._viewport.height=u.chart.height;const h={type:c.type,url:c.url,include:c.include?c.include:null,exclude:c.exclude?c.exclude:null,coord:[c.coordinates[0],c.coordinates[1]],bbox:{width:c._viewport.width,height:c._viewport.height}};o.draw(h)}(e),this}};i.extend(i.src.maps.geojson.renderer,e)}(),function(){const t=i.src.lib.overslash;function e(e,r){var o;o=e,t.extend(o,{origin:{x:0,y:0},zoom:1,maxZoom:10,minZoom:.1,draggable:!0,scrollwheel:!0,keypad:!0,tooltip:!0,_type:"geojson",_zoomRange:{max:20,min:.1},_loaded:!1}),e.type=r.type,e.url=t.isString(r.url)?r.url:e.url,t.isLiteralObject(r.include)&&(e.include=t.clone(r.include)),t.isLiteralObject(r.exclude)&&(e.exclude=t.clone(r.exclude)),t.isArray(r.coordinates)&&t.isNumber(r.coordinates[0])&&t.isNumber(r.coordinates[1])?(e.coordinates=[],e.coordinates[0]=r.coordinates[0]%90,e.coordinates[1]=r.coordinates[1]%180):e.coordinates=[0,0],e.zoom=t.isNumber(r.zoom)?r.zoom:e.zoom,e.maxZoom=t.isNumber(r.maxZoom)?r.maxZoom:e.maxZoom,e.minZoom=t.isNumber(r.minZoom)?r.minZoom:e.minZoom,e.draggable=t.isBoolean(r.draggable)?r.draggable:e.draggable,e.scrollwheel=t.isBoolean(r.scrollwheel)?r.scrollwheel:e.scrollwheel,e.keypad=t.isBoolean(r.keypad)?r.keypad:e.keypad,e.tooltip=t.isBoolean(r.tooltip)?r.tooltip:e.tooltip,delete e.subdomains,delete e.style,delete e.retina,delete e._tile}const r={init(t,r){return e(t,r),this},initMapSettings(t){!function(t){t._actual.zoom=t.zoom,t._viewport.x=t.origin.x,t._viewport.y=t.origin.y,t._viewport.width=0,t._viewport.height=0,t._actual.x=0,t._actual.y=0}(t)},getKeypadZoomSettings:(t,e,r,o)=>(function(t,e,r,o){const{_actual:i}=e;switch(t.shift.start={x:i.x,y:i.y},t.zoom.start={x:i.zoom,y:i.zoom},r){case"zup":t.zoom.end.x=1.05*t.zoom.start.x,t.zoom.end.x>e.maxZoom&&(t.zoom.end.x=e.maxZoom),t.zoom.end.y=t.zoom.end.x;break;case"zdown":t.zoom.end.x=t.zoom.start.x/1.05,t.zoom.end.x<e.minZoom&&(t.zoom.end.x=e.minZoom),t.zoom.end.y=t.zoom.end.x;break;default:throw new Error(`_getZoomGeoJSON: the direction "${r}" is unknown!`)}return t.shift.end.x=t.shift.start.x-o.chart.width*((t.zoom.end.x-t.zoom.start.x)/2),t.shift.end.y=t.shift.start.y-o.chart.height*((t.zoom.end.x-t.zoom.start.x)/2),t})(t,e,r,o)};i.extend(i.src.maps.geojson.util,r)}(),function(){const{MapGL:t}=i.src.libin,{Overlay:e}=i.src.libin,r=i.src.maps._gmap.main,n=i.src.maps.raster.renderer,a=i.src.maps.raster.util;let s;s={_init(r){return a.init(this._db.params,r),this._mapgl=t(this._svg,"raster"),this._overlay=e(this._mess,this._mapgl,o),this},_initMapSettings(t,e){return a.initMapSettings(t,e),this},_draw(){return n.draw(this._svg,this._mapgl,this._db.params,this._db.opts),this},_getKeypadZoomSettings:(t,e,r,o)=>a.getKeypadZoomSettings(t,e,r,o)},i.extend(i.src.maps.raster.main,{Raster:function(t,e,...o){const i=r.GMap(t,s,e.type);return i._init(e),i._render(...o),i}})}(),function(){const{Copyright:t}=i.src.libin;const e={draw(e,r,o,i){!function(e,r,o,i){const n={url:o.url,subdomains:o.subdomains,retina:o.retina,zoom:o.zoom,coord:[o.coordinates[0],o.coordinates[1]],bbox:{width:o._viewport.width,height:o._viewport.height},tile:{width:o._tile.width,height:o._tile.height}};r.draw(n),t.fill(e,i,"openstreetmap"),o._loaded=!0}(e,r,o,i)}};i.extend(i.src.maps.raster.renderer,e)}(),function(){const t=i.src.lib.overslash;function e(e,r){var o;o=e,t.extend(o,{coordinates:[0,0],origin:{x:0,y:0},zoom:0,maxZoom:19,minZoom:0,draggable:!0,scrollwheel:!0,keypad:!0,tooltip:!0,_type:"raster",_zoomRange:{max:19,min:0},_actual:{x:0,y:0,scale:1},_loaded:!1,_wheelingTimeout:!1,_tile:{width:256,height:256}}),e.type=r.type,e.url=t.isString(r.url)?r.url:e.url,e.subdomains=t.isArray(r.subdomains)?t.clone(r.subdomains):e.subdomains,e.retina=t.isString(r.retina)?r.retina:e.retina,[...e.coordinates]=t.isArray(r.coordinates)?r.coordinates:e.coordinates,e.origin=t.isLiteralObject(r.origin)?t.clone(r.origin):e.origin,e.zoom=t.isNumber(r.zoom)?r.zoom:e.zoom,e.maxZoom=t.isNumber(r.maxZoom)?r.maxZoom:e.maxZoom,e.minZoom=t.isNumber(r.minZoom)?r.minZoom:e.minZoom,e.draggable=t.isBoolean(r.draggable)?r.draggable:e.draggable,e.scrollwheel=t.isBoolean(r.scrollwheel)?r.scrollwheel:e.scrollwheel,e.keypad=t.isBoolean(r.keypad)?r.keypad:e.keypad,e.tooltip=t.isBoolean(r.tooltip)?r.tooltip:e.tooltip}const r={init(t,r){return e(t,r),this},initMapSettings(e,r){!function(e,r){e.maxZoom=Math.round(e.maxZoom),e.maxZoom>e._zoomRange.max?e.maxZoom=e._zoomRange.max:e.maxZoom<e._zoomRange.min&&(e.maxZoom=e._zoomRange.min),e.minZoom=Math.round(e.minZoom),e.minZoom<e._zoomRange.min?e.minZoom=e._zoomRange.min:e.minZoom>e._zoomRange.max&&(e.minZoom=e._zoomRange.max),e.maxZoom<e.minZoom&&(e.maxZoom=e.minZoom),e.zoom>e.maxZoom?e.zoom=e.maxZoom:e.zoom<e.minZoom&&(e.zoom=e.minZoom),t.isNumber(e.coordinates[0])||(e.coordinates[0]=0),t.isNumber(e.coordinates[1])||(e.coordinates[1]=0),e.coordinates[0]>90?e.coordinates[0]=90:e.coordinates[0]<-90&&(e.coordinates[0]=-90),e.coordinates[1]<-180&&(e.coordinates[1]=180),e.coordinates[1]>180&&(e.coordinates[1]=180),e._viewport.width=r.chart.width,e._viewport.height=r.chart.height,e._actual.zoom=e.zoom,[e._actual.φ,e._actual.λ]=e.coordinates,r.legend.enabled=!1}(e,r)}};i.extend(i.src.maps.raster.util,r)}(),e});