/** ****************************************************************************
 * Pixi Maps v1.0.0
 *
 * A collection of SVG Maps written in vanilla Javascript.
 * Copyright (c) 2019 Artelsys <contact@artelsys.com> (https://www.artelsys.com).
 * Released under the MIT license. You may obtain a copy of the License
 * at: http://www.opensource.org/licenses/mit-license.php).
 *
 * Pixi includes portions of code for easing equations.
 * Open source under the BSD License.
 * Copyright (c) 2001 Robert Penner
 * ************************************************************************** */
!function(t,e){"use strict";if("object"==typeof self&&self.self===self)t=self;else{if("object"!=typeof global||global.global!==global)throw new Error("root is neither windows nor global!");t=global}"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?module.exports=e(t):t.Pixi=e(t)}(this,function(t){"use strict";var e,r,m,u,h,x,n,i,a,o,s,l,c,d,f,p,y,g,b,v,w,k,M,S,L,z,P,O,E,A,C,R,_,T,I,G,N,F,B,U,j,V,Z,D,X,q,Y,W,H,Q,K,J,$,tt,et,rt,nt,it,at,ot,st,lt,ct,ut,ht,dt,ft,pt,mt,yt,gt,xt,bt,vt,wt,kt,Mt,St,Lt,zt,Pt,Ot,Et,At,Ct,Rt,_t,Tt,It,Gt,Nt,Ft,Bt,Ut,jt,Vt,Zt,Dt,Xt,qt,Yt,Wt,Ht,Qt,Kt,Jt,$t,te,ee,re,ne,ie,ae,oe,se,le,ce,ue,he,de,fe,pe,me,ye,ge,xe,be,ve,we,ke,Me,Se,Le,ze,Pe,Oe,Ee,Ae,Ce,Re,_e,Te,Ie,Ge,Ne,Fe,Be,Ue,je,Ve,Ze,De,Xe,qe,Ye,We,He,Qe,Ke,Je,$e,tr,er,rr,nr,ir,ar,or,sr,lr,cr,ur,hr,dr,fr,pr,mr,yr,gr,xr,br,vr,wr,kr,Mr,Sr,Lr,zr,Pr,Or,Er,Ar,Cr,Rr,_r,Tr,Ir,Gr,Nr,Fr,Br,Ur,jr,Vr,Zr,Dr,Xr,qr,Yr,Wr,Hr,Qr,Kr;return m={isThisATouchDevice:!1,enableTouchDevice:null,touchDblClick:null,touchClickTimer:null,overslash:null,SVG:null,easing:null,Messenger:null,MapGL:null,Chart:{Main:{},Keypad:{},Legend:{},Renderer:{},Copyright:{},Map:{}},Maps:{Core:{Public:{},Renderer:{},DragZoomClick:{},Util:{}},GeoJSON:{Public:{},Renderer:{},Util:{}},Raster:{Public:{},Renderer:{},Util:{}},Vector:{Public:{},Renderer:{},Util:{}}},Overlays:{Public:{},Events:{},Renderer:{},Util:{}},Tooltip:{Public:{},Renderer:{}}},e={},r=t.Pixi,e.noConflict=function(){return t.Pixi=r,this},e.VERSION="Pixi Maps v1.0.0",m.enableTouchDevice=function(){m.isThisATouchDevice||(window.removeEventListener("touchstart",m.enableTouchDevice),m.isThisATouchDevice=!0)},window.addEventListener("touchstart",m.enableTouchDevice),m.touchDblClick=function(t){m.isThisATouchDevice&&(null===m.touchClickTimer?m.touchClickTimer=setTimeout(function(){m.touchClickTimer=null},250):(clearTimeout(m.touchClickTimer),m.touchClickTimer=null,t()))},n=m,i=function(t){var e,r,n=function(t){var e,r,n,i;for(n=1;n<arguments.length;n++)for(e=arguments[n],r=Object.keys(e),i=0;i<r.length;i++)Object.prototype.hasOwnProperty.call(e,r[i])&&(t[r[i]]=e[r[i]]);return t};return e={},r=t.overslash,e.noConflict=function(){return t.overslash=r,this},e.VERSION="0.0.7",n(e,{isUndefined:function(t){return void 0===t},isNull:function(t){return null===t},isBoolean:function(t){return!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t)},isString:function(t){return"[object String]"===Object.prototype.toString.call(t)},isNumber:function(t){return"[object Number]"===Object.prototype.toString.call(t)},isNaN:function(t){return this.isNumber(t)&&t!==+t},isOdd:function(t){var e=t%2;return t===parseFloat(t)?!!e:void 0}}),n(e,{isObject:function(t){var e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:function(t){return"[object Object]"===Object.prototype.toString.call(t)},isFunction:function(t){return"[object Function]"===Object.prototype.toString.call(t)},isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},isMath:function(t){return"[object Math]"===Object.prototype.toString.call(t)},isDate:function(t){return"[object Date]"===Object.prototype.toString.call(t)},isEmpty:function(t){var e;if(null===t)return!0;if(this.isArray(t)||this.isString(t))return 0===t.length;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}}),n(e,{clone:function(t){var e,r=this.isArray(t)?[]:{};if(this.isObject(t)){for(e in t)this.isArray(t[e])?r[e]=this.clone(t[e]):this.isObject(t[e])?r[e]=this.extend(t[e]):r[e]=t[e];return r}},extend:function(t){var e,r,n;if(!this.isObject(t))return t;for(n=1;n<arguments.length;n++)for(r in e=arguments[n])this.isLiteralObject(arguments[n][r])?(t[r]=void 0!==t[r]?t[r]:{},this.extend(t[r],arguments[n][r])):hasOwnProperty.call(e,r)&&(t[r]=this.isArray(e[r])?this.clone(e[r]):e[r]);return t},keys:function(t){return Object.keys(t)},forPropIn:function(e,r){this.keys(e).forEach(function(t){({}).hasOwnProperty.call(e,t)&&r(t)})},assign:function(){var r,t,e,n=arguments[0];for(e=1;e<arguments.length;e++)r=arguments[e],t=Object.keys(r).reduce(function(t,e){return t[e]=Object.getOwnPropertyDescriptor(r,e),t},{});return Object.defineProperties(n,t),n}}),n(e,{contains:function(t,e){return-1!==t.indexOf(e)},flatten:function(t,e){var r,n=[],i=0;if(this.isArray(t)){if(e)return[].concat.apply([],t);for(r=0;r<t.length;r++)this.isArray(t[r])?i=(n=n.concat(this.flatten(t[r]))).length:n[i++]=t[r];return n}},max:function(t){var e,r,n=null;if(this.isArray(t)){for(e=this.flatten(t),r=0;r<e.length;r++)(null===n||n<e[r])&&(n="number"==typeof e[r]?e[r]:n);return null!==n?n:void 0}},min:function(t){var e,r,n=null;if(this.isArray(t)){for(e=this.flatten(t),r=0;r<e.length;r++)(null===n||n>e[r])&&(n="number"==typeof e[r]?e[r]:n);return null!==n?n:void 0}},share:function(t){var e,r,n,i=[];for(r=0;r<t.length;r++)if(e=t[r],!this.contains(i,e)){for(n=1;n<arguments.length&&this.contains(arguments[n],e);n++);n===arguments.length&&i.push(e)}return i}}),n(e,{}),e},"function"==typeof define&&define.amd?define([""],i):"object"==typeof exports?(module.exports=i(n),null===n.overslash&&(n.overslash=i(n))):n.overslash=i(n),a=m,o=function(t){var l,e,r,i,a="http://www.w3.org/2000/svg",o="http://www.w3.org/1999/xlink",n={};return l=function(t){return this instanceof l?(this.browser=n.p.setBrowser(),this.id=null,this[0]=null,this.svgRoot=null,t&&(this.id=t.slice(1),n.p.create(this,this.id)),this):(i=l.VDOM?l.VDOM.window.document:window.document,r=l.VDOM?l.VDOM.window:window,new l(t))},e=t.SVG,l.noConflict=function(){return t.SVG=e,this},l.VERSION="0.0.3",l.prototype={},n._={extend:function(t,e){var r,n=Object.keys(e);for(r=0;r<n.length;r++)t[n[r]]=e[n[r]]}},n._.extend(l.prototype,{select:function(t){return this[0]=this[0].querySelector(t),this},parent:function(){if(!this[0].parentNode)throw new Error("This SVG element has no parent!");return this[0]=this[0].parentNode,this},firstParent:function(){return this[0]=this.svgRoot,this}}),n._.extend(l.prototype,{append:function(t){var e=i.createElementNS(a,t);return this[0]=this[0].appendChild(e),this},appendHTML:function(t){var e;return"string"!=typeof t||((e=i.createElementNS("http://www.w3.org/1999/xhtml","body")).innerHTML=t,this[0]=this[0].appendChild(e)),this},replace:function(t){var e=i.createElementNS(a,t);return this[0].parentNode.replaceChild(e,this[0]),this[0]=e,this},remove:function(){var t;return this[0]&&((t=this[0].parentNode).removeChild(this[0]),this[0]=t),this},removeAllChilds:function(){for(;this[0].firstChild;)this[0].removeChild(this[0].firstChild);return this}}),n._.extend(l.prototype,{animate:function(t,e){return this[0].easing="function"==typeof t?t:n.anim.easing.linear,this[0].frequency=1e3/e||40,this}}),n._.extend(l.prototype,{listen:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].addEventListener(t,e),this},listenOnce:function(e,r){var n=this;return"string"==typeof e&&"function"==typeof r&&this[0].addEventListener(e,function(t){n[0].removeEventListener(e,r),r(t)}),this},unlisten:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].removeEventListener(t,e),this}}),n._.extend(l.prototype,{alink:function(t,e){return this[0].setAttributeNS(o,"xlink:"+t,e),this},attr:function(t,e){if(!this[0])return console.log("warning: this.svgElement is null!"),this;switch(typeof e){case"string":case"number":this[0].setAttributeNS(null,t,e);break;case"object":switch(t){case"d":n.anim.dAnimationRun(this,e);break;case"transform":switch(e.type){case"rotate":n.anim.rotateAnimationRun(this,e);break;case"scale":n.anim.scaleAnimationRun(this,e);break;case"translate":n.anim.translateAnimationRun(this,e);break;default:throw new Error("The animation is not supported for the transform "+e.type+"!")}break;default:throw new Error("The animation is not supported for the attribute "+t+"!")}}return this},rmattr:function(t){return this[0].removeAttributeNS(null,t),this}}),n._.extend(l.prototype,{text:function(t){switch(typeof t){case"number":case"string":this[0].textContent=t;break;case"object":n.anim.textAnimationRun(this,t)}return this}}),n._.extend(l.prototype,{addClass:function(t){var e=this[0].getAttributeNS(null,"class");return e=e?e+" "+t:t,this[0].setAttributeNS(null,"class",e),this},removeClass:function(t){var e=this[0].getAttributeNS(null,"class");return e&&(e=e.replace(t,"").replace(/(^\s+|\s+$)/g,""),this[0].setAttributeNS(null,"class",e)),this},toggleClass:function(t){var e=this[0].getAttributeNS(null,"class");return e&&e.match(t)?this.removeClass(t):this.addClass(t),this}}),n._.extend(l.prototype,{createEvent:function(){var t={},e="animationOver";if(this[0].event)return this[0].event;switch(this.browser){case"modern":t=new Event(e);break;case"old":(t=i.createEvent("Event")).initEvent(e,!0,!0);break;default:throw new Error("This type of browser is not supported!")}return t},query:function(t){return this[0].querySelector(t)},getElement:function(){return this[0]},getAttribute:function(t){return this[0]?this[0].getAttribute(t):null},getComputedStyle:function(){return r.getComputedStyle(this[0])},getPropertyValue:function(t){return this.getPropertyValue(t)},getSize:function(){return{width:this[0].getBoundingClientRect().width,height:this[0].getBoundingClientRect().height}},getAnimationStatus:function(){return this[0].isAnimationOn},stopAnimation:function(){return!!this[0].isAnimationOn&&!(this[0].isAnimationOn=!1)},getAttachedEvent:function(){return this[0].event},trigger:function(t){this[0].dispatchEvent(t)},setMessage:function(t,e){var r,n=this[0].message;return void 0!==n&&n.isArray||(this[0].message=[],n=this[0].message),void 0===n[0]||void 0===n[0][t]?((r={})[t]=e,n.push(r)):n[0][t]=e,this},getMessage:function(t){var e=this[0].message;return void 0===e||void 0===e[0]||void 0===e[0][t]?null:this[0].message[0][t]}}),l.addClass=function(t,e){var r=t.getAttributeNS(null,"class");r=r?r+" "+e:e,t.setAttributeNS(null,"class",r)},l.removeClass=function(t,e){var r=t.getAttributeNS(null,"class");r=r.replace(e,"").replace(/(^\s+|\s+$)/g,""),t.setAttributeNS(null,"class",r)},l.transformAttrToObj=function(t){var e,r,n,i,a,o,s,l,c,u,h,d,f,p,m,y,g,x,b,v,w,k,M="string"==typeof t?t:"";return o=/[+-]?((?:[1-9]\d*|0)(?:\.\d*)?|\.\d+)([eE][+-]?\d+)?/g,s=/translate(.*?)\)/,l=/scale(.*?)\)/,c=/rotate(.*?)\)/,u=/skewX(.*?)\)/,h=/skewY(.*?)\)/,d=/matrix(.*?)\)/,e=null===M.match(s)?null:(m=(f=M.match(s)[0].match(o))?1===f.length?p=parseFloat(f[0],10):(p=parseFloat(f[0],10),parseFloat(f[1],10)):p=null,{x:p,y:m}),r=null===M.match(l)?null:(x=(y=M.match(l)[0].match(o))?1===y.length?g=parseFloat(y[0],10):(g=parseFloat(y[0],10),parseFloat(y[1],10)):g=null,{x:g,y:x}),n=null===M.match(c)?null:(k=(b=M.match(c)[0].match(o))?1===b.length?(v=parseFloat(b[0],10),w=null):2===b.length?(v=parseFloat(b[0],10),w=parseFloat(b[1],10)):(v=parseFloat(b[0],10),w=parseFloat(b[1],10),parseFloat(b[2],10)):w=v=null,{a:v,cx:w,cy:k}),i=null===M.match(u)?null:M.match(u)[0].match(o)?parseFloat(M.match(u)[0].match(o)[0],10):null,a=null===M.match(h)?null:M.match(h)[0].match(o)?parseFloat(M.match(h)[0].match(o)[0],10):null,M.match(d),{translate:e,scale:r,rotate:n,matrix:null,skewX:i,skewY:a}},l.transformAttrToStr=function(t){var e="";return t.translate&&"number"==typeof t.translate.x&&("number"==typeof t.translate.y?e+="translate("+t.translate.x+", "+t.translate.y+") ":e+="translate("+t.translate.x+", 0) "),t.scale&&"number"==typeof t.scale.x&&("number"==typeof t.scale.y?e+="scale("+t.scale.x+", "+t.scale.y+") ":e+="scale("+t.scale.x+", "+t.scale.x+") "),t.rotate&&"number"==typeof t.rotate.a&&("number"==typeof t.rotate.cx&&"number"==typeof t.rotate.cy?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cy+") ":"number"==typeof t.rotate.cx?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cx+") ":e+="rotate("+t.rotate.a+") "),"number"==typeof t.skewX&&(e+="skewX("+t.skewX+") "),"number"==typeof t.skewY&&(e+="skewY("+t.skewY+") "),e.replace(/(^\s+|\s+$)/g,"")},l.draw={arc:function(t,e,r,n){t=void 0!==t?t:0,e=void 0!==e?e:0,r=void 0!==r?r:0,(t%=2*Math.PI)>2*Math.PI&&(t%=2*Math.PI),e>2*Math.PI&&(e%=2*Math.PI);var i=0;Math.abs(e-t)>Math.PI&&(i=1);var a=Math.cos(t),o=Math.sin(t),s=Math.cos(e),l=Math.sin(e),c="";return void 0!==n&&(c="L"+s*n+","+l*n+"A"+n+","+n+" 0 "+i+",0 "+a*n+","+o*n+"Z"),"M"+a*r+","+o*r+"A"+r+","+r+" 0 "+i+",1 "+s*r+","+l*r+c},line:function(t,e){var r="";return t.forEach(function(t){null!==t.x&&null!==t.y&&(""===r?r="M"+t.x+","+t.y:r+="L"+t.x+","+t.y)}),!0===e&&(r+="Z"),r},multipolyline:function(t,e){var r,n,i,a;for(r="",i=0;i<t.length;i++){for(n="",a=0;a<t[i].length;a++)null!==t[i][a].x&&null!==t[i][a].y&&(""===n?n="M"+t[i][a].x+","+t[i][a].y:n+="L"+t[i][a].x+","+t[i][a].y);!0===e&&(n+="z"),r+=n}return r}},n.p={setBrowser:function(){var e;try{e="modern",new Event("event")}catch(t){e="old";try{i.createEvent("Event")}catch(t){throw e="not supported",new Error("This type of browser is not supported!")}}return e},create:function(t,e){var r,n;if("string"!=typeof e||null===i.getElementById(e))return t[0]=null,void(t.svgRoot=null);(r=i.getElementById(e).getElementsByTagNameNS(a,"svg")[0])&&0!==r.length?t[0]=r:((n=i.createElementNS(a,"svg")).setAttributeNS(null,"version","1.1"),n.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",a),n.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink",o),t[0]=i.getElementById(e).appendChild(n)),t.svgRoot=t[0]}},n.anim={easing:{linear:function(t,e,r,n){return r*t/n+e}},dAnimationRun:function(t,e){var r,n,i=t[0],a=i.easing;i.event=t.createEvent(),r={value:0,start:"number"==typeof e.start?e.start:0,stop:"number"==typeof e.start?e.stop:180,t:0,duration:"number"==typeof e.d?e.d:2e3,fn:function(t){return l.draw.arc(0,t,100,80)}},"function"==typeof e.fn&&(r.fn=e.fn),i.isAnimationOn=!0,t.setMessage("isAnimationOn",!0),n=setInterval(function(){r.t+=i.frequency,(r.t>r.duration||r.stop===r.start)&&(r.t=r.duration),r.value=a(r.t,r.start,r.stop-r.start,r.duration),0===r.duration&&(r.value=r.start),i.setAttributeNS(null,"d",r.fn(r.value)),r.t===r.duration&&(clearInterval(n),i.isAnimationOn=!1,t.setMessage("isAnimationOn",!1),i.dispatchEvent(i.event))},i.frequency)},rotateAnimationRun:function(t,e){var r,n,i,a=t[0],o=a.easing;a.event=t.createEvent(),r={a:0,start:"number"==typeof e.start?e.start:0,stop:"number"==typeof e.stop?e.stop:180,t:0,duration:"number"==typeof e.d?e.d:2e3},a.isAnimationOn=!0,t.setMessage("isAnimationOn",!0),n=setInterval(function(){r.t+=a.frequency,(r.t>r.duration||r.stop===r.start)&&(r.t=r.duration),r.a=o(r.t,r.start,r.stop-r.start,r.duration),(i=l.transformAttrToObj(a.getAttribute("transform"))).rotate.a=r.a,a.setAttributeNS(null,"transform",l.transformAttrToStr(i)),r.t===r.duration&&(clearInterval(n),a.isAnimationOn=!1,t.setMessage("isAnimationOn",!1),a.dispatchEvent(a.event))},a.frequency)},scaleAnimationRun:function(t,e){var r,n,i,a=t[0],o=a.easing;r={x0:"number"==typeof e.x0?e.x0:0,y0:"number"==typeof e.y0?e.y0:0,x1:"number"==typeof e.x1?e.x1:1,y1:"number"==typeof e.y1?e.y1:1,x:0,y:0,t:0,duration:"number"==typeof e.d?e.d:2e3},n=setInterval(function(){r.t+=a.frequency,r.t>r.duration&&(r.t=r.duration),r.x=o(r.t,r.x0,r.x1-r.x0,r.duration),r.y=o(r.t,r.y0,r.y1-r.y0,r.duration),(i=l.transformAttrToObj(a.getAttribute("transform"))).scale.x=r.x,i.scale.y=r.y,a.setAttributeNS(null,"transform",l.transformAttrToStr(i)),r.t===r.duration&&clearInterval(n)},a.frequency)},translateAnimationRun:function(t,e){var r,n,i,a,o=t[0],s=o.easing;o.event=t.createEvent(),r=l.transformAttrToObj(t[0].getAttribute("transform")),n={x0:r.translate.x,y0:r.translate.y},i={x:0,y:0,length:Math.sqrt(Math.pow(e.x-n.x0,2)+Math.pow(e.y-n.y0,2)),arc:Math.atan((e.y-n.y0)/(e.x-n.x0)),t:0,duration:2e3},e.x-n.x0<0&&(i.arc+=-Math.PI),0===i.length&&(i.arc=0),"number"==typeof e.d&&(i.duration=e.d),o.isAnimationOn=!0,t.setMessage("isAnimationOn",!0),a=setInterval(function(){i.t+=o.frequency,i.t>i.duration&&(i.t=i.duration),i.x=s(i.t,0,i.length,i.duration)*Math.cos(i.arc)+n.x0,i.y=s(i.t,0,i.length,i.duration)*Math.sin(i.arc)+n.y0,(r=l.transformAttrToObj(o.getAttribute("transform"))).translate.x=i.x,r.translate.y=i.y,o.setAttributeNS(null,"transform",l.transformAttrToStr(r)),!1===o.isAnimationOn||!1===t.getMessage("isAnimationOn")?clearInterval(a):i.t===i.duration&&(clearInterval(a),o.isAnimationOn=!1,t.setMessage("isAnimationOn",!1),o.dispatchEvent(o.event))},o.frequency)},textAnimationRun:function(t,e){var r,n=t[0],i=n.easing,a={value:0,start:"number"==typeof e.start?e.start:0,stop:"number"==typeof e.stop?e.stop:0,t:0,duration:"number"==typeof e.d?e.d:2e3};r=setInterval(function(){a.t+=n.frequency,(a.t>a.duration||a.stop===a.start)&&(a.t=a.duration),a.value=i(a.t,a.start,a.stop-a.start,a.duration),0===a.duration&&(a.value=a.start),n.textContent=a.value.toFixed(0),a.t===a.duration&&clearInterval(r)},n.frequency)}},l},"function"==typeof define&&define.amd?define([""],o):"object"==typeof exports?(module.exports=o(a),null===a.SVG&&(a.SVG=o(a))):a.SVG=o(a),s=m,l=function(){return{linear:function(t,e,r,n){return r*t/n+e},swing:function(t,e,r,n){return r*(.5-Math.cos(t/n*Math.PI)/2)+e},easeInSine:function(t,e,r,n){return-r*Math.cos(t/n*(Math.PI/2))+r+e},easeOutSine:function(t,e,r,n){return r*Math.sin(t/n*(Math.PI/2))+e},easeInOutSine:function(t,e,r,n){return-r/2*(Math.cos(Math.PI*t/n)-1)+e},easeInQuad:function(t,e,r,n){return r*(t/=n)*t+e},easeOutQuad:function(t,e,r,n){return-r*(t/=n)*(t-2)+e},easeInOutQuad:function(t,e,r,n){return(t/=n/2)<1?r/2*t*t+e:-r/2*(--t*(t-2)-1)+e},easeInCubic:function(t,e,r,n){return r*(t/=n)*t*t+e},easeOutCubic:function(t,e,r,n){return r*((t=t/n-1)*t*t+1)+e},easeInOutCubic:function(t,e,r,n){return(t/=n/2)<1?r/2*t*t*t+e:r/2*((t-=2)*t*t+2)+e},easeInQuart:function(t,e,r,n){return r*(t/=n)*t*t*t+e},easeOutQuart:function(t,e,r,n){return-r*((t=t/n-1)*t*t*t-1)+e},easeInOutQuart:function(t,e,r,n){return(t/=n/2)<1?r/2*t*t*t*t+e:-r/2*((t-=2)*t*t*t-2)+e},easeInQuint:function(t,e,r,n){return r*(t/=n)*t*t*t*t+e},easeOutQuint:function(t,e,r,n){return r*((t=t/n-1)*t*t*t*t+1)+e},easeInOutQuint:function(t,e,r,n){return(t/=n/2)<1?r/2*t*t*t*t*t+e:r/2*((t-=2)*t*t*t*t+2)+e},easeInExpo:function(t,e,r,n){return 0===t?e:r*Math.pow(2,10*(t/n-1))+e},easeOutExpo:function(t,e,r,n){return t===n?e+r:r*(1-Math.pow(2,-10*t/n))+e},easeInOutExpo:function(t,e,r,n){return 0===t?e:t===n?e+r:(t/=n/2)<1?r/2*Math.pow(2,10*(t-1))+e:r/2*(2-Math.pow(2,-10*--t))+e},easeInCirc:function(t,e,r,n){return-r*(Math.sqrt(1-(t/=n)*t)-1)+e},easeOutCirc:function(t,e,r,n){return r*Math.sqrt(1-(t=t/n-1)*t)+e},easeInOutCirc:function(t,e,r,n){return(t/=n/2)<1?-r/2*(Math.sqrt(1-t*t)-1)+e:r/2*(Math.sqrt(1-(t-=2)*t)+1)+e},easeInBack:function(t,e,r,n,i){return void 0===i&&(i=1.70158),r*(t/=n)*t*((i+1)*t-i)+e},easeOutBack:function(t,e,r,n,i){return void 0===i&&(i=1.70158),r*((t=t/n-1)*t*((i+1)*t+i)+1)+e},easeInOutBack:function(t,e,r,n,i){return void 0===i&&(i=1.70158),(t/=n/2)<1?r/2*(t*t*((1+(i*=1.525))*t-i))+e:r/2*((t-=2)*t*((1+(i*=1.525))*t+i)+2)+e},easeInElastic:function(t,e,r,n){var i=1.70158,a=0,o=r;return 0===t?e:1==(t/=n)?e+r:(a||(a=.3*n),i=o<Math.abs(r)?(o=r,a/4):a/(2*Math.PI)*Math.asin(r/o),-o*Math.pow(2,10*(t-=1))*Math.sin((t*n-i)*(2*Math.PI)/a)+e)},easeOutElastic:function(t,e,r,n){var i=1.70158,a=0,o=r;return 0===t?e:1==(t/=n)?e+r:(a||(a=.3*n),i=o<Math.abs(r)?(o=r,a/4):a/(2*Math.PI)*Math.asin(r/o),o*Math.pow(2,-10*t)*Math.sin((t*n-i)*(2*Math.PI)/a)+r+e)},easeInOutElastic:function(t,e,r,n){var i=1.70158,a=0,o=r;return 0===t?e:2==(t/=n/2)?e+r:(a||(a=n*(.3*1.5)),i=o<Math.abs(r)?(o=r,a/4):a/(2*Math.PI)*Math.asin(r/o),t<1?o*Math.pow(2,10*(t-=1))*Math.sin((t*n-i)*(2*Math.PI)/a)*-.5+e:o*Math.pow(2,-10*(t-=1))*Math.sin((t*n-i)*(2*Math.PI)/a)*.5+r+e)},easeInBounce:function(t,e,r,n){return r-this.easeOutBounce(n-t,0,r,n)+e},easeOutBounce:function(t,e,r,n){return(t/=n)<1/2.75?r*(7.5625*t*t)+e:t<2/2.75?r*(7.5625*(t-=1.5/2.75)*t+.75)+e:t<2.5/2.75?r*(7.5625*(t-=2.25/2.75)*t+.9375)+e:r*(7.5625*(t-=2.625/2.75)*t+.984375)+e},easeInOutBounce:function(t,e,r,n){return t<n/2?.5*this.easeInBounce(2*t,0,r,n)+e:.5*this.easeOutBounce(2*t-n,0,r,n)+.5*r+e}}},"function"==typeof define&&define.amd?define([""],l):"object"==typeof exports?(module.exports=l(),null===s.easing&&(s.easing=l())):s.easing=l(),c=m,d=function(t){var e,r,n,i;return(i={}).Private={get _schema(){return{listeners:[],listenersOnce:[]}},get _streamSchema(){return{stream:{firing:!1,listeners:[]}}},_add:function(t,e){Object.prototype.hasOwnProperty.call(t,e)||(t[e]=this._schema)},_addStream:function(t,e){Object.prototype.hasOwnProperty.call(t,e)||(t[e]=this._streamSchema)},addEvents:function(t,e){var r;if("string"==typeof e)this._add(t,e);else if(Array.isArray(e))for(r=0;r<e.length;r++)"string"==typeof e[r]&&this._add(t,e[r])},addStreamEvents:function(t,e){var r;if("string"==typeof e)this._addStream(t,e);else if(Array.isArray(e))for(r=0;r<e.length;r++)"string"==typeof e[r]&&this._addStream(t,e[r])},fire:function(t,e,r){var n;if("string"==typeof e&&Object.prototype.hasOwnProperty.call(t,e)){for(n=0;n<t[e].listeners.length;n++)t[e].listeners[n](r);for(n=0;n<t[e].listenersOnce.length;n++)t[e].listenersOnce[n](r);t[e].listenersOnce.splice(0,t[e].listenersOnce.length)}},addEventListener:function(t,e,r,n){n&&this.addEvents(t,e),"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&t[e].listeners.push(r)},addOneTimeEventListener:function(t,e,r,n){n&&this.addEvents(t,e),"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&t[e].listenersOnce.push(r)},removeEventListener:function(t,e,r){var n;"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&(0<=(n=t[e].listeners.indexOf(r))&&t[e].listeners.splice(n,1),0<=(n=t[e].listenersOnce.indexOf(r))&&t[e].listenersOnce.splice(n,1))},fireQ:function(t,e,r){var n=t[e].stream,i=n.listeners;n.firing=!0,function t(){0<i.length?i.shift().apply(r||{},[t].concat(Array.prototype.slice.call(arguments,0))):n.firing=!1}()},fireQL:function(t,e,r){var n=t[e].stream,i=n.listeners;n.firing=!0,function t(){if(0<i.length){for(;1<i.length;)i.shift();i.shift().apply(r||{},[t].concat(Array.prototype.slice.call(arguments,0)))}else n.firing=!1}()},addEventStreamListener:function(t,e,r){"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&(t[e].stream.listeners.push(r),t[e].stream.firing||this.fireQ(t,e))},addEventStreamListenerLast:function(t,e,r){"string"==typeof e&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(t,e)&&(t[e].stream.listeners.push(r),t[e].stream.firing||this.fireQL(t,e))}},e=function(t){var e=Object.create(n);return e.db={},e.addEvents(t),e},r=t.Messenger,e.noConflict=function(){return t.Messenger=r,this},e.VERSION="0.0.4",n={addEvents:function(t){return i.Private.addEvents(this.db,t),this},addStreamEvents:function(t){return i.Private.addStreamEvents(this.db,t),this},fire:function(t,e){return i.Private.fire(this.db,t,e),this},trigger:function(t,e){return this.fire(t,e)},addEventListener:function(t,e){return i.Private.addEventListener(this.db,t,e,this.open),this},addOneTimeEventListener:function(t,e){return i.Private.addOneTimeEventListener(this.db,t,e,this.open),this},removeEventListener:function(t,e){return i.Private.removeEventListener(this.db,t,e),this},on:function(t,e){return this.addEventListener(t,e)},one:function(t,e){return this.addOneTimeEventListener(t,e)},off:function(t,e){return this.removeEventListener(t,e)},fireQActive:function(t){return this.db[t].stream.firing},fireQ:function(t,e){return i.Private.fireQ(this.db,t,e),this},fireQL:function(t,e){return i.Private.fireQL(this.db,t,e),this},addEventStreamListener:function(t,e){return i.Private.addEventStreamListener(this.db,t,e),this},addEventStreamListenerLast:function(t,e){return i.Private.addEventStreamListenerLast(this.db,t,e),this},q:function(t,e){return this.addEventStreamListener(t,e)},ql:function(t,e){return this.addEventStreamListenerLast(t,e)},setOpen:function(){return this.open=!0,this}},e},"function"==typeof define&&define.amd?define([""],d):"object"==typeof exports?(module.exports=d(c),null===c.Messenger&&(c.Messenger=d(c))):c.Messenger=d(c),f=m,p=function(t){var e,r,a,l,n,i,o,s,c,u,h,d,f,p,m,y,g,x,b,v,w,k,M,S,L,z,P,O,E,A,C,R,_,T,I,G,N,F,B,U,j,V,Z,D,X,q,Y,W,H,Q,K,J,$,tt,et,rt,nt,it,at,ot,st,lt,ct,ut,ht,dt,ft,pt,mt,yt,gt,xt,bt,vt,wt,kt,Mt,St,Lt,zt,Pt,Ot,Et,At,Ct,Rt,_t,Tt,It,Gt,Nt,Ft,Bt,Ut,jt,Vt,Zt,Dt,Xt,qt,Yt,Wt,Ht,Qt,Kt,Jt,$t,te,ee,re,ne,ie,ae,oe,se,le,ce,ue,he,de,fe,pe,me,ye,ge,xe,be,ve,we,ke,Me,Se,Le,ze,Pe,Oe,Ee,Ae,Ce,Re,_e,Te,Ie,Ge,Ne,Fe,Be,Ue,je,Ve,Ze,De,Xe,qe,Ye,We,He,Qe,Ke,Je,$e,tr,er,rr,nr,ir,ar,or,sr,lr,cr,ur,hr,dr,fr,pr,mr,yr,gr,xr,br,vr,wr,kr,Mr,Sr,Lr,zr,Pr,Or,Er,Ar,Cr,Rr,_r,Tr,Ir,Gr,Nr,Fr,Br,Ur,jr,Vr,Zr,Dr,Xr,qr,Yr,Wr,Hr;return(a={_:null,Images:{GlyphAtlas:{},Sprite:{}},MapGL:{Core:{Public:{},Renderer:{},Util:{}},GeoJSON:{Public:{},Renderer:{},Util:{}},Raster:{Public:{},Renderer:{},Util:{}},Vector:{Public:{},Worker:{Tile:{Processor:{}}},Source:{Earcut:{},Geo:{},RWebGL:{},Styler:{}},Renderer:{},RenderLineString:{},RenderPoint:{},RenderWebGLText:{},Render2d:{},Drawer2d:{},DrawerWebGL:{},Loader:{},Util:{}}},MATH:{Matrix:{M3:{},M4:{}}},PBF:{TileSource:{},FontSource:{},UtilSource:{}},Rasterizer:{GL:{Public:{},Earcut:{},Polyline:{},Shaders:{},Geometry:{},Image:{},Glyph:{},Font:{},Util:{}},"2D":{Public:{}},SVG:{Public:{}}},Tiler:{Public:{},Util:{}},Tiler2:{Public:{},Map:{},Util:{}},Util:{XMLLoaderSource:{},ColorSource:{},LRU:{}}})._={isString:function(t){return"[object String]"===Object.prototype.toString.call(t)},isNumber:function(t){return"[object Number]"===Object.prototype.toString.call(t)},isObject:function(t){var e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:function(t){return"[object Object]"===Object.prototype.toString.call(t)},isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},isEmpty:function(t){var e;if(null===t)return!0;if(this.isArray(t)||this.isString(t))return 0===t.length;for(e in t)if(t.hasOwnProperty(e))return!1;return!0},hasProperty:function(t,e){return!(!this.isLiteralObject(t)||!this.isString(e))&&Object.prototype.hasOwnProperty.call(t,e)},clone:function(t){var e,r=this.isArray(t)?[]:{};if(this.isObject(t)){for(e in t)this.isArray(t[e])?r[e]=this.clone(t[e]):this.isObject(t[e])?r[e]=this.extend(t[e]):r[e]=t[e];return r}},extend:function(t){var e,r,n;if(!this.isObject(t))return t;for(n=1;n<arguments.length;n++)for(r in e=arguments[n])this.isLiteralObject(arguments[n][r])?(t[r]=void 0!==t[r]?t[r]:{},this.extend(t[r],arguments[n][r])):hasOwnProperty.call(e,r)&&(t[r]=this.isArray(e[r])?this.clone(e[r]):e[r]);return t}},l=a._,s=a.Images.GlyphAtlas,n=function(t,e,r){t.width=e,t.height=r,t.data=new Uint8Array(4*t.width*t.height)},i=function(t,e,r){var n,i=e.width*e.height*4,a=96*r,o=0;do{for(n=0;n<4*e.width;n+=4)t.data[a+n+0]=e.data[o+n+0],t.data[a+n+1]=e.data[o+n+1],t.data[a+n+2]=e.data[o+n+2],t.data[a+n+3]=e.data[o+n+3];o+=4*e.width,a+=4*t.width}while(o<i)},l.extend(s,{create:function(){var t=Object.create(o);return t.width=0,t.height=0,t.data=new Uint8Array(0),t}}),o={set:function(t,e){return n(this,t,e),this},add:function(t,e){return i(this,t,e),this}},h=a.Images.Sprite,c=function(t){var e=document.createElement("canvas"),r=e.getContext("2d");e.width=t.naturalWidth,e.height=t.naturalHeight,r.drawImage(t,0,0),t.atlas=r},u=function(t,e){var r,n=document.getElementById("canvas").getContext("2d");r=t.getImageData(e.x,e.y,e.width,e.height),n.putImageData(r,0,0)},l.extend(h,{createAtlas:function(t){c(t)},drawIcon:function(t,e){u(t,e)},getIcon:function(t,e){return t.getImageData(e.x,e.y,e.width,e.height)}}),f=a.MapGL.Core.Public,p=a.Rasterizer.SVG.Public,m=a.MapGL.Core.Renderer,l.extend(f,{create:function(t,e,r){var n=Object.create(l.extend({},d,e));return n.type=r,n.svg=p.create(t),n["2d"]=null,n.webGL=null,n.db={tiles:null,map:null,icon:null,symbol:null},n}}),d={addSVG:function(t,e){return m.init(this.svg,t,e),this},init:function(){return this},draw:function(){return this},update:function(){return this},zoom:function(){return this},getXYFromLatLong:function(){return this},getLatLongFromXY:function(){return this},getOptimalZoom:function(){return 0}},x=a.MapGL.Core.Renderer,y=function(t,e,r){t.attr("class","map").attr("width",e).attr("height",r)},g=function(t,e,r){t.firstParent().empty().append("g").attr("class","series").attr("transform","translate(0, 0)").append("svg").attr("class","maps").attr("width",e).attr("height",r).append("g").attr("class","geojson").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","raster").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","vector").attr("transform","translate(0, 0) scale(1, 1)").parent().parent().parent()},l.extend(x,{init:function(t,e,r){y(t,e,r),g(t,e,r)}}),v=a.MapGL.GeoJSON.Public,w=a.MapGL.Core.Public,k=a.MapGL.GeoJSON.Renderer,M=a.MapGL.GeoJSON.Util,l.extend(v,{create:function(t){return w.create(t,b,"geojson")}}),b={draw:function(t){return this.db.map=M.initSettings(t),k.draw(this.svg,t.data),this},update:function(t,e,r){return k.update(this.svg,this.db.map,t,e,r),this},zoom:function(t,e,r){return this.update(this.svg,this.db.map,t,e,r)},getXYFromLatLong:function(t,e){return M.getXYFromLatLong(this.db.map,t,e)},getLatLongFromXY:function(t,e){return M.getLatLongFromXY(this.db.map,t,e)}},O=a.MapGL.GeoJSON.Renderer,S=function(t){var e,r,n,i;for(e="",i=0;i<t.length;i++)r=t[i][0],n=t[i][1],""===e?e="M"+r+","+n:e+="L"+r+","+n;return e},L=function(t){var e,r;for(e="",r=0;r<t.length;r++)e+=S(t[r]),e+="z";return e},z=function(t,e){var r,n,i;for(n=0;n<e.features.length;n++){switch(e.features[n].geometry.type){case"MultiPolygon":for(r="",i=0;i<e.features[n].geometry.coordinates.length;i++)r+=L(e.features[n].geometry.coordinates[i]);break;case"Polygon":r=L(e.features[n].geometry.coordinates);break;case"Polyline":r=S(e.features[n].geometry.coordinates);break;default:throw new Error('_draw: the type "'+e.features[n].geometry.type+'" is unknown!')}t.select(".series").select(".maps").select(".geojson").append("path").attr("id",e.features[n].id).attr("title",e.features[n].title).attr("d",r).firstParent()}t.firstParent()},P=function(t,e,r,n,i){e.shift.x=r-e.bbox.x,e.shift.y=n-e.bbox.y,e.zoom=i,t.select(".series").select(".geojson").attr("transform","translate("+r+", "+n+") scale("+i+", "+i+")").firstParent()},l.extend(O,{draw:function(t,e){z(t,e)},update:function(t,e,r,n,i){P(t,e,r,n,i)}}),_=a.MapGL.GeoJSON.Util,E=function(t){var e={zoom:null,shift:{x:null,y:null},bbox:{x:0,y:0,width:null,height:null},data:null};return e.zoom=t.zoom,e.shift.x=t.shift.x,e.shift.y=t.shift.y,e.bbox.x=t.bbox.x,e.bbox.y=t.bbox.y,e.bbox.width=t.bbox.width,e.bbox.height=t.bbox.height,e.data=t.data,e},A=function(t,e){return{x:e,y:180*Math.log(Math.tan(Math.PI/4+t/2/180*Math.PI))/Math.PI}},C=function(t,e,r){var n,i,a,o,s=t.data.parameters.scale,l=t.data.parameters.topLatitude,c=t.data.parameters.leftLongitude,u=t.zoom,h=t.shift;return n=A(l,c),i=t.bbox.x-n.x*s*u,a=t.bbox.y+n.y*s*u,{x:i+(o=A(e,r)).x*s*u+h.x,y:a-o.y*s*u+h.y}},R=function(t,e,r){var n=(e-t.shift.x)/(t.zoom*t.data.parameters.scale),i=t.data.parameters.xLeft+n,a=(r-t.shift.y)/(t.zoom*t.data.parameters.scale),o=t.data.parameters.yTop-a;return{"λ":i,"φ":(Math.atan(Math.exp(o/(180/Math.PI)))-Math.PI/4)*(360/Math.PI)}},l.extend(_,{initSettings:function(t){return E(t)},getXYFromLatLong:function(t,e,r){return C(t,e,r)},getLatLongFromXY:function(t,e,r){return R(t,e,r)}}),I=a.MapGL.Raster.Public,G=a.MapGL.Core.Public,N=a.MapGL.Raster.Renderer,F=a.MapGL.Raster.Util,B=a.Tiler.Public,U=a.Util.LRU,l.extend(I,{create:function(t){var e=G.create(t,T,"raster");return e.db.tiles=U.create(1e3),e}}),T={draw:function(t){return this.db.map=F.initSettings(t),N.draw(this.svg,this.db.map,this.db.tiles),this},update:function(t,e,r){return N.update(this.svg,this.db.map,this.db.tiles,t,e,r),this},zoom:function(t,e,r,n){return N.zoom(this.svg,this.db.map,t,e,r,n),this},getXYFromLatLong:function(t,e){return F.getXYFromLatLong(this.db.map,t,e)},getLatLongFromXY:function(t,e){return B.getLatLongFromXY(this.db.map,t,e)},getOptimalZoom:function(t){return B.getOptimalZoom(this.db.map,t)},getCoord:function(){return this.db.map.coord},enableCoord:function(){return this.db.map.bbox.coord=!0,this},disableCoord:function(){return this.db.map.bbox.coord=!1,this},computeCenterViewCoord:function(t,e,r){return B.computeCenterViewCoord(this.db.map,t,e,r)},resetScale:function(){return this.db.map.inter.scale=1,this}},W=a.MapGL.Raster.Renderer,H=a.Tiler.Public,j=function(e,t){var r=new Image,n=1;e.setAttributeNS(null,"fill-opacity",n),r.addEventListener("load",function(){var t;t=setInterval(function(){n-=.05,e.setAttributeNS(null,"fill-opacity",n),n<=0&&(e.setAttributeNS(null,"fill-opacity",0),clearInterval(t))},20)}),r.src=t.url},V=function(t,e,r){var n,i,a,o,s,l,c,u,h;for(t.select(".series").select(".maps").select(".raster").attr("transform","translate(0, 0) scale(1, 1)"),l=[],o=t.children(),h=0;h<o.length;h++)(c=o[h].getAttribute("id"))&&l.push(c);for(s=[],h=0;h<r.length;h++)(n=e.get(r[h].id))?i=n.url:(i=r[h].url,e.set(r[h].id,{url:i}),a=!0),s.push(r[h].id),-1===l.indexOf(r[h].id)?(t.append("image").attr("id",r[h].id).alink("href",i).attr("x",r[h].x).attr("y",r[h].y).attr("width",r[h].width+.2).attr("height",r[h].height+.2).parent().append("rect").attr("x",r[h].x).attr("y",r[h].y).attr("width",r[h].width).attr("height",r[h].height).attr("fill","#E8E8E8").attr("fill-opacity",0),a&&(u=t.getElement(),j(u,r[h])),t.parent()):t.select("#"+r[h].id).attr("x",r[h].x).attr("y",r[h].y).next().attr("x",r[h].x).attr("y",r[h].y).parent();for(h=0;h<l.length;h++)-1===s.indexOf(l[h])&&t.select("#"+l[h]).next().remove().select("#"+l[h]).remove();t.firstParent()},Z=function(t,e,r,n,i,a){e.inter.scale=i,e.inter.cursor.x=a.x,e.inter.cursor.y=a.y,t.select(".series").select(".maps").select(".raster").attr("transform","translate("+r+", "+n+") scale("+i+", "+i+")").firstParent()},Y=function(t,e,r){var n=H.getTiles(e);V(t,r,n)},D=function(t,e,r,n,i,a){var o=n-e.bbox.x,s=i-e.bbox.y;e.zoom=l.isNumber(a)?a:e.zoom,e.coord.λ+=e.tile.delta.λ*o,e.coord.φ+=e.tile.delta.φ*s,e.bbox.x=n,e.bbox.y=i,Y(t,e,r)},q=function(t,e,r,n,i,a){var o,s,l=a-e.zoom,c={};if(c.x=e.bbox.width/2,c.y=e.bbox.height/2,0===l)return e.inter.scale=1,void D(t,e,r,n,i,a);0<=l?1<=l?(a=Math.floor(a),e.inter.scale=1,D(t,e,r,n,i,a)):(o=l*(e.bbox.width/2),s=l*(e.bbox.height/2),Z(t,e,-o,-s,1+l,c)):l<=-1?(a=Math.ceil(a),e.inter.scale=1,D(t,e,r,n,i,a)):(o=l/2*(e.bbox.width/2),s=l/2*(e.bbox.height/2),Z(t,e,-o,-s,1+l/2,c))},X=function(t,e,r,n,i,a){e.zoom=l.isNumber(a)?a:e.zoom,e.coord.λ=n,e.coord.φ=i,e.bbox.x=0,e.bbox.y=0,Y(t,e,r)},l.extend(W,{draw:function(t,e,r){Y(t,e,r)},update:function(t,e,r,n,i,a){return e.bbox.coord?X(t,e,r,n,i,a):q(t,e,r,n,i,a)},zoom:function(t,e,r,n,i,a){Z(t,e,r,n,i,a)}}),J=a.MapGL.Raster.Util,$=a.Tiler.Public,Q=function(t){var e={url:null,zoom:null,coord:{"φ":null,"λ":null},bbox:{x:0,y:0,width:null,height:null,coord:!1},tile:{x:null,y:null,size:{width:null,height:null},shift:{x:null,y:null},delta:{"φ":null,"λ":null}},inter:{scale:1,cursor:{x:null,y:null}}};return e.url=$.decodeUrl(t.url,t.subdomains,t.retina),e.token=t.token,e.zoom=l.isNumber(t.zoom)?t.zoom:0,e.coord.φ=l.isNumber(t.coord.φ)?t.coord.φ:0,e.coord.λ=l.isNumber(t.coord.λ)?t.coord.λ:0,e.bbox.width=l.isNumber(t.bbox.width)?t.bbox.width:1e3,e.bbox.height=l.isNumber(t.bbox.height)?t.bbox.height:350,e.tile.size.width=l.isNumber(t.tile.width)?t.tile.width:256,e.tile.size.height=l.isNumber(t.tile.height)?t.tile.height:256,e},K=function(t,e,r){var n=$.getXYFromLatLong(t,e,r);return 1!==t.inter.scale?{x:(1-t.inter.scale)*t.inter.cursor.x+n.x*t.inter.scale,y:(1-t.inter.scale)*t.inter.cursor.y+n.y*t.inter.scale}:n},l.extend(J,{initSettings:function(t){return Q(t)},getXYFromLatLong:function(t,e,r){return K(t,e,r)}}),et=a.MapGL.Vector.Public,rt=a.MapGL.Vector.Renderer,nt=a.MapGL.Vector.Loader,it=a.MapGL.Vector.Util,at=a.MapGL.Core.Public,ot=a.Rasterizer.GL.Public,st=a.Rasterizer["2D"].Public,lt=a.Rasterizer.GL.Earcut,ct=a.Util.LRU,l.extend(et,{create:function(t){var e;return(e=at.create(t,tt,"vector")).db.Q=l.async.init(),e.db.tiles=ct.create(),e.db.symbol=[],e.db.scene=[],e.db.workers={processors:null},e}}),tt={init:function(t,e,r){switch(rt.addCanvas(this.svg),r){case"webgl":rt.createWorkers(this.db),this.webGL=ot.create(this.svg,t,e),this.webGL.init(),this.earcut=lt;break;case"2d":this["2d"]=st.create(this.svg,t,e);break;default:throw new Error('The rasterizer "'+r+'" is unknown!')}return this},draw:function(t,e,r){var n=this,i=this["2d"]?this["2d"]:this.webGL;this.db.map=it.initSettings(t),nt.loadData(i,this.db,t.style,function(){rt.init(i,n.db),e?rt.drawOneTile(i,n.db,e):rt.draw(i,n.db,r)})},load:function(t,e){var r=this["2d"]?this["2d"]:this.webGL;this.db.map=it.initSettings(t),nt.loadData(r,this.db,t.style,function(){e&&e()})},update:function(t,e,r){var n=this["2d"]?this["2d"]:this.webGL;return rt.update(n,this.db,t,e,r),this},zoom:function(){throw new Error("zoom not implemented yet!")},getXYFromLatLong:function(t,e){return it.getXYFromLatLong(this.db.map,t,e)},getLatLongFromXY:function(t,e){return it.getLatLongFromXY(this.db.map,t,e)}},function(){var t=a.MapGL.Vector.Source.Earcut;function e(){function t(t,e,r){r=r||2;var n,i,a,o,s,l,c,u=e&&e.length,h=u?e[0]*r:t.length,d=m(t,0,h,r,!0),f=[];if(!d)return f;if(u&&(d=function(t,e,r,n){var i,a,o,s,l,c=[];for(i=0,a=e.length;i<a;i++)o=e[i]*n,s=i<a-1?e[i+1]*n:t.length,(l=m(t,o,s,n,!1))===l.next&&(l.steiner=!0),c.push(w(l));for(c.sort(x),i=0;i<c.length;i++)b(c[i],r),r=y(r,r.next);return r}(t,e,d,r)),t.length>80*r){n=a=t[0],i=o=t[1];for(var p=r;p<h;p+=r)(s=t[p])<n&&(n=s),(l=t[p+1])<i&&(i=l),a<s&&(a=s),o<l&&(o=l);c=0!==(c=Math.max(a-n,o-i))?1/c:0}return g(d,f,r,n,i,c),f}function m(t,e,r,n,i){var a,o;if(i===0<P(t,e,r,n))for(a=e;a<r;a+=n)o=l(a,t[a],t[a+1],o);else for(a=r-n;e<=a;a-=n)o=l(a,t[a],t[a+1],o);return o&&s(o,o.next)&&(z(o),o=o.next),o}function y(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!s(n,n.next)&&0!==M(n.prev,n,n.next))n=n.next;else{if(z(n),(n=e=n.prev)===n.next)break;r=!0}}while(r||n!==e);return e}function g(t,e,r,n,i,a,o){if(t){!o&&a&&function(t,e,r,n){var i=t;for(;null===i.z&&(i.z=v(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next,i!==t;);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,a,o,s,l,c=1;do{for(r=t,a=t=null,o=0;r;){for(o++,n=r,e=s=0;e<c&&(s++,n=n.nextZ);e++);for(l=c;0<s||0<l&&n;)0!==s&&(0===l||!n||r.z<=n.z)?(r=(i=r).nextZ,s--):(n=(i=n).nextZ,l--),a?a.nextZ=i:t=i,i.prevZ=a,a=i;r=n}a.nextZ=null,c*=2}while(1<o)}(i)}(t,n,i,a);for(var s,l,c=t;t.prev!==t.next;)if(s=t.prev,l=t.next,a?h(t,n,i,a):u(t))e.push(s.i/r),e.push(t.i/r),e.push(l.i/r),z(t),t=l.next,c=l.next;else if((t=l)===c){o?1===o?g(t=d(t,e,r),e,r,n,i,a,2):2===o&&f(t,e,r,n,i,a):g(y(t),e,r,n,i,a,1);break}}}function u(t){var e=t.prev,r=t,n=t.next;if(0<=M(e,r,n))return!1;for(var i=t.next.next;i!==t.prev;){if(k(e.x,e.y,r.x,r.y,n.x,n.y,i.x,i.y)&&0<=M(i.prev,i,i.next))return!1;i=i.next}return!0}function h(t,e,r,n){var i=t.prev,a=t,o=t.next;if(0<=M(i,a,o))return!1;for(var s=i.x<a.x?i.x<o.x?i.x:o.x:a.x<o.x?a.x:o.x,l=i.y<a.y?i.y<o.y?i.y:o.y:a.y<o.y?a.y:o.y,c=i.x>a.x?i.x>o.x?i.x:o.x:a.x>o.x?a.x:o.x,u=i.y>a.y?i.y>o.y?i.y:o.y:a.y>o.y?a.y:o.y,h=v(s,l,e,r,n),d=v(c,u,e,r,n),f=t.prevZ,p=t.nextZ;f&&f.z>=h&&p&&p.z<=d;){if(f!==t.prev&&f!==t.next&&k(i.x,i.y,a.x,a.y,o.x,o.y,f.x,f.y)&&0<=M(f.prev,f,f.next))return!1;if(f=f.prevZ,p!==t.prev&&p!==t.next&&k(i.x,i.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=M(p.prev,p,p.next))return!1;p=p.nextZ}for(;f&&f.z>=h;){if(f!==t.prev&&f!==t.next&&k(i.x,i.y,a.x,a.y,o.x,o.y,f.x,f.y)&&0<=M(f.prev,f,f.next))return!1;f=f.prevZ}for(;p&&p.z<=d;){if(p!==t.prev&&p!==t.next&&k(i.x,i.y,a.x,a.y,o.x,o.y,p.x,p.y)&&0<=M(p.prev,p,p.next))return!1;p=p.nextZ}return!0}function d(t,e,r){var n=t;do{var i=n.prev,a=n.next.next;!s(i,a)&&p(i,n,n.next,a)&&S(i,a)&&S(a,i)&&(e.push(i.i/r),e.push(n.i/r),e.push(a.i/r),z(n),z(n.next),n=t=a),n=n.next}while(n!==t);return n}function f(t,e,r,n,i,a){var o,s,l=t;do{for(var c=l.next.next;c!==l.prev;){if(l.i!==c.i&&(s=c,(o=l).next.i!==s.i&&o.prev.i!==s.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&p(r,r.next,t,e))return!0;r=r.next}while(r!==t);return!1}(o,s)&&S(o,s)&&S(s,o)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,a=(t.y+e.y)/2;for(;r.y>a!=r.next.y>a&&r.next.y!==r.y&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next,r!==t;);return n}(o,s))){var u=L(l,c);return l=y(l,l.next),u=y(u,u.next),g(l,e,r,n,i,a),void g(u,e,r,n,i,a)}c=c.next}l=l.next}while(l!==t)}function x(t,e){return t.x-e.x}function b(t,e){if(e=function(t,e){var r,n=e,i=t.x,a=t.y,o=-1/0;do{if(a<=n.y&&a>=n.next.y&&n.next.y!==n.y){var s=n.x+(a-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(s<=i&&o<s){if((o=s)===i){if(a===n.y)return n;if(a===n.next.y)return n.next}r=n.x<n.next.x?n:n.next}}n=n.next}while(n!==e);if(!r)return null;if(i===o)return r.prev;var l,c=r,u=r.x,h=r.y,d=1/0;n=r.next;for(;n!==c;)i>=n.x&&n.x>=u&&i!==n.x&&k(a<h?i:o,a,u,h,a<h?o:i,a,n.x,n.y)&&((l=Math.abs(a-n.y)/(i-n.x))<d||l===d&&n.x>r.x)&&S(n,t)&&(r=n,d=l),n=n.next;return r}(t,e)){var r=L(e,t);y(r,r.next)}}function v(t,e,r,n,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*i)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-n)*i)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function w(t){for(var e=t,r=t;e.x<r.x&&(r=e),(e=e.next)!==t;);return r}function k(t,e,r,n,i,a,o,s){return 0<=(i-o)*(e-s)-(t-o)*(a-s)&&0<=(t-o)*(n-s)-(r-o)*(e-s)&&0<=(r-o)*(a-s)-(i-o)*(n-s)}function M(t,e,r){return(e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function s(t,e){return t.x===e.x&&t.y===e.y}function p(t,e,r,n){return!!(s(t,e)&&s(r,n)||s(t,n)&&s(r,e))||0<M(t,e,r)!=0<M(t,e,n)&&0<M(r,n,t)!=0<M(r,n,e)}function S(t,e){return M(t.prev,t,t.next)<0?0<=M(t,e,t.next)&&0<=M(t,t.prev,e):M(t,e,t.prev)<0||M(t,t.next,e)<0}function L(t,e){var r=new o(t.i,t.x,t.y),n=new o(e.i,e.x,e.y),i=t.next,a=e.prev;return(t.next=e).prev=t,(r.next=i).prev=r,(n.next=r).prev=n,(a.next=n).prev=a,n}function l(t,e,r,n){var i=new o(t,e,r);return n?(i.next=n.next,(i.prev=n).next.prev=i,n.next=i):(i.prev=i).next=i,i}function z(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function o(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function P(t,e,r,n){for(var i=0,a=e,o=r-n;a<r;a+=n)i+=(t[o]-t[a])*(t[a+1]+t[o+1]),o=a;return i}return t.deviation=function(t,e,r,n){var i=e&&e.length,a=i?e[0]*r:t.length,o=Math.abs(P(t,0,a,r));if(i)for(var s=0,l=e.length;s<l;s++){var c=e[s]*r,u=s<l-1?e[s+1]*r:t.length;o-=Math.abs(P(t,c,u,r))}var h=0;for(s=0;s<n.length;s+=3){var d=n[s]*r,f=n[s+1]*r,p=n[s+2]*r;h+=Math.abs((t[d]-t[p])*(t[f+1]-t[d+1])-(t[d]-t[f])*(t[p+1]-t[d+1]))}return 0===o&&0===h?0:Math.abs((h-o)/o)},{earcut:t,flatten:t.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var a=0;a<t[i].length;a++)for(var o=0;o<e;o++)r.vertices.push(t[i][a][o]);0<i&&(n+=t[i-1].length,r.holes.push(n))}return r},deviation:t.deviation}}l.extend(t,{getSource:function(){return e.toString()},create:function(){return e()}})}(),function(){var t=a.MapGL.Vector.Source.Geo;function e(){var n,h,e,r,i;return n=function(t,e,r){var n,i,a,o={};for(a=0;n=t.tags[a],a+=1,i=t.tags[a],a+=1,o[e[n]]=r[i],a<t.tags.length;);return o},h=function(t){var e,r,n=0;for(r=t.length-1,e=0;e<t.length;e++)n+=(t[r][0]-t[e][0])*(t[r][1]+t[e][1]),r=e;return 0<n},e=function(t){var e,r,n,i,a,o=0,s=0,l=[],c=[],u=[];i=0;do{switch(r=7&t[i],n=t[i]>>3,i+=1,r){case 1:for(a=0;o+=t[i+a]>>1^-(1&t[i+a]),s+=t[i+a+1]>>1^-(1&t[i+a+1]),(a+=2)<2*n;);0===u.length?u.push([o,s]):(h(u)?0===c.length?c.push(u):(l.push(c),(c=[]).push(u)):c.push(u),(u=[]).push([o,s])),i+=2*n;break;case 2:for(a=0;o+=t[i+a]>>1^-(1&t[i+a]),s+=t[i+a+1]>>1^-(1&t[i+a+1]),u.push([o,s]),(a+=2)<2*n;);i+=2*n;break;case 7:e=!0,h(u)?0===c.length?c.push(u):(l.push(c),(c=[]).push(u)):c.push(u),u=[];break;default:throw new Error('_fromGeom2Multipolygon: the command id "'+r+'" is unknown!')}}while(i<t.length);if(0!==u.length)throw new Error("_fromGeom2Multipolygon: ring not empty!");return 0!==c.length&&l.push(c),{multi:l,closedPath:e}},r=function(t){var e,r=[],n=[];for(e=0;e<t.length;e++)h(t[e])&&0!==n.length?(r.push(n),(n=[]).push(t[e])):n.push(t[e]);return 0<n.length&&r.push(n),r},i=function(t){var e,r,n,i,a,o=0,s=0,l=[],c=[];i=0;do{switch(r=7&t[i],n=t[i]>>3,i+=1,r){case 1:for(a=0;o+=t[i+a]>>1^-(1&t[i+a]),s+=t[i+a+1]>>1^-(1&t[i+a+1]),(a+=2)<2*n;);0===c.length?c.push([o,s]):(l.push(c),(c=[]).push([o,s])),i+=2*n;break;case 2:for(a=0;o+=t[i+a]>>1^-(1&t[i+a]),s+=t[i+a+1]>>1^-(1&t[i+a+1]),c.push([o,s]),(a+=2)<2*n;);i+=2*n;break;case 7:e=!0,l.push(c),c=[];break;default:throw new Error('_fromGeom2Coord: the command id "'+r+'" is unknown!')}}while(i<t.length);return 0!==c.length&&l.push(c),{coord:l,closedPath:e}},{getProperties:function(t,e,r){return n(t,e,r)},isClockwise:function(t){return h(t)},fromGeom2Multipolygon:function(t){return e(t)},coord2Multipolygon:function(t){return r(t)},fromGeom2Coord:function(t){return i(t)}}}l.extend(t,{getSource:function(){return e.toString()},create:function(){return e()}})}(),function(){var t=a.MapGL.Vector.Source.RWebGL,e=a.MapGL.Vector.Source.Styler,r=a.MapGL.Vector.Source.Geo,n=a.MapGL.Vector.Source.Earcut;function i(t,e,r){var d,o,n,s,i,a,l,c=t||StylerLibrary(),u=e||GeoLibrary(),h=r||EarcutLibrary();return d=function(t,e,r){var n=Math.atan2(e,t);return 0===t?{x:r,y:0}:0===e?{x:0,y:r}:{x:Math.sin(n)*r,y:Math.cos(n)*r}},o=function(t,e,r){var n,i,a,o,s,l,c,u=[],h=e*r;for(s=0;s<t.length;s++)for(l=0;l<t[s].length-1;l++)n=t[s][l][0],i=t[s][l][1],a=t[s][l+1][0],o=t[s][l+1][1],c=d(a-n,o-i,h/2),u.push(n-c.x,i+c.y,a-c.x,o+c.y,a+c.x,o-c.y,a+c.x,o-c.y,n+c.x,i-c.y,n-c.x,i+c.y);return u},l=function(t,e,r){var n,i=e[r],a=i.rpaint["line-width"]+i.rpaint["line-gap-width"];a!==t.polygons[r].width&&(n=t.polygons[r].coord,t.polygons[r].vertices=o(n,a,4),t.polygons[r].width=a),t.polygons[r].color=c.getColor(i)},a=function(t,e){var r=u.fromGeom2Coord(t.geometry).coord,n=e.rpaint["line-width"]+e.rpaint["line-gap-width"];t.polygons.push({coord:r,vertices:o(r,n,4),color:c.getColor(e),width:n})},s=function(t){var e,r=[];for(e=0;e<t.styles.length;e++)r.push(c.getColor(t.styles[e]));return r},i=function(t){t.color=s(t)},n=function(t){var e,r,n,i,a=u.fromGeom2Multipolygon(t.geometry).multi;for(t.vertices=[],n=0;n<a.length;n++)for(e=h.flatten(a[n]),r=h.earcut(e.vertices,e.holes,e.dimensions),i=0;i<r.length;i++)t.vertices.push(e.vertices[r[i]*e.dimensions]),t.vertices.push(e.vertices[r[i]*e.dimensions+1]);t.color=s(t)},{processPolygon:function(t){n(t)},updatePolygon:function(t){i(t)},processPolyline:function(t,e){a(t,e)},updatePolyline:function(t,e,r){l(t,e,r)}}}l.extend(t,{getSource:function(){return i.toString()},create:function(){return i(e.create(),r.create(),n.create())}})}(),function(){var t=a.MapGL.Vector.Source.Styler,k=a.Util.ColorSource;function e(t){var l,o,s,e,c,u,h,d,f,p,n,i,m,y,g,x,b,r,a,v,w=t||k();return l={isString:function(t){return"[object String]"===Object.prototype.toString.call(t)},isNumber:function(t){return"[object Number]"===Object.prototype.toString.call(t)},isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},isLiteralObject:function(t){return"[object Object]"===Object.prototype.toString.call(t)},hasProperty:function(t,e){return!(!this.isLiteralObject(t)||!this.isString(e))&&Object.prototype.hasOwnProperty.call(t,e)}},o=function(t){switch(t){case"background":case"fill":return{visibility:"visible"};case"line":return{"line-cap":"butt","line-join":"miter","line-miter-limit":2,"line-round-limit":1.05,visibility:"visible"};case"symbol":return{"symbol-placement":"point","symbol-spacing":250,"symbol-avoid-edges":!1,"icon-allow-overlap":!1,"icon-ignore-placement":!1,"icon-optional":!1,"icon-rotation-alignment":"auto","icon-size":1,"icon-text-fit":"none","icon-text-fit-padding":[0,0,0,0],"icon-image":null,"icon-rotate":0,"icon-padding":2,"icon-keep-upright":!1,"icon-offset":[0,0],"icon-anchor":"center","icon-pitch-alignment":"auto","text-pitch-alignment":"auto","text-rotation-alignment":"auto","text-field":"","text-font":["Open Sans Regular","Arial Unicode MS Regular"],"text-size":16,"text-max-width":10,"text-line-height":1.2,"text-letter-spacing":0,"text-justify":"center","text-anchor":"center","text-max-angle":45,"text-rotate":0,"text-padding":2,"text-keep-upright":!0,"text-transform":"none","text-offset":[0,0],"text-allow-overlap":!1,"text-ignore-placement":!1,"text-optional":!1,visibility:"visible"};default:throw new Error('_getLayoutTemplate: "'+t+'" is not implemented yet!')}},s=function(t){switch(t){case"background":return{"background-color":"#000000","background-pattern":null,"background-opacity":1};case"fill":return{"fill-antialias":!0,"fill-opacity":1,"fill-color":"#000000","fill-outline-color":null,"fill-translate":[0,0],"fill-translate-anchor":"map","fill-pattern":null};case"line":return{"line-opacity":1,"line-color":"#000000","line-translate":[0,0],"line-translate-anchor":"map","line-width":1,"line-gap-width":0,"line-offset":0,"line-blur":0,"line-dasharray":null,"line-pattern":null};case"symbol":return{"icon-opacity":1,"icon-color":"#000000","icon-halo-color":"rgba(0, 0, 0, 0)","icon-halo-width":0,"icon-halo-blur":0,"icon-translate":[0,0],"icon-translate-anchor":"map","text-opacity":1,"text-color":"#000000","text-halo-color":"rgba(0, 0, 0, 0)","text-halo-width":0,"text-halo-blur":0,"text-translate":[0,0],"text-translate-anchor":"map"};default:throw new Error('_getPaintTemplate: "'+t+'" is not implemented yet!')}},function(){return["background-color","background-opacity","fill-opacity","fill-color","fill-outline-color","fill-translate","line-miter-limit","line-round-limit","line-opacity","line-color","line-translate","line-width","line-gap-width","line-offset","line-blur","symbol-spacing","icon-size","icon-tex-fit-padding","icon-rotate","icon-padding","icon-offset","text-size","text-max-width","text-line-height","text-letter-spacing","text-max-angle","text-rotate","text-padding","text-offset","icon-opacity","icon-color","icon-halo-color","icon-halo-width","icon-halo-blur","icon-translate","text-opacity","text-color","text-halo-color","text-halo-width","text-halo-blur","text-translate"]},function(){return{"background-color":"c","background-opacity":1,"fill-opacity":1,"fill-color":"c","fill-outline-color":"c","fill-translate":[],"line-miter-limit":1,"line-round-limit":1,"line-opacity":1,"line-color":"c","line-translate":[],"line-width":1,"line-gap-width":1,"line-offset":1,"line-blur":1,"symbol-spacing":1,"icon-size":1,"icon-text-fit-padding":[],"icon-rotate":1,"icon-padding":1,"icon-offset":[],"text-size":1,"text-max-width":1,"text-line-height":1,"text-letter-spacing":1,"text-max-angle":1,"text-rotate":1,"text-padding":1,"text-offset":[],"icon-opacity":1,"icon-color":"c","icon-halo-color":"c","icon-halo-width":1,"icon-halo-blur":1,"icon-translate":[],"text-opacity":1,"text-color":"c","text-halo-color":"c","text-halo-width":1,"text-halo-blur":1,"text-translate":[]}},e=function(t){var e,r;switch(t.type){case"background":return e=t.rpaint["background-color"],r=t.rpaint["background-opacity"],w.addColorAlphaChannel(e,r);case"fill":return e=t.rpaint["fill-color"],r=t.rpaint["fill-opacity"],w.addColorAlphaChannel(e,r);case"line":return e=t.rpaint["line-color"],r=t.rpaint["line-opacity"],w.addColorAlphaChannel(e,r);case"symbol":return e=t.rpaint["text-color"],r=t.rpaint["text-opacity"],w.addColorAlphaChannel(e,r);default:throw new Error('_getColor: the type "'+t.type+'" is illegal!')}},c=function(t,e){var r,n,i,a=e;if(l.isString(e)){if(r=e.match(/{(.*?)}/g)){for(i=0;i<r.length;i++)n=r[i].replace(/{|}/g,""),a=a.replace(r[i],t[n]?t[n]:"");return a}return e}return e},u=function(t,e,r,n){var i,a=r.x-e.x,o=n-e.x;return n<=e.x?e.y:n>=r.x?r.y:1===t?(i=o/a,e.y+(r.y-e.y)*i):(i=(Math.pow(t,o)-1)/(Math.pow(t,a)-1),e.y*(1-i)+r.y*i)},h=function(t,e,r,n){var i,a=[];for(i=0;i<e.y.length;i++)a.push(u(t,{x:e.x,y:e[i]},{x:r.x,y:r[i]},n));return a},d=function(t,e,r,n){var i,a,o,s=w.getHSL(e.y),l=w.getHSL(r.y);return i=u(t,{x:e.x,y:s[0]},{x:r.x,y:l[0]},n),a=u(t,{x:e.x,y:s[1]},{x:r.x,y:l[1]},n),o=u(t,{x:e.x,y:s[2]},{x:r.x,y:l[2]},n),"hsl("+Math.round(i)+", "+Math.round(a)+"%, "+Math.round(o)+"%)"},f=function(t,e){var r,n,i,a;if(!l.isArray(t))throw new Error("_findInterval: first argument must be an array!");for(n=!0,a=0;a<t.length;a++){if(e===t[a][0]){i=a;break}if(e<t[a][0])break}return r=i||0===i?t[i][1]:0===a?t[0][1]:a===t.length?t[a-1][1]:(n=!1,t.slice(a-1,a+1)),{match:n,val:r}},p=function(t,e,r){var n,i,a=["background-color","background-opacity","fill-opacity","fill-color","fill-outline-color","fill-translate","line-miter-limit","line-round-limit","line-opacity","line-color","line-translate","line-width","line-gap-width","line-offset","line-blur","symbol-spacing","icon-size","icon-tex-fit-padding","icon-rotate","icon-padding","icon-offset","text-size","text-max-width","text-line-height","text-letter-spacing","text-max-angle","text-rotate","text-padding","text-offset","icon-opacity","icon-color","icon-halo-color","icon-halo-width","icon-halo-blur","icon-translate","text-opacity","text-color","text-halo-color","text-halo-width","text-halo-blur","text-translate"],o={"background-color":"c","background-opacity":1,"fill-opacity":1,"fill-color":"c","fill-outline-color":"c","fill-translate":[],"line-miter-limit":1,"line-round-limit":1,"line-opacity":1,"line-color":"c","line-translate":[],"line-width":1,"line-gap-width":1,"line-offset":1,"line-blur":1,"symbol-spacing":1,"icon-size":1,"icon-text-fit-padding":[],"icon-rotate":1,"icon-padding":1,"icon-offset":[],"text-size":1,"text-max-width":1,"text-line-height":1,"text-letter-spacing":1,"text-max-angle":1,"text-rotate":1,"text-padding":1,"text-offset":[],"icon-opacity":1,"icon-color":"c","icon-halo-color":"c","icon-halo-width":1,"icon-halo-blur":1,"icon-translate":[],"text-opacity":1,"text-color":"c","text-halo-color":"c","text-halo-width":1,"text-halo-blur":1,"text-translate":[]}[t],s=e.base||1;if((n=f(e.stops,r)).match)return n.val;if(-1===a.indexOf(t))return n.val[0][1];if(l.isNumber(o))i=u(s,{x:n.val[0][0],y:n.val[0][1]},{x:n.val[1][0],y:n.val[1][1]},r);else if(l.isString(o)&&"c"===o)i=d(s,{x:n.val[0][0],y:n.val[0][1]},{x:n.val[1][0],y:n.val[1][1]},r);else{if(!l.isArray(o))throw new Error('_computePropertyValue: the type "'+o+'" is unknown!');i=h(s,{x:n.val[0][0],y:n.val[0][1]},{x:n.val[1][0],y:n.val[1][1]},r)}return i},n=function(t,e,r){var n,i=o(e.type),a=Object.keys(i);for(n=0;n<a.length;n++)e.layout[a[n]]&&!l.isLiteralObject(e.layout[a[n]])?i[a[n]]=e.layout[a[n]]:(l.hasProperty(e.layout[a[n]],"base")||l.hasProperty(e.layout[a[n]],"stops"))&&(i[a[n]]=p(a[n],e.layout[a[n]],r)),i[a[n]]=c(t,i[a[n]]);return i},i=function(t,e,r){var n,i=s(e.type),a=Object.keys(i);for(n=0;n<a.length;n++)e.paint[a[n]]&&!l.isLiteralObject(e.paint[a[n]])?i[a[n]]=e.paint[a[n]]:(l.hasProperty(e.paint[a[n]],"base")||l.hasProperty(e.paint[a[n]],"stops"))&&(i[a[n]]=p(a[n],e.paint[a[n]],r)),i[a[n]]=c(t,i[a[n]]);return i},m=function(t,e,r){switch(e.type){case"background":case"fill":case"line":case"symbol":e.rlayout=n(t,e,r),e.rpaint=i(t,e,r);break;case"raster":case"circle":case"fill-extrusion":case"heatmap":case"hillshade":throw new Error('_computeLayout: the type "'+e.type+'" is not processed yet!')}},y=function(t,e,r){var n,i=!1,a=t[0],o="$type"===t[1]?e:r[t[1]];if("$type"===t[1]&&"=="!==a&&"!="!==a&&"in"!==a&&"!in"!==a)return!1;switch(a){case"has":i=o;break;case"!has":i=void 0===o;break;case"==":i=o===t[2];break;case"!=":i=o!==t[2];break;case">":i=o>t[2];break;case">=":i=o>=t[2];break;case"<":i=o<t[2];break;case"<=":i=o<=t[2];break;case"in":for(n=2;n<t.length;n++)if(o===t[n]){i=!0;break}break;case"!in":for(i=!0,n=2;n<t.length;n++)if(o===t[n]){i=!1;break}}return i},g=function(t,e,r,n){var i,a,o;if("all"===e)return!0;if("all"!==e[0])return a=y(e,r,n);if([],0===(i=e.slice(1)).length)return!0;for(o=0;o<i.length&&(a=g(t,i[o],r,n));o++);return a},x=function(t,e,r,n){var i,a,o,s=t.filter;if(t.maxzoom||(t.maxzoom=22),t.minzoom||(t.minzoom=0),n<t.minzoom||n>=t.maxzoom)return!1;if(!s||!l.isArray(s))return!0;for(l.isString(s[0])&&"all"!==s[0]?(i=[]).push(s):i=s,o=0;o<i.length&&(a=g(t,i[o],e,r));o++);return a},b=function(t,e,r,n,i,a){var o,s=[],l=e[r];for(o=0;o<l.length;o++)x(t.layers[l[o]],n,i,a)&&(m(i,t.layers[l[o]],a),s.push(l[o]));return s},r=function(t,e){var r;for(r=0;r<t.length;r++)if("background"===t[r].id)return t[r].rlayout=n({},t[r],e),t[r].rpaint=i({},t[r],e),t[r];return null},a=function(t,e){var r,n,i={},a=[];for(r=0;r<t.length;r++)for(i[t[r].name]=[],a.push(t[r].name),n=0;n<e.layers.length;n++)e.layers[n]["source-layer"]===t[r].name&&i[t[r].name].push(n);return{iLayers:i,lRank:a}},v=function(t){var e,r,n,i,a;for(i=0;i<t.length;i++)if(t[i].ref){for(n=!1,a=0;a<t.length;a++)if(t[i].ref===t[a].id){e=t[i],(r=t[a]).type&&(e.type=r.type),r.source&&(e.source=r.source),r["source-layer"]&&(e["source-layer"]=r["source-layer"]),r.minzoom&&(e.minzoom=r.minzoom),r.maxzoom&&(e.maxzoom=r.maxzoom),r.filter&&(e.filter=r.filter),r.layout&&(e.layout=r.layout),n=!0;break}if(!n)throw new Error('_extendStyle: the ref "'+t[i].ref+'" was not found!')}},{extendStyle:function(t){v(t.layers)},index:function(t,e){return a(t,e)},getBackgroundStyle:function(t,e){return r(t.layers,e)},extract:function(t,e,r,n,i,a){return b(t,e,r,n,i,a)},getColor:function(t){return e(t)}}}l.extend(t,{getSource:function(){return k.getSource()+e.toString()},create:function(){return e(k.create())}})}(),ut=a.MapGL.Vector.Worker.Tile.Processor,l.extend(ut,{createBlobURL:function(t){var e=function(){var o,r,n=XMLHTTPLibrary(),e=PBFTileLibrary(),c=StylerLibrary(),s=GeoLibrary(),l=RWebGLLibrary();o=function(t,e,r,n,i){var a,o,s=c.index(t.layers,n).iLayers,l=[];switch(e.type){case"POLYGON":a=c.extract(n,s,r,"Polygon",e.properties,i);break;case"LINESTRING":a=c.extract(n,s,r,"LineString",e.properties,i);break;case"POINT":a=c.extract(n,s,r,"Point",e.properties,i)}for(o=0;o<a.length;o++)l[o]=n.layers[a[o]];return l},r=function(t,e){var r,n,i,a;for(i=0;i<t.layers.length;i++)for(n=t.layers[i],a=0;a<n.features.length;a++)switch((r=n.features[a]).properties=s.getProperties(r,n.keys,n.values),r.styles=o(t,r,n.name,e,t.zoom),r.type){case"POLYGON":l.processPolygon(r);break;case"LINESTRING":case"POINT":break;default:throw new Error('worker.process: the type "'+r.type+'" is unsupported!')}return t},self.load=function(t,e,r){n.load(t,e,function(t){r&&r(t)})},self.decode=function(t){return e.decode(t)},self.process=function(t,e){r(t,e)},self.addEventListener("message",function(r){switch(r.data.method){case"setStyle":self.style=r.data.payload;break;case"getTile":self.load(r.data.payload.url,"bin",function(t){var e={id:r.data.payload.id,url:r.data.payload.url,x:r.data.payload.x,y:r.data.payload.y,width:r.data.payload.width,height:r.data.payload.height,zoom:r.data.payload.zoom,layers:self.decode(t)};self.postMessage({wid:r.data.wid,tile:e})});break;case"process":self.load(r.data.payload.url,"bin",function(t){var e={id:r.data.payload.id,url:r.data.payload.url,x:r.data.payload.x,y:r.data.payload.y,width:r.data.payload.width,height:r.data.payload.height,zoom:r.data.payload.zoom,layers:self.decode(t)};self.process(e,self.style),self.postMessage({wid:r.data.wid,tile:e})})}})}.toString(),r=new Blob([t,"(",e,")()"],{type:"application/javascript"});this.blobURL=URL.createObjectURL(r)},create:function(){return this.blobURL||this.createBlobURL(),new Worker(this.blobURL)},destroy:function(){URL.revokeObjectURL(this.blobURL),this.blobURL=void 0}}),bt=a.MapGL.Vector.Renderer,vt=a.MapGL.Vector.DrawerWebGL,wt=a.MapGL.Vector.Worker.Tile.Processor,kt=a.Util.XMLLoaderSource,Mt=a.PBF.TileSource,St=a.MapGL.Vector.Source.Styler,Lt=a.MapGL.Vector.Source.Geo,zt=a.MapGL.Vector.Source.Earcut,Pt=a.MapGL.Vector.Source.RWebGL,Ot=a.Tiler2.Public,ht=function(t){var e,r,n=t[0].parentNode,i=document.createElement("canvas");n.insertBefore(i,n.childNodes[0]),n.style.position="relative",r=(e=n.firstElementChild).nextElementSibling,e.style.position="absolute",e.style.top=0,e.style.left=0,r.style.position="absolute",r.style.top=0,r.style.left=0},dt=function(t){var e,r=t.workers.processors;for(e=0;e<r.length;e++)r[e].w.postMessage({wid:e,method:"setStyle",payload:t.style})},ft=function(t){var e,r;for(e=kt.getSource()+"\n"+Mt.getSource()+"\n"+St.getSource()+"\n"+Lt.getSource()+"\n"+zt.getSource()+"\n"+Pt.getSource(),t.workers.processors=[],wt.createBlobURL(e),r=0;r<6;r++)t.workers.processors.push({id:r,free:!0,w:wt.create()})},pt=function(t,e,r){var n,i,a=t.workers.processors,o=t.map.zoom,s=!1;for(e.zoom=o,i=0;i<a.length;i++)if((n=a[i]).free){n.free=!1,n.w.onmessage=function(t){a[t.data.wid].free=!0,r(t.data.tile)},n.w.postMessage({wid:i,method:"process",payload:e}),s=!0;break}if(!s)throw new Error("_processTile: all the workers are busy!")},mt=function(t,e){t.ctx||vt.drawScene(t,e)},yt=function(e,r,n){var t,i,a=r.map,o=Ot.getTiles(a),s=!1;for(r.scene=[],i=0;i<o.length;i++)(t=r.tiles.get(o[i].id))?(t.x=o[i].x,t.y=o[i].y,t.width=o[i].width,t.height=o[i].height,t.zoom=a.zoom,r.tiles.set(t.id,t),r.scene.push(t.id)):(s=!0,pt(r,o[i],function(t){r.tiles.set(t.id,t),r.scene.push(t.id),mt(e,r),r.scene.length===o.length&&n&&n()}));s||(mt(e,r),n&&n())},gt=function(e,r,t){var n,i,a=r.map;n={id:(i=/(\/\d+.*\d\.)/.exec(t)[0].match(/\d+/g).map(Number))[0]+"."+i[1]+"."+i[2],url:t,x:-512,y:512,width:a.tile.width,height:a.tile.height,zoom:a.zoom},pt(r,n,function(t){r.tiles.set(t.id,t),r.scene=[],r.scene.push(t.id),mt(e,r)})},xt=function(t,e,r,n,i){e.map.zoom=i,yt(t,e)},l.extend(bt,{addCanvas:function(t){ht(t)},init:function(t,e){dt(e)},createWorkers:function(t){ft(t)},draw:function(t,e,r){yt(t,e,r)},drawOneTile:function(t,e,r){gt(t,e,r)},update:function(t,e,r,n,i){xt(t,e,0,0,i)}}),Ct=a.MapGL.Vector.RenderLineString,Rt=a.MapGL.Vector.RenderWebGL,Et=function(t,e){var r,n=t.styles;for(r=0;r<n.length;r++)switch(n[r].type){case"line":e&&Rt.updatePolyline(t,n,r);break;case"symbol":break;default:throw new Error('_updateLineString: the type "'+n[r].type+'" is unknown!')}},At=function(t,e){var r,n=t.styles;for(t.polygons=[],r=0;r<n.length;r++)switch(n[r].type){case"line":e&&Rt.processPolyline(t,n[r]);break;case"symbol":break;default:throw new Error('_processLineString: the type "'+n[r].type+'" is unknown!')}},l.extend(Ct,{processLineString:function(t,e){At(t,e)},updateLineString:function(t,e){Et(t,e)}}),Nt=a.MapGL.Vector.RenderPoint,Ft=a.MapGL.Vector.RenderWebGLText,Bt=a.MapGL.Vector.Geo,Ut=a.MapGL.Vector.Styler,jt=a.Images.Sprite,_t=function(t,e,r,n,i){var a=e.rlayout["text-offset"],o=n||[0,0],s=e.rlayout["text-padding"];switch(t.text.align=e.rlayout["text-justify"],"uppercase"===e.rlayout["text-transform"]?t.text.value=e.rlayout["text-field"].toUpperCase():"lowercase"===e.rlayout["text-transform"]?t.text.value=e.rlayout["text-field"].toLowerCase():t.text.value=e.rlayout["text-field"],t.text.font.family=e.rlayout["text-font"],t.text.font.size=e.rlayout["text-size"],t.text.color=Ut.getColor(e),e.rlayout["text-anchor"]){case"center":t.text.align="center",t.text.baseline="middle",t.text.x=t.x,t.text.y=t.y;break;case"left":t.text.align="left",t.text.baseline="middle",t.text.x=t.x+o[0]+a[0]+s,t.text.y=t.y+a[1]+s;break;case"right":t.text.align="right",t.text.baseline="middle",t.text.x=t.x-o[0]+a[0]+s,t.text.y=t.y+a[1]+s;break;case"top":t.text.baseline="top",t.text.x=t.x,t.text.y=t.y+o[1]+a[1]+s;break;case"bottom":t.text.baseline="bottom",t.text.x=t.x+a[0]+s,t.text.y=t.y-o[1]+a[1]+s;break;case"top-left":t.text.align="left",t.text.baseline="top",t.text.x=t.x+o[0]+a[0]+s,t.text.y=t.y-o[1]+a[1]+s;break;case"top-right":t.text.align="right",t.text.baseline="top",t.text.x=t.x-o[0]+a[0]+s,t.text.y=t.y+o[1]+a[1]+s;break;case"bottom-left":t.text.align="left",t.text.baseline="bottom",t.text.x=t.x+o[0]+a[0]+s,t.text.y=t.y-o[1]+a[1]+s;break;case"bottom-right":t.text.align="right",t.text.baseline="bottom",t.text.x=t.x-o[0]+a[0]+s,t.text.y=t.y-o[1]+a[1]+s;break;default:throw new Error('_drawText: the text-anchor "'+e.rlayout["text-anchor"]+'" is illegal!')}i&&(t.text.glyph=Ft.processText(r,t.text))},Tt=function(t,e,r,n){var i,a,o=r.style[e.rlayout["icon-image"]],s=e.rlayout["icon-anchor"],l=[];if(!o)return null;switch(s){case"center":i=t.x-o.width*o.pixelRatio/2,a=t.y-o.height*o.pixelRatio/2,l[0]=o.width*o.pixelRatio/2+e.rlayout["icon-padding"],l[1]=o.height*o.pixelRatio/2+e.rlayout["icon-padding"]}return t.icon.dheight=(t.icon.dwidth=(t.icon.dy=(t.icon.dx=(t.icon.sheight=(t.icon.swidth=(t.icon.sy=n?(t.icon.image=jt.getIcon(r.image.atlas,o),t.icon.sx=0):(t.icon.image=r.image,t.icon.sx=o.x,o.y),o.width),o.height),i),a),o.width/o.pixelRatio),o.height/o.pixelRatio),l},It=function(t,e,r,n,i,a){var o,s=1+i%1;t.x=t.coord[0][0]*s,t.y=t.coord[0][1]*s,e.rlayout["icon-image"]&&(o=Tt(t,e,n,a)),e.rlayout["text-field"]&&_t(t,e,r,o,a)},Gt=function(t,e,r,n,i){var a,o=Bt.fromGeom2Coord(t.geometry).coord[0];for(t.symbol=[],a=0;a<t.styles.length;a++)t.symbol[a]={tileSize:null,coord:null,x:null,y:null,icon:{image:null,sx:null,sy:null,swidth:null,sheight:null,dx:null,dy:null,dwidth:null,dheight:null},text:{value:"",baseline:null,align:null,color:null,x:null,y:null,font:{family:null,size:null}}},t.symbol[a].tileSize=4096*(1+n%1),t.symbol[a].coord=o,It(t.symbol[a],t.styles[a],e,r,n,i)},l.extend(Nt,{processPointSymbol:function(t,e,r,n,i){Gt(t,e,r,n,i)},updatePointSymbol:function(t,e,r,n,i){var a;for(a=0;a<t.styles.length;a++)It(t.symbol[a],t.styles[a],e,r,n,i)}}),Xt=a.MapGL.Vector.RenderWebGLText,qt=a.Images.GlyphAtlas,Vt=function(t){var e,r;for(t.index=[],r=0;r<t.glyphs.length;r++)e=t.glyphs[r].id,t.index[r]=e},Zt=function(t,e,r,n,i,a){var o,s;switch(e){case"left":o=0;break;case"right":o=-(t+i)*n;break;case"center":o=-(t+i/2)*n/2;break;case"start":o=0;break;case"end":o=-(t+i)*n;break;default:o=0}switch(r){case"top":s=.75*a*n;break;case"hanging":s=.5*a*n;break;case"middle":s=.25*a*n;break;case"alphabetic":case"ideographic":s=0;break;case"bottom":s=-.25*a*n;break;default:s=0}return{x:o,y:s}},Dt=function(t,e){var r,n,i,a,o,s,l,c,u,h,d,f,p,m=qt.create(),y=e.align,g=e.baseline,x=e.font.size/24,b=-3,v=[],w=[];for((r=t[e.font.family[0]]?t[e.font.family[0]]["0-255"]:(t.missing||(t.missing=[]),-1===t.missing.indexOf(e.font.family[0])&&t.missing.push(e.font.family[0]),t.default["0-255"])).index||Vt(r),m.set(24*e.value.length,24),d=0;d<e.value.length;d++)i=e.value.slice(d,d+1),f=r.index.indexOf(i.charCodeAt(0)),n=r.glyphs[f]?r.glyphs[f]:r.glyphs["?".charCodeAt(0)],m.add(n.bitmap,d),a=24*d,o=n.bitmap.width,s=n.bitmap.height,l=b+n.metrics.left,c=1.5-(24+n.metrics.top+6),u=n.bitmap.width,h=n.bitmap.height,v.push(l,c,l+u,c,l,c+h,l+u,c,l,c+h,l+u,c+h),w.push(a,0,a+o,0,a,0+s,a+o,0,a,0+s,a+o,0+s),b+=n.metrics.advance;return p=Zt(b,y,g,x,3,24),{image:{width:m.width,height:m.height,data:m.data},vertex:v,texture:w,dx:p.x,dy:p.y}},l.extend(Xt,{processText:function(t,e){return Dt(t,e)}}),Wt=a.MapGL.Vector.DrawerWebGL,Ht=a.MapGL.Vector.Source.Styler,Yt=function(t,e){var r,n,i,a,o,s,l=Ht.create(),c=e.map.viewport,u=l.getBackgroundStyle(e.style,e.map.zoom),h=e.scene,d=1+e.map.zoom%1;for(t.empty().fillBackground(u?l.getColor(u):"white"),i=0;i<h.length;i++)for(r=e.tiles.get(h[i]),t.setTransform(r.x-c.x,-(r.y-c.y),d),a=0;a<r.layers.length;a++)for(o=0;o<r.layers[a].features.length;o++)switch((n=r.layers[a].features[o]).type){case"POLYGON":if(!n.styles)break;for(s=0;s<n.styles.length;s++)t.fillStyle(n.color[s]).fillPolygon(n.vertices);break;case"LINESTRING":case"POINT":break;default:throw new Error('_drawScene: the geometry "'+n.type+'" does not exist!')}},l.extend(Wt,{drawScene:function(t,e){Yt(t,e)}}),te=a.MapGL.Vector.Loader,ee=a.MapGL.Vector.Source.Styler,re=a.PBF.FontSource,ne=a.Images.Sprite,Qt=function(t,e,r){l.load(t,"bin",function(t){r(e,t)})},Kt=function(r,t){var e,n,i;if(r&&r.missing)for(e=l.clone(r.missing),i=0;i<e.length;i++)Qt(t+"/fonts/"+e[i]+"/0-255.pbf",e[i],function(t,e){r[t]={"0-255":re.create().decode(e)[0]},n=r.missing.indexOf(t),r.missing.splice(n,n+1)})},Jt=function(t,e,r){l.load(t,"bin",function(t){r&&r({tile:e,data:t})})},$t=function(e,r,t,n){r.icon={style:null,image:new Image},l.async.listenForAll(r.Q,"load",3,function(){n&&n()}),l.load(t,"json",function(t){r.style=JSON.parse(t),ee.create().extendStyle(r.style),l.load(r.style.sprite+"/sprite@2x.json","json",function(t){r.icon.style=JSON.parse(t),l.async.pushOne(r.Q,"load",null)}),l.load(r.style.sprite+"/sprite@2x.png","blob",function(t){r.icon.image.addEventListener("load",function(){ne.createAtlas(r.icon.image),l.async.pushOne(r.Q,"load",null)}),r.icon.image.src=t}),e.gl?l.load(r.style.sprite+"/fonts/DIN Offc Pro Medium/0-255.pbf","bin",function(t){r.fonts={},r.fonts.default={"0-255":re.create().decode(t)[0]},r.fonts["DIN Offc Pro Medium"]=r.fonts.default,l.async.pushOne(r.Q,"load",null)}):l.async.pushOne(r.Q,"load",null)})},l.extend(te,{loadFonts:function(t,e){Kt(t,e)},loadTile:function(t,e,r){Jt(t,e,r)},loadData:function(t,e,r,n){$t(t,e,r,n)}}),function(){var e,n,i,t=a.MapGL.Vector.Util,o=(a.MapGL.Vector.Styler,a.Tiler2.Public);a.PBF.Public;e=function(t){var e,r={url:null,token:null,ext:null,zoom:null,viewport:{coord:{"φ":null,"λ":null},x:null,y:null,px:null,py:null,width:null,height:null,origin:{coord:{"φ":null,"λ":null},x:null,y:null}},tile:{n:{x:null,y:null},x:null,y:null,width:null,height:null}};return r.url=o.decodeUrl(t.url,t.subdomains),r.token=l.isString(t.token)?t.token:"",r.ext=l.isString(t.ext)?t.ext:"pbf",r.zoom=l.isNumber(t.zoom)?t.zoom:0,r.viewport.coord.φ=t.coord&&l.isNumber(t.coord[0])?t.coord[0]:0,r.viewport.coord.λ=t.coord&&l.isNumber(t.coord[1])?t.coord[1]:0,r.viewport.width=t.bbox&&l.isNumber(t.bbox.width)?t.bbox.width:1e3,r.viewport.height=t.bbox&&l.isNumber(t.bbox.height)?t.bbox.height:1e3,r.tile.width=t.tile&&l.isNumber(t.tile.width)?t.tile.width:1024,r.tile.height=t.tile&&l.isNumber(t.tile.height)?t.tile.height:1024,r.viewport.origin.coord.φ=r.viewport.coord.φ,r.viewport.origin.coord.λ=r.viewport.coord.λ,e=o.getXYFromLatLong(r.viewport.coord.φ,r.viewport.coord.λ,r.zoom),r.viewport.x=e.x,r.viewport.y=e.y,r.viewport.origin.x=r.viewport.x,r.viewport.origin.y=r.viewport.y,r},n=function(t,e,r){var n=t.viewport,i=o.getXYFromLatLong(e,r,t.zoom);return{x:i.x-n.x+n.width/2,y:-(i.y-n.y-n.height/2)}},i=function(t,e,r){var n=t.viewport,i=e-n.width/2+n.x,a=-r+n.height/2+n.y;return o.getLatLongFromXY(i,a,t.zoom)},l.extend(t,{initSettings:function(t){return e(t)},getXYFromLatLong:function(t,e,r){return n(t,e,r)},getLatLongFromXY:function(t,e,r){return i(t,e,r)}})}(),l.extend(l,{readUint32:function(){},ieee754:{read:function(t,e,r,n,i){var a,o,s=8*i-n-1,l=(1<<s)-1,c=l>>1,u=-7,h=r?i-1:0,d=r?-1:1,f=t[e+h];for(h+=d,a=f&(1<<-u)-1,f>>=-u,u+=s;0<u;a=256*a+t[e+h],h+=d,u-=8);for(o=a&(1<<-u)-1,a>>=-u,u+=n;0<u;o=256*o+t[e+h],h+=d,u-=8);if(0===a)a=1-c;else{if(a===l)return o?NaN:1/0*(f?-1:1);o+=Math.pow(2,n),a-=c}return(f?-1:1)*o*Math.pow(2,a-n)}}}),ie=a.MATH.Matrix.M3,l.extend(ie,{orthographicX:function(t,e,r,n,i,a,o,s){return[r/i*2,0,0,0,n/a*-2,0,t/i*2+o,e/a*-2+s,1]},orthographic:function(t,e,r,n,i,a){return[2/(e-t),0,0,0,2/(r-n)*-1,0,i,a,1]},projection:function(t,e){return[2/t,0,0,0,-2/e,0,0,0,0]},identity:function(){return[1,0,0,0,1,0,0,0,1]},translation:function(t,e){return[1,0,0,0,1,0,t,e,1]},rotation:function(t){var e=Math.cos(t),r=Math.sin(t);return[e,-r,0,r,e,0,0,0,1]},scaling:function(t,e){return[t,0,0,0,e,0,0,0,1]},multiply:function(t,e){var r=t[0],n=t[1],i=t[2],a=t[3],o=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=e[0],d=e[1],f=e[2],p=e[3],m=e[4],y=e[5],g=e[6],x=e[7],b=e[8];return[h*r+d*a+f*l,h*n+d*o+f*c,h*i+d*s+f*u,p*r+m*a+y*l,p*n+m*o+y*c,p*i+m*s+y*u,g*r+x*a+b*l,g*n+x*o+b*c,g*i+x*s+b*u]},translate:function(t,e,r){return this.multiply(t,this.translation(e,r))},rotate:function(t,e){return this.multiply(t,this.rotation(e))},scale:function(t,e,r){return this.multiply(t,this.scaling(e,r))}}),ae=a.MATH.Matrix.M4,l.extend(ae,{orthographic:function(t,e,r,n,i,a,o){return(o=o||new Float32Array(16))[0]=2/(e-t),o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=2/(n-r),o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=2/(i-a),o[11]=0,o[12]=(t+e)/(t-e),o[13]=(r+n)/(r-n),o[14]=(i+a)/(i-a),o[15]=1,o},translate:function(t,e,r,n,i){var a=t[0],o=t[1],s=t[2],l=t[3],c=t[4],u=t[5],h=t[6],d=t[7],f=t[8],p=t[9],m=t[10],y=t[11],g=t[12],x=t[13],b=t[14],v=t[15];return t!==(i=i||new Float32Array(16))&&(i[0]=a,i[1]=o,i[2]=s,i[3]=l,i[4]=c,i[5]=u,i[6]=h,i[7]=d,i[8]=f,i[9]=p,i[10]=m,i[11]=y),i[12]=a*e+c*r+f*n+g,i[13]=o*e+u*r+p*n+x,i[14]=s*e+h*r+m*n+b,i[15]=l*e+d*r+y*n+v,i},scale:function(t,e,r,n,i){return(i=i||new Float32Array(16))[0]=e*t[0],i[1]=e*t[1],i[2]=e*t[2],i[3]=e*t[3],i[4]=r*t[4],i[5]=r*t[5],i[6]=r*t[6],i[7]=r*t[7],i[8]=n*t[8],i[9]=n*t[9],i[10]=n*t[10],i[11]=n*t[11],t!==i&&(i[12]=t[12],i[13]=t[13],i[14]=t[14],i[15]=t[15]),i},translation:function(t,e,r,n){return(n=n||new Float32Array(16))[0]=1,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=1,n[11]=0,n[12]=t,n[13]=e,n[14]=r,n[15]=1,n}}),function(){var t=a.PBF.TileSource,r=a.PBF.UtilSource;function e(t){var i,a,o,s,l,e,c=t||r();return i=function(t){for(var e,r=0,n=[];r=(e=c.readVarint(t,r)).pos,n.push(e.val),r<t.length;);return n},a=function(t){var e;switch(t){case 0:e="UNKNOWN";break;case 1:e="POINT";break;case 2:e="LINESTRING";break;case 3:e="POLYGON";break;default:throw new Error('_decodeFeatureType: the type "'+t+'" is unknown!')}return e},o=function(t){var e,r,n=0;r={id:null,tags:[],type:null,geometry:null};do{switch(n=(e=c.readVarint(t,n)).pos,e.tag){case 1:n=(e=c.readVarint(t,n)).pos,r.id=e.val;break;case 2:n=(e=c.readBuffer(t,n)).pos,r.tags=i(e.val);break;case 3:n=(e=c.readVarint(t,n)).pos,r.type=a(e.val);break;case 4:n=(e=c.readBuffer(t,n)).pos,r.geometry=i(e.val);break;default:throw new Error('_extractFeature: the tag "'+e.tag+'" is unknown!')}}while(n<t.length);return r},s=function(t){var e,r=0;switch(r=(e=c.readVarint(t,r)).pos,e.tag){case 1:return r=(e=c.readString(t,r)).pos,e.val;case 2:return c.ieee754.read(t,r,!0,23,4);case 3:return c.ieee754.read(t,r,!0,52,8);case 4:return r=(e=c.readVarint(t,r)).pos,e.val;case 5:case 6:case 7:throw new Error('_extractValue: the tag "'+e.tag+'" is not implemented yet!');default:throw new Error('_extractValue: the tag "'+e.tag+'" is unknown!')}},l=function(t){var e,r,n=0;r={version:1,name:null,features:[],keys:[],values:[],extend:4096};do{switch(n=(e=c.readVarint(t,n)).pos,e.tag){case 15:if(n=(e=c.readVarint(t,n)).pos,r.version=e.val,1===r.version)throw new Error("_readLayer: vector-tile spec v1 is not implemented!");break;case 1:n=(e=c.readString(t,n)).pos,r.name=e.val;break;case 2:n=(e=c.readBuffer(t,n)).pos,r.features.push(o(e.val));break;case 3:n=(e=c.readString(t,n)).pos,r.keys.push(e.val);break;case 4:n=(e=c.readBuffer(t,n)).pos,r.values.push(s(e.val));break;case 5:n=(e=c.readVarint(t,n)).pos,r.extend=e.val;break;default:throw new Error('_readLayer: the tag "'+e.tag+'" is unknown!')}}while(n<t.length);return r},e=function(t){var e,r=[],n=0;do{if(2!==(e=c.readVarint(t,n)).type||3!==e.tag)throw new Error("This is not a correct vector tile. type_wire = "+e.type+", tag = "+e.tag+"!");n=e.pos,n=(e=c.readBuffer(t,n)).pos,r.push(l(e.val))}while(n<t.length);return r},{decode:function(t){return e(t)}}}l.extend(t,{getSource:function(){return r.getSource()+"\n"+e.toString()},create:function(){return e(r.create())}})}(),function(){var t=a.PBF.FontSource,r=a.PBF.UtilSource;function e(t){var u,i,a,e,h=t||r();return u=function(t,e,r){var n,i=new Uint8Array(e*r*4);if(t){if(t.length!==e*r)throw new Error("_image: mismatched image size!")}else t=new Uint8Array(e*r);for(n=0;n<e*r;n++)i[4*n+0]=t[n],i[4*n+1]=t[n],i[4*n+2]=t[n],i[4*n+3]=255;return{width:e,height:r,data:i}},i=function(t){var e,r=0,n=null,i=null,a=0,o=0,s=0,l=0,c=0;do{switch(r=(e=h.readVarint(t,r)).pos,e.tag){case 1:r=(e=h.readVarint(t,r)).pos,n=e.val;break;case 2:r=(e=h.readBytes(t,r)).pos,i=e.val;break;case 3:r=(e=h.readVarint(t,r)).pos,a=e.val;break;case 4:r=(e=h.readVarint(t,r)).pos,o=e.val;break;case 5:r=(e=h.readSVarint(t,r)).pos,s=e.val;break;case 6:r=(e=h.readSVarint(t,r)).pos,l=e.val;break;case 7:r=(e=h.readVarint(t,r)).pos,c=e.val;break;default:throw new Error('_extractGlyph: the type "'+e.tag+'" is not supported!')}}while(r<t.length);return{id:n,bitmap:u(i,a+6,o+6),metrics:{top:l,left:s,width:a,height:o,advance:c}}},a=function(t){var e,r,n=0;r={name:null,range:null,glyphs:[]};do{switch(n=(e=h.readVarint(t,n)).pos,e.tag){case 1:n=(e=h.readString(t,n)).pos,r.name=e.val;break;case 2:n=(e=h.readString(t,n)).pos,r.range=e.val;break;case 3:n=(e=h.readBuffer(t,n)).pos,r.glyphs.push(i(e.val));break;default:throw new Error('_readFontStack: the type "'+e.tag+'" is not supported!')}}while(n<t.length);return r},e=function(t){var e,r=[],n=0;do{if(2!==(e=h.readVarint(t,n)).type||1!==e.tag)throw new Error("This is not a correct glyphs font. glyphs = "+e.type+", tag = "+e.tag+"!");n=e.pos,n=(e=h.readBuffer(t,n)).pos,r.push(a(e.val))}while(n<t.length);return r},{decode:function(t){return e(t)}}}l.extend(t,{getSource:function(){return r.getSource()+"\n"+e.toString()},create:function(){return e(r.create())}})}(),function(){var t=a.PBF.UtilSource;function e(){var i,t,c,e,r;return t=function(t,e){var r=i(t,e),n=r.val;return r.val=n%2==1?(n+1)/-2:n/2,r},c=function(t,e){var r=i(t,e);return{val:t.slice(r.pos,r.pos+r.val),pos:r.pos+r.val}},e=function(t,e){return c(t,e)},r=function(t,e){for(var r,n,i,a=c(t,e),o=a.val,s="",l=0;l<o.length;)if((r=o[l])<128)s+=String.fromCharCode(r),l+=1;else if(191<r&&r<224){if(l+1>=o.length)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");n=t[l+1],s+=String.fromCharCode((31&r)<<6|63&n),l+=2}else{if(l+2>=o.length)throw new Error("UTF-8 Decode failed. Two byte character was truncated.");n=t[l+1],i=t[l+2],s+=String.fromCharCode((15&r)<<12|(63&n)<<6|63&i),l+=3}return{val:s,pos:a.pos}},{ieee754:{read:function(t,e,r,n,i){var a,o,s=8*i-n-1,l=(1<<s)-1,c=l>>1,u=-7,h=r?i-1:0,d=r?-1:1,f=t[e+h];for(h+=d,a=f&(1<<-u)-1,f>>=-u,u+=s;0<u;a=256*a+t[e+h],h+=d,u-=8);for(o=a&(1<<-u)-1,a>>=-u,u+=n;0<u;o=256*o+t[e+h],h+=d,u-=8);if(0===a)a=1-c;else{if(a===l)return o?NaN:1/0*(f?-1:1);o+=Math.pow(2,n),a-=c}return(f?-1:1)*o*Math.pow(2,a-n)}},readVarint:i=function(t,e){var r,n,i=e;return n=127&(r=t[i++]),r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(127&(r=t[i++]))<<7,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(127&(r=t[i++]))<<14,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(127&(r=t[i++]))<<21,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(15&(r=t[i++]))<<28,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(15&(r=t[i++]))<<35,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(15&(r=t[i++]))<<42,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(15&(r=t[i++]))<<49,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:(n|=(15&(r=t[i++]))<<56,r<128?{val:n,pos:i,type:7&n,tag:n>>3}:{val:n|=(15&(r=t[i++]))<<73,pos:i,type:7&n,tag:n>>3}))))))))},readSVarint:t,readBuffer:c,readBytes:e,readString:r}}l.extend(t,{getSource:function(){return e.toString()},create:function(){return e()}})}(),se=a.Rasterizer["2D"].Public,l.extend(se,{create:function(t,e,r,n){var i,a="number"==typeof e?e:1024,o="number"==typeof e?r:1024,s=n;return(i=Object.create(oe))[0]=null,i.ctx=null,i.scale=null,i.pixelRatio=null,i[0]=t[0].parentNode.firstElementChild,i.ctx=i[0].getContext("2d"),s||(s=(window.devicePixelRatio||1)/(i.ctx.webkitBackingStorePixelRatio||i.ctx.mozBackingStorePixelRatio||i.ctx.msBackingStorePixelRatio||i.ctx.oBackingStorePixelRatio||i.ctx.backingStorePixelRatio||1)),i[0].width=a*s,i[0].height=o*s,i[0].style.width=a+"px",i[0].style.height=o+"px",i.ctx.setTransform(s,0,0,s,0,0),i.pixelRatio=s,i.scale=.25,i}}),oe={attr:function(t,e){return 2!==arguments.length||"string"!=typeof t&&"number"!=typeof t||"string"!=typeof e&&"number"!=typeof e||this[0]&&this[0].setAttribute(t,e),this},empty:function(){return this.ctx.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0),this.ctx.clearRect(0,0,this[0].width,this[0].height),this},fillBackground:function(t){return this.ctx.fillStyle=t,this.ctx.fillRect(0,0,this[0].width,this[0].height),this},fillStyle:function(t){return this.ctx.fillStyle=t,this},strokeStyle:function(t){return this.ctx.strokeStyle=t,this},shadowColor:function(t){return this.ctx.shadowColor=t,this},shadowBlur:function(t){return this.ctx.shadowBlur=t,this},lineCap:function(t){return t?(this.ctx.lineCap=t,this):this.ctx.lineCap},lineJoin:function(t){return t?(this.ctx.lineJoin=t,this):this.ctx.lineJoin},lineWidth:function(t){return t?(this.ctx.lineWidth=t*this.pixelRatio,this):this.ctx.lineWidth},miterLimit:function(t){return t?(this.ctx.miterLimit=t*this.scale,this):this.ctx.miterLimit},rect:function(t,e,r,n){return this.ctx.rect(t*this.scale,e*this.scale,r*this.scale,n*this.scale),this},fillRect:function(t,e,r,n){return this.ctx.fillRect(t*this.scale,e*this.scale,r*this.scale,n*this.scale),this},strokeRect:function(t,e,r,n){return this.ctx.strokeRect(t*this.scale,e*this.scale,r*this.scale,n*this.scale),this},clearRect:function(t,e,r,n){return this.ctx.clearRect(t,e,r,n),this},fill:function(){return this.ctx.fill(),this},stroke:function(){return this.ctx.stroke(),this},beginPath:function(){return this.ctx.beginPath(),this},moveTo:function(t,e){return this.ctx.moveTo(t*this.scale,e*this.scale),this},closePath:function(){return this.ctx.closePath(),this},lineTo:function(t,e){return this.ctx.lineTo(t*this.scale,e*this.scale),this},scale:function(t,e){return this.ctx.scale(t,e),this},rotate:function(t){return this.ctx.rotate(t),this},translate:function(t,e){return this.ctx.translate(t*this.scale,e*this.scale),this},transform:function(t,e,r,n,i,a){return this.ctx.transform(t*this.pixelRatio,e,r,n*this.pixelRatio,i*this.pixelRatio,a*this.pixelRatio),this},setTransform:function(t,e,r,n,i,a){return this.ctx.setTransform(t*this.pixelRatio,e,r,n*this.pixelRatio,i*this.pixelRatio,a*this.pixelRatio),this},font:function(t){return this.ctx.font=t,this},textAlign:function(t){return this.ctx.textAlign=t,this},textBaseline:function(t){return this.ctx.textBaseline=t,this},textWidth:function(t){return this.ctx.lineWidth=t,this},fillText:function(t,e,r,n){return this.ctx.fillText(t,e*this.scale,r*this.scale,n),this},strokeText:function(t,e,r,n){return this.ctx.strokeText(t,e*this.scale,r*this.scale,n),this},measureText:function(t){return this.ctx.measureText(t).width},drawImage:function(t,e,r,n,i,a,o,s,l){return this.ctx.drawImage(t,e,r,n,i,a*this.scale,o*this.scale,s,l),this},save:function(){return this.ctx.save(),this},restore:function(){return this.ctx.restore(),this}},ce=a.Rasterizer.GL.Public,ue=a.Rasterizer.GL.Shaders,he=a.Rasterizer.GL.Geometry,de=a.Rasterizer.GL.Image,fe=a.Rasterizer.GL.Glyph,a.Rasterizer.GL.Font,pe=a.Images.GlyphAtlas,me=a.MapGL.Vector.RenderWebGLText,l.extend(ce,{create:function(t,e,r){var n,i="number"==typeof e?e:1024,a="number"==typeof e?r:1024;if((n=Object.create(le))[0]=null,n[0]=t[0].parentNode.firstElementChild,n.gl=n[0].getContext("webgl"),!n.gl)throw new Error("Unable to initialize WebGL. Your browser or machine may not support it!");return n.pixelRatio=2,n.ratio=4,n[0].width=2*i,n[0].height=2*a,n[0].style.width=i+"px",n[0].style.height=a+"px",n}}),le={init:function(){var t=this.gl;return this.shader=ue.get(),this.shader.geometry=he.getShader(),this.shader.image=de.getShader(),this.shader.glyph=fe.getShader(),he.init(t,this.shader),de.init(t,this.shader),fe.init(t,this.shader),t.viewport(0,0,t.canvas.width,t.canvas.height),this.empty(),this.setTransform(0,0,1),this.atlas=pe.create(),this},empty:function(){var t=this.gl;return t.clearColor(.97,.97,.97,1),t.clear(t.COLOR_BUFFER_BIT),t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE),t.enable(t.BLEND),this},fillBackground:function(t){var e=l.color.toRGBA(t);return this.gl.clearColor(e[0]/255,e[1]/255,e[2]/255,e[3]),this.gl.clear(this.gl.COLOR_BUFFER_BIT),this},fillStyle:function(t){var e=l.color.toRGBA(t);return this.shader.color=[e[0]/255,e[1]/255,e[2]/255,e[3]],this},shift:function(t,e){var r=this.shader.transform;return r.translate.x=t,r.translate.y=e,this.shader.transform.modified=!0,this},zoom:function(t){var e=this.shader.transform;return e.scale.x=t/this.ratio,e.scale.y=t/this.ratio,this.shader.transform.modified=!0,this},setTransform:function(t,e,r){var n=this.shader.transform;return n.translate.x=t,n.translate.y=e,n.scale.x=r/this.ratio,n.scale.y=r/this.ratio,this.shader.transform.modified=!0,this},fillLines:function(t){return he.drawLines(this.gl,this.shader,t),this},fillStripLines:function(t){return he.drawStripLines(this.gl,this.shader,t),this},fillLoopLines:function(t){return he.drawLoopLines(this.gl,this.shader,t),this},fillTriangles:function(t){return he.drawTriangles(this.gl,this.shader,t),this},fillRect:function(t,e,r,n){var i=[t,e,t+r,e,t+r,e+n,t+r,e+n,t,e+n,t,e];return this.fillTriangles(i),this},fillPolygon:function(t){return he.drawPolygon(this.gl,this.shader,t),this},drawImage:function(t,e,r,n,i,a,o,s,l){return de.drawImage(this.gl,this.shader,this.ratio,t,e,r,n,i,a,o,s,l),this},font:function(t,e){return this.shader.glyph.font.family=t,this.shader.glyph.font.size=e,this},textAlign:function(t){return-1<["left","right","center","start","end"].indexOf(t)&&(this.shader.glyph.text.align=t),this},textBaseline:function(t){return-1<["top","hanging","middle","alphabetic","ideographic","bottom"].indexOf(t)&&(this.shader.glyph.text.baseline=t),this},textRotate:function(t){return this.shader.glyph.text.angle=t,this},haloColor:function(t){var e=l.color.toRGBA(t);return this.shader.glyph.halo.color=[e[0]/255,e[1]/255,e[2]/255,e[3]],this},haloWidth:function(t){return this.shader.glyph.halo.width=t,this},fillText:function(t,e){return me.processText(t,e)},drawGlyph:function(t,e,r,n,i,a,o){return fe.drawGlyph(this.gl,this.shader,this.ratio,t,e,r,n+a*this.ratio,i+o*this.ratio),this}},ye=a.Rasterizer.GL.Polyline,l.extend(ye,{}),be=a.Rasterizer.GL.Shaders,ge=function(t,e,r){var n=t.createShader(e);if(t.shaderSource(n,r),t.compileShader(n),!t.getShaderParameter(n,t.COMPILE_STATUS))throw new Error("could not compile shader:"+t.getShaderInfoLog(n));return n},xe=function(t,e,r){var n,i,a;if(n=ge(t,t.VERTEX_SHADER,e),i=ge(t,t.FRAGMENT_SHADER,r),a=t.createProgram(),t.attachShader(a,n),t.attachShader(a,i),t.linkProgram(a),!t.getProgramParameter(a,t.LINK_STATUS))throw new Error("could not link shaders:"+t.getProgramInfoLog(a));return a},l.extend(be,{get:function(){return{type:null,transform:{modified:!0,translate:{x:0,y:0},scale:{x:1,y:1},rotate:0},color:null,geometry:null,image:null,glyph:null}},createAndCompileShaderProgram:function(t,e,r){return xe(t,e,r)}}),Le=a.Rasterizer.GL.Geometry,ze=a.Rasterizer.GL.Shaders,a.Rasterizer.GL.Polyline,a.Rasterizer.GL.Earcut,Pe=a.MATH.Matrix.M3,ve=function(){return["attribute vec2 a_position;","","uniform mat3 u_matrix;","","void main() {","  // Multiply the position by the matrix.","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","}"].join("\n")},we=function(){return["precision mediump float;","","uniform vec4 u_color;","","void main() {","  gl_FragColor = u_color;","}"].join("\n")},ke=function(t,e){var r;return r=Pe.projection(t.canvas.clientWidth,t.canvas.clientHeight),r=Pe.translate(r,e.translate.x,e.translate.y),r=Pe.rotate(r,e.rotate),r=Pe.scale(r,e.scale.x,e.scale.y)},Me=function(t,e){var r=e.geometry,n=ve(),i=we();r.program=ze.createAndCompileShaderProgram(t,n,i),r.attribs.a_position=t.getAttribLocation(r.program,"a_position"),r.uniforms.u_color=t.getUniformLocation(r.program,"u_color"),r.uniforms.u_matrix=t.getUniformLocation(r.program,"u_matrix"),r.buffer=t.createBuffer(),r.matrix=ke(t,e.transform)},Se=function(t,e,r,n){e.transform.modified&&(e.geometry.matrix=ke(t,e.transform),e.transform.modified=!1),t.useProgram(e.geometry.program),t.bindBuffer(t.ARRAY_BUFFER,e.geometry.buffer),t.vertexAttribPointer(e.geometry.attribs.a_position,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.geometry.attribs.a_position),t.uniform4fv(e.geometry.uniforms.u_color,e.color),t.uniformMatrix3fv(e.geometry.uniforms.u_matrix,!1,e.geometry.matrix),t.bufferData(t.ARRAY_BUFFER,new Float32Array(n),t.STATIC_DRAW),t.drawArrays(r,0,n.length/2)},l.extend(Le,{getShader:function(){return{program:null,buffer:null,matrix:null,attribs:{a_position:null},uniforms:{u_color:null,u_matrix:null}}},init:function(t,e){Me(t,e)},drawLines:function(t,e,r){Se(t,e,t.LINES,r)},drawStripLines:function(t,e,r){Se(t,e,t.LINE_STRIP,r)},drawLoopLines:function(t,e,r){Se(t,e,t.LINE_LOOP,r)},drawTriangles:function(t,e,r){Se(t,e,t.TRIANGLES,r)},drawStripTriangles:function(t,e,r){Se(t,e,t.TRIANGLE_STRIP,r)},drawFanTriangles:function(t,e,r){Se(t,e,t.TRIANGLE_FAN,r)},drawPolygon:function(t,e,r){Se(t,e,t.TRIANGLES,r)}}),Re=a.Rasterizer.GL.Image,_e=a.Rasterizer.GL.Shaders,Te=a.MATH.Matrix.M3,Oe=function(){return["attribute vec2 a_position;","attribute vec2 a_texcoord;","","uniform mat3 u_matrix;","uniform mat3 u_textureMatrix;","","varying vec2 v_texcoord;","","void main() {","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","  v_texcoord = (u_textureMatrix * vec3(a_texcoord, 1)).xy;","}"].join("\n")},Ee=function(){return["precision mediump float;","","uniform sampler2D u_texture;","","varying vec2 v_texcoord;","","void main() {","  gl_FragColor = texture2D(u_texture, v_texcoord);","}"].join("\n")},Ae=function(t,e){var r,n,i,a=Oe(),o=Ee(),s=e.image.quad,l=e.image.texture;r=_e.createAndCompileShaderProgram(t,a,o),e.image.program=r,s.buffer=t.createBuffer(),s.attribs.a_position=t.getAttribLocation(r,"a_position"),s.uniforms.u_matrix=t.getUniformLocation(r,"u_matrix"),t.bindBuffer(t.ARRAY_BUFFER,s.buffer),n=[0,0,0,1,1,0,1,0,0,1,1,1],t.bufferData(t.ARRAY_BUFFER,new Float32Array(n),t.STATIC_DRAW),l.buffer=t.createBuffer(),l.tex=t.createTexture(),l.attribs.a_texcoord=t.getAttribLocation(r,"a_texcoord"),l.uniforms.u_textureMatrix=t.getUniformLocation(r,"u_textureMatrix"),l.uniforms.u_texture=t.getUniformLocation(r,"u_texture"),t.bindBuffer(t.ARRAY_BUFFER,l.buffer),i=[0,0,0,1,1,0,1,0,0,1,1,1],t.bufferData(t.ARRAY_BUFFER,new Float32Array(i),t.STATIC_DRAW)},Ce=function(t,e,r,n,i,a,o,s,l,c,u,h){var d,f,p=e.transform.translate;t.useProgram(e.image.program),t.bindBuffer(t.ARRAY_BUFFER,e.image.quad.buffer),t.vertexAttribPointer(e.image.quad.attribs.a_position,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.image.quad.attribs.a_position),d=Te.orthographic(0,t.canvas.clientWidth,t.canvas.clientHeight,0,0,0),d=Te.translate(d,p.x+l/r,p.y+c/r),d=Te.scale(d,u,h),t.uniformMatrix3fv(e.image.quad.uniforms.u_matrix,!1,d),t.bindBuffer(t.ARRAY_BUFFER,e.image.texture.buffer),t.vertexAttribPointer(e.image.texture.attribs.a_texcoord,2,t.FLOAT,!1,0,0),t.enableVertexAttribArray(e.image.texture.attribs.a_texcoord),t.bindTexture(t.TEXTURE_2D,e.image.texture.tex),n.width?t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,n):t.texImage2D(t.TEXTURE_2D,0,t.RGBA,o,s,0,t.RGBA,t.UNSIGNED_BYTE,n),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),f=Te.translation(i/n.width,a/n.height),f=Te.scale(f,o/n.width,s/n.height),t.uniformMatrix3fv(e.image.texture.uniforms.u_textureMatrix,!1,f),t.uniform1i(e.image.texture.uniforms.u_texture,0),t.drawArrays(t.TRIANGLES,0,6)},l.extend(Re,{getShader:function(){return{program:null,matrix:null,quad:{buffer:null,attribs:{a_position:null},uniforms:{u_matrix:null}},texture:{buffer:null,tex:null,loaded:null,attribs:{a_texcoord:null},uniforms:{u_textureMatrix:null,u_texture:null}}}},init:function(t,e){Ae(t,e)},drawImage:function(t,e,r,n,i,a,o,s,l,c,u,h){Ce(t,e,r,n,i,a,o,s,l,c,u,h)}}),je=a.Rasterizer.GL.Glyph,Ve=a.Rasterizer.GL.Shaders,Ze=a.MATH.Matrix.M3,Ie=function(){return["attribute vec2 a_position;","attribute vec2 a_texcoord;","","uniform mat3 u_matrix;","uniform vec2 u_texsize;","","varying vec2 v_texcoord;","","void main() {","  gl_Position = vec4((u_matrix * vec3(a_position, 1)).xy, 0, 1);","  v_texcoord = a_texcoord / u_texsize;","}"].join("\n")},Ge=function(){return["precision mediump float;","","uniform sampler2D u_texture;","uniform vec4 u_color;","uniform float u_buffer;","uniform float u_gamma;","","varying vec2 v_texcoord;","","void main() {","  float dist = texture2D(u_texture, v_texcoord).r;","  float alpha = smoothstep(u_buffer - u_gamma, u_buffer + u_gamma, dist);","  gl_FragColor = vec4(u_color.rgb, alpha * u_color.a);","}"].join("\n")},Ne=function(t){return t<=.5?-.8*t+1:.5<t&&t<=1?-.2*t+.7:1<t&&t<=1.25?-.1*t+.65:1.25<t&&t<=5?-.0266*t+.533:0},Fe=function(t,e){var r,n=Ie(),i=Ge(),a=e.glyph.quad,o=e.glyph.texture;r=Ve.createAndCompileShaderProgram(t,n,i),e.glyph.program=r,a.buffer=t.createBuffer(),a.attribs.a_position=t.getAttribLocation(r,"a_position"),a.uniforms.u_matrix=t.getUniformLocation(r,"u_matrix"),o.buffer=t.createBuffer(),o.tex=t.createTexture(),o.attribs.a_texcoord=t.getAttribLocation(r,"a_texcoord"),o.uniforms.u_texture=t.getUniformLocation(r,"u_texture"),o.uniforms.u_color=t.getUniformLocation(r,"u_color"),o.uniforms.u_buffer=t.getUniformLocation(r,"u_buffer"),o.uniforms.u_gamma=t.getUniformLocation(r,"u_gamma"),o.uniforms.u_texsize=t.getUniformLocation(r,"u_texsize")},Be=function(t,e,r){var n=r.data,i=r.width,a=r.height;t.bindTexture(t.TEXTURE_2D,e.glyph.texture.tex),t.texImage2D(t.TEXTURE_2D,0,t.RGBA,i,a,0,t.RGBA,t.UNSIGNED_BYTE,n),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR)},Ue=function(t,e,r,n,i,a,o,s){var l,c=e.transform.translate,u=e.glyph.font.size,h=e.color,d=e.glyph.font.size/e.glyph.font.defaultSize,f=e.glyph.text.angle,p=e.glyph.halo.color,m=e.glyph.halo.width,y=e.glyph.font.gamma;t.useProgram(e.glyph.program),t.bindBuffer(t.ARRAY_BUFFER,e.glyph.quad.buffer),t.bufferData(t.ARRAY_BUFFER,new Float32Array(i),t.STATIC_DRAW),t.enableVertexAttribArray(e.glyph.quad.attribs.a_position),t.vertexAttribPointer(e.glyph.quad.attribs.a_position,2,t.FLOAT,!1,0,0),l=Ze.orthographic(0,t.canvas.clientWidth,t.canvas.clientHeight,0,0,0),l=Ze.translate(l,c.x+o/r,c.y+s/r),l=Ze.rotate(l,f),l=Ze.scale(l,d,d),t.uniformMatrix3fv(e.glyph.quad.uniforms.u_matrix,!1,l),Be(t,e,n),t.bindBuffer(t.ARRAY_BUFFER,e.glyph.texture.buffer),t.bufferData(t.ARRAY_BUFFER,new Float32Array(a),t.STATIC_DRAW),t.enableVertexAttribArray(e.glyph.texture.attribs.a_texcoord),t.vertexAttribPointer(e.glyph.texture.attribs.a_texcoord,2,t.FLOAT,!1,0,0),t.uniform2f(e.glyph.texture.uniforms.u_texsize,n.width,n.height),t.uniform1i(e.glyph.texture.uniforms.u_texture,0),t.uniform4fv(e.glyph.texture.uniforms.u_color,p),t.uniform1f(e.glyph.texture.uniforms.u_buffer,Ne(m)),t.drawArrays(t.TRIANGLES,0,i.length/2),t.uniform4fv(e.glyph.texture.uniforms.u_color,h),t.uniform1f(e.glyph.texture.uniforms.u_buffer,.75),t.uniform1f(e.glyph.texture.uniforms.u_gamma,1.4142*y/u),t.drawArrays(t.TRIANGLES,0,a.length/2)},l.extend(je,{getShader:function(){return{program:null,font:{defaultSize:24,size:24,family:"sans-serif",buffer:1,gamma:1},text:{align:"start",baseline:"alphabetic",angle:0},halo:{color:[1,1,1,1],blur:0,width:0},quad:{buffer:null,matrix:null,attribs:{},uniforms:{}},texture:{buffer:null,tex:null,attribs:{},uniforms:{}}}},init:function(t,e){Fe(t,e)},drawGlyph:function(t,e,r,n,i,a,o,s){Ue(t,e,r,n,i,a,o,s),e.image.texture.loaded=!1}}),function(){var t=a.Rasterizer.GL.Font;a.Rasterizer.GL.Glyph;l.extend(t,{})}(),De=a.Rasterizer.GL.Util,l.extend(De,{}),qe=a.Rasterizer.SVG.Public,l.extend(qe,{create:function(t){var e,r,n,i="http://www.w3.org/2000/svg",a="http://www.w3.org/1999/xlink";return(e=Object.create(Xe)).id=null,e[0]=null,e.root=null,e.SVG_NS=i,e.XLINK_NS=a,e.XHTML_NS="http://www.w3.org/1999/xhtml",t&&(e.id=t.slice(1),"string"!=typeof e.id||null===document.getElementById(e.id)||((r=document.getElementById(e.id).getElementsByTagNameNS(i,"svg")[0])&&0!==r.length?e[0]=r:((n=document.createElementNS(i,"svg")).setAttributeNS(null,"version","1.1"),n.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",i),n.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink",a),e[0]=document.getElementById(e.id).appendChild(n)),e.root=e[0])),e}}),Xe={alink:function(t,e){return this[0].setAttributeNS(this.XLINK_NS,"xlink:"+t,e),this},attr:function(t,e){return 2!==arguments.length||"string"!=typeof t&&"number"!=typeof t||"string"!=typeof e&&"number"!=typeof e||this[0]&&this[0].setAttributeNS(null,t,e),this},append:function(t){var e;return t&&"string"==typeof t&&(e=document.createElementNS(this.SVG_NS,t),this[0]=this[0].appendChild(e)),this},remove:function(){var t;return this[0]&&((t=this[0].parentNode).removeChild(this[0]),this[0]=t),this},empty:function(){for(var t=this[0];t.firstChild;)t.removeChild(t.firstChild);return this},removeAllChilds:function(){return this.empty()},firstParent:function(){return this[0]=this.root,this},parent:function(){if(!this[0].parentNode)throw new Error("This SVG element has no parent!");return this[0]=this[0].parentNode,this},query:function(t){return this[0].querySelector(t)},select:function(t){return t&&"string"==typeof t&&(this[0]=this[0].querySelector(t)),this},getElement:function(){return this[0]},previous:function(){return this[0]=this[0].previousElementSibling,this},next:function(){return this[0]=this[0].nextElementSibling,this},text:function(t){return"string"!=typeof t&&"number"!=typeof t||(this[0].textContent=t),this},replace:function(t){var e=document.createElementNS(this.SVG_NS,t);return this[0].parentNode.replaceChild(e,this[0]),this[0]=e,this},children:function(){return this[0].children},removeChild:function(t){return t&&this[0].removeChild(t),this},replaceChild:function(t,e){return t&&this[0].replaceChild(t,e),this}},ir=a.Tiler.Public,ar=a.Tiler.Util,Ye=function(t,e){var r=Math.pow(2,e)*(t+180)/360;return{n:Math.floor(r),s:r%1}},We=function(t,e){var r=(1-Math.log(Math.tan(t*Math.PI/180)+1/Math.cos(t*Math.PI/180))/Math.PI)/2*Math.pow(2,e);return{n:Math.floor(r),s:r%1}},He=function(t,e){return t/Math.pow(2,e)*360-180},Qe=function(t,e){var r=Math.PI-2*Math.PI*t/Math.pow(2,e);return 180/Math.PI*Math.atan(.5*(Math.exp(r)-Math.exp(-r)))},Ke=function(t,e){var r,n,i,a,o,s;return(r={}).shift={},i=Ye(t.coord.λ,e),r.x=i.n,r.shift.x=-i.s*t.tile.size.width,a=We(t.coord.φ,e),r.y=a.n,r.shift.y=-a.s*t.tile.size.height,r.delta={},r.delta.λ=(He(r.x,e)-He(r.x+1,e))/t.tile.size.width,r.delta.φ=(Qe(r.y,e)-Qe(r.y+1,e))/t.tile.size.height,n={first:{},shift:{}},(o=Math.ceil((t.bbox.height/2+r.shift.y)/t.tile.size.height))<0&&(o=0),(s=Math.ceil((t.bbox.height/2-(t.tile.size.height+r.shift.y))/t.tile.size.height))<0&&(s=0),n.rows=o+1+s,n.first.y=r.y-o,n.shift.y=t.bbox.height/2+r.shift.y-t.tile.size.height*o,(o=Math.ceil((t.bbox.width/2+r.shift.x)/t.tile.size.width))<0&&(o=0),(s=Math.ceil((t.bbox.width/2-(t.tile.size.width+r.shift.x))/t.tile.size.width))<0&&(s=0),n.columns=o+1+s,n.first.x=r.x-o,n.shift.x=t.bbox.width/2+r.shift.x-t.tile.size.width*o,{tile:r,tiles:n}},Je=function(t,e,r){var n,i,a=0;for(n=0;n<t.length;n++)(i=t[n].id.match(/\d+/g).map(Number))[1]===e&&i[2]===r&&(a+=1);return 0===a?"":"n"+a},$e=function(t){var e,r,n,i,a,o,s,l=Math.floor(t.zoom),c=Math.pow(2,l),u=Ke(t,l),h={},d=[];for(t.tile.x=u.tile.x,t.tile.y=u.tile.y,t.tile.shift.x=u.tile.shift.x,t.tile.shift.y=u.tile.shift.y,t.tile.delta.λ=u.tile.delta.λ,t.tile.delta.φ=u.tile.delta.φ,n=o=a=0;n<u.tiles.rows;n++)for(i=0;i<u.tiles.columns;i++)h.x=u.tiles.first.x+i,h.y=u.tiles.first.y+n,0<=h.y&&h.y<c&&((h.x<0||h.x>=c)&&(h.x=Math.abs((c+h.x)%c),s=!0),t.url.subdomains?(a>=t.url.subdomains.length&&(a=0),e=t.url.protocol+t.url.body.replace(/\{s\}/,t.url.subdomains[a]),a+=1):e=t.url.protocol+t.url.body,e=e.replace(/\{z\}/,l).replace(/\{x\}/,h.x).replace(/\{y\}/,h.y).replace(/\{retina\}/,t.url.retina),t.token&&(e+="?access_token="+t.token),r=s?Je(d,h.x,h.y):"",d.push({url:e,id:"z"+l+"x"+h.x+"y"+h.y+r,pos:o,x:t.tile.size.width*i+u.tiles.shift.x,y:t.tile.size.height*n+u.tiles.shift.y,width:t.tile.size.width,height:t.tile.size.height}),o+=1);return d},er=function(t,e,r){var n,i,a,o,s,l,c,u=Math.round(t.zoom);return i=(n=Ye(r,u)).n,a=n.s*t.tile.size.width,o=(i-t.tile.x)*t.tile.size.width+t.tile.shift.x+a+t.bbox.width/2,l=(s=We(e,u)).n,c=s.s*t.tile.size.height,{x:o,y:(l-t.tile.y)*t.tile.size.height+t.tile.shift.y+c+t.bbox.height/2}},tr=function(t,e,r){var n,i,a,o,s,l,c=Math.round(t.zoom),u=Math.pow(2,c);return n=e>t.bbox.width/2+t.tile.shift.x?t.tile.x+Math.floor((e-t.tile.shift.x-t.bbox.width/2)/t.tile.size.width):t.tile.x+Math.ceil((e-t.tile.shift.x-t.bbox.width/2)/t.tile.size.width),a=(e-t.tile.shift.x-t.bbox.width/2)%t.tile.size.width,i=r>t.bbox.height/2+t.tile.shift.y?t.tile.y+Math.floor((r-t.tile.shift.y-t.bbox.height/2)/t.tile.size.height):t.tile.y+Math.ceil((r-t.tile.shift.y-t.bbox.height/2)/t.tile.size.height),o=(r-t.tile.shift.y-t.bbox.height/2)%t.tile.size.height,(i<0||u<=i)&&(i=0),(n<0||u<=n)&&(n=Math.abs((u+n)%u)),s=He(n,c),s+=(He(n+1,c)-s)*(a/t.tile.size.width),l=Qe(i,c),{"φ":l+=(Qe(i+1,c)-l)*(o/t.tile.size.height),"λ":s}},rr=function(t,e,r,n){var i,a,o,s,l;return i=Ye(r.λ,n).n,a=We(r.φ,n).n,o=He(i+1,n)-He(i,n),s=r.λ-o/t.tile.size.width*(e.x-t.bbox.width/2),l=Qe(a+1,n)-Qe(a,n),{"φ":r.φ-l/t.tile.size.height*(e.y-t.bbox.height/2),"λ":s}},nr=function(t,e){var r,n,i,a,o=e.right-e.left,s=e.top-e.bottom,l=t.zoom,c=e.right-o/2,u=e.top-s/2;if(r=Ye(c,l).n,i=(He(r+1,l)-He(r,l))*(t.bbox.width/t.tile.size.width),n=We(u,l).n,a=(Qe(n,l)-Qe(n+1,l))*(t.bbox.height/t.tile.size.height),i<o||a<s)for(;i<o||a<s;)r=Ye(c,l-=1).n,i=(He(r+1,l)-He(r,l))*(t.bbox.width/t.tile.size.width),n=We(u,l).n,a=(Qe(n,l)-Qe(n+1,l))*(t.bbox.height/t.tile.size.height);else{for(;o<i&&s<a;)r=Ye(c,l+=1).n,i=(He(r+1,l)-He(r,l))*(t.bbox.width/t.tile.size.width),n=We(u,l).n,a=(Qe(n,l)-Qe(n+1,l))*(t.bbox.height/t.tile.size.height);l-=1}return l},l.extend(ir,{getTiles:function(t){return $e(t)},getXYFromLatLong:function(t,e,r){return er(t,e,r)},getLatLongFromXY:function(t,e,r){return tr(t,e,r)},computeCenterViewCoord:function(t,e,r,n){return rr(t,e,r,n)},getOptimalZoom:function(t,e){return nr(t,e)},decodeUrl:function(t,e,r){return ar.decodeUrl(t,e,r)}}),sr=a.Tiler.Util,or=function(t,e,r){var n;if(t.match(/\{s\}/)){if(!l.isArray(e))throw new Error("_decodeUrl: you must define an array of subdomains!");if(l.isEmpty(e))throw new Error("_decodeUrl: the list of subdomains must not be empty!")}if(!t.match(/\{z\}/))throw new Error("_decodeUrl: the url must contain the pattern {z}!");if(!t.match(/\{x\}/))throw new Error("_decodeUrl: the url must contain the pattern {x}!");if(!t.match(/\{y\}/))throw new Error("_decodeUrl: the url must contain the pattern {y}!");if(t.match(/\{retina\}/)&&!l.isString(r))throw new Error("_decodeUrl: you must define a retina pattern!");return n=t.match(/http:/)?"http://":"https://",t.match(/\{s\}/),{protocol:n,body:t.replace(n,""),subdomains:t.match(/\{s\}/)?e:null,retina:r}},l.extend(sr,{decodeUrl:function(t,e,r){return or(t,e,r)}}),lr=a.Tiler2.Public,cr=a.Tiler2.Map,ur=a.Tiler2.Util,l.extend(lr,{decodeUrl:function(t,e){return ur.decodeUrl(t,e)},getXYFromLatLong:function(t,e,r){return cr.getXYFromLatLon(t,e,r)},getLatLongFromXY:function(t,e,r){return cr.getLatLonFromXY(t,e,r)},getTiles:function(t){return cr.getTiles(t)}}),wr=a.Tiler2.Map,hr=function(t,e){return{x:e,y:180*Math.log(Math.tan(Math.PI/4+t/2/180*Math.PI))/Math.PI}},dr=function(t,e){return{"φ":Math.atan(Math.sinh(e/180*Math.PI))*(180/Math.PI),"λ":t}},fr=function(t,e){var r=Math.pow(2,e)*(t+180)/360;return Math.floor(r)},pr=function(t,e){var r=(1-Math.log(Math.tan(t*Math.PI/180)+1/Math.cos(t*Math.PI/180))/Math.PI)/2*Math.pow(2,e);return Math.floor(r)},mr=function(t,e){return t/Math.pow(2,e)*360-180},yr=function(t,e){var r=Math.PI-2*Math.PI*t/Math.pow(2,e);return 180/Math.PI*Math.atan(.5*(Math.exp(r)-Math.exp(-r)))},gr=function(t,e,r){var n=Math.pow(2,Math.floor(r)),i=1+r%1,a=1024*n,o=1024*n,s=hr(t,e);return{x:Math.round(s.x/180*(a/2)*i),y:Math.round(s.y/180*(o/2)*i)}},xr=function(t,e,r){var n=Math.pow(2,Math.floor(r)),i=1+r%1,a=dr(t/i/(1024*n/2)*180,e/i/(1024*n/2)*180);return{"φ":a.φ,"λ":a.λ}},br=function(t,e){var r=fr(t.λ,e),n=pr(t.φ,e),i=mr(r,e),a=yr(n,e),o=gr(a,i,e);return{n:{x:r,y:n},x:o.x,y:o.y}},vr=function(t){var e,r,n,i,a,o,s,l,c,u,h=t.tile,d=t.viewport,f=Math.floor(t.zoom),p=Math.pow(2,f),m=br(d.coord,f),y=gr(d.coord.φ,d.coord.λ,f),g=1+t.zoom%1,x=[],b={};for(h.n.x=m.n.x,h.n.y=m.n.y,h.x=m.x,h.y=m.y,n=0<(n=d.width/2+(h.x-y.x))?Math.ceil(n/h.width):0,i=0<(i=d.width/2-(h.x+h.width-y.x))?Math.ceil(i/h.width):0,b.x=h.n.x-n,r=n+1+i,s=0<(s=d.height/2-(h.y-y.y))?Math.ceil(s/h.height):0,o=0<(o=d.height/2+(h.y-h.height-y.y))?Math.ceil(o/h.height):0,b.y=h.n.y-s,a=s+1+o,l=u=0;l<a;l++)for(c=0;c<r;c++)e=t.url.subdomains?t.url.protocol+t.url.subdomains[u]+"."+t.url.body:t.url.protocol+t.url.body,e+="/"+f+"/"+(b.x+c)+"/"+(b.y+l)+"."+t.ext,e+=t.token?"?access_token="+t.token:"",u=t.url.subdomains&&u+1<t.url.subdomains.length?u+1:0,x.push({id:f+"."+(b.x+c)+"."+(b.y+l),url:e,x:h.width*g*(b.x+c-p/2),y:h.height*g*(p/2-(b.y+l)),width:h.width*g,height:h.height*g});return d.x=Math.round(y.x*g),d.y=Math.round(y.y*g),x},l.extend(wr,{getXYFromLatLon:function(t,e,r){return gr(t,e,r)},getLatLonFromXY:function(t,e,r){return xr(t,e,r)},getTiles:function(t){return vr(t)}}),Mr=a.Tiler2.Util,kr=function(t,e){var r;if(t.match(/\{s\}/)){if(!l.isArray(e))throw new Error("_decodeUrl: you must define an array of subdomains!");if(l.isEmpty(e))throw new Error("_decodeUrl: the list of subdomains could not be empty!")}return{protocol:r=t.match(/http:/)?"http://":"https://",body:t.match(/\{s\}/)?t.replace(r+"{s}.",""):t.replace(r,""),subdomains:t.match(/\{s\}/)?e:null}},l.extend(Mr,{decodeUrl:function(t,e){return kr(t,e)}}),Sr=function(t,e,r){return!(!Object.prototype.hasOwnProperty.call(t,e)||"function"!=typeof r)},Lr=function(t,e,r){var n=t[e].serie,i=n.listeners;n.firing=!0,function t(){0<i.length?i.shift().apply(r||{},[t].concat(Array.prototype.slice.call(arguments,0))):n.firing=!1}()},zr=function(t,e,r){Sr(t,e,r)&&(t[e].serie.listeners.push(r),t[e].serie.firing||Lr(t,e))},Pr=function(t,e){var r;if(t[e]&&t[e].parallel){for(r=0;r<t[e].parallel.listeners.length;r++)t[e].parallel.listeners[r](t[e].parallel.payloads);t[e].parallel.listeners.splice(0,t[e].parallel.listeners.length),t[e].parallel.qty=0,t[e].parallel.payloads=[]}},Or=function(t,e,r){t[e]&&t[e].parallel&&(t[e].parallel.payloads.push(r),t[e].parallel.qty-=1,0===t[e].parallel.qty&&Pr(t,e))},Er=function(t,e,r,n){Sr(t,e,n)&&(t[e].parallel.listeners.push(n),t[e].parallel.qty=r)},(Ar=l).extend(Ar,{async:{init:function(){return{draw:{serie:{firing:!1,listeners:[]}},load:{parallel:{firing:!1,listeners:[],qty:null,payloads:[]}}}},Q:function(t,e,r){zr(t,e,r)},pushOne:function(t,e,r){Or(t,e,r)},listenForAll:function(t,e,r,n){Er(t,e,r,n)}}}),Cr=function(t,r,n){var e=new XMLHttpRequest;switch(e.onreadystatechange=function(){var t,e;if(4===this.readyState&&200===this.status)switch(r){case"json":this.responseText&&n(this.responseText);break;case"bin":this.response&&(t=new Uint8Array(this.response),n(t));break;case"blob":this.response&&(e=window.URL.createObjectURL(this.response),n(e));break;default:throw new Error('_load: the type "'+r+'" is unknown!')}},r){case"json":e.open("GET",t,!0),e.send(null);break;case"bin":e.open("GET",t,!0),e.responseType="arraybuffer",e.send(null);break;case"blob":e.open("GET",t,!0),e.responseType="blob",e.send(null);break;default:throw new Error('_load: the type "'+r+'" is unknown!')}},(Rr=l).extend(Rr,{load:function(t,e,r){Cr(t,e,r)}}),function(){var t=a.Util.XMLLoaderSource;function e(){return{load:function(t,r,n){var e=new XMLHttpRequest;switch(e.onreadystatechange=function(){var t,e;if(4===this.readyState&&200===this.status)switch(r){case"json":this.responseText&&n(this.responseText);break;case"bin":this.response&&(t=new Uint8Array(this.response),n(t));break;case"blob":this.response&&(e=window.URL.createObjectURL(this.response),n(e));break;default:throw new Error('_load: the type "'+r+'" is unknown!')}},r){case"json":e.open("GET",t,!0),e.send(null);break;case"bin":e.open("GET",t,!0),e.responseType="arraybuffer",e.send(null);break;case"blob":e.open("GET",t,!0),e.responseType="blob",e.send(null);break;default:throw new Error('_load: the type "'+r+'" is unknown!')}}}}l.extend(t,{getSource:function(){return e.toString()},create:function(){return e()}})}(),_r=function(t){return t.match(/[+-]?\d+(\.\d+)?/g).map(Number)},Tr=function(t){var e=t.slice(1).toString();return 3===e.length?e=e.slice(0,1)+e.slice(0,1)+e.slice(1,2)+e.slice(1,2)+e.slice(2,3)+e.slice(2,3):6!==e.length&&(e="000000"),[parseInt(e.slice(0,2),16),parseInt(e.slice(2,4),16),parseInt(e.slice(4,6),16)]},Ir=function(t){var e,r,n,i,a,o,s,l,c;if(e=t[0]/255,r=t[1]/255,n=t[2]/255,c=((i=Math.max(e,r,n))+(a=Math.min(e,r,n)))/2,i===a)l=s=0;else switch(o=i-a,l=.5<c?o/(2-i-a):o/(i+a),i){case e:s=(r-n)/o+(r<n?6:0);break;case r:s=(n-e)/o+2;break;case n:s=(e-r)/o+4}return[60*s,100*l,100*c]},Gr=function(t,e,r){var n,i;function a(t,e,r){return r<0&&(r+=1),1<r&&(r-=1),r<1/6?t+6*(e-t)*r:r<.5?e:r<2/3?t+(e-t)*(2/3-r)*6:t}return 0===e?[255*r,255*r,255*r]:[255*a(n=2*r-(i=r<.5?r*(1+e):r+e-r*e),i,t+1/3),255*a(n,i,t),255*a(n,i,t-1/3)]},Nr=function(t){var e;if("rgb"!==t.slice(0,3)&&"hsl"!==t.slice(0,3))throw new Error('_getRGBValues: "'+t+'" is illegal!');return[(e=_r(t))[0],e[1],e[2]]},Fr=function(t){var e,r="#"===t.slice(0,1)?"#":t.slice(0,3);switch(r){case"#":return e=Tr(t),Ir(e);case"rgb":return e=Nr(t),Ir(e);case"hsl":return Nr(t);default:throw new Error('_fromHexOrRbg2Hsl: the type "'+r+'" is illegal!')}},Br=function(t,e){var r,n="#"===t.slice(0,1)?"#":t.slice(0,3);switch(n){case"#":return"rgba("+(r=Tr(t))[0]+", "+r[1]+", "+r[2]+", "+e+")";case"rgb":return"rgba("+(r=Nr(t))[0]+", "+r[1]+", "+r[2]+", "+e+")";case"hsl":return"hsla("+(r=Nr(t))[0]+", "+r[1]+"%, "+r[2]+"%, "+e+")";default:throw new Error('_colorAlphaChannel: the type "'+n+'" is illegal!')}},Ur=function(t){var e,r,n,i="#"===t.slice(0,1)?"#":t.slice(0,3);switch(i){case"#":return[(n=Tr(t))[0],n[1],n[2],1];case"rgb":return e=_r(t),"a"===(r=t.slice(4,5))?[e[0],e[1],e[2],e[3]]:[e[0],e[1],e[2],1];case"hsl":return e=_r(t),r=t.slice(3,4),n=Gr(e[0]/360,e[1]/100,e[2]/100),"a"===r?[n[0],n[1],n[2],e[3]]:[n[0],n[1],n[2],1];default:throw new Error('_toRGBA: the type "'+i+'" is illegal!')}},(jr=l).extend(jr,{color:{toRGBA:function(t){return Ur(t)},addColorAlphaChannel:function(t,e){return Br(t,e)},getHSL:function(t){return Fr(t)}}}),function(){var t=a.Util.ColorSource;function e(){var a,o,n,s,i,e,r,l;return a=function(t){return t.match(/[+-]?\d+(\.\d+)?/g).map(Number)},o=function(t){var e=t.slice(1).toString();return 3===e.length?e=e.slice(0,1)+e.slice(0,1)+e.slice(1,2)+e.slice(1,2)+e.slice(2,3)+e.slice(2,3):6!==e.length&&(e="000000"),[parseInt(e.slice(0,2),16),parseInt(e.slice(2,4),16),parseInt(e.slice(4,6),16)]},n=function(t){var e,r,n,i,a,o,s,l,c;if(e=t[0]/255,r=t[1]/255,n=t[2]/255,c=((i=Math.max(e,r,n))+(a=Math.min(e,r,n)))/2,i===a)l=s=0;else switch(o=i-a,l=.5<c?o/(2-i-a):o/(i+a),i){case e:s=(r-n)/o+(r<n?6:0);break;case r:s=(n-e)/o+2;break;case n:s=(e-r)/o+4}return[60*s,100*l,100*c]},s=function(t,e,r){var n,i;function a(t,e,r){return r<0&&(r+=1),1<r&&(r-=1),r<1/6?t+6*(e-t)*r:r<.5?e:r<2/3?t+(e-t)*(2/3-r)*6:t}return 0===e?[255*r,255*r,255*r]:[255*a(n=2*r-(i=r<.5?r*(1+e):r+e-r*e),i,t+1/3),255*a(n,i,t),255*a(n,i,t-1/3)]},i=function(t){var e;if("rgb"!==t.slice(0,3)&&"hsl"!==t.slice(0,3))throw new Error('_getRGBValues: "'+t+'" is illegal!');return[(e=a(t))[0],e[1],e[2]]},l=function(t){var e,r="#"===t.slice(0,1)?"#":t.slice(0,3);switch(r){case"#":return e=o(t),n(e);case"rgb":return e=i(t),n(e);case"hsl":return i(t);default:throw new Error('_fromHexOrRbg2Hsl: the type "'+r+'" is illegal!')}},r=function(t,e){var r,n="#"===t.slice(0,1)?"#":t.slice(0,3);switch(n){case"#":return"rgba("+(r=o(t))[0]+", "+r[1]+", "+r[2]+", "+e+")";case"rgb":return"rgba("+(r=i(t))[0]+", "+r[1]+", "+r[2]+", "+e+")";case"hsl":return"hsla("+(r=i(t))[0]+", "+r[1]+"%, "+r[2]+"%, "+e+")";default:throw new Error('_colorAlphaChannel: the type "'+n+'" is illegal!')}},e=function(t){var e,r,n,i="#"===t.slice(0,1)?"#":t.slice(0,3);switch(i){case"#":return[(n=o(t))[0],n[1],n[2],1];case"rgb":return e=a(t),"a"===(r=t.slice(4,5))?[e[0],e[1],e[2],e[3]]:[e[0],e[1],e[2],1];case"hsl":return e=a(t),r=t.slice(3,4),n=s(e[0]/360,e[1]/100,e[2]/100),"a"===r?[n[0],n[1],n[2],e[3]]:[n[0],n[1],n[2],1];default:throw new Error('_toRGBA: the type "'+i+'" is illegal!')}},{toRGBA:function(t){return e(t)},addColorAlphaChannel:function(t,e){return r(t,e)},getHSL:function(t){return l(t)}}}l.extend(t,{getSource:function(){return e.toString()},create:function(){return e()}})}(),qr=a.Util.LRU,Vr=function(t){for(;t.lru<t.mru&&void 0===t.list[t.lru];)t.lru+=1},Zr=function(t,e){var r;return t.cache[e]?(r=t.cache[e].stamp,delete t.list[r],t.list[t.mru]=e,t.cache[e].stamp=t.mru,t.mru+=1,t.cache[e].value):null},Dr=function(t,e,r){var n;t.cache[e]?t.cache[e].value=r:(t.cache[e]={value:r,stamp:t.mru},t.list[t.cache[e].stamp]=e,t.mru+=1,t.items+=1),t.items>t.maxItems&&(Vr(t),n=t.list[t.lru],delete t.cache[n],delete t.list[t.lru],t.items-=1)},l.extend(qr,{create:function(t){var e=Object.create(Xr);return e.cache={},e.list={},e.lru=0,e.mru=0,e.items=0,e.maxItems=t||10,e}}),Xr={_dumpCache:function(){return this.cache},_dumpList:function(){return this.list},_dumpParams:function(){return{lru:this.lru,mru:this.mru,items:this.items,maxItems:this.maxItems}},get:function(t){return Zr(this,t)},set:function(t,e){Dr(this,t,e)}},Yr=a.MapGL.GeoJSON.Public,Wr=a.MapGL.Raster.Public,Hr=a.MapGL.Vector.Public,e=function(t,e){var r;if(arguments.length<2||"string"!=typeof t||"string"!=typeof e)throw new Error("MapGL constructor must get two arguments that are strings!");switch(e){case"geojson":r=Yr.create(t);break;case"raster":r=Wr.create(t);break;case"vector":r=Hr.create(t);break;default:throw new Error('MapGL: the type "'+e+'" is not supported!')}return r},r=t.MapGL,e.noConflict=function(){return t.MapGL=r,this},e.VERSION="0.0.0",e.MG=a,e},"function"==typeof define&&define.amd?define([""],p):"object"==typeof exports?(module.exports=p(f),null===f.MapGL&&(f.MapGL=p(f))):f.MapGL=p(f),h=m.SVG,x=m.overslash,u=m.MapGL,M=m.Chart.Main,y=function(r,t,e){var n=x.clone(r[0]);switch(e){case"area":case"bar":case"column":case"line":case"pie":case"polar":case"radar":case"waterfall":case"map":return!(!x.isArray(t)||x.isEmpty(t)||(r.splice(0),t.forEach(function(t,e){r[e]=x.extend({},n,t)}),0));case"circle":case"gauge":return!!x.isNumber(t)&&(r[0]=x.extend({},n,{label:"Item 1",type:e,value:t}),!0);default:throw new Error('_copySeries: the chart "'+e+'" is not recognized!')}},g=function(t){var e=t.chart,r=t.title,n=t.subtitle,i=t.legend;r.x=null===r.x?e.width/2:r.x,r.y=null===r.y?15:r.y,n.x=null===n.x?e.width/2:n.x,n.y=null===n.y?35:n.y,i.enabled=null===i.enabled||i.enabled,i.floating=null===i.floating||i.floating,i.layout=null===i.layout?"vertical":i.layout,i.align.horizontal=null===i.align.horizontal?"right":i.align.horizontal,i.align.vertical=null===i.align.vertical?"top":i.align.vertical,i.shift.x=null===i.shift.x?0:i.shift.x,i.shift.y=null===i.shift.y?0:i.shift.y,i.icon.width=null===i.icon.width?10:i.icon.width,i.icon.height=null===i.icon.height?10:i.icon.height,i.icon.gap.x=null===i.icon.gap.x?.5*i.icon.width:i.icon.gap.x,i.icon.gap.y=null===i.icon.gap.y?.5*i.icon.height:i.icon.gap.y},b=function(t,e,r){var n=t.chart,i=e.align.horizontal,a=e.align.vertical;e.enabled&&!e.floating?n.grid.height="left"!==i||"top"!==a&&"middle"!==a&&"bottom"!==a?"middle"===i&&"top"===a?(n.grid.x=null===n.grid.x?n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?e.background.y+e.background.height+n.grid.margin.bottom:n.grid.y,n.grid.width=null===n.grid.width?n.width-n.grid.x-n.grid.margin.right:n.grid.width,null===n.grid.height?n.height-n.grid.y-n.grid.margin.bottom:t.chart.grid.height):"middle"===i&&"middle"===a?(n.grid.x=null===n.grid.x?n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?n.grid.margin.top:n.grid.y,n.grid.width=null===n.grid.width?n.width-n.grid.x-n.grid.margin.right:n.grid.width,null===n.grid.height?n.height-n.grid.y-n.grid.margin.bottom:n.grid.height):"middle"===i&&"bottom"===a?(n.grid.x=null===n.grid.x?n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?n.grid.margin.top:n.grid.y,n.grid.width=null===n.grid.width?n.width-n.grid.x-n.grid.margin.right:n.grid.width,null===n.grid.height?e.background.y-n.grid.y-n.grid.margin.bottom:n.grid.height):(n.grid.x=null===n.grid.x?n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?n.grid.margin.top:n.grid.y,n.grid.width=null===n.grid.width?e.background.x-n.grid.x-n.grid.margin.right:n.grid.width,null===n.grid.height?n.height-n.grid.y-n.grid.margin.bottom:n.grid.height):(n.grid.x=null===n.grid.x?e.background.x+e.background.width+n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?n.grid.margin.top:n.grid.y,n.grid.width=null===n.grid.width?n.width-n.grid.x-n.grid.margin.right:n.grid.width,null===n.grid.height?n.height-n.grid.y-n.grid.margin.bottom:n.grid.height):(n.grid.x=null===n.grid.x?n.grid.margin.left:n.grid.x,n.grid.y=null===n.grid.y?n.grid.margin.top:n.grid.y,n.grid.width=null===n.grid.width?n.width-n.grid.x-n.grid.margin.right:n.grid.width,n.grid.height=null===n.grid.height?n.height-n.grid.y-n.grid.margin.bottom:n.grid.height),"charts"===r&&(n.grid.y+=n.grid.height)},v=function(t,e){switch(e){case"area":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type||"percent"===t.chart.type?t.chart.type+" area":"basic area";break;case"bar":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?t.chart.type+" bar":"basic bar";break;case"circle":t.chart.type="circle";break;case"column":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?t.chart.type+" column":"basic column";break;case"gauge":t.chart.type="gauge";break;case"line":t.chart.type="line";break;case"pie":t.chart.type="pie";break;case"polar":t.chart.type="polar";break;case"radar":t.chart.type="radar";break;case"waterfall":t.chart.type="waterfall";break;case"map":t.chart.type="map";break;default:throw new Error('_setChartType: this type "'+e+'" is unknown!')}},w=function(t,e){var r,n,i,a,o;if(!(e.xAxis&&e.xAxis.plot&&e.xAxis.plot.type)){if(e.xAxis.categories)r=e.xAxis.categories;else{if(!e.yAxis.categories)return;r=e.yAxis.categories}for(n=r.data.length,a=0;a<t.length;a++)for(o=0;o<r.data.length;o++)t[a].data[o]||(t[a].data[o]=0);for(0===n&&(r.data.push("???"),n=r.data.length),a=0;a<t.length;a++)i=t[a].data.length,t[a].data.splice(n,i-n)}},k=function(t){var e=t.xAxis.type||t.yAxis.type;switch(e){case"categories":return{x0:t.chart.grid.x,y0:t.chart.grid.y-t.chart.grid.height,width:t.chart.grid.width,height:t.chart.grid.height};case"plot":return{x0:t.chart.grid.x+t.xAxis.data.min,y0:t.chart.grid.y-t.chart.grid.height,width:t.xAxis.data.max-t.xAxis.data.min,height:t.chart.grid.height};default:throw new Error('Pix.chart._setActiveArea: the type "'+e+'" is unknown!')}},x.extend(M,{copySeries:function(t,e,r){return y(t,e,r)},computeGenericSettings:function(t){g(t)},computeGridSize:function(t,e,r){b(t,e,r)},setChartType:function(t,e){v(t,e)},normalizeSeries:function(t,e,r,n){w(t,e)},setActiveArea:function(t){return k(t)}}),L=m.Chart.Keypad,z=m.Maps.Core.DragZoomClick,S=function(t,e){var r,n,i,a;for(r=[/\szup/,/\szdown/,/\sup/,/\sleft/,/\sdown/,/\sright/,/\scenter/],n=e.target.getAttribute("class"),a=0;a<r.length;a++)if(null!==n.match(r[a])){i=n.match(r[a]);break}if(i)switch(i=i[0].trim()){case"center":z.keypadToDefault(t);break;case"zup":case"zdown":z.keypadZoom(t,i);break;case"left":case"right":case"up":case"down":z.keypadShift(t,i);break;default:throw new Error('_keypad.onkeypadclick: what is this key "'+i+'"!')}},x.extend(L,{onKeypadClick:function(t){S(this,t)}}),C=m.Chart.Legend,P=function(t){var e,r,n;for(e={enabled:null,floating:null,layout:null,align:{horizontal:null,vertical:null},shift:{x:null,y:null},icon:{width:null,height:null,gap:{x:null,y:null}},background:{x:null,y:null,width:null,height:null,padding:{top:5,left:5,bottom:5,right:5}},data:[]},r={label:null,color:null,bbox:{width:null,height:null}},n=0;n<t;n++)e.data.push(x.extend({},r));return e},O=function(t,e,r){var n;switch(r){case"area":case"bar":case"column":case"pie":for(n=0;n<t.data.length;n++)t.data[n].color=e[n].style.fillColor;break;case"line":for(n=0;n<t.data.length;n++)t.data[n].color=e[n].style.stroke;break;case"polar":for(n=0;n<t.data.length;n++)"line"===e[n].type?t.data[n].color=e[n].style.stroke:t.data[n].color=e[n].style.fillColor;break;case"radar":for(n=0;n<t.data.length;n++)"area"===e[n].type?t.data[n].color=e[n].style.fillColor:t.data[n].color=e[n].style.stroke;break;case"map":for(n=0;n<t.data.length;n++)e&&e[n]&&e[n].style&&(t.data[n].color=e[n].style.fillColor)}},E=function(t,e,r){var n;switch(r){case"area":case"bar":case"circle":case"column":case"gauge":case"line":case"pie":case"polar":case"radar":case"waterfall":for(n=0;n<t.data.length;n++)t.data[n].label=e[n].label;break;case"map":for(n=0;n<t.data.length;n++)t.data[n].label=e[n].title;break;default:throw new Error('_addLabel: the type "'+r+'" is unknown!')}for(O(t,e,r),n=t.data.length-1;0<=n;n--)void 0===t.data[n].label&&t.data.splice(n,1)},A=function(t,e){var r,n=t.background,i=t.icon,a=t.layout,o=t.align;if(!1!==t.enabled){for(n.width=0,r=n.height=0;r<t.data.length;r++)"horizontal"===a?(n.width+=i.width+i.gap.x+t.data[r].bbox.width+4*i.gap.x,n.height=t.data[r].bbox.height):(n.width<i.width+i.gap.x+t.data[r].bbox.width&&(n.width=i.width+i.gap.x+t.data[r].bbox.width),n.height+=i.height+i.gap.y);"horizontal"===a?(n.width-=4*i.gap.x,n.width+=n.padding.left+n.padding.right,n.height+=n.padding.bottom):(n.height-=i.gap.y,n.width+=n.padding.left+n.padding.right,n.height+=n.padding.top+n.padding.bottom),n.width=Math.round(n.width),n.height=Math.round(n.height),"left"===o.horizontal?n.x=1:"middle"===o.horizontal?n.x=(e.chart.width-n.width)/2:n.x=e.chart.width-n.width-1,"top"===o.vertical?n.y=1:"middle"===o.vertical?n.y=(e.chart.height-n.height)/2:n.y=e.chart.height-n.height-1,n.x+=t.shift.x,n.y+=t.shift.y}},x.extend(C,{create:function(t){return P(t)},addLabel:function(t,e,r){E(t,e,r)},computeSettings:function(t,e){A(t,e)}}),G=m.Chart.Renderer,R=function(t,e,r,n){t.attr("class",e).attr("width",r).attr("height",n)},_=function(t,e){t.select(".charttitle"),e.title&&e.title.label&&t.append("text").attr("class","title").attr("x",e.title.x).attr("y",e.title.y).text(e.title.label).parent(),e.subtitle&&e.subtitle.label&&t.append("text").attr("class","subtitle").attr("x",e.subtitle.x).attr("y",e.subtitle.y).text(e.subtitle.label).parent(),t.firstParent()},T=function(t,e){var r,n,i,a=e.background,o=e.icon,s=e.layout;if(e.enabled){for(t.select(".legend").attr("transform","translate("+a.x+", "+a.y+")").append("rect").attr("class","background").attr("x",.5).attr("y",.5).attr("width",a.width).attr("height",a.height).parent(),r=a.padding.left,n=a.padding.top,i=0;i<e.data.length;i++)t.append("rect").attr("style","fill: "+e.data[i].color).attr("x",r).attr("y",n).attr("width",o.width).attr("height",o.height).parent().append("text").attr("x",r+o.width+o.gap.x).attr("y",n+o.height).text(e.data[i].label).parent(),"horizontal"===s?r+=o.width+o.gap.x+e.data[i].bbox.width+4*o.gap.x:n+=o.height+o.gap.y;t.firstParent()}},I=function(t,e){var r;if(e.enabled){for(t.append("g"),r=0;r<e.data.length;r++)t.append("text").attr("x",0).attr("y",0).text(e.data[r].label).parent(),e.data[r].bbox=t.getSize();t.remove("g")}},x.extend(G,{set:function(t,e,r,n){R(t,e,r,n)},drawTitle:function(t,e){_(t,e)},drawLegend:function(t,e){T(t,e)},getLegendBoundingBoxes:function(t,e){I(t,e)}}),U=m.Chart.Renderer,N=function(t,e){var r=e.chart.grid,n=r.width,i=r.height,a=r.x,o=r.y;t.append("g").attr("class","series").attr("transform","translate("+a+", "+o+")"),t.append("svg").attr("class","maps").attr("width",n).attr("height",i).append("g").attr("class","geojson").attr("transform","translate(0, 0) scale(0, 0)").parent().append("g").attr("class","raster").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","vector").attr("transform","translate(0, 0) scale(1, 1)").parent().parent(),t.append("svg").attr("class","overlay").append("g").attr("class","multipolygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polyline").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","point").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","icon").attr("transform","translate(0, 0) scale(1, 1)").parent().parent().parent(),t.append("g").attr("class","charttitle").parent().append("g").attr("class","legend").parent().append("g").attr("class","tooltip").parent().append("g").attr("class","activearea").parent().append("g").attr("class","keypad").parent().append("g").attr("class","copyright").parent().parent()},F=function(t,e,r){var n=r.chart.grid,i=n.width,a=n.height,o=n.x,s=n.y;t.select(".activearea").attr("transform","translate("+o+", "+s+")"),t.append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",i).attr("height",a).parent().append("g").attr("class","activezone").attr("transform","translate(0, 0) scale(1, 1)").append("g").attr("class","multipolygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polygon").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","polyline").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","point").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","icon").attr("transform","translate(0, 0) scale(1, 1)").firstParent()},B=function(t,e,r){e.select(".activearea").listen("wheel",r.zoom.bind(t)).listen("mousedown",r.drag.bind(t)).listen("touchstart",r.drag.bind(t)).listen("click",r.click.bind(t)).listen("dblclick",r.dblClick.bind(t)).firstParent()},x.extend(U,{fill:function(t,e){N(t,e)},drawActiveArea:function(t,e,r){F(t,0,r)},addEvents2ActiveArea:function(t,e,r){B(t,e,r)}}),X=m.Chart.Renderer,j=function(t,e,r){var n,i,a,o,s,l;if(!1!==e.keypad){for(o={width:76.5+2*(n={x:3,y:3}).x,height:51+2*n.y},a={zup:[[{x:(i={zup:[8.5+n.x,17+n.y,"zup"],zdown:[8.5+n.x,34+n.y,"zdown"],left:[34+n.x,25.5+n.y,"left"],up:[51+n.x,8.5+n.y,"up"],center:[51+n.x,25.5+n.y,"center"],down:[51+n.x,42.5+n.y,"down"],right:[68+n.x,25.5+n.y,"right"]}).zup[0]-4,y:i.zup[1]},{x:i.zup[0]+4,y:i.zup[1]}],[{x:i.zup[0],y:i.zup[1]-4},{x:i.zup[0],y:i.zup[1]+4}]],zdown:[[{x:i.zdown[0]-4,y:i.zdown[1]},{x:i.zdown[0]+4,y:i.zdown[1]}]],left:[[{x:i.left[0]+3,y:i.left[1]-4},{x:i.left[0]-3,y:i.left[1]},{x:i.left[0]+3,y:i.left[1]+4}]],up:[[{x:i.up[0]-4,y:i.up[1]+3},{x:i.up[0],y:i.up[1]-3},{x:i.up[0]+4,y:i.up[1]+3}]],center:[[{x:i.center[0]-4,y:i.center[1]-4},{x:i.center[0]+4,y:i.center[1]+4}],[{x:i.center[0]+4,y:i.center[1]-4},{x:i.center[0]-4,y:i.center[1]+4}]],down:[[{x:i.down[0]-4,y:i.down[1]-3},{x:i.down[0],y:i.down[1]+3},{x:i.down[0]+4,y:i.down[1]-3}]],right:[[{x:i.right[0]-3,y:i.right[1]-4},{x:i.right[0]+3,y:i.right[1]},{x:i.right[0]-3,y:i.right[1]+4}]]},t.select(".keypad").attr("transform","translate("+(r.chart.width-o.width-2)+", "+(r.chart.height-o.height-2)+")"),t.append("rect").attr("class","background").attr("x",.5).attr("y",0).attr("rx",2).attr("ry",2).attr("width",o.width+.5).attr("height",o.height+.5).parent(),s=Object.keys(i),l=0;l<s.length;l++)t.append("rect").attr("class","key "+i[s[l]][2]).attr("x",i[s[l]][0]-7.5).attr("y",i[s[l]][1]-7.5).attr("rx",2).attr("ry",2).attr("width",15).attr("height",15).parent().append("path").attr("class","icon "+s[l]).attr("d",h.draw.multipolyline(a[i[s[l]][2]])).parent();t.firstParent()}},V=function(t,e){t.select(".keypad").listen("click",e).firstParent()},Z=function(t,e,r,n,i){switch(e){case"touch":t.select(".activearea").listen("touchend",r).listen("touchmove",n).listen("touchcancel",i).parent();break;case"mouse":t.select(".activearea").listen("mouseup",r).listen("mousemove",n).listen("mouseout",i).parent();break;default:throw new Error('_attachDragEvents: the type "'+e+'" is unknown!')}},D=function(t,e,r,n,i){switch(e){case"touch":t.select(".activearea").unlisten("touchend",r).unlisten("touchmove",n).unlisten("touchcancel",i).parent();break;case"mouse":t.select(".activearea").unlisten("mouseup",r).unlisten("mousemove",n).unlisten("mouseout",i).parent();break;default:throw new Error('_removeDragEvents: the type "'+e+'" is unknown!')}},x.extend(X,{drawKeypad:function(t,e,r){j(t,e,r)},addEvent2Keypad:function(t,e){V(t,e)},attachDragEvents:function(t,e,r,n,i){Z(t,e,r,n,i)},removeDragEvents:function(t,e,r,n,i){D(t,e,r,n,i)}}),Q=m.Chart.Copyright,q=function(t){t.select(".copyright").attr("transform","translate(0, 0)"),t.append("rect").attr("class","background").attr("rx",0).attr("ry",0).attr("x",0).attr("y",0).attr("width",0).attr("height",0).parent(),t.append("text").attr("class","text"),t.append("a").alink("href","#").attr("class","xlink1").append("tspan").attr("class","t1").text("").parent().parent(),t.append("a").alink("href","#").attr("class","xlink2").append("tspan").attr("class","t2").attr("dx","5").text("").parent().parent(),t.append("tspan").attr("class","t3").attr("dx","5").text("").parent(),t.append("title").attr("class","title").text("").parent(),t.firstParent()},Y=function(t,e){void 0!==e.copyleft.text&&t.select(".copyright").select(".text").select(".xlink1").select(".t1").text(e.copyleft.text).parent().parent().parent().parent(),void 0!==e.copyleft.url&&t.select(".copyright").select(".text").select(".xlink1").alink("href",e.copyleft.url).parent().parent().parent(),void 0!==e.copyright.text&&t.select(".copyright").select(".text").select(".xlink2").select(".t2").text(e.copyright.text).parent().parent().parent().parent(),void 0!==e.copypost&&void 0!==e.copypost.text&&t.select(".copyright").select(".text").select(".t3").text(e.copypost.text).parent().parent().parent(),void 0!==e.copyright.url&&t.select(".copyright").select(".text").select(".xlink2").alink("href",e.copyright.url).parent().parent().parent(),void 0!==e.title&&t.select(".copyright").select(".text").select(".title").text(e.title).parent().parent().parent()},W=function(t,e,r){var n,i,a,o;n=0,t.query(".keypad")&&(n=t.select(".keypad").getSize().width,t.firstParent()),i=t.select(".copyright").getSize(),t.firstParent(),(o={}).x=e.chart.width-n-i.width-2,o.y=e.chart.height-2,t.select(".copyright").attr("transform","translate("+o.x+", "+o.y+")").firstParent(),"openstreetmap"===r&&((a={x:-2}).y=2-i.height,a.width=i.width+4,a.height=i.height+2,o.x-=2,o.y-=4,t.select(".copyright").attr("transform","translate("+o.x+", "+o.y+")").select(".background").attr("rx",2).attr("ry",2).attr("x",a.x).attr("y",a.y).attr("width",a.width).attr("height",a.height).firstParent())},H=function(t,e,r){switch(r){case"classic":Y(t,{copyleft:{text:"Pixi Charts",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Artelsys",url:"http://www.artelsys.com"},title:"Copyright (c) 2019 Artelsys. All Rights Reserved."});break;case"naturalearth":Y(t,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Natural Earth",url:"http://www.naturalearthdata.com"},title:"Copyright (c) 2019 Artelsys. Made with free vector and raster map data @ naturalearthdata.com."});break;case"openstreetmap":Y(t,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© OpenStreetMap",url:"http://www.openstreetmap.org/copyright"},copypost:{text:"contributors"},title:"Copyright (c) 2019 Artelsys. Made with raster map data @ openstreetmap.com."});break;case"datagouv":Y(t,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Data.Gouv.fr",url:"https://www.data.gouv.fr/en/"},copypost:{text:"contributors"},title:"Copyright (c) 2019 Artelsys. Made with data @ data.gouv.fr - licence ODbl."});break;default:throw new Error('Pix.Graphics.Copyright.fill: this "'+r+'" is unknown!')}W(t,e,r)},x.extend(Q,{draw:function(t){q(t)},fill:function(t,e,r){H(t,e,r)}}),K=m.Maps.Core.Public,J=m.Maps.Core.Renderer,$=m.Maps.Core.Util,tt=m.Overlays.Public,x.extend(K,{create:function(t,e,r){var n;if(!t.chart[0])throw new Error("The chart can't be created. There is no DOM element to attach it!");return(n=Object.create(x.extend({},this.methods,e))).id=t.id,n.chart=t.chart,n.mapgl=t.mapgl,n.db=t.db,$.init(n.db,n.id,r),n},getMouseOrFingerPositionOnChart:function(t,e,r){return $.getMouseOrFingerPositionOnChart(t,e,r)},getMouseOrFingerPositionOnMap:function(t,e,r){return $.getMouseOrFingerPositionOnMap(t,e,r)},methods:{_init:function(){return this},_addDemo:function(){return this},_initMapSettings:function(){return this},_draw:function(){return this},_render:function(t,e,r){return J.render(this,t,e,r),this},_getKeypadZoomSettings:function(){return this},moveTo:function(){return this},overlayAppend:function(t){return tt.appendPoi(this.chart,this.mapgl,this.db,t),this},overlayUpdate:function(t){return tt.updatePoi(this.chart,this.mapgl,this.db,t),this},overlayRemove:function(t){return tt.remove(this,t),this},overlayDelete:function(){return tt.delete(this),this},overlayBlink:function(t){return tt.blink(this,t),this},overlayUnblink:function(t){return tt.unblink(this,t),this},overlaySetVisible:function(t){return tt.setVisible(this,t),this},overlaySetInvisible:function(t){return tt.setInvisible(this,t),this},overlayAttachTooltip:function(t,e,r,n){return tt.attachTooltip(this,t,e,r,n),this},addEventListener:function(t,e){return this.db.mess.addEventListener(t,e),this},addOneTimeEventListener:function(t,e){return this.db.mess.addOneTimeEventListener(t,e),this},removeEventListener:function(t,e){return this.db.mess.removeEventListener(t,e),this},on:function(t,e){return this.addEventListener(t,e)},one:function(t,e){return this.addOneTimeEventListener(t,e)},off:function(t,e){return this.removeEventListener(t,e)},getImage:function(t,e,r){var n=h(this.id);if("string"!=typeof t&&null!==t)throw new Error("First argument must be a string or null!");if("string"!=typeof e&&null!==e)throw new Error("Second argument must be a string or null!");if("function"!=typeof r)throw new Error("Third argument must be a function!");setTimeout(function(){m.image.toImage(n.getElement(),[".charttitle",".series",".keypad",".copyright",".tooltip"],t,e,r)},5e3)}}}),rt=m.Maps.Core.Renderer,nt=m.Maps.Core.DragZoomClick,it=m.Chart.Main,at=m.Chart.Keypad,ot=m.Chart.Legend,st=m.Chart.Renderer,lt=m.Chart.Copyright,ct=m.Overlays.Public,et=function(t,e,r,n){var i,a,o,s=t.id,l=t.chart,c=t.db;i=e||[],a=r||{},it.copySeries(c.series,i,"map"),x.extend(c.opts,a),t._addDemo(c.map,c.series,c.opts),t._initMapSettings(c.map,c.opts),it.computeGenericSettings(c.opts),o=ot.create(c.series.length),x.extend(o,c.opts.legend),ot.addLabel(o,c.series,"map"),st.getLegendBoundingBoxes(l,o),ot.computeSettings(o,c.opts),it.computeGridSize(c.opts,o),it.setChartType(c.opts,"map"),st.set(l,"map",c.opts.chart.width,c.opts.chart.height),c.opts.chart.boundingBoxes=l.getElement().getBoundingClientRect(),st.fill(l,c.opts),st.drawTitle(l,c.opts),st.drawLegend(l,o),st.drawActiveArea(l,c.map,c.opts),st.addEvents2ActiveArea(t,l,nt),st.drawKeypad(l,c.map,c.opts),st.addEvent2Keypad(l,at.onKeypadClick.bind(t)),lt.draw(l,c.opts),ct.init(t),t.mapgl=u(s,n),t._draw()},x.extend(rt,{render:function(t,e,r,n){et(t,e,r,n)}}),gt=m.Maps.Core.DragZoomClick,xt=m.easing,bt=m.Chart.Renderer,vt=m.Overlays.Public,wt=m.Tooltip.Public,kt=m.Maps.Raster.Public,Mt=m.Maps.Core.Util,ut=function(t,e,r,n,i,a){var o,s=r.map,l=s.params.shift,c=s.origin;o=setInterval(function(){n.shift.t+=n.shift.frequency,n.shift.t>n.shift.duration&&(n.shift.t=n.shift.duration),l.x=n.shift.easing(n.shift.t,n.shift.start.x,n.shift.end.x-n.shift.start.x,n.shift.duration),l.y=n.shift.easing(n.shift.t,n.shift.start.y,n.shift.end.y-n.shift.start.y,n.shift.duration),s.params.zoom=n.shift.easing(n.shift.t,n.zoom.start.x,n.zoom.end.x-n.zoom.start.x,n.shift.duration),e.update(c.x+l.x,c.y+l.y,s.params.zoom,a),vt.update(t,e,r),n.shift.t===n.shift.duration&&(clearInterval(o),i&&i())},n.shift.frequency)},ht=function(t,e){var r,n=t.chart,i=t.mapgl,a=t.db,o=a.mess,s=a.map,l=a.opts,c=s.origin,u=s.params.shift,h=-e.deltaY/100;if(s.scrollwheel&&!o.fireQActive("moveto"))switch(e.preventDefault(),s.params.zoom+h>s.maxZoom?h=s.maxZoom-s.params.zoom:s.params.zoom+h<s.minZoom&&(h=s.minZoom-s.params.zoom),r=Mt.getMouseOrFingerPositionOnMap(e,s,l),s.type){case"geojson":case"vector":u.x+=-(r.x-u.x)/s.params.zoom*h,u.y+=-(r.y-u.y)/s.params.zoom*h,s.params.zoom+=h,i.update(c.x+u.x,c.y+u.y,s.params.zoom),vt.update(n,i,a);break;case"raster":kt.zoom(n,i,a,r,h);break;default:throw new Error('_zoom: the type "'+s.type+'"is unknown!')}},dt=function(t,e){var r,n,i,a,o=e.type.match(/touch/)?"touch":"mouse",s=t.chart,l=t.mapgl,c=t.db,u=c.mess,h=c.map,d=c.opts,f=h.origin,p=h.params.shift,m=h.params.zoom,y=d.chart.grid.width,g=d.chart.grid.height;r=function(t){var e;e=Mt.getMouseOrFingerPositionOnChart(t,h,d),p.x=a.map.x+(e.x-a.mouse.x),p.y=a.map.y+(e.y-a.mouse.y),l.update(f.x+p.x,f.y+p.y,m),vt.update(s,l,c),"touch"===o&&(e.x<0||e.x>y||e.y<0||e.y>g)&&n()},n=function(){bt.removeDragEvents(s,o,n,r,i),wt.release(s)},i=function(t){var e;((e=Mt.getMouseOrFingerPositionOnChart(t,h,d)).x<=0||e.x>=y||e.y<=0||e.y>=g)&&n()},h.draggable&&!u.fireQActive("moveto")&&("mouse"===o&&e.preventDefault(),bt.attachDragEvents(s,o,n,r,i),wt.hide(s),(a={mouse:{},map:{}}).mouse=Mt.getMouseOrFingerPositionOnChart(e,h,d),a.map.x=p.x,a.map.y=p.y)},ft=function(t){var e,r=t.chart,n=t.mapgl,i=t.db,a=i.mess,o=i.map,s=i.opts,l=o.params.shift,c=s.constants.timeToScale,u=1e3/s.constants.framesPerSecond||40,h=xt.easeInOutCubic;a.q("moveto",function(t){switch(e={shift:{start:{x:l.x,y:l.y},end:{x:0,y:0},t:0,duration:c,frequency:u,easing:h},zoom:{start:{x:o.params.zoom,y:o.params.zoom},end:{x:o.zoom,y:o.zoom},t:0,duration:c,frequency:u,easing:h}},o.type){case"geojson":case"vector":ut(r,n,i,e,t);break;case"raster":kt.backToDefaultPos(r,n,i,e,ut,t);break;default:throw new Error('_keypadToDefault: thet type "'+o.type+'" is unknown!')}})},pt=function(e,r){var n,i=e.chart,a=e.mapgl,o=e.db,t=o.mess,s=o.map,l=o.opts;t.q("moveto",function(t){n=e._getKeypadZoomSettings(s,r,l),ut(i,a,o,n,t)})},mt=function(t,e){var r,n=t.chart,i=t.mapgl,a=t.db,o=a.mess,s=a.map,l=a.opts,c=s.params.shift,u=l.chart.grid,h=l.constants.timeToScale,d=1e3/l.constants.framesPerSecond||40,f=xt.easeInOutCubic;o.q("moveto",function(t){switch(r={shift:{start:{x:c.x,y:c.y},end:{x:c.x,y:c.y},t:0,duration:h,frequency:d,easing:f},zoom:{start:{x:s.params.zoom,y:s.params.zoom},end:{x:s.params.zoom,y:s.params.zoom},t:0,duration:h,frequency:d,easing:f}},e){case"up":r.shift.end.y=c.y+.05*u.height;break;case"down":r.shift.end.y=c.y-.05*u.height;break;case"left":r.shift.end.x=c.x+.05*u.width;break;case"right":r.shift.end.x=c.x-.05*u.width;break;default:throw new Error('_keypadShift: the direction "'+e+'" is unknown!')}ut(n,i,a,r,t)})},yt=function(t,e,r,n,i){var a,o=r.mess,s=r.map,l=r.opts,c=Mt.getMouseOrFingerPositionOnMap(n,s,l),u=e.getLatLongFromXY(c.x,c.y);a={x:c.x,y:c.y,latitude:u.φ,longitude:u.λ},o.fire(i,{chart:{id:t.id},overlay:null,cursor:a}),"click"===i&&m.touchDblClick(function(){o.fire("dblclick",{chart:{id:t.id},overlay:null,cursor:a})})},x.extend(gt,{zoom:function(t){ht(this,t)},drag:function(t){dt(this,t)},click:function(t){yt(this.chart,this.mapgl,this.db,t,"click")},dblClick:function(t){yt(this.chart,this.mapgl,this.db,t,"dblclick")},keypadToDefault:function(t){ft(t)},keypadZoom:function(t,e){pt(t,e)},keypadShift:function(t,e){mt(t,e)},smoothMove:function(t,e,r,n,i){ut(t,e,r,n,i)}}),Pt=m.Maps.Core.Util,Ot=m.Messenger,St=function(t,e){t.map={url:null,subdomains:null,style:null,coordinates:null,origin:{x:null,y:null},zoom:null,maxZoom:null,minZoom:null,draggable:null,scrollwheel:null,keypad:null,tooltip:null,type:null,zoomRange:{max:null,min:null},bbox:{width:null,height:null},params:{zoom:null,shift:{x:null,y:null}},loaded:!1,wheelingTimeout:!1,overlay:{blinkingPeriod:750}},t.series=[{name:null,label:null,suffix:{first:null,second:null},type:"map",data:[],color:null}],t.opts={chart:{type:"map",width:600,height:420,grid:{x:null,y:null,width:null,height:null,margin:{top:0,left:0,right:0,bottom:0}},boundingBoxes:{},viewport:{"φ":{top:null,bottom:null},"λ":{left:null,right:null}}},title:{label:null,x:null,y:20},subtitle:{label:null,x:null,y:35},legend:{enabled:null,floating:null,layout:null,align:{horizontal:null,vertical:null},shift:{x:null,y:null},icon:{width:null,height:null,gap:{x:null,y:null}}},tooltip:{enabled:!0,animated:!0},xAxis:{type:null,cursor:{enabled:!1},plot:{type:null,start:null,increment:null,suffix:"",margin:{left:5,right:5}},categories:{data:[]},data:{min:null,max:null,width:null,scale:null,numberOfElements:null}},yAxis:{min:null,max:null,minor:null,exp:null,scale:null,title:{label:"Label here",x:null,y:null},interval:{number:null,height:null}},constants:{timeToScale:1e3,framesPerSecond:50,gap:{x:12,y:-5}}},t.overlays={},t.tooltip={chart:h(e),custom:null,params:null,x:0,y:0},t.mess=Ot(["overlayover","overlayout","click","dblclick"]),t.mess.addEvents("load"),t.mess.addStreamEvents("moveto"),t.mess.addStreamEvents("tooltip")},Lt=function(t,e,r){var n,i,a=r.chart;return i=t.type.match(/touch/)?(n=t.touches[0].clientX,t.touches[0].clientY):(n=t.clientX,t.clientY),{x:n-a.boundingBoxes.left,y:i-a.boundingBoxes.top}},zt=function(t,e,r){var n=Lt(t,0,r);return{x:n.x-e.origin.x,y:n.y-e.origin.y}},x.extend(Pt,{init:function(t,e,r){St(t,e)},getMouseOrFingerPositionOnChart:function(t,e,r){return Lt(t,0,r)},getMouseOrFingerPositionOnMap:function(t,e,r){return zt(t,e,r)}}),Et=m.Maps.GeoJSON.Public,At=m.Maps.Core.Public,Ct=m.Maps.GeoJSON.Renderer,Rt=m.Maps.GeoJSON.Util,x.extend(Et,{create:function(t,e,r,n){var i,a="geojson";return(i=At.create(t,this.methods,a))._init(i.db,e),i._render(r,n,a),i},methods:{_init:function(t,e){return Rt.init(t,e),this},_addDemo:function(){return this},_initMapSettings:function(t){return Rt.initMapSettings(t),this},_draw:function(){x.load(this.db.map.url,Ct.draw.bind(this))},_getKeypadZoomSettings:function(t,e,r){return Rt.getKeypadZoomSettings(t,e,r)},moveTo:function(t,e){return Ct.moveTo(this.chart,this.mapgl,this.db,t,e),this}}}),Ft=m.Maps.GeoJSON.Renderer,Bt=m.easing,Ut=m.Maps.Core.DragZoomClick,jt=m.Chart.Copyright,Vt=m.Overlays.Public,_t=function(t,e,r){var n,i=r.map,a=r.opts,o=a.constants.timeToScale,s=1e3/a.constants.framesPerSecond||40,l=Bt.easeInOutCubic;i.params.zoom=0,i.params.shift.x=i.bbox.width*i.zoom/2,i.params.shift.y=i.bbox.height*i.zoom/2,n={shift:{start:{x:i.params.shift.x,y:i.params.shift.y},end:{x:0,y:0},t:0,duration:o,frequency:s,easing:l},zoom:{start:{x:i.params.zoom,y:i.params.zoom},end:{x:i.zoom,y:i.zoom},t:0,duration:o,frequency:s,easing:l}},Ut.smoothMove(t,e,r,n,function(){r.mess.fire("load"),i.loaded=!0})},Tt=function(t,e,r,n){var i,a,o,s={};for(o=0;o<n.features.length;o++)i={geometry:{type:(a=n.features[o]).geometry.type,coordinates:a.geometry.coordinates,unit:"px"}},s[a.id]=i;Vt.fill(t,e,r,s)},It=function(t,e){var r,n,i=h(t.id),a=t.mapgl,o=t.db,s=o.map,l=o.opts;s.data=JSON.parse(e.slice(e.indexOf("json =")+7)),s.bbox.width=(s.data.parameters.xRight-s.data.parameters.xLeft)*s.data.parameters.scale,s.bbox.height=(s.data.parameters.yTop-s.data.parameters.yBottom)*s.data.parameters.scale,n={zoom:s.params.zoom,shift:{x:s.params.shift.x,y:s.params.shift.y},bbox:{x:s.origin.x,y:s.origin.y,width:s.bbox.width,height:s.bbox.height},data:s.data},a.draw(n),(r=s.data.copyright).match(/Natural Earth/)?jt.fill(i,l,"naturalearth"):r.match(/data\.gouv\.fr/)&&jt.fill(i,l,"datagouv"),Tt(i,a,o,s.data),_t(i,a,o)},Gt=function(a,o,s,t,l){var e=s.mess,c=s.map,u=s.opts,h=x.isArray(t)?"coord":"id",d=t,f=t,p=c.params.shift,m=u.constants.timeToScale,y=1e3/u.constants.framesPerSecond||40,g=Bt.easeInOutCubic;e.q("moveto",function(t){var e,r,n,i;i=x.isNumber(l)?l<c.minZoom?c.minZoom:l>c.maxZoom?c.maxZoom:l:c.params.zoom,e="coord"===h?o.getXYFromLatLong(d[0],d[1]):(n=Vt.getCenterOverlay(s.overlays.poi[f]),"px"!==s.overlays.poi[f].geometry.unit?o.getXYFromLatLong(n.φ,n.λ):{x:n.φ,y:n.λ}),(r={shift:{start:{x:p.x,y:p.y},end:{x:null,y:null},t:0,duration:m,frequency:y,easing:g},zoom:{start:{x:c.params.zoom,y:c.params.zoom},end:{x:i,y:i},t:0,duration:m,frequency:y,easing:g}}).shift.end.x=-(e.x-p.x)/r.zoom.start.x*r.zoom.end.x,r.shift.end.y=-(e.y-p.y)/r.zoom.start.y*r.zoom.end.y,r.shift.end.x+=u.chart.width/2,r.shift.end.y+=u.chart.height/2,Ut.smoothMove(a,o,s,r,t)})},Nt=function(t,e,r,n,i){r.map.loaded?Gt(t,e,r,n,i):r.mess.one("load",function(){Gt(t,e,r,n,i)})},x.extend(Ft,{draw:function(t,e,r){if(t)throw t;It(this,r)},moveTo:function(t,e,r,n,i){Nt(t,e,r,n,i)}}),qt=m.Maps.GeoJSON.Util,Yt=m.easing,Zt=function(t,e){x.extend(t.map,{url:null,origin:{x:0,y:0},zoom:1,maxZoom:10,minZoom:.1,draggable:!0,scrollwheel:!0,keypad:!0,tooltip:!0,type:"geojson",zoomRange:{max:20,min:.1},bbox:{width:null,height:null},params:{zoom:null,shift:{x:null,y:null}},loaded:!1},e)},Dt=function(t){t.params.zoom=t.zoom,t.bbox.x=t.origin.x,t.bbox.y=t.origin.y,t.bbox.width=0,t.bbox.height=0,t.params.shift.x=0,t.params.shift.y=0},Xt=function(t,e,r){var n,i=r.constants.timeToScale,a=1e3/r.constants.framesPerSecond||40,o=Yt.easeInOutCubic;switch(n={shift:{start:{x:t.params.shift.x,y:t.params.shift.y},end:{x:null,y:null},t:0,duration:i,frequency:a,easing:o},zoom:{start:{x:t.params.zoom,y:t.params.zoom},end:{x:null,y:null},t:0,duration:i,frequency:a,easing:o}},e){case"zup":n.zoom.end.x=1.05*n.zoom.start.x,n.zoom.end.x>t.maxZoom&&(n.zoom.end.x=t.maxZoom),n.zoom.end.y=n.zoom.end.x;break;case"zdown":n.zoom.end.x=n.zoom.start.x/1.05,n.zoom.end.x<t.minZoom&&(n.zoom.end.x=t.minZoom),n.zoom.end.y=n.zoom.end.x;break;default:throw new Error('_getZoomGeoJSON: the direction "'+e+'" is unknown!')}return n.shift.end.x=n.shift.start.x-r.chart.width*((n.zoom.end.x-n.zoom.start.x)/2),n.shift.end.y=n.shift.start.y-r.chart.height*((n.zoom.end.x-n.zoom.start.x)/2),n},x.extend(qt,{init:function(t,e){Zt(t,e)},initMapSettings:function(t,e){return Dt(t)},getKeypadZoomSettings:function(t,e,r){return Xt(t,e,r)}}),Wt=m.Maps.Raster.Public,Ht=m.Maps.Core.Public,Qt=m.Maps.Raster.Renderer,Kt=m.Maps.Raster.Util,x.extend(Wt,{create:function(t,e,r,n){var i;return(i=Ht.create(t,this.methods,"raster"))._init(i.db,e),i._render(r,n,"raster"),i},backToDefaultPos:function(t,e,r,n,i,a){Qt.backToDefaultPos(t,e,r,n,i,a)},zoom:function(t,e,r,n,i){Qt.zoom(t,e,r,n,i)},methods:{_init:function(t,e){return Kt.init(t,e),this},_addDemo:function(){return this},_initMapSettings:function(t,e){return Kt.initMapSettings(t,e),this},_draw:function(){return Qt.draw(this.chart,this.mapgl,this.db),this},_getKeypadZoomSettings:function(t,e,r){return Kt.getKeypadZoomSettings(t,e,r)},moveTo:function(t,e){return Qt.moveTo(this.chart,this.mapgl,this.db,t,e),this}}}),re=m.Maps.Raster.Renderer,ne=m.easing,ie=m.Chart.Copyright,ae=m.Maps.Core.DragZoomClick,oe=m.Overlays.Public,Jt=function(t,e,r,n,i){var a,o,s,l,c=r.map;0<=i&&c.params.zoom>=c.maxZoom||i<=0&&c.params.zoom<=c.minZoom||(c.params.scale+=i,20<c.params.scale?c.params.scale=20:c.params.scale<.1&&(c.params.scale=.1),s=-(c.params.scale-1)*n.x,l=-(c.params.scale-1)*n.y,e.zoom(s,l,c.params.scale,n),oe.update(t,e,r),clearTimeout(c.wheelingTimeout),c.wheelingTimeout=setTimeout(function(){1<c.params.scale?(c.params.zoom+=Math.round(Math.sqrt(c.params.scale-1)),c.params.zoom>c.maxZoom&&(c.params.zoom=c.maxZoom)):(c.params.zoom-=Math.round(Math.sqrt(1/c.params.scale-1)),c.params.zoom<c.minZoom&&(c.params.zoom=c.minZoom)),c.params.scale=1,c.params.shift.x=0,c.params.shift.y=0,e.resetScale(),a=e.getLatLongFromXY(n.x,n.y),o=e.computeCenterViewCoord(n,a,c.params.zoom),e.enableCoord(),e.update(o.λ,o.φ,c.params.zoom),e.disableCoord(),oe.update(t,e,r),c.wheelingTimeout=void 0},250))},$t=function(t,e,r,n,i,a){var o=r.map,s=e.getCoord(),l=x.extend({},n);if(n.zoom.end.x>=n.zoom.start.x)return n.shift.start.x=s.λ,n.shift.start.y=s.φ,n.shift.end.x=o.params.coord.λ,n.shift.end.y=o.params.coord.φ,n.zoom.end.x=n.zoom.start.x,n.zoom.end.y=n.zoom.start.y,e.enableCoord(),void i(t,e,r,n,function(){l.shift.start.x=0,l.shift.start.y=0,l.shift.end.x=0,l.shift.end.y=0,e.disableCoord(),i(t,e,r,l,function(){o.params.shift.x=0,o.params.shift.y=0,a&&a()})});n.shift.start.x=o.params.shift.x,n.shift.start.y=o.params.shift.y,n.shift.end.x=o.params.shift.x,n.shift.end.y=o.params.shift.y,i(t,e,r,n,function(){l.zoom.start.x=l.zoom.end.x,l.zoom.start.y=l.zoom.end.y,l.shift.start.x=s.λ,l.shift.start.y=s.φ,l.shift.end.x=o.params.coord.λ,l.shift.end.y=o.params.coord.φ,e.enableCoord(),i(t,e,r,l,function(){o.params.shift.x=0,o.params.shift.y=0,e.disableCoord(),a&&a()})})},te=function(t,e,r){var n=r.map,i=r.opts,a={url:n.url,subdomains:n.subdomains,retina:n.retina,zoom:n.zoom,coord:{"φ":n.params.coord.φ,"λ":n.params.coord.λ},bbox:{width:n.bbox.width,height:n.bbox.height},tile:{width:n.tile.width,height:n.tile.height}};e.draw(a),ie.fill(t,i,"openstreetmap"),n.loaded=!0},ee=function(n,i,a,t,o){var s,e=a.mess,l=a.map,r=a.opts,c=x.isArray(t)?"coord":"id",u=t,h=t,d=r.constants.timeToScale,f=1e3/r.constants.framesPerSecond||40,p=ne.easeInOutCubic;e.q("moveto",function(t){var e,r;r=x.isNumber(o)?o<l.minZoom?l.minZoom:o>l.maxZoom?l.maxZoom:o:l.params.zoom,"coord"===c?(l.params.coord.φ=u[0],l.params.coord.λ=u[1]):(l.params.coord=oe.getCenterOverlay(a.overlays.poi[h]),"auto"===o&&(r=(s=oe.getBoundingBox(a.overlays.poi[h]))?i.getOptimalZoom(s):l.params.zoom)),l.zoom=r,e={shift:{start:{x:null,y:null},end:{x:null,y:null},t:0,duration:d,frequency:f,easing:p},zoom:{start:{x:l.params.zoom,y:l.params.zoom},end:{x:r,y:r},t:0,duration:d,frequency:f,easing:p}},$t(n,i,a,e,ae.smoothMove,t)})},x.extend(re,{draw:function(t,e,r){te(t,e,r)},backToDefaultPos:function(t,e,r,n,i,a){$t(t,e,r,n,i,a)},zoom:function(t,e,r,n,i){Jt(t,e,r,n,i)},moveTo:function(t,e,r,n,i){return ee(t,e,r,n,i),this}}),ue=m.Maps.Raster.Util,he=m.easing,se=function(t,e){x.extend(t.map,{url:null,subdomains:null,retina:null,coordinates:[0,0],origin:{x:0,y:0},zoom:0,maxZoom:19,minZoom:0,draggable:!0,scrollwheel:!0,keypad:!0,tooltip:!0,type:"raster",zoomRange:{max:19,min:0},bbox:{width:null,height:null},params:{scale:1,shift:{x:0,y:0},zoom:null,coord:{"φ":null,"λ":null}},loaded:!1,wheelingTimeout:!1,tile:{size:{x:256,y:256}}},e)},le=function(t,e){x.isNumber(t.zoom)||(t.zoom=0),x.isNumber(t.maxZoom)||(t.maxZoom=t.zoomRange.max),x.isNumber(t.minZoom)||(t.minZoom=t.zoomRange.min),t.maxZoom=Math.round(t.maxZoom),t.maxZoom>t.zoomRange.max?t.maxZoom=t.zoomRange.max:t.maxZoom<t.zoomRange.min&&(t.maxZoom=t.zoomRange.min),t.minZoom=Math.round(t.minZoom),t.minZoom<t.zoomRange.min?t.minZoom=t.zoomRange.min:t.minZoom>t.zoomRange.max&&(t.minZoom=t.zoomRange.max),t.maxZoom<t.minZoom&&(t.maxZoom=t.minZoom),t.zoom>t.maxZoom?t.zoom=t.maxZoom:t.zoom<t.minZoom&&(t.zoom=t.minZoom),x.isNumber(t.coordinates[0])||(t.coordinates[0]=0),x.isNumber(t.coordinates[1])||(t.coordinates[1]=0),90<t.coordinates[0]?t.coordinates[0]=90:t.coordinates[0]<-90&&(t.coordinates[0]=-90),t.coordinates[1]<-180&&(t.coordinates[1]=180),180<t.coordinates[1]&&(t.coordinates[1]=180),t.bbox.width=e.chart.width,t.bbox.height=e.chart.height,t.params.zoom=t.zoom,t.params.coord.φ=t.coordinates[0],t.params.coord.λ=t.coordinates[1],e.legend.enabled=!1},ce=function(t,e,r){var n,i=r.constants.timeToScale,a=1e3/r.constants.framesPerSecond||40,o=he.easeInOutCubic;switch(n={shift:{start:{x:t.params.shift.x,y:t.params.shift.y},end:{x:t.params.shift.x,y:t.params.shift.y},t:0,duration:i,frequency:a,easing:o},zoom:{start:{x:t.params.zoom,y:t.params.zoom},end:{x:t.params.zoom,y:t.params.zoom},t:0,duration:i,frequency:a,easing:o}},e){case"zup":t.params.zoom+1<=t.maxZoom&&(n.zoom.end.x+=1,n.zoom.end.y+=1);break;case"zdown":t.params.zoom-1>=t.minZoom&&(n.zoom.end.x-=1,n.zoom.end.y-=1);break;default:throw new Error('_carto.keypadDrag: the direction "'+e+'" is unknown!')}return n},x.extend(ue,{init:function(t,e){se(t,e)},initMapSettings:function(t,e){return le(t,e)},getKeypadZoomSettings:function(t,e,r){return ce(t,e,r)}}),de=m.Maps.Vector.Public,fe=m.Maps.Core.Public,pe=m.Maps.Vector.Renderer,me=m.Maps.Vector.Util,ye=m.Maps.Raster.Util,x.extend(de,{create:function(t,e,r,n){var i;return(i=fe.create(t,this.methods,"vector"))._init(i.db,e),i._render(r,n,"vector"),i},methods:{_init:function(t,e){return ye.init(t,e),this},_addDemo:function(){return this},_initMapSettings:function(t,e){return ye.initMapSettings(t,e),this},_draw:function(){return pe.draw(this.mapgl,this.chart,this.db,this.db.opts,"webgl"),this},_getKeypadZoomSettings:function(t,e,r){return me.getKeypadZoomSettings(t,e,r)}}}),xe=m.Maps.Vector.Renderer,be=m.Chart.Copyright,ge=function(t,e,r,n,i){var a=r.map,o=r.mess;t.init(a.bbox.width,a.bbox.height,i),t.draw({type:"vector",style:a.style,url:a.url,subdomains:a.subdomains,token:a.token,ext:a.ext,zoom:a.zoom,coord:[a.coord[0],a.coord[1]],bbox:{width:a.bbox.width,height:a.bbox.height},tile:{}},null,function(){o.fire("load"),a.loaded=!0}),be.fill(e,n,"openstreetmap")},x.extend(xe,{draw:function(t,e,r,n,i){ge(t,e,r,n,i)}}),we=m.Maps.Vector.Util,ke=m.easing,ve=function(t,e,r){var n,i=r.constants.timeToScale,a=1e3/r.constants.framesPerSecond||40,o=ke.easeInOutCubic;switch(n={shift:{start:{x:t.params.shift.x,y:t.params.shift.y},end:{x:t.params.shift.x,y:t.params.shift.y},t:0,duration:i,frequency:a,easing:o},zoom:{start:{x:t.params.zoom,y:t.params.zoom},end:{x:t.params.zoom,y:t.params.zoom},t:0,duration:i,frequency:a,easing:o}},e){case"zup":t.params.zoom+1<=t.maxZoom&&(n.zoom.end.x+=1,n.zoom.end.y+=1);break;case"zdown":t.params.zoom-1>=t.minZoom&&(n.zoom.end.x-=1,n.zoom.end.y-=1);break;default:throw new Error('_carto.keypadDrag: the direction "'+e+'" is unknown!')}return n},x.extend(we,{getKeypadZoomSettings:function(t,e,r){return ve(t,e,r)}}),Be=m.Overlays.Public,Ue=m.Overlays,je=Ue.Renderer,Ve=Ue.Util,Me=function(t){var e,r={};if(!x.isObject(t))return{};if(t.title&&x.isString(t.title)&&(r.title=t.title),t.style&&(r.style={},t.style.fillColor&&x.isString(t.style.fillColor)&&(r.style.fillColor=t.style.fillColor),t.style.fillOpacity&&x.isNumber(t.style.fillOpacity)&&(r.style.fillOpacity=t.style.fillOpacity),t.style.strokeColor&&x.isString(t.style.strokeColor)&&(r.style.strokeColor=t.style.strokeColor),t.style.strokeOpacity&&x.isNumber(t.style.strokeOpacity)&&(r.style.strokeOpacity=t.style.strokeOpacity),t.style.strokeWidth&&x.isNumber(t.style.strokeWidth)&&(r.style.strokeWidth=t.style.strokeWidth),t.style.backgroundColor&&x.isString(t.style.backgroundColor)&&(r.style.backgroundColor=t.style.backgroundColor),t.style.backgroundOpacity&&x.isNumber(t.style.backgroundOpacity)&&(r.style.backgroundOpacity=t.style.backgroundOpacity)),t.over&&(r.over={},t.over.fillColor&&x.isString(t.over.fillColor)&&(r.over.fillColor=t.over.fillColor),t.over.fillOpacity&&x.isNumber(t.over.fillOpacity)&&(r.over.fillOpacity=t.over.fillOpacity),t.over.strokeColor&&x.isString(t.over.strokeColor)&&(r.over.strokeColor=t.over.strokeColor),t.over.strokeOpacity&&x.isNumber(t.over.strokeOpacity)&&(r.over.strokeOpacity=t.over.strokeOpacity),t.over.strokeWidth&&x.isNumber(t.over.strokeWidth)&&(r.over.strokeWidth=t.over.strokeWidth),t.over.backgroundColor&&x.isString(t.over.backgroundColor)&&(r.over.backgroundColor=t.over.backgroundColor),t.over.backgroundOpacity&&x.isNumber(t.over.backgroundOpacity)&&(r.over.backgroundOpacity=t.over.backgroundOpacity)),t.geometry&&(r.geometry={},t.geometry.type&&x.isString(t.geometry.type)&&(r.geometry.type=t.geometry.type),t.geometry.radius&&x.isNumber(t.geometry.radius)&&(r.geometry.radius=t.geometry.radius),t.geometry.unit&&x.isString(t.geometry.unit)&&(r.geometry.unit=t.geometry.unit),t.geometry.coordinates&&x.isArray(t.geometry.coordinates)&&(r.geometry.coordinates=x.clone(t.geometry.coordinates)),t.geometry.shape&&x.isObject(t.geometry.shape))){if(r.geometry.shape={},t.geometry.shape.height&&x.isNumber(t.geometry.shape.height)&&(r.geometry.shape.height=t.geometry.shape.height),t.geometry.shape.width&&x.isNumber(t.geometry.shape.width)&&(r.geometry.shape.width=t.geometry.shape.width),t.geometry.shape.viewBox&&x.isArray(t.geometry.shape.viewBox)&&4<=t.geometry.shape.viewBox.length){for(r.geometry.shape.viewBox=[],e=0;e<4;e++)x.isNumber(t.geometry.shape.viewBox[e])&&(r.geometry.shape.viewBox[e]=t.geometry.shape.viewBox[e]);4!==r.geometry.shape.viewBox.length&&delete r.geometry.shape.viewBox}t.geometry.shape.path&&x.isString(t.geometry.shape.path)&&(r.geometry.shape.path=t.geometry.shape.path)}if(t.properties)if(x.isArray(t.properties))for(r.properties=[],e=0;e<t.properties.length;e++)x.isString(t.properties[e])?r.properties.push(t.properties[e]):x.isObject(t.properties[e])&&r.properties.push(x.clone(t.properties[e]));else x.isObject(t.properties)&&(r.properties=x.clone(t.properties));return t.visibilityRange&&(r.visibilityRange={},x.isNumber(t.visibilityRange.minZoom)&&(r.visibilityRange.minZoom=t.visibilityRange.minZoom),x.isNumber(t.visibilityRange.maxZoom)&&(r.visibilityRange.maxZoom=t.visibilityRange.maxZoom),x.isEmpty(r.visibilityRange)&&delete r.visibilityRange),r},Se=function(t){var e,r,n,i,a,o,s=t.geometry;if(!s||!s.type)return!1;switch(e=s.radius,r=s.coordinates,n=s.shape,s.type){case"Point":return e&&2===r.length&&x.isNumber(r[0])&&x.isNumber(r[0]);case"Polyline":if(!r)return!1;for(i=0;i<r.length;i++)if(2!==r[i].length||!x.isNumber(r[i][0])||!x.isNumber(r[i][1]))return!1;return!0;case"Polygon":if(!r)return!1;for(i=0;i<r.length;i++)for(a=0;a<r[i].length;a++)if(2!==r[i][a].length||!x.isNumber(r[i][a][0])||!x.isNumber(r[i][a][1]))return!1;return!0;case"MultiPolygon":if(!r)return!1;for(i=0;i<r.length;i++)for(a=0;a<r[i].length;a++)for(o=0;o<r[i][a].length;o++)if(2!==r[i][a][o].length||!x.isNumber(r[i][a][o][0])||!x.isNumber(r[i][a][o][1]))return!1;return!0;case"Icon":return!!r&&2===r.length&&x.isNumber(r[0])&&x.isNumber(r[0])&&n&&n.width&&n.height&&n.path;default:return!1}},Le=function(t,e,r,n){var i,a,o=[],s=Object.keys(r);if(!x.isObject(r))return[];switch(n){case"append":for(a=0;a<s.length;a++)e[s[a]]||(i=Me(r[s[a]]),Se(i)&&(e[s[a]]={},x.extend(e[s[a]],{title:"",geometry:{type:null,coordinates:[0,0]},properties:{},visible:!0,hidden:!0},i),o.push(s[a])));break;case"update":for(a=0;a<s.length;a++)e[s[a]]&&(i=Me(r[s[a]]),x.extend(e[s[a]],i),o.push(s[a]))}return o},ze=function(t,e){var r;for(r=0;r<e.length;r++)t[e[r]].hidden=!1},Pe=function(t,e,r,n,i){var a=r.blink;a.timerid=setInterval(function(){a.state&&"off"!==a.state?(je.turnOff(a.chart,t,e,r,n),a.state="off"):(r.hidden||je.turnOn(a.chart,t,e,r,n),a.state="on")},i)},Oe=function(t,e){e.blink&&(clearInterval(e.blink.timerid),delete e.blink)},Ee=function(t,e){var r,n,i,a=t.chart,o=t.mapgl,s=t.db,l=s.mess,c=s.map,u=s.overlays.poi;if("string"==typeof e)(r=[])[0]=e;else{if(!x.isArray(e))return;r=e}l.one("load",function(){for(i=0;i<r.length;i++)"string"==typeof(n=r[i])&&u[n]&&!u[n].hidden&&(u[n].hidden=!0,je.turnOff(a,o,s,u[n],n))}),c.loaded&&l.fire("load")},Ae=function(t,e){var r,n,i,a=t.chart,o=t.mapgl,s=t.db,l=s.mess,c=s.map,u=s.overlays.poi;if("string"==typeof e)(r=[])[0]=e;else{if(!x.isArray(e))return;r=e}l.one("load",function(){for(i=0;i<r.length;i++)"string"==typeof(n=r[i])&&u[n]&&u[n].hidden&&(u[n].hidden=!1,je.turnOn(a,o,s,u[n],n))}),c.loaded&&l.fire("load")},Ce=function(t,e){var r,n,i,a=t.chart,o=t.mapgl,s=t.db,l=s.mess,c=s.map,u=s.overlays.poi;if("string"==typeof e)(r=[])[0]=e;else{if(!x.isArray(e))return;r=e}l.one("load",function(){for(i=0;i<r.length;i++)"string"==typeof(n=r[i])&&u[n]&&!u[n].hidden&&u[n].blink&&(Oe(0,u[n]),je.turnOn(a,o,s,u[n],n))}),c.loaded&&l.fire("load")},Re=function(t,e){var r,n,i,a=t.mapgl,o=t.db,s=o.mess,l=o.map,c=o.overlays.poi;if("string"==typeof e)(r=[])[0]=e;else{if(!x.isArray(e))return;r=e}s.one("load",function(){for(i=0;i<r.length;i++)"string"!=typeof(n=r[i])||!c[n]||c[n].hidden||c[n].blink||(c[n].blink={},c[n].blink.chart=h(t.id),c[n].blink.timerid=null,Pe(a,o,c[n],n,l.overlay.blinkingPeriod))}),l.loaded&&s.fire("load")},_e=function(t,e){var r,n,i,a,o=t.chart,s=t.db,l=s.mess,c=s.map,u=s.overlays;x.isArray(e)&&(l.one("load",function(){for(a=0;a<e.length;a++)n=e[a],(r=u.poi[n])&&(i=r.geometry.type,Oe(0,r),je.remove(o,i,n),delete u.poi[n])}),c.loaded&&l.fire("load"))},Te=function(t){var e,r=t.db.overlays.poi;e=Object.keys(r),_e(t,e)},Ie=function(t,e,r,n){var i,a=r.mess,o=r.map,s=r.overlays;a.one("load",function(){i=Le(0,s.poi,n,"update"),Ve.computeBoundingBox(e,s.poi,i),ze(s.poi,i),je.add(t,e,r,i)}),o.loaded&&a.fire("load")},Ge=function(t,e,r,n){var i,a=r.mess,o=r.map,s=r.overlays;a.one("load",function(){i=Le(0,s.poi,n,"append"),Ve.computeBoundingBox(e,s.poi,i),ze(s.poi,i),je.add(t,e,r,i)}),o.loaded&&a.fire("load")},Ne=function(t,e,r,n){r.map;var i,a=r.overlays;i=Le(0,a.poi,n,"append"),Ve.computeBoundingBox(e,a.poi,i),je.add(t,e,r,i)},Fe=function(t){t.db.overlays={poi:{},handlers:{mouseOver:Ue.Events.mouseOver.bind(t),mouseOut:Ue.Events.mouseOut.bind(t),click:Ue.Events.click.bind(t),dblClick:Ue.Events.dblClick.bind(t)}}},x.extend(Be,{init:function(t){Fe(t)},fill:function(t,e,r,n){Ne(t,e,r,n)},appendPoi:function(t,e,r,n){Ge(t,e,r,n)},updatePoi:function(t,e,r,n){Ie(t,e,r,n)},delete:function(t){Te(t)},remove:function(t,e){_e(t,e)},blink:function(t,e){Re(t,e)},unblink:function(t,e){Ce(t,e)},setVisible:function(t,e){Ae(t,e)},setInvisible:function(t,e){Ee(t,e)},attachTooltip:function(t,e,r,n,i){var a=t.db.overlays.poi[e];x.isString(r)&&x.isString(n)&&x.isString(i)&&a&&(a.tooltip={xmlString:r,width:n,height:i})},update:function(t,e,r){je.updateSizeAndPosition(t,e,r)},highlight:function(t,e,r,n){je.highlight(t,e,r,n)},tunedown:function(t,e,r){je.tunedown(t,e,r)},getCenterOverlay:function(t){return Ve.getCenterOverlay(t)},getBoundingBox:function(t){return Ve.getBoundingBox(t)}}),qe=m.Overlays.Events,Ye=m.easing,We=m.Tooltip.Public,He=m.Overlays.Public,Qe=m.Maps.Core.Public,Ze=function(t,e,r,n,i){var a,o,s,l,c=r.mess,u=r.map,h=r.opts,d=r.overlays,f=n.target.id.slice(1),p=d.poi[f];n.stopPropagation(),h.chart.boundingBoxes=t[0].getBoundingClientRect(),o=Qe.getMouseOrFingerPositionOnMap(n,u,h),l=e.getLatLongFromXY(o.x,o.y),s={x:o.x,y:o.y,latitude:l.φ,longitude:l.λ},a={id:f,title:p.title,style:p.style?p.style:{},over:p.over?p.over:{},geometry:p.geometry,properties:p.properties},c.fire(i,{chart:{id:t.id},overlay:a,cursor:s}),"click"===i&&m.touchDblClick(function(){c.fire("dblclick",{chart:{id:t.id},overlay:a,cursor:s})})},Xe=function(t,e){var i,r=t.chart,n=t.mapgl,a=t.db,o=a.mess,s=a.map,l=a.opts,c=a.tooltip,u=e.target,h=u.id.slice(1),d=a.overlays.poi[h],f=l.tooltip.animated,p=Ye.easeOutBack;l.chart.boundingBoxes=r[0].getBoundingClientRect(),He.highlight(r,n,a,h),d.tooltip=void 0,Ze(r,n,a,e,"overlayover"),u.onmousemove=function(t){var e,r,n;if(l.tooltip.enabled){if(e=Qe.getMouseOrFingerPositionOnChart(t,s,l),(r=We.create()).params.type="horizontal",r.animation.animate=f,r.animation.easing=p,r.animation.framesPerSecond=50,r.animation.duration=750,r.frameColor="Polyline"===d.geometry.type?d.style.strokeColor:d.style.fillColor,r.title=d.title,x.isArray(d.properties))for(n=0;n<d.properties.length;n++)r.content.push(d.properties[n]);else for(i=Object.keys(d.properties),n=0;n<i.length;n++)r.content.push({label:i[n],value:d.properties[i[n]],color:d.style.fillColor});r.anchor={x:e.x,y:e.y-5},r.limits={max:{x:l.chart.width,y:1.5*l.chart.grid.height},min:{x:0,y:0}},c.custom=void 0,d.tooltip&&(c.custom=d.tooltip),We.moveTo(c,r,o,l)}}},De=function(t,e){var r=t.chart,n=t.mapgl,i=t.db,a=i.mess,o=i.tooltip,s=e.target.id.slice(1);He.tunedown(r,i,s),Ze(r,n,i,e,"overlayout"),We.remove(o,a)},x.extend(qe,{mouseOver:function(t){Xe(this,t)},mouseOut:function(t){De(this,t)},click:function(t){Ze(this.chart,this.mapgl,this.db,t,"click")},dblClick:function(t){Ze(this.chart,this.mapgl,this.db,t,"dblclick")}}),mr=m.Overlays.Renderer,yr=m.Overlays.Util,Ke=function(t,e){var r,n,i=t.getLatLongFromXY(0,0),a=t.getLatLongFromXY(e.opts.chart.width,e.opts.chart.height);r=.1*(i.φ-a.φ),n=a.λ>=i.λ?.1*(a.λ-i.λ):.1*(360-(a.λ-i.λ)),e.opts.chart.viewport.φ.top=i.φ+r,e.opts.chart.viewport.φ.bottom=a.φ-r,e.opts.chart.viewport.λ.left=i.λ-n,e.opts.chart.viewport.λ.right=a.λ+n},Je=function(t,e){return!t.visibilityRange||!!(e>=t.visibilityRange.minZoom&&e<=t.visibilityRange.maxZoom)},$e=function(t,e,r){var n,i,a,o,s;for(n="",s=0;s<e.length;s++)a="px"===r?(i=e[s][0],e[s][1]):(i=(o=t.getXYFromLatLong(e[s][0],e[s][1])).x,o.y),""===n?n="M"+i+","+a:n+="L"+i+","+a;return n},tr=function(t,e,r){var n,i;for(n="",i=0;i<e.length;i++)n+=$e(t,e[i],r),n+="z";return n},er=function(t,e){var r,n;switch(e.type){case"Polyline":r=$e(t,e.coordinates,e.unit);break;case"Polygon":r=tr(t,e.coordinates,e.unit);break;case"MultiPolygon":for(r="",n=0;n<e.coordinates.length;n++)r+=tr(t,e.coordinates[n],e.unit);break;default:throw new Error('overlay._toPath: the type "'+e.type+'" is unknown!')}return r},rr=function(t,e,r,n,i){var a,o,s,l,c,u,h,d=r.overlays.poi,f=r.overlays.handlers,p=r.opts.chart.viewport;if(0!==n.length){for(t.select(".series").select(".overlay").select("."+i.toLowerCase()),h=0;h<n.length;h++)o=(a=d[n[h]]).style||{},s=yr.isInsideViewport(e,p,a),u=er(e,a.geometry),c=t.query("#i"+n[h]),l=!!s&&!a.hidden&&Je(a,r.map.params.zoom),c?l?t.select("#i"+n[h]).attr("d",u).attr("fill",o.fillColor).attr("fill-opacity",o.fillOpacity).attr("stroke",o.strokeColor).attr("stroke-opacity",o.strokeOpacity).attr("stroke-width",o.strokeWidth).attr("style","visibility: visible").parent():t.select("#i"+n[h]).attr("style","visibility: hidden").parent():t.append("path").attr("id","i"+n[h]).attr("d",u).attr("fill",o.fillColor).attr("fill-opacity",o.fillOpacity).attr("stroke",o.strokeColor).attr("stroke-opacity",o.strokeOpacity).attr("stroke-width",o.strokeWidth).attr("style",l?"visibility: visible":"visibility: hidden").parent();for(t.firstParent(),t.select(".activearea").select(".activezone").select("."+i.toLowerCase()),h=0;h<n.length;h++)o=(a=d[n[h]]).style||{},s=yr.isInsideViewport(e,p,a),u=er(e,a.geometry),c=t.query("#i"+n[h]),l=!!s&&!a.hidden&&Je(a,r.map.params.zoom),c?l?t.select("#i"+n[h]).attr("d",u).attr("style","visibility: visible").parent():t.select("#i"+n[h]).attr("style","visibility: hidden").parent():t.append("path").attr("id","i"+n[h]).attr("d",u).listen("mouseover",f.mouseOver).listen("mouseout",f.mouseOut).listen("click",f.click).listen("dblclick",f.dblClick).attr("style",l?"visibility: visible":"visibility: hidden").parent();t.firstParent()}},nr=function(t,e,r,n,i,a){var o,s,l=n.geometry.coordinates[0],c=n.geometry.coordinates[1],u=e.getXYFromLatLong(l,c),h=r.overlays.handlers,d=n.style||{},f=r.opts.chart.viewport,p=yr.isInsideViewport(e,f,n);t.select(".series").select(".overlay").select(".point").attr("transform","translate(0, 0) scale(1, 1)"),s=t.query("#i"+i),o=!!p&&!n.hidden&&Je(n,r.map.params.zoom),s?o?t.select("#i"+i).attr("cx",u.x).attr("cy",u.y).attr("r",n.geometry.radius).attr("fill",d.fillColor).attr("fill-opacity",d.fillOpacity).attr("stroke",d.strokeColor).attr("stroke-opacity",d.strokeOpacity).attr("stroke-width",d.strokeWidth).attr("style","visibility: visible").firstParent():t.select("#i"+i).attr("style","visibility: hidden").parent():t.append("circle").attr("id","i"+i).attr("cx",u.x).attr("cy",u.y).attr("r",n.geometry.radius).attr("fill",d.fillColor).attr("fill-opacity",d.fillOpacity).attr("stroke",d.strokeColor).attr("stroke-opacity",d.strokeOpacity).attr("stroke-width",d.strokeWidth).attr("style","visible").firstParent(),a||(t.select(".activearea").select(".activezone").select(".point").attr("transform","translate(0, 0) scale(1, 1)"),s?o?t.select("#i"+i).attr("cx",u.x).attr("cy",u.y).attr("r",n.geometry.radius).attr("stroke-width",d.strokeWidth).attr("style","visibility: visible"):t.select("#i"+i).attr("style","visibility: hidden"):t.append("circle").attr("id","i"+i).attr("cx",u.x).attr("cy",u.y).attr("r",n.geometry.radius).listen("mouseover",h.mouseOver).listen("mouseout",h.mouseOut).listen("click",h.click).listen("dblclick",h.dblClick).attr("stroke-width",d.strokeWidth).attr("style","visible"),t.firstParent())},ir=function(t,e,r,n,i){var a,o,s,l,c,u,h,d,f,p=r.overlays.poi,m=r.overlays.handlers,y=r.opts.chart.viewport;if(0!==n.length){for(t.select(".series").select(".overlay").select(".point").attr("transform","translate(0, 0) scale(1, 1)"),f=0;f<n.length;f++)o=(a=p[n[f]]).geometry.coordinates[0],s=a.geometry.coordinates[1],l=e.getXYFromLatLong(o,s),c=a.style||{},u=yr.isInsideViewport(e,y,a),d=t.query("#i"+n[f]),h=!!u&&!a.hidden&&Je(a,r.map.params.zoom),d?h?t.select("#i"+n[f]).attr("cx",l.x).attr("cy",l.y).attr("r",a.geometry.radius).attr("fill",c.fillColor).attr("fill-opacity",c.fillOpacity).attr("stroke",c.strokeColor).attr("stroke-opacity",c.strokeOpacity).attr("stroke-width",c.strokeWidth).attr("style","visibility: visible").parent():t.select("#i"+n[f]).attr("style","visibility: hidden").parent():t.append("circle").attr("id","i"+n[f]).attr("cx",l.x).attr("cy",l.y).attr("r",a.geometry.radius).attr("fill",c.fillColor).attr("fill-opacity",c.fillOpacity).attr("stroke",c.strokeColor).attr("stroke-opacity",c.strokeOpacity).attr("stroke-width",c.strokeWidth).attr("style",h?"visibility: visible":"visibility: hidden").parent();if(t.firstParent(),!i){for(t.select(".activearea").select(".activezone").select(".point").attr("transform","translate(0, 0) scale(1, 1)"),f=0;f<n.length;f++)o=(a=p[n[f]]).geometry.coordinates[0],s=a.geometry.coordinates[1],l=e.getXYFromLatLong(o,s),c=a.style||{},u=yr.isInsideViewport(e,y,a),d=t.query("#i"+n[f]),h=!!u&&!a.hidden&&Je(a,r.map.params.zoom),d?h?t.select("#i"+n[f]).attr("cx",l.x).attr("cy",l.y).attr("r",a.geometry.radius).attr("stroke-width",c.strokeWidth).attr("style","visibility: visible").parent():t.select("#i"+n[f]).attr("style","visibility: hidden").parent():t.append("circle").attr("id","i"+n[f]).attr("cx",l.x).attr("cy",l.y).attr("r",a.geometry.radius).attr("stroke-width",c.strokeWidth).listen("mouseover",m.mouseOver).listen("mouseout",m.mouseOut).listen("click",m.click).listen("dblclick",m.dblClick).attr("style",h?"visibility: visible":"visibility: hidden").parent();t.firstParent()}}},ar=function(t,e,r,n){var i,a,o,s,l,c,u,h,d,f,p,m,y=r.overlays.poi,g=r.overlays.handlers,x=r.opts.chart.viewport;if(0!==n.length){for(t.select(".series").select(".overlay").select(".icon").attr("transform","translate(0, 0) scale(1, 1)"),m=0;m<n.length;m++)a=(i=y[n[m]]).geometry.coordinates[0],o=i.geometry.coordinates[1],s=e.getXYFromLatLong(a,o),l=i.style||{},c=yr.isInsideViewport(e,x,i),p="translate("+(d=s.x-i.geometry.shape.width/2)+" "+(f=s.y-i.geometry.shape.height/2)+")",h=t.query("#i"+n[m]),u=!!c&&!i.hidden&&Je(i,r.map.params.zoom),h?u?t.select("#i"+n[m]).attr("transform",p).select(".r").attr("fill",l.backgroundColor).attr("fill-opacity",l.backgroundOpacity).parent().select(".ic").attr("d",i.geometry.shape.path).attr("fill",l.fillColor).attr("fill-opacity",l.fillOpacity).attr("stroke",l.strokeColor).attr("stroke-opacity",l.strokeOpacity).attr("stroke-width",l.strokeWidth).parent().attr("style","visibility: visible").parent():t.select("#i"+n[m]).attr("style","visibility: hidden").parent():t.append("g").attr("id","i"+n[m]).attr("transform",p).append("rect").attr("class","r").attr("x",0).attr("y",0).attr("width",i.geometry.shape.width+4).attr("height",i.geometry.shape.height+4).attr("fill",l.backgroundColor).attr("fill-opacity",l.backgroundOpacity).parent().append("path").attr("class","ic").attr("transform","translate(2, 2)").attr("d",i.geometry.shape.path).attr("fill",l.fillColor).attr("fill-opacity",l.fillOpacity).attr("stroke",l.strokeColor).attr("stroke-opacity",l.strokeOpacity).attr("stroke-width",l.strokeWidth).parent().attr("style",u?"visibility: visible":"visibility: hidden").parent();for(t.firstParent(),t.select(".activearea").select(".activezone").select(".icon").attr("transform","translate(0, 0) scale(1, 1)"),m=0;m<n.length;m++)a=(i=y[n[m]]).geometry.coordinates[0],o=i.geometry.coordinates[1],s=e.getXYFromLatLong(a,o),l=i.style||{},c=yr.isInsideViewport(e,x,i),d=s.x-i.geometry.shape.width/2,f=s.y-i.geometry.shape.height/2,h=t.query("#i"+n[m]),u=!!c&&!i.hidden&&Je(i,r.map.params.zoom),h?u?t.select("#i"+n[m]).attr("x",d-2).attr("y",f-2).attr("stroke-width",l.strokeWidth).attr("style","visibility: visible").parent():t.select("#i"+n[m]).attr("style","visibility: hidden").parent():t.append("rect").attr("id","i"+n[m]).attr("x",d-2).attr("y",f-2).attr("width",i.geometry.shape.width+4).attr("height",i.geometry.shape.height+4).attr("stroke-width",l.strokeWidth).listen("mouseover",g.mouseOver).listen("mouseout",g.mouseOut).listen("click",g.click).listen("dblclick",g.dblClick).attr("style",u?"visibility: visible":"visibility: hidden").parent();t.firstParent()}},or=function(t,e,r){var n=e.map,i=n.params.zoom,a=n.origin.x+n.params.shift.x,o=n.origin.y+n.params.shift.y;t.select(".series").select(".overlay").select("."+r.toLowerCase()).attr("transform","translate("+a+", "+o+") scale("+i+", "+i+")").firstParent().select(".activearea").select(".activezone").select("."+r.toLowerCase()).attr("transform","translate("+a+", "+o+") scale("+i+", "+i+")").firstParent()},sr=function(t,e,r,n){var i,a,o,s=[],l=[],c=[],u=[],h=[];for(o=0;o<n.length;o++)switch(a=n[o],(i=r.overlays.poi[a].geometry).type){case"MultiPolygon":s.push(a);break;case"Polygon":l.push(a);break;case"Polyline":c.push(a);break;case"Point":u.push(a);break;case"Icon":h.push(a);break;default:throw new Error('renderer._add: the type "'+i.type+'" is unknown!')}rr(t,e,r,s,"MultiPolygon"),rr(t,e,r,l,"Polygon"),rr(t,e,r,c,"Polyline"),ir(t,e,r,u),ar(t,e,r,h)},lr=function(t,e,r){var n,i,a=r.map,o=Object.keys(r.overlays.poi),s=[],l=[],c=[],u=[],h=[];for(i=0;i<o.length;i++)switch(n=r.overlays.poi[o[i]].geometry.type,a.type){case"geojson":switch(n){case"MultiPolygon":case"Polygon":case"Polyline":or(t,r,n);break;case"Point":u.push(o[i]);break;case"Icon":h.push(o[i]);break;default:throw new Error('_updateSizeAndPosition: the geometry type "'+n+'" is not supported for GeoJSON map!')}break;case"raster":case"vector":switch(n){case"MultiPolygon":s.push(o[i]);break;case"Polygon":l.push(o[i]);break;case"Polyline":c.push(o[i]);break;case"Point":u.push(o[i]);break;case"Icon":h.push(o[i]);break;default:throw new Error('_updateSizeAndPosition: the geometry type "'+n+'" is unknown!')}break;default:throw new Error('_updateSizeAndPosition: the type "'+a.type+'" is unknown!')}rr(t,e,r,s,"MultiPolygon"),rr(t,e,r,l,"Polygon"),rr(t,e,r,c,"Polyline"),ir(t,e,r,u),ar(t,e,r,h)},cr=function(t,e,r){t.select(".series").select(".overlay").select("."+e.toLowerCase()).select("#i"+r).remove().firstParent(),t.select(".activearea").select(".activezone").select("."+e.toLowerCase()).select("#i"+r).remove().firstParent()},ur=function(t,e,r,n){var i,a=r.overlays.poi[n];i={style:{fillColor:"transparent",strokeColor:a.style.fillColor,strokeWidth:4,strokeOpacity:.35},geometry:{type:"Point",radius:a.geometry.radius+3,coordinates:a.geometry.coordinates}},nr(t,e,r,i,"halo",!0)},hr=function(t,e,r,n){var i=r||{};switch(e){case"MultiPolygon":case"Polygon":case"Polyline":t.select(".series").select(".overlay").select("."+e.toLowerCase()).select("#i"+n).attr("fill",i.fillColor).attr("fill-opacity",i.fillOpacity).attr("stroke",i.strokeColor).attr("stroke-opacity",i.strokeOpacity).attr("stroke-width",i.strokeWidth).firstParent();break;case"Icon":t.select(".series").select(".overlay").select("."+e.toLowerCase()).select("#i"+n).select(".r").attr("fill",i.backgroundColor).attr("fill-opacity",i.backgroundOpacity).parent().select(".ic").attr("fill",i.fillColor).attr("fill-opacity",i.fillOpacity).attr("stroke",i.strokeColor).attr("stroke-opacity",i.strokeOpacity).attr("stroke-width",i.strokeWidth).firstParent()}},dr=function(t,e,r,n){var i=r.overlays.poi[n];switch(i.geometry.type){case"MultiPolygon":hr(t,"MultiPolygon",r.overlays.poi[n].over,n);break;case"Polygon":hr(t,"Polygon",r.overlays.poi[n].over,n);break;case"Polyline":hr(t,"Polyline",r.overlays.poi[n].over,n);break;case"Point":ur(t,e,r,n);break;case"Icon":hr(t,"Icon",r.overlays.poi[n].over,n);break;default:throw new Error('_highlight: the type "'+i.geometry.type+'"is unknown!')}},fr=function(t,e,r){var n=e.overlays.poi[r];switch(n.geometry.type){case"MultiPolygon":hr(t,"MultiPolygon",e.overlays.poi[r].style,r);break;case"Polygon":hr(t,"Polygon",e.overlays.poi[r].style,r);break;case"Polyline":hr(t,"Polyline",e.overlays.poi[r].style,r);break;case"Point":cr(t,"Point","halo");break;case"Icon":hr(t,"Icon",e.overlays.poi[r].style,r);break;default:throw new Error('_tunedown: the type "'+n.geometry.type+'"is unknown!')}},pr=function(t,e,r,n,i,a){var o;o=!!yr.isInsideViewport(e,r.opts.chart.viewport,n)&&"hidden"!==a&&Je(n,r.map.params.zoom),t.select(".series").select(".overlay").select("."+n.geometry.type.toLowerCase()).select("#i"+i).attr("style",o?"visibility: visible":"visibility: hidden").firstParent(),t.select(".activearea").select(".activezone").select("."+n.geometry.type.toLowerCase()).select("#i"+i).attr("style",o?"visibility: visible":"visibility: hidden").firstParent()},x.extend(mr,{add:function(t,e,r,n){Ke(e,r),sr(t,e,r,n)},updateSizeAndPosition:function(t,e,r){Ke(e,r),lr(t,e,r)},remove:function(t,e,r){cr(t,e,r)},highlight:function(t,e,r,n){dr(t,e,r,n)},tunedown:function(t,e,r){fr(t,e,r)},turnOn:function(t,e,r,n,i){pr(t,e,r,n,i,"visible")},turnOff:function(t,e,r,n,i){pr(t,e,r,n,i,"hidden")}}),Pr=m.Overlays.Util,gr=function(t){var e,r,n,i,a,o;for(r=t.length,o=e=0;o<r-1;o++)e+=t[o][0]*t[o+1][1]-t[o+1][0]*t[o][1];for(e*=.5,o=i=n=0;o<r-1;o++)a=t[o][0]*t[o+1][1]-t[o+1][0]*t[o][1],n+=(t[o][0]+t[o+1][0])*a,i+=(t[o][1]+t[o+1][1])*a;return{x:n*=1/(6*e),y:i*=1/(6*e)}},xr=function(t){var e;switch(t.geometry.type){case"MultiPolygon":return e=gr(t.geometry.coordinates[0][0]),(x.isNaN(e.x)||x.isNaN(e.y))&&(e.x=t.geometry.coordinates[0][0][0][0],e.y=t.geometry.coordinates[0][0][0][1]),{"φ":e.x,"λ":e.y};case"Polygon":return{"φ":(e=gr(t.geometry.coordinates[0])).x,"λ":e.y};case"Point":return{"φ":t.geometry.coordinates[0],"λ":t.geometry.coordinates[1]};default:return{"φ":0,"λ":0}}},br=function(t){var e,r;for(e={x:{min:999999,max:-999999},y:{min:999999,max:-999999}},r=0;r<t.length;r++)t[r][0]<e.x.min&&(e.x.min=t[r][0]),t[r][0]>e.x.max&&(e.x.max=t[r][0]),t[r][1]<e.y.min&&(e.y.min=t[r][1]),t[r][1]>e.y.max&&(e.y.max=t[r][1]);return e},vr=function(t){var e,r,n;for(e={x:{min:999999,max:-999999},y:{min:999999,max:-999999}},n=0;n<t.length;n++)(r=br(t[n])).x.min<e.x.min&&(e.x.min=r.x.min),r.x.max>e.x.max&&(e.x.max=r.x.max),r.y.min<e.y.min&&(e.y.min=r.y.min),r.y.max>e.y.max&&(e.y.max=r.y.max);return e},wr=function(t){var e,r,n;for(e={x:{min:999999,max:-999999},y:{min:999999,max:-999999}},n=0;n<t.length;n++)(r=vr(t[n])).x.min<e.x.min&&(e.x.min=r.x.min),r.x.max>e.x.max&&(e.x.max=r.x.max),r.y.min<e.y.min&&(e.y.min=r.y.min),r.y.max>e.y.max&&(e.y.max=r.y.max);return e},kr=function(t){var e;switch(t.geometry.type){case"MultiPolygon":e=wr(t.geometry.coordinates);break;case"Polygon":e=vr(t.geometry.coordinates);break;case"Polyline":e=br(t.geometry.coordinates);break;case"Point":case"Icon":e={y:{min:null,max:null},x:{max:null,min:null}};break;default:throw new Error('_getBoundingBox: the type "'+t.geometry.type+'" is unknown!')}return{left:e.y.min,right:e.y.max,top:e.x.max,bottom:e.x.min}},zr=function(t,e,r){var n,i,a,o;for(o=0;o<r.length;o++)"px"===e[r[o]].geometry.unit?(n=kr(e[r[o]]),i=t.getLatLongFromXY(n.top,n.left),a=t.getLatLongFromXY(n.bottom,n.right),e[r[o]].geometry.bbox={"φ":{top:i.φ,bottom:a.φ},"λ":{left:i.λ,right:a.λ}}):(n=kr(e[r[o]]),e[r[o]].geometry.bbox={"φ":{top:n.top,bottom:n.bottom},"λ":{left:n.left,right:n.right}})},Mr=function(t){var e=t.geometry.bbox;return{left:e.λ.left,right:e.λ.right,top:e.φ.top,bottom:e.φ.bottom}},Sr=function(t,e,r){return!(e>t.φ.top||e<t.φ.bottom)&&(t.λ.right>=t.λ.left?!(r<t.λ.left||r>t.λ.right):0<=r?r>=t.λ.left:r<=t.λ.right)},Lr=function(t,e){var r,n,i=e.geometry.bbox;switch(e.geometry.type){case"MultiPolygon":case"Polygon":case"Polyline":return!(i.φ.bottom>t.φ.top||i.φ.top<t.φ.bottom||i.λ.right<t.λ.left||i.λ.left>t.λ.right);case"Point":case"Icon":return r=e.geometry.coordinates[0],n=e.geometry.coordinates[1],Sr(t,r,n);default:throw new Error('_isInsideViewport: the type "'+e.geometry.type+'" is not supported!')}},x.extend(Pr,{getCenterOverlay:function(t){return xr(t)},computeBoundingBox:function(t,e,r){zr(t,e,r)},getBoundingBox:function(t){return Mr(t)},isInsideViewport:function(t,e,r){return"geojson"===t.type||Lr(e,r)}}),Tr=m.Tooltip.Public,Ir=m.easing,Gr=m.Tooltip.Renderer,Or=function(){return{frame:[],frameColor:"slategrey",hide:!1,title:null,content:[],animation:{animate:!1,easing:Ir.linear,framesPerSecond:50,duration:1e3},params:{type:null,symmetry:null,shift:null},anchor:{x:null,y:null},shift:{x:null,y:null},outerbbox:{x:null,y:null},bbox:{width:null,height:null},limits:{min:{x:0,y:0},max:{x:0,y:0}},custom:null}},Er=function(e){var t,r=[{x:0,y:0},{x:e.bbox.width,y:0},{x:e.bbox.width,y:e.bbox.height},{x:e.bbox.width/2+7.5,y:e.bbox.height},{x:e.bbox.width/2,y:e.bbox.height+7.5},{x:e.bbox.width/2-7.5,y:e.bbox.height},{x:0,y:e.bbox.height}],n=[{x:0,y:0},{x:e.bbox.width,y:0},{x:e.bbox.width,y:e.bbox.height},{x:0,y:e.bbox.height},{x:0,y:e.bbox.height/2+7.5},{x:-7.5,y:e.bbox.height/2},{x:0,y:e.bbox.height/2-7.5}];switch(e.params.type){case"horizontal":e.frame=r,"horizontal"===e.params.symmetry?(e.frame.forEach(function(t){t.y=e.bbox.height-t.y}),e.shift.x=-e.bbox.width/2,e.shift.y=7.5):(e.shift.x=-e.bbox.width/2,e.shift.y=-(e.bbox.height+7.5+2)),"left"===e.params.shift?(e.frame[3].x=30,e.frame[4].x=22.5,e.frame[5].x=15,e.shift.x=-22.5):"right"===e.params.shift&&(e.frame[3].x=e.bbox.width-15,e.frame[4].x=e.bbox.width-22.5,e.frame[5].x=e.bbox.width-30,e.shift.x=-(e.bbox.width-22.5)),e.outerbbox={x:e.bbox.width,y:e.bbox.height+7.5};break;case"vertical":e.frame=n,"vertical"===e.params.symmetry?(e.frame.forEach(function(t){t.x=e.bbox.width-t.x}),e.shift.x=-(e.bbox.width+7.5+3)):e.shift.x=7.5,e.shift.y=-e.bbox.height/2,"top"===e.params.shift?(e.frame[4].y=30,e.frame[5].y=22.5,e.frame[6].y=15,e.shift.y=-22.5):"bottom"===e.params.shift&&(e.frame[4].y=e.bbox.height-15,e.frame[5].y=e.bbox.height-15-7.5,e.frame[6].y=e.bbox.height-15-7.5-7.5,e.shift.y=-(e.bbox.height-15-7.5)),e.outerbbox={x:e.bbox.width+7.5,y:e.bbox.height};break;default:throw new Error('_createGeometry: the type "'+e.params.type+'" is unknown!')}for(t=0;t<e.frame.length;t++)e.frame[t]={x:Math.round(e.frame[t].x)+.5,y:Math.round(e.frame[t].y)+.5}},Ar=function(t,e,r,n){switch(e.chart.type){case"basic column":case"stacked column":case"basic bar":case"stacked bar":case"line":case"basic area":case"stacked area":case"percent area":case"radar":case"pie":case"polar":case"waterfall":case"map":Er(t),x.isFunction(t.anchor.x)&&(t.anchor.x=t.anchor.x()),x.isFunction(t.anchor.y)&&(t.anchor.y=t.anchor.y()),"horizontal"===t.params.type?(t.anchor.x+t.outerbbox.x/2>t.limits.max.x?t.params.shift="right":t.anchor.x-t.outerbbox.x/2<t.limits.min.x&&(t.params.shift="left"),Math.abs(t.anchor.y)+t.outerbbox.y>t.limits.max.y&&(t.params.symmetry="horizontal")):(t.anchor.x+t.outerbbox.x>t.limits.max.x&&(t.params.symmetry="vertical"),Math.abs(t.anchor.y)+t.outerbbox.y/2>t.limits.max.y?t.params.shift="top":Math.abs(t.anchor.y)-t.outerbbox.y/2<t.limits.min.y&&(t.params.shift="bottom")),null===t.params.symmetry&&null===t.params.shift||Er(t),0===r&&0===n&&(t.animation.animate=!1);break;default:throw t.anchor.x=0,t.anchor.y=0,Er(t),new Error('_computePosition: the type "'+e.chart.type+'" is unknown!')}},Cr=function(t,e,r){var n;if(0===e.duration)return t.x=e.end.x,t.y=e.end.y,Gr.move(t.chart,t.x,t.y),void(r&&r());n=setInterval(function(){e.t+=e.frequency,e.t>e.duration&&(e.t=e.duration),t.x=e.easing(e.t,e.start.x,e.end.x-e.start.x,e.duration),t.y=e.easing(e.t,e.start.y,e.end.y-e.start.y,e.duration),Gr.move(t.chart,t.x,t.y),e.t===e.duration&&(clearInterval(n),r&&r())},e.frequency)},Rr=function(t,e,r,n){var i,a=e.animation.animate,o=e.animation.duration;Gr.draw(t,e,r,Ar),i={start:{x:t.x,y:t.y},end:{x:Math.round(r.chart.grid.x+e.anchor.x+e.shift.x),y:Math.round(r.chart.grid.y+e.anchor.y+e.shift.y)},t:0,easing:e.animation.easing,duration:a?o:0,frequency:1e3/e.animation.framesPerSecond},Cr(t,i,n)},_r=function(t,e){var r,n=Or();r={start:{x:t.x,y:t.y},end:{x:t.x,y:t.y},t:0,easing:n.animation.easing,duration:n.animation.duration/2,frequency:1e3/n.animation.framesPerSecond},Cr(t,r,function(){Gr.remove(t.chart),e()})},x.extend(Tr,{create:function(){return Or()},moveTo:function(e,r,t,n){t.ql("tooltip",function(t){Rr(e,r,n,t)})},remove:function(e,t){t.ql("tooltip",function(t){_r(e,t)})},hide:function(t){Gr.hide(t)},release:function(t){Gr.release(t)}}),qr=m.Tooltip.Renderer,Nr=function(t,e,r){t.select(".tooltip").attr("transform","translate("+e+", "+r+")").removeAllChilds().append("path").attr("class","shadow1").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.05").attr("stroke-width","5").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow2").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.1").attr("stroke-width","3").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow3").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.15").attr("stroke-width","1").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","frame").attr("stroke-width","1").attr("d","M0,0L1,0L1,1L0,1L0,0").parent()},Fr=function(t,e){var r=0;return x.isNull(e.title)||(t.append("text").attr("class","title").attr("x",5).attr("y",15).text(e.title).parent(),r=15),r},Br=function(t,e,r){var n;for(n=0;n<e.content.length;n++)x.isObject(e.content[n])?(t.append("circle").attr("cx",8).attr("cy",15*(n+1)-3+r).attr("r",3),e.content[n].color&&t.attr("style","fill: "+e.content[n].color),t.parent().append("text").attr("class","label n"+n).attr("x",16).attr("y",15*(n+1)+r).append("tspan").attr("class","item").text(e.content[n].label+": ").parent().append("tspan").attr("class","value").text(e.content[n].value).parent().parent()):t.append("text").attr("class","label n"+n).attr("x",10).attr("y",15*(n+1)+r).append("tspan").attr("class","item").text("").parent().append("tspan").attr("class","value").text(e.content[n]).parent().parent(),e.content[n].suffix&&(e.content[n].suffix.first&&t.select(".label.n"+n).append("tspan").attr("class","firstsuffix").text(e.content[n].suffix.first).parent().parent(),e.content[n].suffix.second&&t.select(".label.n"+n).append("tspan").attr("class","secondsuffix").text(e.content[n].suffix.second).parent().parent())},Ur=function(t,e,r,n){var i,a=t.chart;Nr(a,t.x,t.y),i=Fr(a,e),Br(a,e,i),e.bbox.width=1.1*a[0].getBoundingClientRect().width,e.bbox.height=1.1*a[0].getBoundingClientRect().height,n(e,r,t.x,t.y),a.select(".shadow1").attr("d",h.draw.line(e.frame,!0)).parent().select(".shadow2").attr("d",h.draw.line(e.frame,!0)).parent().select(".shadow3").attr("d",h.draw.line(e.frame,!0)).parent().select(".frame").attr("stroke",e.frameColor).attr("d",h.draw.line(e.frame,!0)).parent().parent()},jr=function(t,e){var r=t.chart,n=t.custom;r.select(".tooltip").removeAllChilds().append("foreignObject").attr("class","foreign").attr("width",n.width).attr("height",n.height).appendHTML(n.xmlString).parent().parent().parent(),e.bbox.width=parseInt(n.width,10),e.bbox.height=parseInt(n.height,10),x.isFunction(e.anchor.x)&&(e.anchor.x=e.anchor.x()),x.isFunction(e.anchor.y)&&(e.anchor.y=e.anchor.y()),e.shift.x=-parseInt(n.width,10)/2,e.shift.y=-(parseInt(n.height,10)+5)},Vr=function(t,e,r){t.select(".tooltip").attr("transform","translate("+e+", "+r+")").parent()},Zr=function(t){t.select(".tooltip").removeAllChilds().parent()},Dr=function(t){t.select(".tooltip").attr("style","visibility: hidden").parent()},Xr=function(t){t.select(".tooltip").attr("style","visibility: visible").parent()},x.extend(qr,{draw:function(t,e,r,n){t.custom?jr(t,e):Ur(t,e,r,n)},move:function(t,e,r){Vr(t,e,r)},remove:function(t){Zr(t)},hide:function(t){Dr(t)},release:function(t){Xr(t)}}),(Yr=x).extend(Yr,{load:function(t,e){var r=new XMLHttpRequest;r.onreadystatechange=function(){4===r.readyState&&(200===r.status||0===r.status?e(!1,r,r.responseText):e(!0,r))},r.open("GET",t,!0),r.send(null)}}),Hr=m.Maps.GeoJSON.Public,Qr=m.Maps.Raster.Public,Kr=m.Maps.Vector.Public,e.Map=function(t){var e=Object.create(Wr);return e.id=t||"body",e.chart=h(t),e.mapgl=null,e.db={series:null,opts:null,tooltip:null,mess:null},e},Wr={draw:function(t,e,r){switch(t.type){case"geojson":return Hr.create(this,t,e,r);case"raster":return Qr.create(this,t,e,r);case"vector":return Kr.create(this,t,e,r);default:throw new Error('The map "'+t.type+'" is unknown!')}}},e});