/*! ****************************************************************************
 * Pixi Charts v1.1.0
 *
 * A collection of SVG Charts written in vanilla Javascript.
 * Copyright (c) 2020 Mobilabs <contact@mobilabs.fr> (http://www.mobilabs.fr).
 * Released under the MIT license. You may obtain a copy of the License
 * at: http://www.opensource.org/licenses/mit-license.php).
 *
 * Pixi includes portions of code for easing equations.
 * Open source under the BSD License.
 * Copyright (c) 2001 Robert Penner
 * ************************************************************************** */
!function(t,e){"use strict";"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?module.exports=e(t):t.Pixi=e(t)}(this,t=>{"use strict";let e,a,r={src:{tree:{},pixi:{},pixichart:{},util:{deviceutil:{},util1:{},util2:{}},lib:{Easing:null,Messenger:null,overslash:null,SVG:null,TaskQ:null},libin:{Chart:null,Copyright:null,Legend:null,Snapshot:null,Tooltip:null},charts:{_chart:{main:{},renderer:{},mouseevents:{},util:{}},classic:{area:{main:{},renderer:{},util:{}},bar:{main:{},renderer:{},util:{}},barchartrace:{main:{},renderer:{},bar:{},counter:{},util:{}},circle:{main:{},renderer:{},util:{}},column:{main:{},renderer:{},util:{}},gauge:{main:{},renderer:{},util:{}},line:{main:{},renderer:{},util:{}},pie:{main:{},renderer:{},util:{}},polar:{main:{},renderer:{},util:{}},radar:{main:{},renderer:{},util:{}}},financial:{waterfall:{main:{},renderer:{},util:{}}}}},extend:function(t,e){for(var a=Object.keys(e),r=0;r<a.length;r++)t[a[r]]=e[a[r]]}};const i={isThisATouchDevice:!1,enableTouchDevice:null,touchDblClick:null,touchClickTimer:null};return function(){const a=t.Pixi;e={_setTestMode:()=>i,noConflict(){return t.Pixi=a,this},load(t,e){const a=new XMLHttpRequest;a.onreadystatechange=function(){4===a.readyState&&(200===a.status||0===a.status?e(!1,a,a.responseText):e(!0,a))},a.open("GET",t,!0),a.send(null)}},e.VERSION="1.1.0"}(),function(){const t=r.src.charts.classic.area.main,a=r.src.charts.classic.bar.main,i=r.src.charts.classic.barchartrace.main,n=r.src.charts.classic.circle.main,s=r.src.charts.classic.column.main,l=r.src.charts.classic.gauge.main,o=r.src.charts.classic.line.main,c=r.src.charts.classic.pie.main,h=r.src.charts.classic.polar.main,d=r.src.charts.classic.radar.main,u=r.src.charts.financial.waterfall.main;e.Chart=function(...e){return function(...e){const[r,x,p,y]=e,g="[object String]"===Object.prototype.toString.call(r)?r:"body";switch(x){case"area":return t.Area(g,p,y);case"bar":return a.Bar(g,p,y);case"barchartrace":return i.BarChartRace(g,p,y);case"circle":return n.Circle(g,p,y);case"column":return s.Column(g,p,y);case"gauge":return l.Gauge(g,p,y);case"line":return o.Line(g,p,y);case"pie":return c.Pie(g,p,y);case"polar":return h.Polar(g,p,y);case"radar":return d.Radar(g,p,y);case"waterfall":return u.Waterfall(g,p,y);case"candlestick":return"candlestick";case"renko":return"renko";case"ichimoku":return"ichimoku";case"OHLC":return"OHLC";default:throw new Error(`The chart ${x} is unknown!`)}}(...e)}}(),function(){const t=function(){i.isThisATouchDevice||(window.removeEventListener("touchstart",t),i.isThisATouchDevice=!0)};window.addEventListener("touchstart",t),a=function(t){i.isThisATouchDevice&&(null===i.touchClickTimer?i.touchClickTimer=setTimeout(()=>{i.touchClickTimer=null},250):(clearTimeout(i.touchClickTimer),i.touchClickTimer=null,t()))}}(),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Easing&&(t.Easing=e(t))):t.Easing=e(t)}(r.src.lib,t=>{let e;return function(){const a=t.Easing;e={noConflict(){return t.Easing=a,this},linear:(t,e,a,r)=>a*t/r+e,swing:(t,e,a,r)=>a*(.5-Math.cos(t/r*Math.PI)/2)+e,easeInSine:(t,e,a,r)=>-a*Math.cos(t/r*(Math.PI/2))+a+e,easeOutSine:(t,e,a,r)=>a*Math.sin(t/r*(Math.PI/2))+e,easeInOutSine:(t,e,a,r)=>-a/2*(Math.cos(Math.PI*t/r)-1)+e,easeInQuad:(t,e,a,r)=>a*(t/=r)*t+e,easeOutQuad:(t,e,a,r)=>-a*(t/=r)*(t-2)+e,easeInOutQuad:(t,e,a,r)=>(t/=r/2)<1?a/2*t*t+e:-a/2*(--t*(t-2)-1)+e,easeInCubic:(t,e,a,r)=>a*(t/=r)*t*t+e,easeOutCubic:(t,e,a,r)=>a*((t=t/r-1)*t*t+1)+e,easeInOutCubic:(t,e,a,r)=>(t/=r/2)<1?a/2*t*t*t+e:a/2*((t-=2)*t*t+2)+e,easeInQuart:(t,e,a,r)=>a*(t/=r)*t*t*t+e,easeOutQuart:(t,e,a,r)=>-a*((t=t/r-1)*t*t*t-1)+e,easeInOutQuart:(t,e,a,r)=>(t/=r/2)<1?a/2*t*t*t*t+e:-a/2*((t-=2)*t*t*t-2)+e,easeInQuint:(t,e,a,r)=>a*(t/=r)*t*t*t*t+e,easeOutQuint:(t,e,a,r)=>a*((t=t/r-1)*t*t*t*t+1)+e,easeInOutQuint:(t,e,a,r)=>(t/=r/2)<1?a/2*t*t*t*t*t+e:a/2*((t-=2)*t*t*t*t+2)+e,easeInExpo:(t,e,a,r)=>0===t?e:a*Math.pow(2,10*(t/r-1))+e,easeOutExpo:(t,e,a,r)=>t===r?e+a:a*(1-Math.pow(2,-10*t/r))+e,easeInOutExpo:(t,e,a,r)=>0===t?e:t===r?e+a:(t/=r/2)<1?a/2*Math.pow(2,10*(t-1))+e:a/2*(2-Math.pow(2,-10*--t))+e,easeInCirc:(t,e,a,r)=>-a*(Math.sqrt(1-(t/=r)*t)-1)+e,easeOutCirc:(t,e,a,r)=>a*Math.sqrt(1-(t=t/r-1)*t)+e,easeInOutCirc:(t,e,a,r)=>(t/=r/2)<1?-a/2*(Math.sqrt(1-t*t)-1)+e:a/2*(Math.sqrt(1-(t-=2)*t)+1)+e,easeInBack:(t,e,a,r,i)=>(void 0===i&&(i=1.70158),a*(t/=r)*t*((i+1)*t-i)+e),easeOutBack:(t,e,a,r,i)=>(void 0===i&&(i=1.70158),a*((t=t/r-1)*t*((i+1)*t+i)+1)+e),easeInOutBack:(t,e,a,r,i)=>(void 0===i&&(i=1.70158),(t/=r/2)<1?a/2*(t*t*((1+(i*=1.525))*t-i))+e:a/2*((t-=2)*t*((1+(i*=1.525))*t+i)+2)+e),easeInElastic(t,e,a,r){var i=1.70158,n=0,s=a;return 0===t?e:1==(t/=r)?e+a:(n||(n=.3*r),s<Math.abs(a)?(s=a,i=n/4):i=n/(2*Math.PI)*Math.asin(a/s),-s*Math.pow(2,10*(t-=1))*Math.sin((t*r-i)*(2*Math.PI)/n)+e)},easeOutElastic(t,e,a,r){var i=1.70158,n=0,s=a;return 0===t?e:1==(t/=r)?e+a:(n||(n=.3*r),s<Math.abs(a)?(s=a,i=n/4):i=n/(2*Math.PI)*Math.asin(a/s),s*Math.pow(2,-10*t)*Math.sin((t*r-i)*(2*Math.PI)/n)+a+e)},easeInOutElastic(t,e,a,r){var i=1.70158,n=0,s=a;return 0===t?e:2==(t/=r/2)?e+a:(n||(n=r*(.3*1.5)),s<Math.abs(a)?(s=a,i=n/4):i=n/(2*Math.PI)*Math.asin(a/s),t<1?s*Math.pow(2,10*(t-=1))*Math.sin((t*r-i)*(2*Math.PI)/n)*-.5+e:s*Math.pow(2,-10*(t-=1))*Math.sin((t*r-i)*(2*Math.PI)/n)*.5+a+e)},easeInBounce(t,e,a,r){return a-this.easeOutBounce(r-t,0,a,r)+e},easeOutBounce:(t,e,a,r)=>(t/=r)<1/2.75?a*(7.5625*t*t)+e:t<2/2.75?a*(7.5625*(t-=1.5/2.75)*t+.75)+e:t<2.5/2.75?a*(7.5625*(t-=2.25/2.75)*t+.9375)+e:a*(7.5625*(t-=2.625/2.75)*t+.984375)+e,easeInOutBounce(t,e,a,r){return t<r/2?.5*this.easeInBounce(2*t,0,a,r)+e:.5*this.easeOutBounce(2*t-r,0,a,r)+.5*a+e}},e.VERSION="0.0.1"}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Messenger&&(t.Messenger=e(t))):t.Messenger=e(t)}(r.src.lib,t=>{let e,a;return function(){const r=t.Messenger;let i;e=function(){const t=Object.create(i);return t._db={},t},e.VERSION="0.0.1",e.noConflict=function(){return t.Messenger=r,this},i={subscribe(t,e){return a.subscribe(this._db,t,e),this},subscribeOnce(t,e){return a.subscribeOnce(this._db,t,e),this},unsubscribe(t,e){return a.unsubscribe(this._db,t,e),this},publish(t,e){return a.publish(this._db,t,e),this}}}(),function(){function t(t,e){"string"==typeof e&&function(t,e){Object.prototype.hasOwnProperty.call(t,e)||(t[e]={listeners:[],listenersOnce:[]})}(t,e)}a={subscribe(e,a,r){!function(e,a,r){t(e,a),"string"==typeof a&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(e,a)&&e[a].listeners.push(r)}(e,a,r)},subscribeOnce(e,a,r){!function(e,a,r){t(e,a),"string"==typeof a&&"function"==typeof r&&Object.prototype.hasOwnProperty.call(e,a)&&e[a].listenersOnce.push(r)}(e,a,r)},unsubscribe(t,e,a){!function(t,e,a){let r;"string"==typeof e&&"function"==typeof a&&Object.prototype.hasOwnProperty.call(t,e)&&(r=t[e].listeners.indexOf(a),r>=0&&t[e].listeners.splice(r,1),r=t[e].listenersOnce.indexOf(a),r>=0&&t[e].listenersOnce.splice(r,1))}(t,e,a)},publish(t,e,a){!function(t,e,a){if("string"==typeof e&&Object.prototype.hasOwnProperty.call(t,e)){for(let r=0;r<t[e].listeners.length;r++)t[e].listeners[r](a);for(let r=0;r<t[e].listenersOnce.length;r++)t[e].listenersOnce[r](a);t[e].listenersOnce.splice(0,t[e].listenersOnce.length)}}(t,e,a)}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.overslash&&(t.overslash=e(t))):t.overslash=e(t)}(r.src.lib,t=>{let e,a;return a=function(t,e){const a=Object.keys(e);for(let r=0;r<a.length;r++)t[a[r]]=e[a[r]]},function(){const a=t.overslash;e={noConflict(){return t.overslash=a,this}},e.VERSION="1.0.0"}(),a(e,{isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isNaN(t){return this.isNumber(t)&&t!==+t},isOdd(t){const e=t%2;return t===parseFloat(t)?!!e:void 0}}),a(e,{isObject(t){const e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),isFunction:t=>"[object Function]"===Object.prototype.toString.call(t),isArray:t=>"[object Array]"===Object.prototype.toString.call(t),isMath:t=>"[object Math]"===Object.prototype.toString.call(t),isDate:t=>"[object Date]"===Object.prototype.toString.call(t),isEmpty(t){let e;if(null===t)return!0;if(this.isArray(t)||this.isString(t))return 0===t.length;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}}),a(e,{clone(t){const e=this.isArray(t)?[]:{};let a;if(this.isObject(t)){for(a in t)this.isArray(t[a])?e[a]=this.clone(t[a]):this.isObject(t[a])?e[a]=this.extend(t[a]):e[a]=t[a];return e}},extend(t){let e,a;if(!this.isObject(t))return t;for(let r=1;r<arguments.length;r++)for(a in e=arguments[r],e)this.isLiteralObject(arguments[r][a])?(t[a]=void 0!==t[a]?t[a]:{},this.extend(t[a],arguments[r][a])):hasOwnProperty.call(e,a)&&(t[a]=this.isArray(e[a])?this.clone(e[a]):e[a]);return t},keys:t=>Object.keys(t),forPropIn(t,e){this.keys(t).forEach(a=>{({}).hasOwnProperty.call(t,a)&&e(a)})},assign(){const t=arguments[0];let e,a,r;for(r=1;r<arguments.length;r++)e=arguments[r],a=Object.keys(e).reduce((t,a)=>(t[a]=Object.getOwnPropertyDescriptor(e,a),t),{});return Object.defineProperties(t,a),t}}),a(e,{contains:(t,e)=>-1!==t.indexOf(e),flatten(t,e){let a,r=[],i=0;if(this.isArray(t)){if(e)return[].concat.apply([],t);for(a=0;a<t.length;a++)this.isArray(t[a])?(r=r.concat(this.flatten(t[a])),i=r.length):r[i++]=t[a];return r}},max(t){let e,a=null;if(!this.isArray(t))return;const r=this.flatten(t);for(e=0;e<r.length;e++)(null===a||a<r[e])&&(a="number"==typeof r[e]?r[e]:a);return null!==a?a:void 0},min(t){let e,a=null;if(!this.isArray(t))return;const r=this.flatten(t);for(e=0;e<r.length;e++)(null===a||a>r[e])&&(a="number"==typeof r[e]?r[e]:a);return null!==a?a:void 0},share(t){const e=[];let a,r,i;for(r=0;r<t.length;r++)if(a=t[r],!this.contains(e,a)){for(i=1;i<arguments.length&&this.contains(arguments[i],a);i++);i===arguments.length&&e.push(a)}return e}}),a(e,{}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.SVG&&(t.SVG=e(t))):t.SVG=e(t)}(r.src.lib,t=>{const e="http://www.w3.org/2000/svg",a="http://www.w3.org/1999/xlink";let r,i;const n={Dollar:{Public:{}},SVG:{Public:{}},Anim:{Public:{}},Methods:{Static:{Public:{}},Attr:{Public:{}},Text:{Public:{}}}};return function(){const e=n.Dollar.Public,a=n.SVG.Public,s=n.Methods.Static.Public,l=t.SVG;let o;r=function(t){const n=Object.create(i.extend(o,e)),{id:s,_root:l}=a.create(t);return n.id=s,n._root=l,n._SVG=r,n},r._setTestMode=function(){return n},r.noConflict=function(){return t.SVG=l,this},r.transformAttrToObj=function(t){return s.transformAttrToObj(t)},r.transformAttrToStr=function(t){return s.transformAttrToStr(t)},r.getArc=function(t,e,a,r){return s.getArc(t,e,a,r)},r.getLine=function(t,e){return s.getLine(t,e)},r.getMultipolyline=function(t,e){return s.getMultipolyline(t,e)},o={},r.VERSION="0.0.3"}(),i={extend(t,e){const a=Object.keys(e);for(let r=0;r<a.length;r++)t[a[r]]=e[a[r]];return t},isUndefined:t=>void 0===t,isNull:t=>null===t,isBoolean:t=>!0===t||!1===t||"[object Boolean]"===Object.prototype.toString.call(t),isString:t=>"[object String]"===Object.prototype.toString.call(t),isNumber:t=>"[object Number]"===Object.prototype.toString.call(t),isObject(t){const e=typeof t;return("function"===e||"object"===e)&&!!t},isLiteralObject:t=>"[object Object]"===Object.prototype.toString.call(t),isFunction:t=>"[object Function]"===Object.prototype.toString.call(t),isArray:t=>"[object Array]"===Object.prototype.toString.call(t),elinear:(t,e,a,r)=>a*t/r+e},function(){const t=n.Dollar.Public,r=n.Methods.Attr.Public,s=n.Methods.Text.Public;i.extend(t,{$:function(t){const{id:i}=this,{_root:n}=this;return{id:i,0:t?n.querySelector(t):n,_root:n,firstParent:function(){return this._root&&(this[0]=this._root),this},parent:function(){return this.root?this[0]!==this.root&&(this[0]=this[0].parentNode):this[0]=this[0].parentNode,this},previous:function(){return this[0]=this[0].previousElementSibling,this},next:function(){return this[0]=this[0].nextElementSibling,this},select:function(t){return this[0]=this[0].querySelector(t),this},append:function(t){const a=document.createElementNS(e,t);return this[0]=this[0].appendChild(a),this},appendBefore:function(t,a){const r=document.createElementNS(e,t),i=this[0].querySelector(a);return this[0].insertBefore(r,i),this[0]=r,this},appendAfter:function(t,a){const r=document.createElementNS(e,t),i=this[0].querySelector(a).nextElementSibling;return this[0].insertBefore(r,i),this[0]=r,this},appendHTML:function(t){if("string"!=typeof t)return this;const e=document.createElementNS("http://www.w3.org/1999/xhtml","body");return e.innerHTML=t,this[0]=this[0].appendChild(e),this},replace:function(t){const a=document.createElementNS(e,t);return this[0].parentNode.replaceChild(a,this[0]),this[0]=a,this},remove:function(){let t;return this[0]&&(t=this[0].parentNode,t.removeChild(this[0]),this[0]=t),this},removeChild:function(t){return t&&this[0].removeChild(t),this},replaceChild:function(t,e){return t&&this[0].replaceChild(t,e),this},removeAllChilds:function(){for(;this[0].firstChild;)this[0].removeChild(this[0].firstChild);return this},empty:function(){for(;this[0].firstChild;)this[0].removeChild(this[0].firstChild);return this},listen:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].addEventListener(t,e),this},listenOnce:function(t,e){const a=this[0];return"string"==typeof t&&"function"==typeof e&&a.addEventListener(t,(function r(i){a.removeEventListener(t,r),e(i)})),this},unlisten:function(t,e){return"string"==typeof t&&"function"==typeof e&&this[0].removeEventListener(t,e),this},alink:function(t,e){return this[0].setAttributeNS(a,`xlink:${t}`,e),this},attr:function(t,e){return this[0]?(r.attr(this[0],t,e),this):(console.log("warning: this.svgElement is null!"),this)},rmattr:function(t){return this[0].removeAttributeNS(null,t),this},text:function(t){return s.text(this[0],t),this},addClass:function(t){let e=this[0].getAttributeNS(null,"class");return e=e?`${e} ${t}`:t,this[0].setAttributeNS(null,"class",e),this},removeClass:function(t){let e=this[0].getAttributeNS(null,"class");return e&&(e=e.replace(t,"").replace(/(^\s+|\s+$)/g,""),this[0].setAttributeNS(null,"class",e)),this},toggleClass:function(t){const e=this[0].getAttributeNS(null,"class");return e&&e.match(t)?(this.removeClass(t),this):(this.addClass(t),this)},query:function(t){return this[0].querySelector(t)},getElement:function(){return this[0]},children:function(){return this[0].children},getAttribute:function(t){return this[0]?this[0].getAttribute(t):null},getComputedStyle:function(){return window.getComputedStyle(this[0])},getPropertyValue:function(t){return this.getPropertyValue(t)},getSize:function(){return{width:this[0].getBoundingClientRect().width,height:this[0].getBoundingClientRect().height}},getBbox:function(){return{top:this[0].getBoundingClientRect().top,left:this[0].getBoundingClientRect().left,width:this[0].getBoundingClientRect().width,height:this[0].getBoundingClientRect().height}}}}})}(),function(){const t=n.Anim.Public;i.extend(t,{rotateRun(t,e){!function(t,e){const a={a:0,t:0,start:i.isNumber(e.start)?e.start:null,stop:i.isNumber(e.stop)?e.stop:180,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3};if(i.isNull(a.start)){const e=r.transformAttrToObj(t.getAttribute("transform"));a.start=i.isObject(e.scale)&&i.isNumber(e.scale.a)?e.scale.a:180}const n=setInterval(()=>{a.t+=a.period,(a.t>a.duration||a.stop===a.start)&&(a.t=a.duration),a.a=a.easing(a.t,a.start,a.stop-a.start,a.duration);const e=r.transformAttrToObj(t.getAttribute("transform"));e.rotate.a=a.a,t.setAttributeNS(null,"transform",r.transformAttrToStr(e)),a.t===a.duration&&clearInterval(n)},a.period)}(t,e)},scaleRun(t,e){!function(t,e){const a={x:0,y:0,t:0,x0:i.isObject(e.start)&&i.isNumber(e.start.x)?e.start.x:null,y0:i.isObject(e.start)&&i.isNumber(e.start.y)?e.start.y:null,x1:i.isObject(e.stop)&&i.isNumber(e.stop.x)?e.stop.x:1,y1:i.isObject(e.stop)&&i.isNumber(e.stop.y)?e.stop.y:1,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3},n=r.transformAttrToObj(t.getAttribute("transform"));(i.isNull(a.x0)||i.isNull(a.y0))&&(a.x0=i.isObject(n.scale)&&i.isNumber(n.scale.x)?n.scale.x:0,a.y0=i.isObject(n.scale)&&i.isNumber(n.scale.y)?n.scale.y:0);const s=setInterval(()=>{a.t+=a.period,a.t>a.duration&&(a.t=a.duration),a.x=a.easing(a.t,a.x0,a.x1-a.x0,a.duration),a.y=a.easing(a.t,a.y0,a.y1-a.y0,a.duration);const e=r.transformAttrToObj(t.getAttribute("transform"));e.scale.x=a.x,e.scale.y=a.y,t.setAttributeNS(null,"transform",r.transformAttrToStr(e)),a.t===a.duration&&clearInterval(s)},a.period)}(t,e)},translateRun(t,e){!function(t,e){const a={x:0,y:0,t:0,length:null,arc:null,period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,duration:i.isNumber(e.duration)?e.duration:2e3};let n,s;if(e.start&&i.isNumber(e.start.x)&&i.isNumber(e.start.y))n=e.start.x,s=e.start.y;else{const e=r.transformAttrToObj(t.getAttribute("transform"));n=i.isObject(e.translate)&&i.isNumber(e.translate.x)?e.translate.x:0,s=i.isObject(e.translate)&&i.isNumber(e.translate.y)?e.translate.x:0}a.length=Math.sqrt(Math.pow(e.stop.x-n,2)+Math.pow(e.stop.y-s,2)),a.arc=Math.atan((e.stop.y-s)/(e.stop.x-n)),e.stop.x-n<0&&(a.arc+=-Math.PI),0===a.length&&(a.arc=0);const l=setInterval(()=>{a.t+=a.period,a.t>a.duration&&(a.t=a.duration),a.x=a.easing(a.t,0,a.length,a.duration)*Math.cos(a.arc)+n,a.y=a.easing(a.t,0,a.length,a.duration)*Math.sin(a.arc)+s;const e=r.transformAttrToObj(t.getAttribute("transform"));e.translate.x=a.x,e.translate.y=a.y,t.setAttributeNS(null,"transform",r.transformAttrToStr(e)),a.t===a.duration&&clearInterval(l)},a.period)}(t,e)},textRun(t,e){!function(t,e){const a={period:i.isNumber(e.frequency)?1e3/e.frequency:10,easing:i.isFunction(e.easing)?e.easing:i.elinear,value:0,start:i.isNumber(e.start)?e.start:0,stop:i.isNumber(e.stop)?e.stop:0,t:0,duration:i.isNumber(e.duration)?e.duration:2e3},r=setInterval(()=>{a.t+=a.period,(a.t>a.duration||a.stop===a.start)&&(a.t=a.duration),a.value=a.easing(a.t,a.start,a.stop-a.start,a.duration),0===a.duration&&(a.value=a.start),t.textContent=a.value.toFixed(0),a.t===a.duration&&clearInterval(r)},a.period)}(t,e)}})}(),function(){const t=n.Methods.Attr.Public,e=n.Anim.Public;i.extend(t,{attr(t,a,r){!function(t,a,r){switch(typeof r){case"string":case"number":t.setAttributeNS(null,a,r);break;case"object":switch(a){case"transform":switch(r.type){case"rotate":e.rotateRun(t,r);break;case"scale":e.scaleRun(t,r);break;case"translate":e.translateRun(t,r);break;default:throw new Error(`The animation is not supported for the transform ${r.type}!`)}break;default:throw new Error(`The animation is not supported for the attribute ${a}!`)}}}(t,a,r)}})}(),function(){const t=n.Methods.Static.Public;i.extend(t,{transformAttrToObj:t=>(function(t){const e="string"==typeof t?t:"",a=/[+-]?((?:[1-9]\d*|0)(?:\.\d*)?|\.\d+)([eE][+-]?\d+)?/g,r=/translate(.*?)\)/,i=/scale(.*?)\)/,n=/rotate(.*?)\)/,s=/skewX(.*?)\)/,l=/skewY(.*?)\)/,o=null===e.match(r)?null:function(){let t,i;const n=e.match(r)[0].match(a);return n?1===n.length?(t=parseFloat(n[0],10),i=t):(t=parseFloat(n[0],10),i=parseFloat(n[1],10)):(t=null,i=null),{x:t,y:i}}(),c=null===e.match(i)?null:function(){let t,r;const n=e.match(i)[0].match(a);return n?1===n.length?(t=parseFloat(n[0],10),r=t):(t=parseFloat(n[0],10),r=parseFloat(n[1],10)):(t=null,r=null),{x:t,y:r}}(),h=null===e.match(n)?null:function(){let t,r,i;const s=e.match(n)[0].match(a);return s?1===s.length?(t=parseFloat(s[0],10),r=null,i=null):2===s.length?(t=parseFloat(s[0],10),r=parseFloat(s[1],10),i=r):(t=parseFloat(s[0],10),r=parseFloat(s[1],10),i=parseFloat(s[2],10)):(t=null,r=null,i=null),{a:t,cx:r,cy:i}}(),d=null===e.match(s)?null:e.match(s)[0].match(a)?parseFloat(e.match(s)[0].match(a)[0],10):null,u=null===e.match(l)?null:e.match(l)[0].match(a)?parseFloat(e.match(l)[0].match(a)[0],10):null;return{translate:o,scale:c,rotate:h,matrix:(e.match(/matrix(.*?)\)/),null),skewX:d,skewY:u}})(t),transformAttrToStr:t=>(function(t){let e="";return t.translate&&"number"==typeof t.translate.x&&("number"==typeof t.translate.y?e+="translate("+t.translate.x+", "+t.translate.y+") ":e+="translate("+t.translate.x+", 0) "),t.scale&&"number"==typeof t.scale.x&&("number"==typeof t.scale.y?e+="scale("+t.scale.x+", "+t.scale.y+") ":e+="scale("+t.scale.x+", "+t.scale.x+") "),t.rotate&&"number"==typeof t.rotate.a&&("number"==typeof t.rotate.cx&&"number"==typeof t.rotate.cy?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cy+") ":"number"==typeof t.rotate.cx?e+="rotate("+t.rotate.a+", "+t.rotate.cx+", "+t.rotate.cx+") ":e+="rotate("+t.rotate.a+") "),"number"==typeof t.skewX&&(e+="skewX("+t.skewX+") "),"number"==typeof t.skewY&&(e+="skewY("+t.skewY+") "),e.replace(/(^\s+|\s+$)/g,"")})(t),getArc:(t,e,a,r)=>(function(t,e,a,r){t=void 0!==t?t:0,e=void 0!==e?e:0,a=void 0!==a?a:0,(t%=2*Math.PI)>2*Math.PI&&(t%=2*Math.PI),e>2*Math.PI&&(e%=2*Math.PI);let i=0;Math.abs(e-t)>Math.PI&&(i=1);const n=Math.cos(t),s=Math.sin(t),l=Math.cos(e),o=Math.sin(e);let c="";return void 0!==r&&(c="L"+l*r+","+o*r+"A"+r+","+r+" 0 "+i+",0 "+n*r+","+s*r+"Z"),"M"+n*a+","+s*a+"A"+a+","+a+" 0 "+i+",1 "+l*a+","+o*a+c})(t,e,a,r),getLine:(t,e)=>(function(t,e){let a="";return t.forEach(t=>{null!==t.x&&null!==t.y&&(""===a?a=`M${t.x}, ${t.y}`:a+=`L${t.x},${t.y}`)}),!0===e&&(a+="Z"),a})(t,e),getMultipolyline:(t,e)=>(function(t,e){let a,r,i,n;for(a="",i=0;i<t.length;i++){for(r="",n=0;n<t[i].length;n++)null!==t[i][n].x&&null!==t[i][n].y&&(""===r?r=`M${t[i][n].x},${t[i][n].y}`:r+=`L${t[i][n].x}, ${t[i][n].y}`);!0===e&&(r+="z"),a+=r}return a})(t,e)})}(),function(){const t=n.SVG.Public;i.extend(t,{create:t=>(function(t){const r="string"==typeof t?t:"body",i=document.querySelector(r)||document.querySelector("body");let n,s=`i${Math.random().toString(36).substr(2,7)}`;const l=i.getElementsByTagNameNS(e,"svg")[0];if(l&&0!==l.length)s=l.getAttributeNS(null,"id"),n=l;else{const t=document.createElementNS(e,"svg");t.setAttributeNS(null,"id",s),t.setAttributeNS(null,"version","1.1"),t.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",e),t.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink",a),i.appendChild(t),n=t}return{id:s,_root:n}})(t)})}(),function(){const t=n.Methods.Text.Public,e=n.Anim.Public;i.extend(t,{text(t,a){!function(t,a){switch(typeof a){case"number":case"string":t.textContent=a;break;case"object":e.textRun(t,a)}}(t,a)}})}(),r}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.TaskQ&&(t.TaskQ=e(t))):t.TaskQ=e(t)}(r.src.lib,t=>{let e,a={src:{taskq:{},private:{taskq:{}}},extend:function(t,e){for(var a=Object.keys(e),r=0;r<a.length;r++)t[a[r]]=e[a[r]]}};return function(){const r=a.src.private.taskq,i=t.TaskQ;let n;e=function(){const t=Object.create(n);return t._dQ={},t},e.VERSION="0.0.2",e.noConflict=function(){return t.TaskQ=i,this},n={pushQ(t,e){return r.pushQ(this._dQ,t,e),this},popQ(t,e){return r.popQ(this._dQ,t,e),this}}}(),function(){function t(t,e){"string"!=typeof e||Object.prototype.hasOwnProperty.call(t,e)||(t[e]={firing:!1,listeners:[]})}const e={pushQ(e,a,r){t(e,a),"string"==typeof a&&"function"==typeof r&&(e[a].listeners.push(r),e[a].firing||function(t,e,a){const r=t[e].listeners;t[e].firing=!0,function i(){r.length>0?r.shift().apply(a||{},[i].concat(Array.prototype.slice.call(arguments,0))):t[e].firing=!1}()}(e,a))},popQ(e,a,r){t(e,a),"string"==typeof a&&"function"==typeof r&&(e[a].listeners.push(r),e[a].firing||function(t,e,a){const r=t[e].listeners;t[e].firing=!0,function i(){if(r.length>0){for(;r.length>1;)r.shift();r.shift().apply(a||{},[i].concat(Array.prototype.slice.call(arguments,0)))}else t[e].firing=!1}()}(e,a))}};a.extend(a.src.private.taskq,e)}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Chart&&(t.Chart=e(t))):t.Chart=e(t)}(r.src.libin,t=>{let e;return function(){const a=t.Chart;e={noConflict(){return t.Chart=a,this},extend(t,e){const a=Object.keys(e);for(let r=0;r<a.length;r++)t[a[r]]=e[a[r]]}},e.VERSION="0.0.4",e.extend(e,{data:{},dom:{},util:{}})}(),e.extend(e.data,{copySeries:(t,e,a,r)=>(function(t,e,a,r){const i=r.clone(t[0]);switch(a){case"area":case"bar":case"column":case"line":case"pie":case"polar":case"radar":case"barchartrace":case"waterfall":case"map":return!(!r.isArray(e)||r.isEmpty(e)||(t.splice(0),e.forEach((e,a)=>{t[a]=r.extend({},i,e)}),0));case"circle":case"gauge":return!!r.isNumber(e)&&(t[0]=r.extend({},i,{label:"Item 1",type:a,value:e}),!0);default:throw new Error(`_copySeries: the chart ${a} is not recognized!`)}})(t,e,a,r),computeGenericSettings(t){!function(t){const{chart:e}=t,{title:a}=t,{subtitle:r}=t,{legend:i}=t;a.x=null===a.x?e.width/2:a.x,a.y=null===a.y?15:a.y,r.x=null===r.x?e.width/2:r.x,r.y=null===r.y?35:r.y,i.enabled=null===i.enabled||i.enabled,i.floating=null===i.floating||i.floating,i.layout=null===i.layout?"vertical":i.layout,i.align.horizontal=null===i.align.horizontal?"right":i.align.horizontal,i.align.vertical=null===i.align.vertical?"top":i.align.vertical,i.shift.x=null===i.shift.x?0:i.shift.x,i.shift.y=null===i.shift.y?0:i.shift.y,i.icon.width=null===i.icon.width?10:i.icon.width,i.icon.height=null===i.icon.height?10:i.icon.height,i.icon.gap.x=null===i.icon.gap.x?.5*i.icon.width:i.icon.gap.x,i.icon.gap.y=null===i.icon.gap.y?.5*i.icon.height:i.icon.gap.y}(t)},computeGridSize(t,e,a){!function(t,e,a){const{chart:r}=t,{horizontal:i}=e.align,{vertical:n}=e.align;e.enabled&&!e.floating?"left"!==i||"top"!==n&&"middle"!==n&&"bottom"!==n?"middle"===i&&"top"===n?(r.grid.x=null===r.grid.x?r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?e.background.y+e.background.height+r.grid.margin.bottom:r.grid.y,r.grid.width=null===r.grid.width?r.width-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?r.height-r.grid.y-r.grid.margin.bottom:t.chart.grid.height):"middle"===i&&"middle"===n?(r.grid.x=null===r.grid.x?r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?r.grid.margin.top:r.grid.y,r.grid.width=null===r.grid.width?r.width-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?r.height-r.grid.y-r.grid.margin.bottom:r.grid.height):"middle"===i&&"bottom"===n?(r.grid.x=null===r.grid.x?r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?r.grid.margin.top:r.grid.y,r.grid.width=null===r.grid.width?r.width-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?e.background.y-r.grid.y-r.grid.margin.bottom:r.grid.height):(r.grid.x=null===r.grid.x?r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?r.grid.margin.top:r.grid.y,r.grid.width=null===r.grid.width?e.background.x-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?r.height-r.grid.y-r.grid.margin.bottom:r.grid.height):(r.grid.x=null===r.grid.x?e.background.x+e.background.width+r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?r.grid.margin.top:r.grid.y,r.grid.width=null===r.grid.width?r.width-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?r.height-r.grid.y-r.grid.margin.bottom:r.grid.height):(r.grid.x=null===r.grid.x?r.grid.margin.left:r.grid.x,r.grid.y=null===r.grid.y?r.grid.margin.top:r.grid.y,r.grid.width=null===r.grid.width?r.width-r.grid.x-r.grid.margin.right:r.grid.width,r.grid.height=null===r.grid.height?r.height-r.grid.y-r.grid.margin.bottom:r.grid.height),"charts"===a&&(r.grid.y+=r.grid.height)}(t,e,a)},setChartType(t,e){!function(t,e){switch(e){case"area":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type||"percent"===t.chart.type?`${t.chart.type} area`:"basic area";break;case"bar":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?`${t.chart.type} bar`:"basic bar";break;case"circle":t.chart.type="circle";break;case"column":t.chart.type="basic"===t.chart.type||"stacked"===t.chart.type?`${t.chart.type} column`:"basic column";break;case"gauge":t.chart.type="gauge";break;case"line":t.chart.type="line";break;case"pie":t.chart.type="pie";break;case"polar":t.chart.type="polar";break;case"radar":t.chart.type="radar";break;case"barchartrace":t.chart.type="barchartrace";break;case"waterfall":t.chart.type="waterfall";break;case"map":t.chart.type="map";break;default:throw new Error(`_setChartType: this type "${e}" is unknown!`)}}(t,e)},normalizeSeries(t,e,a,r){!function(t,e){let a,r,i;if(!(e.xAxis&&e.xAxis.plot&&e.xAxis.plot.type)){if(e.xAxis.categories)a=e.xAxis.categories;else{if(!e.yAxis.categories)return;a=e.yAxis.categories}r=a.data.length;for(let e=0;e<t.length;e++)for(let r=0;r<a.data.length;r++)t[e].data[r]||(t[e].data[r]=0);0===r&&(a.data.push("???"),r=a.data.length);for(let e=0;e<t.length;e++)i=t[e].data.length,t[e].data.splice(r,i-r)}}(t,e)},setActiveArea:t=>(function(t){const e=t.xAxis.type||t.yAxis.type;switch(e){case"categories":return{x0:t.chart.grid.x,y0:t.chart.grid.y-t.chart.grid.height,width:t.chart.grid.width,height:t.chart.grid.height};case"plot":return{x0:t.chart.grid.x+t.xAxis.data.min,y0:t.chart.grid.y-t.chart.grid.height,width:t.xAxis.data.max-t.xAxis.data.min,height:t.chart.grid.height};default:throw new Error(`Pix.chart._setActiveArea: the type "${e}" is unknown!`)}})(t)}),e.extend(e.dom,{set(t,e,a,r){!function(t,e,a,r){t.$().attr("class",e).attr("width",a).attr("height",r)}(t,e,a,r)},fill(t){!function(t){t.$().append("defs").parent().append("g").attr("class","grid").parent().append("g").attr("class","series").parent().append("g").attr("class","header").parent().append("g").attr("class","legend").parent().append("g").attr("class","cursor").parent().append("g").attr("class","highlight").parent().append("g").attr("class","tooltip").parent().append("g").attr("class","activearea").parent().append("g").attr("class","copyright").parent().append("g").attr("class","footer").parent()}(t)},fillmap(t,e){!function(t,e){const{grid:a}=e.chart,{width:r}=a,{height:i}=a,n=a.x,s=a.y;t.$().select(".grid").remove().select(".cursor").remove().select(".highlight").remove(),t.$().appendAfter("g",".activearea").attr("class","keypad").parent().select(".series").attr("transform",`translate(${n}, ${s})`).append("svg").attr("class","maps").attr("width",r).attr("height",i).append("g").attr("class","geojson").attr("transform","translate(0, 0) scale(0, 0)").parent().append("g").attr("class","raster").attr("transform","translate(0, 0) scale(1, 1)").parent().append("g").attr("class","vector").attr("transform","translate(0, 0) scale(1, 1)")}(t,e)}}),e.extend(e.dom,{drawGrid(t,e,a,r,i){switch(a.chart.type){case"basic bar":case"stacked bar":case"barchartrace":!function(t,e,a,r){const i=e.chart.grid.x,n=e.chart.grid.y,{length:s}=e.yAxis.categories.data,l=e.chart.grid.height/s,o=t.$();o.select(".grid").attr("transform",`translate(${i}, ${n}) scale(1, 1)`);for(let t=0;t<=e.xAxis.interval.number;t++)o.append("line").attr("class","x-axis").attr("x1",e.xAxis.interval.width*t).attr("y1",0).attr("x2",e.xAxis.interval.width*t).attr("y2",-e.chart.grid.height).parent().append("text").attr("class","x-axis").attr("x",e.xAxis.interval.width*t).attr("y",e.constants.gap.x).text(r.toRound(e.xAxis.minor*t+e.xAxis.min,e.xAxis.exp)).parent();for(let t=0;t<=s;t++)o.append("line").attr("class","-axis").attr("x1",0).attr("y1",l*t*-1).attr("x2",-3).attr("y2",l*t*-1).parent();for(let t=0;t<s;t++)o.append("text").attr("class","y-axis").attr("x",e.constants.gap.y).attr("y",l*(t+.5)*-1).text(e.yAxis.categories.data[t]).parent();o.append("text").attr("class","x-axis title").attr("transform","rotate(0)").attr("x",e.xAxis.title.x).attr("y",-1*e.xAxis.title.y).text(e.xAxis.title.label)}(t,a,0,i);break;default:!function(t,e,a,r,i){const n=a.chart.grid.x,s=a.chart.grid.y,{type:l}=a.xAxis;let o,c,h,d,u,x,p,y,g,m,f;const b=t.$();switch(b.select(".grid").attr("transform",`translate(${n}, ${s}) scale(1, 1)`),l){case"categories":o=a.xAxis.categories.data.length,c=a.chart.grid.width/o,d=3;for(let t=0;t<=o;t++)b.append("line").attr("class","x-axis").attr("x1",c*t).attr("y1",0).attr("x2",c*t).attr("y2",d).parent();!function(t,e){const{length:a}=e.xAxis.categories.data,r=e.chart.grid.width/a;let i,n;for(let s=0;s<a;s++){const a=e.xAxis.categories.data[s].split(" ");if(t.append("text").attr("class","x-axis").attr("x",r*(s+.5)).attr("y",e.constants.gap.x).text(e.xAxis.categories.data[s]),n=t.getSize(),n.width<r||1===a.length)t.parent();else{i=a[0];for(let e=1;e<a.length;e++)if(i+=` ${a[e]}`,t.text(i),n=t.getSize(),n.width>r){const i=a.slice(0,e).join(" "),l=a.slice(e).join(" ");t.text("").append("tspan").attr("x",r*(s+.5)).text(i).parent().append("tspan").attr("x",r*(s+.5)).attr("dy",n.height).text(l).parent().parent();break}}}}(b,a);break;case"plot":switch(u=6,d=5,x=a.xAxis.data.min,p=a.xAxis.data.max,y=a.xAxis.plot.start,g=e[0].data.length*a.xAxis.plot.increment,m=(p-x)/g,h=a.xAxis.plot.type,h){case"number":f=r.buildMarkers(y,g,6);break;case"datetime":f=r.buildDateMarkers(y,g,6);break;default:throw new Error(`Pix.chart._drawGrid: the subtype "${h}" is not supported!`)}for(let t=0;t<f.pos.length;t++)b.append("line").attr("class","x-axis").attr("x1",f.pos[t]*m+x).attr("y1",0).attr("x2",f.pos[t]*m+x).attr("y2",d).parent().append("text").attr("class","x-axis").attr("x",f.pos[t]*m+x).attr("y",18).text(f.label[t]).parent();break;default:throw new Error(`Pix.chart._drawGrid: the type "${l}" is not supported!`)}for(let t=0;t<=a.yAxis.interval.number;t++)b.append("line").attr("class","x-axis").attr("x1",0).attr("y1",-a.yAxis.interval.height*t).attr("x2",a.chart.grid.width).attr("y2",-a.yAxis.interval.height*t).parent().append("text").attr("class","y-axis").attr("x",a.constants.gap.y).attr("y",-a.yAxis.interval.height*t).text(i.toRound(a.yAxis.minor*t+a.yAxis.min,a.yAxis.exp)).parent();b.append("text").attr("class","y-axis title").attr("transform","rotate(-90)").attr("x",a.yAxis.title.y).attr("y",-1*a.yAxis.title.x).text(a.yAxis.title.label).parent(),b.parent()}(t,e,a,r,i)}}}),e.extend(e.dom,{drawHeader(t,a){return function(t){const{chart:e}=t,{title:a}=t,{subtitle:r}=t;a&&(a.x=a.x?a.x:e.width/2,a.y=a.y?a.y:15),r&&(r.x=r.x?r.x:e.width/2,r.y=r.y?r.y:35)}(a),function(t,e,a){a.title&&a.title.label&&e.$().select(".header").append("text").attr("class","title").attr("style",t.getStyle(a.title.style)).attr("x",a.title.x).attr("y",a.title.y).text(a.title.label),a.subtitle&&a.subtitle.label&&e.$().select(".header").append("text").attr("class","subtitle").attr("style",t.getStyle(a.subtitle.style)).attr("x",a.subtitle.x).attr("y",a.subtitle.y).text(a.subtitle.label)}(e.util,t,a),this},drawFooter(t,a){return function(t){const{footer:e}=t;e&&(e.x=e.x?e.x:0,e.y=e.y?e.y:t.chart.height-2)}(a),function(t,e,a){a.footer&&a.footer.label&&e.$().select(".footer").append("text").attr("class","text").attr("style",t.getStyle(a.footer.style)).attr("x",a.footer.x).attr("y",a.footer.y).text(a.footer.label)}(e.util,t,a),this}}),e.extend(e.dom,{addVerticalCursor(t,e){!function(t,e){e.cursor.enabled&&t.$().select(".cursor").attr("transform",`translate(${e.chart.grid.x}, ${e.chart.grid.y})`).attr("display","none").append("line").attr("class","cursorline").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",-e.yAxis.max*e.yAxis.scale)}(t,e)},moveVerticalCursor(t,e,a){!function(t,e,a){e.cursor.enabled&&t.$().select(".cursor").select(".cursorline").attr("x1",a).attr("y1",0).attr("x2",a).attr("y2",(e.yAxis.max-e.yAxis.min)*e.yAxis.scale*-1).parent().attr("display","inherit")}(t,e,a)},turnVerticalCursorOff(t){!function(t){t.$().select(".cursor").attr("display","none")}(t)}}),e.extend(e.dom,{highlightSelectedPoints(t,e,a){!function(t,e,a){if(!e.highlight.enabled)return;const r=t.$();r.select(".highlight").replace("g").attr("class","highlight").attr("transform",`translate(${e.chart.grid.x}, ${e.chart.grid.y})`).attr("display","none");for(let t=0;t<a.length;t++)r.append("circle").attr("class","outer").attr("style",`stroke: ${a[t].color}`).attr("cx",a[t].x).attr("cy",a[t].y).attr("r",6).parent().append("circle").attr("class","inner").attr("style",`fill: ${a[t].color}`).attr("cx",a[t].x).attr("cy",a[t].y).attr("r",3).parent();r.attr("display","inherit")}(t,e,a)},turnLightsOff(t,e){!function(t,e){e.highlight.enabled&&t.$().select(".highlight").attr("display","none")}(t,e)}}),e.extend(e.dom,{drawActiveArea(t,e){!function(t,e){t.$().select(".activearea").attr("transform",`translate(${e.x0}, ${e.y0})`)}(t,e)},drawActiveAreaMap(t,e){!function(t,e){const{grid:a}=e.chart,{width:r}=a,{height:i}=a,n=a.x,s=a.y;t.$().select(".activearea").attr("transform",`translate(${n}, ${s})`).append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",r).attr("height",i)}(t,e)},addEvents2ActiveArea(t,e,a,r){!function(t,e,a,r){t.$().select(".activearea").append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",e.width).attr("height",e.height).listen("mouseover",a).listen("mouseout",r)}(t,e,a,r)},addClickEvents2ActiveArea(t,e,a){!function(t,e,a){t.$().select(".activearea").append("rect").attr("class","background").attr("x",0).attr("y",0).attr("width",e.width).attr("height",e.height).listen("click",a)}(t,e,a)},addEvents2ActiveAreaMap(t,e,a){!function(t,e,a){e.$().select(".activearea").listenOnce("mousemove",a.firstmousemove.bind(t)).listen("mousemove",a.mousemove.bind(t)).listen("wheel",a.zoom.bind(t)).listen("mousedown",a.drag.bind(t)).listenOnce("touchstart",a.firsttouchstart.bind(t)).listen("touchstart",a.touchstart.bind(t)).listen("touchmove",a.touchmove.bind(t),{passive:!1}).listen("touchend",a.touchend.bind(t)).listen("click",a.click.bind(t)).listen("dblclick",a.dblClick.bind(t)).firstParent()}(t,e,a)}}),e.extend(e.util,{getStyle:t=>(function(t){let e="";return"[object Object]"!==Object.prototype.toString.call(t)?"inherit":(e+=t.fillColor?`fill:${t.fillColor};`:"",e+=t.fillOpacity?`fill-opacity:${t.fillOpacity};`:"",e+=t.stroke?`stroke:${t.stroke};`:"",e+=t.strokeOpacity?`stroke-opacity:${t.strokeOpacity};`:"",e+=t.strokeWidth?`stroke-width:${t.strokeWidth};`:"",e||"inherit")})(t)}),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Copyright&&(t.Copyright=e(t))):t.Copyright=e(t)}(r.src.libin,t=>{let e,a;return function(){const r=t.Copyright;e={noConflict(){return t.Copyright=r,this},draw(t){a.draw(t)},fill(t,e,r){a.fill(t,e,r),a.place(t,e),a.addBackground(t,e,r)},shift(t,e,r){a.shift(t,e,r)}},e.VERSION="0.0.3"}(),function(){function t(t,e){void 0!==e.copyleft.text&&t.$().select(".copyright").select(".text").select(".xlink1").select(".t1").text(e.copyleft.text),void 0!==e.copyleft.url&&t.$().select(".copyright").select(".text").select(".xlink1").alink("href",e.copyleft.url),void 0!==e.copyright.text&&t.$().select(".copyright").select(".text").select(".xlink2").select(".t2").text(e.copyright.text),void 0!==e.copypost&&void 0!==e.copypost.text&&t.$().select(".copyright").select(".text").select(".t3").text(e.copypost.text),void 0!==e.copyright.url&&t.$().select(".copyright").select(".text").select(".xlink2").alink("href",e.copyright.url),void 0!==e.title&&t.$().select(".copyright").select(".text").select(".title").text(e.title)}a={draw(t){!function(t){const e=t.$();e.select(".copyright").attr("transform","translate(0, 0)"),e.append("rect").attr("class","background").attr("rx",0).attr("ry",0).attr("x",0).attr("y",0).attr("width",0).attr("height",0).parent(),e.append("text").attr("class","text"),e.append("a").alink("href","#").attr("class","xlink1").append("tspan").attr("class","t1").text("").parent().parent(),e.append("a").alink("href","#").attr("class","xlink2").append("tspan").attr("class","t2").attr("dx","5").text("").parent().parent(),e.append("tspan").attr("class","t3").attr("dx","5").text("").parent(),e.append("title").attr("class","title").text("")}(t)},fill(e,a,r){!function(e,a,r){switch(r){case"classic":t(e,{copyleft:{text:"Pixi Charts",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Artelsys",url:"http://www.artelsys.com"},title:"Copyright (c) 2020 Artelsys. All Rights Reserved."});break;case"naturalearth":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Natural Earth",url:"http://www.naturalearthdata.com"},title:"Copyright (c) 2020 Artelsys. Made with free vector and raster map data @ naturalearthdata.com."});break;case"openstreetmap":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© OpenStreetMap",url:"http://www.openstreetmap.org/copyright"},copypost:{text:"contributors"},title:"Copyright (c) 2020 Artelsys. Made with raster map data @ openstreetmap.com."});break;case"datagouv":t(e,{copyleft:{text:"Pixi Maps",url:"http://pixi.mobilabs.fr"},copyright:{text:"© Data.Gouv.fr",url:"https://www.data.gouv.fr/en/"},copypost:{text:"contributors"},title:"Copyright (c) 2020 Artelsys. Made with data @ data.gouv.fr - licence ODbl."});break;default:throw new Error(`Pix.Libs.Copyright.fill: this "${r}" is unknown!`)}}(e,0,r)},place(t,e){!function(t,e){const a=t._SVG,r=t.$(),i=r.select(".copyright").getSize(),n=a.transformAttrToObj(r.getAttribute("transform"));n.translate.x=e.chart.width+n.translate.x-i.width-2,n.translate.y=e.chart.height+n.translate.y-2,r.attr("transform",a.transformAttrToStr(n))}(t,e)},addBackground(t,e,a){!function(t,e,a){const r=t._SVG,i=t.$();if("openstreetmap"===a){const t={x:-2},e=i.select(".copyright").getSize();t.y=2-e.height,t.width=e.width+4,t.height=e.height+2;const a=r.transformAttrToObj(i.getAttribute("transform"));a.translate.x-=2,a.translate.y-=4,i.attr("transform",r.transformAttrToStr(a)).select(".background").attr("rx",2).attr("ry",2).attr("x",t.x).attr("y",t.y).attr("width",t.width).attr("height",t.height)}}(t,0,a)},shift(t,e,a){!function(t,e,a){const r=t._SVG,i=t.$();i.select(".copyright");const n=r.transformAttrToObj(i.getAttribute("transform"));n.translate.x+=e,n.translate.y+=a,i.attr("transform",r.transformAttrToStr(n))}(t,e,a)}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Legend&&(t.Legend=e(t))):t.Legend=e(t)}(r.src.libin,t=>{let e,a,r,i;return function(){const i=t.Legend;let n;e=function(){const t=Object.create(n);return t._params=null,t},e.VERSION="0.0.2",e.noConflict=function(){return t.Legend=i,this},n={set(t,e,r,i,n){return this._params=a.set(t,e,r,i,n),this},get(){return this._params},draw(t){return r.draw(t,this._params),this}}}(),a={set(t,e,a,n,s){const l=e.extend(i.getParams(a.length),n.legend);return function(t,e,a){switch(a){case"area":case"bar":case"circle":case"column":case"gauge":case"line":case"pie":case"polar":case"radar":case"waterfall":case"barchartrace":for(let a=0;a<t.data.length;a++)t.data[a].label=e[a].label;break;case"map":for(let a=0;a<t.data.length;a++)t.data[a].label=e[a].title;break;default:throw new Error(`_addLabel: the type "${a}" is unknown!`)}!function(t,e,a){switch(a){case"area":case"bar":case"column":case"pie":case"barchartrace":for(let a=0;a<t.data.length;a++)t.data[a].color=e[a].style.fillColor;break;case"line":for(let a=0;a<t.data.length;a++)t.data[a].color=e[a].style.stroke;break;case"polar":for(let a=0;a<t.data.length;a++)"line"===e[a].type?t.data[a].color=e[a].style.stroke:t.data[a].color=e[a].style.fillColor;break;case"radar":for(let a=0;a<t.data.length;a++)"area"===e[a].type?t.data[a].color=e[a].style.fillColor:t.data[a].color=e[a].style.stroke;break;case"map":for(let a=0;a<t.data.length;a++)e&&e[a]&&e[a].style&&(t.data[a].color=e[a].style.fillColor)}}(t,e,a);for(let e=t.data.length-1;e>=0;e--)void 0===t.data[e].label&&t.data.splice(e,1)}(l,a,s),r.getBbox(t,l),function(t,e){const a=t.background,{icon:r}=t,{layout:i}=t,{align:n}=t;if(!1!==t.enabled){a.width=0,a.height=0;for(let e=0;e<t.data.length;e++)"horizontal"===i?(a.width+=r.width+r.gap.x+t.data[e].bbox.width+4*r.gap.x,a.height=t.data[e].bbox.height):(a.width<r.width+r.gap.x+t.data[e].bbox.width&&(a.width=r.width+r.gap.x+t.data[e].bbox.width),a.height+=r.height+r.gap.y);"horizontal"===i?(a.width-=4*r.gap.x,a.width+=a.padding.left+a.padding.right,a.height+=a.padding.bottom):(a.height-=r.gap.y,a.width+=a.padding.left+a.padding.right,a.height+=a.padding.top+a.padding.bottom),a.width=Math.round(a.width),a.height=Math.round(a.height),"left"===n.horizontal?a.x=1:"middle"===n.horizontal?a.x=(e.chart.width-a.width)/2:a.x=e.chart.width-a.width-1,"top"===n.vertical?a.y=1:"middle"===n.vertical?a.y=(e.chart.height-a.height)/2:a.y=e.chart.height-a.height-1,a.x+=t.shift.x,a.y+=t.shift.y}}(l,n),l}},r={getBbox(t,e){!function(t,e){if(!e.enabled)return;const a=t.$().append("g");for(let t=0;t<e.data.length;t++)a.append("text").attr("x",0).attr("y",0).text(e.data[t].label).parent(),e.data[t].bbox=a.getSize();a.remove("g")}(t,e)},draw(t,e){!function(t,e){const{background:a}=e,{icon:r}=e,{layout:i}=e;let n,s;if(!e.enabled)return;const l=t.$();l.select(".legend").attr("transform",`translate(${a.x}, ${a.y})`).append("rect").attr("class","background").attr("x",.5).attr("y",.5).attr("width",a.width).attr("height",a.height).parent(),n=a.padding.left,s=a.padding.top;for(let t=0;t<e.data.length;t++)l.append("rect").attr("style",`fill: ${e.data[t].color}`).attr("x",n).attr("y",s).attr("width",r.width).attr("height",r.height).parent().append("text").attr("x",n+r.width+r.gap.x).attr("y",s+r.height).text(e.data[t].label).parent(),"horizontal"===i?n+=r.width+r.gap.x+e.data[t].bbox.width+4*r.gap.x:s+=r.height+r.gap.y}(t,e)}},i={getParams:t=>(function(t){const e={enabled:null,floating:null,layout:null,align:{horizontal:null,vertical:null},shift:{x:null,y:null},icon:{width:null,height:null,gap:{x:null,y:null}},background:{x:null,y:null,width:null,height:null,padding:{top:5,left:5,bottom:5,right:5}},data:[]};for(let a=0;a<t;a++)e.data.push({label:null,color:null,bbox:{width:null,height:null}});return e})(t)},e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Snapshot&&(t.Snapshot=e(t))):t.Snapshot=e(t)}(r.src.libin,t=>{let e,a;return function(){const r=t.Snapshot;e={noConflict(){return t.Snapshot=r,this},take(...t){return a.takeSnapshot(...t),this}},e.VERSION="0.0.2"}(),function(){function t(){const t=arguments[0],e=arguments[1],a=arguments[2],r=arguments[3],i=arguments[4],n=document.createElement("canvas"),s=n.getContext("2d");n.setAttribute("width",256),n.setAttribute("height",256),s.drawImage(e,0,0,256,256);const l=n.toDataURL("image/png",1);t.setAttribute("xlink:href",l),a.push("a"),a.length>=r&&i()}function e(e,a,r){let i,n;const s=function(t,e){const a="http://www.w3.org/2000/svg",r=t.$().getElement(),i=document.createElementNS(a,"svg");i.setAttributeNS(null,"version","1.1"),i.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns",a),i.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),i.setAttribute("class",r.getAttribute("class")),i.setAttribute("width",r.getAttribute("width")),i.setAttribute("height",r.getAttribute("height"));for(let t=0;t<e.length;t++)null!==r.querySelector(e[t])?i.appendChild(r.querySelector(e[t]).cloneNode(!0)):console.log(`_createSVG warning: the node ${e[t]} does not exist!`);return i}(e,a),l=function(t,e){let a,r,i,n,s,l,o;r="",n="";const c=document.styleSheets;for(l=0;l<c.length;l++)for(a=c[l].cssRules,o=0;o<a.length;o++)i=a[o],i.selectorText===e&&(r=`svg { ${i.style.cssText} }\n`),void 0!==i.selectorText&&(s=t.querySelectorAll(i.selectorText.replace(`${e} `,"")),s.length>0&&(n+=`${i.selectorText.replace(e,"")} { ${i.style.cssText} }\n`));return r.concat(n)}(s,".pixi");!function(t,e){const a=document.createElement("style");a.setAttribute("xmlns","http://www.w3.org/1999/xhtml"),a.setAttribute("type","text/css"),a.innerHTML=`${e}>`,t.insertBefore(a,t.firstChild)}(s,l),function(e,a){let r,i,n,s,l;if(e.querySelector(".series")&&e.querySelector(".series").querySelector(".maps")&&e.querySelector(".series").querySelector(".maps").querySelector(".raster"))if(r=e.querySelector(".series").querySelector(".maps").querySelector(".raster").children,r.length>0){for(i=[],l=0;l<r.length;l++)r[l].getAttribute("xlink:href")&&i.push(r[l]);for(n=[],l=0;l<i.length;l++)s=document.createElement("img"),s.crossOrigin="Anonymous",s.addEventListener("load",t.bind(this,i[l],s,n,i.length,a),!1),s.src=i[l].getAttribute("xlink:href")}else a();else a()}(s,()=>{i=(new XMLSerializer).serializeToString(s),n=new Image,n.src=`data:image/svg+xml;base64,${window.btoa(unescape(encodeURIComponent(i)))}`,r(n,s)})}function r(...t){const a=function(){if(arguments.length<2)return null;const t={chart:arguments[0],format:"png",quality:"high",pause:1,nodes:[".series"],callback:null};for(let e=1;e<arguments.length;e++)"[object String]"===Object.prototype.toString.call(arguments[e])?"png"===arguments[e]||"jpeg"===arguments[e]?t.format=arguments[e]:"high"!==arguments[e]&&"medium"!==arguments[e]&&"low"!==arguments[e]||(t.quality=arguments[e]):"[object Number]"===Object.prototype.toString.call(arguments[e])?t.pause=arguments[e]:"[object Array]"===Object.prototype.toString.call(arguments[e])?t.nodes=arguments[e]:"[object Function]"===Object.prototype.toString.call(arguments[e])&&(t.callback=arguments[e]);return t.callback?t:null}(...t),r=1e3*a.pause;a&&setTimeout(()=>{e(a.chart,a.nodes,(t,e)=>{!function(t,e,a,r,i){t.onload=function(){let n,s;const l=document.createElement("canvas");l.width=e.getAttribute("width"),l.height=e.getAttribute("height"),l.getContext("2d").drawImage(t,0,0),n="jpeg"===a||"jpg"===a?"jpeg":"png",s="high"===r?1:"medium"===r?.5:"low"===r?.1:.5;const o=l.toDataURL(`image/${n}`,s);i(o)}}(t,e,a.format,a.quality,a.callback)})},r)}a={takeSnapshot(...t){return r(...t),this}}}(),e}),function(t,e){"function"==typeof define&&define.amd?define([""],e):"object"==typeof exports?(module.exports=e(t),null===t.Tooltip&&(t.Tooltip=e(t))):t.Tooltip=e(t)}(r.src.libin,t=>{let e,a,r,i;return function(){const n=t.Tooltip;let s;e=function(t,e){const a=Object.create(s);return a._svg=t||null,a._taskQ=e||null,a._tip={params:null,frame:i.getFrameParams(),x:0,y:0},a},e.VERSION="0.0.4",e.noConflict=function(){return t.Tooltip=n,this},s={set(t,e){return t.extend(this._tip.params,e),this},get:()=>i.getDefaultParams(),draw(t,e){return this._tip.params=t,r.draw(this._svg,this._tip,e),this},moveTo(t,e){return this._taskQ.popQ("tooltip",r=>{a.moveTo(this._svg,this._tip,t,e,r)}),this},move(t,e,r){return this._tip.params.anchor.x=e,this._tip.params.anchor.y=r,this._taskQ.popQ("tooltip",e=>{a.moveTo(this._svg,this._tip,this._tip.params,t,e)}),this},remove(){return this._tip.params&&this._taskQ.popQ("tooltip",t=>{a.remove(this._svg,this._tip,t)}),this},hide(){r.hide(this._svg)},release(){r.release(this._svg)}}}(),function(){function t(t,e,a,i){if(0===a.duration)return e.x=a.end.x,e.y=a.end.y,r.move(t,e.x,e.y),void(i&&i());const n=setInterval(()=>{a.t+=a.frequency,a.t>a.duration&&(a.t=a.duration),e.x=a.easing(a.t,a.start.x,a.end.x-a.start.x,a.duration),e.y=a.easing(a.t,a.start.y,a.end.y-a.start.y,a.duration),r.move(t,e.x,e.y),a.t===a.duration&&(clearInterval(n),i&&i())},a.frequency)}a={move(e,a,r,i){t(e,a,r,i)},moveTo(e,a,i,n,s){!function(e,a,i,n,s){const{frame:l}=a,{animate:o}=i,{duration:c}=i.animation,{easing:h}=i.animation,d=1e3/i.animation.framesPerSecond;a.params=i,r.draw(e,a,n),t(e,a,{start:{x:a.x,y:a.y},end:{x:Math.round(n.chart.grid.x+i.anchor.x+l.shift.x),y:Math.round(n.chart.grid.y+i.anchor.y+l.shift.y)},t:0,easing:h,duration:o?c:0,frequency:d},s)}(e,a,i,n,s)},remove(e,a,i){!function(e,a,i){const n={start:{x:a.x,y:a.y},end:{x:a.x,y:a.y},t:0,easing:a.params.animation.easing,duration:a.params.animation.duration/2,frequency:1e3/a.params.animation.framesPerSecond};t(e,a,n,()=>{r.remove(e),i()})}(e,a,i)}}}(),r={draw(t,e,a){e.params.custom?function(t,e){const{params:a}=e,{frame:r}=e,{custom:i}=a;t.$().select(".tooltip").removeAllChilds().append("foreignObject").attr("class","foreign").attr("width",i.width).attr("height",i.height).appendHTML(i.xmlString),r.bbox.width=parseInt(i.width,10),r.bbox.height=parseInt(i.height,10),"[object Function]"===Object.prototype.toString.call(a.anchor.x)&&(a.anchor.x=a.anchor.x(r)),"[object Function]"===Object.prototype.toString.call(a.anchor.y)&&(a.anchor.y=a.anchor.y(r)),r.shift.x=-parseInt(i.width,10)/2,r.shift.y=-(parseInt(i.height,10)+5)}(t,e):function(t,e,a){const r=t._SVG,{frame:n}=e,{params:s}=e;!function(t,e,a){t.$().select(".tooltip").attr("transform",`translate(${e}, ${a})`).removeAllChilds().append("path").attr("class","shadow1").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.05").attr("stroke-width","5").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow2").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.1").attr("stroke-width","3").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","shadow3").attr("fill","none").attr("stroke","black").attr("stroke-opacity","0.15").attr("stroke-width","1").attr("transform","translate(1,1)").attr("d","").parent().append("path").attr("class","frame").attr("stroke-width","1").attr("d","M0,0L1,0L1,1L0,1L0,0").parent()}(t,e.x,e.y);const l=function(t,e){let a=0;return null!==e&&(t.$().select(".tooltip").append("text").attr("class","title").attr("x",5).attr("y",15).text(e).parent(),a=15),a}(t,e.params.title);!function(t,e,a){const r=t.$().select(".tooltip");function i(t){const e=typeof t;return("function"===e||"object"===e)&&!!t}for(let t=0;t<e.length;t++)i(e[t])?(r.append("circle").attr("cx",8).attr("cy",15*(t+1)-3+a).attr("r",3),e[t].color&&r.attr("style",`fill: ${e[t].color}`),r.parent().append("text").attr("class",`label n${t}`).attr("x",16).attr("y",15*(t+1)+a).append("tspan").attr("class","item").text(`${e[t].label}: `).parent().append("tspan").attr("class","value").text(e[t].value).parent().parent()):r.append("text").attr("class",`label n${t}`).attr("x",10).attr("y",15*(t+1)+a).append("tspan").attr("class","item").text("").parent().append("tspan").attr("class","value").text(e[t]).parent().parent(),e[t].suffix&&(e[t].suffix.first&&r.select(`.label.n${t}`).append("tspan").attr("class","firstsuffix").text(e[t].suffix.first).parent().parent(),e[t].suffix.second&&r.select(`.label.n${t}`).append("tspan").attr("class","secondsuffix").text(e[t].suffix.second).parent().parent())}(t,e.params.content,l),n.bbox=t.$().select(".tooltip").getSize(),n.bbox.width*=1.1,n.bbox.height*=1.1,i.computePosition(e,a,s.x,s.y),t.$().select(".tooltip").select(".shadow1").attr("d",r.getLine(n.coord,!0)).parent().select(".shadow2").attr("d",r.getLine(n.coord,!0)).parent().select(".shadow3").attr("d",r.getLine(n.coord,!0)).parent().select(".frame").attr("stroke",s.frameColor).attr("d",r.getLine(n.coord,!0))}(t,e,a)},move(t,e,a){!function(t,e,a){t.$().select(".tooltip").attr("transform",`translate(${e}, ${a})`)}(t,e,a)},remove(t){!function(t){t.$().select(".tooltip").removeAllChilds()}(t)},hide(t){!function(t){t.$().select(".tooltip").attr("style","visibility: hidden")}(t)},release(t){!function(t){t.$().select(".tooltip").attr("style","visibility: visible")}(t)}},function(){function t(t){const{params:e}=t,{frame:a}=t,r=[{x:0,y:0},{x:a.bbox.width,y:0},{x:a.bbox.width,y:a.bbox.height},{x:a.bbox.width/2+7.5,y:a.bbox.height},{x:a.bbox.width/2,y:a.bbox.height+7.5},{x:a.bbox.width/2-7.5,y:a.bbox.height},{x:0,y:a.bbox.height}],i=[{x:0,y:0},{x:a.bbox.width,y:0},{x:a.bbox.width,y:a.bbox.height},{x:0,y:a.bbox.height},{x:0,y:a.bbox.height/2+7.5},{x:-7.5,y:a.bbox.height/2},{x:0,y:a.bbox.height/2-7.5}];switch(e.orientation.type){case"horizontal":a.coord=r,"horizontal"===e.orientation.symmetry?(a.coord.forEach(t=>{t.y=a.bbox.height-t.y}),a.shift.x=-a.bbox.width/2,a.shift.y=7.5):(a.shift.x=-a.bbox.width/2,a.shift.y=-(a.bbox.height+7.5+2)),"left"===e.orientation.shift?(a.coord[3].x=30,a.coord[4].x=22.5,a.coord[5].x=15,a.shift.x=-22.5):"right"===e.orientation.shift&&(a.coord[3].x=a.bbox.width-15,a.coord[4].x=a.bbox.width-22.5,a.coord[5].x=a.bbox.width-30,a.shift.x=-(a.bbox.width-22.5)),a.outerbbox={x:a.bbox.width,y:a.bbox.height+7.5};break;case"vertical":a.coord=i,"vertical"===e.orientation.symmetry?(a.coord.forEach(t=>{t.x=a.bbox.width-t.x}),a.shift.x=-(a.bbox.width+7.5+3),a.shift.y=-a.bbox.height/2):(a.shift.x=7.5,a.shift.y=-a.bbox.height/2),"top"===e.orientation.shift?(a.coord[4].y=30,a.coord[5].y=22.5,a.coord[6].y=15,a.shift.y=-22.5):"bottom"===e.orientation.shift&&(a.coord[4].y=a.bbox.height-15,a.coord[5].y=a.bbox.height-15-7.5,a.coord[6].y=a.bbox.height-15-7.5-7.5,a.shift.y=-(a.bbox.height-15-7.5)),a.outerbbox={x:a.bbox.width+7.5,y:a.bbox.height};break;default:throw new Error(`_createGeometry: the type "${e.orientation.type}" is unknown!`)}for(let t=0;t<a.coord.length;t++)a.coord[t]={x:Math.round(a.coord[t].x)+.5,y:Math.round(a.coord[t].y)+.5}}i={getFrameParams:()=>({coord:[],outerbbox:{x:null,y:null},bbox:{width:null,height:null},shift:{x:null,y:null}}),getDefaultParams:()=>({visible:!1,frameColor:"slategrey",title:null,content:[],custom:null,animate:!1,animation:{easing:(t,e,a,r)=>a*t/r+e,framesPerSecond:50,duration:1e3},orientation:{type:null,symmetry:null,shift:null},anchor:{x:null,y:null},limits:{min:{x:0,y:0},max:{x:0,y:0}}}),computePosition(e,a,r,i){!function(e,a,r,i){const{params:n}=e,{frame:s}=e;switch(a.chart.type){case"basic column":case"stacked column":case"basic bar":case"stacked bar":case"line":case"basic area":case"stacked area":case"percent area":case"radar":case"pie":case"polar":case"waterfall":case"map":t(e),"[object Function]"===Object.prototype.toString.call(n.anchor.x)&&(n.anchor.x=n.anchor.x(s)),"[object Function]"===Object.prototype.toString.call(n.anchor.y)&&(n.anchor.y=n.anchor.y(s)),"horizontal"===n.orientation.type?(n.anchor.x+s.outerbbox.x/2>n.limits.max.x?n.orientation.shift="right":n.anchor.x-s.outerbbox.x/2<n.limits.min.x&&(n.orientation.shift="left"),Math.abs(n.anchor.y)+s.outerbbox.y>n.limits.max.y&&(n.orientation.symmetry="horizontal")):(n.anchor.x+s.outerbbox.x>n.limits.max.x&&(n.orientation.symmetry="vertical"),Math.abs(n.anchor.y)+s.outerbbox.y/2>n.limits.max.y?n.orientation.shift="top":Math.abs(n.anchor.y)-s.outerbbox.y/2<n.limits.min.y&&(n.orientation.shift="bottom")),null===n.orientation.symmetry&&null===n.orientation.shift||t(e),0===r&&0===i&&(e.animate=!1);break;default:throw n.anchor.x=0,n.anchor.y=0,t(e),new Error(`_computePosition: the type "${a.chart.type}" is unknown!`)}}(e,a,r,i)}}}(),e}),function(){const{Messenger:t}=r.src.lib,e=r.src.lib.overslash,{SVG:a}=r.src.lib,{TaskQ:i}=r.src.lib,{Chart:n}=r.src.libin,{Legend:s}=r.src.libin,{Snapshot:l}=r.src.libin,{Tooltip:o}=r.src.libin,c=r.src.charts._chart.renderer,h=r.src.charts._chart.util;let d;d={_ccinit(){this._mess=t(),this._svg=a(this.sel),this._taskQ=i(),this._legend=s(),this._tooltip=o(this._svg,this._taskQ),this._db={series:null,opts:null},h.init(this._db,this.type),this._init()},_init(){return this},_copySeries:(t,e,a,r)=>n.data.copySeries(t,e,a,r),_addDemo(){return this},_normalizeSeries(t,e,a){n.data.normalizeSeries(t,e,a)},_computeAxisSettings(){return this},_postInit(){return this},_drawGrid(t,e,a,r,i){return n.dom.drawGrid(t,e,a,r,i),this},_drawChart(){return this},_addVerticalCursor(t,e){return n.dom.addVerticalCursor(t,e),this},_addActiveArea(){return this},_setActiveArea:t=>n.data.setActiveArea(t),_findMatch:()=>null,_setLights:()=>null,_highlightSelectedPoints(t,e,a){n.dom.highlightSelectedPoints(t,e,a)},_setTooltip:()=>null,_draw(t,e){c.draw(this,t,e)},_update(){return this},update(t){return this._update(t),this},attachTooltip(t,a,r){return e.isString(t)&&e.isString(a)&&e.isString(r)&&(this._tooltip.custom={xmlString:t,width:a,height:r}),this},addEventListener(t,e){return this._mess.subscribe(t,e),this},addOneTimeEventListener(t,e){return this._mess.subscribeOnce(t,e),this},dispatchEvent(t,e){return this._mess.publish(t,e),this},removeEventListener(t,e){return this._mess.unsubscribe(t,e),this},on(t,e){return this.addEventListener(t,e)},one(t,e){return this.addOneTimeEventListener(t,e)},fire(t,e){return this.dispatchEvent(t,e)},off(t,e){return this.removeEventListener(t,e)},takeSnapshot(...t){l.take(this._svg,...t)}},r.extend(r.src.charts._chart.main,{GChart:function(t,a,r){if(!document.querySelector(t))throw new Error("The chart can't be created. There is no DOM element to attach it!");const i=Object.create(e.extend({},d,a));return i.sel=t,i.type=r,i._ccinit(),i}})}(),function(){const t=r.src.lib.overslash,{Chart:e}=r.src.libin,{Copyright:a}=r.src.libin,i=r.src.util.util1,n=r.src.util.util2;const s={draw(r,s,l){!function(r,s,l){const o=r._legend,{_db:c}=r,{type:h}=r,d=r._svg,u=t.isUndefined(s)?[]:s,x=l||{},p=r._copySeries(c.series,u,h,t);t.extend(c.opts,x),p||r._addDemo(c.series,c.opts),e.data.computeGenericSettings(c.opts),o.set(d,t,c.series,c.opts,h),e.data.computeGridSize(c.opts,o.get(),"charts"),r._normalizeSeries(c.series,c.opts,h),e.data.setChartType(c.opts,h),r._postInit(c.series,c.opts),r._computeAxisSettings(c.series,c.opts),e.dom.set(d,h,c.opts.chart.width,c.opts.chart.height);const y=d.$().getBbox();c.opts.chart.boundingBoxes={left:y.left+window.pageXOffset,top:y.top+window.pageYOffset},e.dom.fill(d,c.opts),r._drawGrid(d,c.series,c.opts,i,n),r._drawChart(d,c.series,c.opts),e.dom.drawHeader(d,c.opts),e.dom.drawFooter(d,c.opts),o.draw(d),r._addVerticalCursor(d,c.opts),r._addActiveArea(d,r._setActiveArea(c.opts)),a.draw(d),a.fill(d,c.opts,"classic")}(r,s,l)}};r.extend(r.src.charts._chart.renderer,s)}(),function(){const{Easing:t}=r.src.lib,{Chart:e}=r.src.libin,a=r.src.charts._chart.util;const i={onMouseOver(r){!function(r,i){const{target:n}=i,s=r._svg,l=r._tooltip,o=r._db,{series:c}=o,{opts:h}=o,d=h.tooltip.animated,u=t.easeOutBack;let x,p,y,g,m;n.onmousemove=function(t){(h.tooltip.enabled||h.cursor.enabled)&&(x=a.getMouseOrFingerPositionOnChart(s,t,h),e.dom.moveVerticalCursor(s,h,x.x),y=r._findMatch(c,h,x,t),g=r._setLights(c,h,y),r._highlightSelectedPoints(s,h,g),m=l.get(),m.animate=d,m.animation.easing=u,m.animation.framesPerSecond=50,m.animation.duration=750,r._setTooltip(m,h,c,x,y),y.point!==p&&(r.fire("over",{x:m.title,series:m.content}),p=y.point),l.custom&&(m.custom=l.custom),l.moveTo(m,h))}}(this,r)},onMouseOut(t){!function(t){const a=t._svg,r=t._tooltip,i=t._taskQ,n=t._db,{opts:s}=n;e.dom.turnVerticalCursorOff(a),e.dom.turnLightsOff(a,s),r.remove(i),t.fire("out")}(this)}};r.extend(r.src.charts._chart.mouseevents,i)}(),function(){const t={init(t,e){!function(t,e){t.opts={chart:{type:null,width:620,height:300,grid:{x:null,y:null,width:null,height:null,margin:{top:50,left:50,right:15,bottom:30}},boundingBoxes:{}},title:{label:null,x:null,y:20},subtitle:{label:null,x:null,y:35},footer:{label:null,x:null,y:null,style:{}},legend:{enabled:!0,floating:!1,layout:"vertical",align:{horizontal:"right",vertical:"middle"},shift:{x:0,y:0},icon:{width:null,height:null,gap:{x:null,y:null}}},tooltip:{enabled:!0,animated:!0},cursor:{enabled:!1},highlight:{enabled:!1},xAxis:{type:null,cursor:{enabled:!1},plot:{type:null,start:null,increment:null,suffix:"",margin:{left:5,right:5}},categories:{data:[]},data:{min:null,max:null,width:null,scale:null,numberOfElements:null}},yAxis:{min:null,max:null,minor:null,exp:null,scale:null,title:{label:"Label here",x:35,y:null},interval:{number:null,height:null}},constants:{timeToScale:1e3,framesPerSecond:50,gap:{x:12,y:-5},element:{edge:4,gap:1}}},t.opts.chart.type=e,t.series=[{label:null,type:null,prefix:"",suffix:"",visible:!1,color:null,data:[],private:{},style:{},over:{}}]}(t,e)},getMouseOrFingerPositionOnChart:(t,e,a)=>(function(t,e,a){let r,i;return a.chart.boundingBoxes=t.$().getBbox(),e.type.match(/touch/)?2===e.touches.length?(r=e.touches[0].clientX+(e.touches[1].clientX-e.touches[0].clientX)/2,i=e.touches[0].clientY+(e.touches[1].clientY-e.touches[0].clientY)/2):(r=e.touches[0].clientX,i=e.touches[0].clientY):(r=e.clientX,i=e.clientY),{x:r-(a.chart.boundingBoxes.left+a.chart.grid.x),y:i-(a.chart.boundingBoxes.top+a.chart.grid.y)}})(t,e,a)};r.extend(r.src.charts._chart.util,t)}(),function(){const{Chart:t}=r.src.libin,e=r.src.charts._chart.main,a=r.src.charts._chart.mouseevents,i=r.src.charts.classic.area.renderer,n=r.src.charts.classic.area.util;let s;s={_init(){n.init(this._db.series,this._db.opts)},_addDemo(t,e){n.addDemo(t,e)},_computeAxisSettings(t,e){n.computeAxisSettings(t,e)},_postInit(t,e){n.postInit(t,e)},_drawChart(t,e,a){i.drawChart(t,e,a)},_addActiveArea(e,r){t.dom.drawActiveArea(e,r),t.dom.addEvents2ActiveArea(e,r,a.onMouseOver.bind(this),a.onMouseOut.bind(this))},_findMatch:(t,e,a)=>n.findMatch(t,e,a),_setLights:(t,e,a)=>n.setLights(t,e,a),_setTooltip(t,e,a,r,i){n.setTooltip(t,e,a,r,i)}},r.extend(r.src.charts.classic.area.main,{Area:function(t,a,r){const i=e.GChart(t,s,"area");return i._draw(a,r),i}})}(),function(){const t=r.src.lib.overslash,{SVG:e}=r.src.lib;const a={drawChart(a,r,i){!function(a,r,i){const{numberOfElements:n}=i.xAxis.data,s=1e3/i.constants.framesPerSecond,{type:l}=i.chart,o=i.constants.timeToScale/s,c=i.chart.grid.x+i.xAxis.data.min,h=i.chart.grid.y,d=i.xAxis.data.scale,u=i.yAxis.scale,x=[];let p,y,g,m={},f=1,b=0,A=[],w=0,v=0,k=[];const M=a.$();if(M.select(".series").attr("transform",`translate(${c}, ${h}) scale(1, 1)`),"basic area"===l)for(p=0;p<r.length;p++)M.append("path").attr("class",`area n${p}`).attr("fill",r[p].style.fillColor||"inherit").attr("fill-opacity",void 0!==r[p].style.fillOpacity?r[p].style.fillOpacity:"inherit").attr("d","").parent().append("path").attr("class",`line n${p}`).attr("stroke",r[p].style.stroke||"inherit").attr("stroke-opacity",void 0!==r[p].style.strokeOpacity?r[p].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==r[p].style.strokeWidth?r[p].style.strokeWidth:"inherit").attr("d","").parent();else{for(p=0;p<r.length;p++)M.append("path").attr("class",`area n${p}`).attr("fill",r[p].style.fillColor||"inherit").attr("fill-opacity",void 0!==r[p].style.fillOpacity?r[p].style.fillOpacity:"inherit").attr("d","").parent();for(p=0;p<r.length;p++)M.append("path").attr("class",`line n${p}`).attr("stroke",r[p].style.stroke||"inherit").attr("stroke-opacity",void 0!==r[p].style.strokeOpacity?r[p].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==r[p].style.strokeWidth?r[p].style.strokeWidth:"inherit").attr("d","").parent()}switch(M.parent(),m=a.$().select(".series"),o>n?(f=Math.floor(o/n),w=1):(f=o/n,w=Math.round(1/f)),l){case"basic area":case"stacked area":for(f<1&&(f=1),p=0;p<r.length;p++){for(y=0;y<r[p].data.length-1;y++)for(g=0;g<f;g++)A.push({x:g/f*1+y,y:(r[p].data[y+1]-r[p].data[y])*(g/f)+r[p].data[y]});A.push({x:y,y:r[p].data[y]}),x[p]=A,A=[]}break;case"percent area":for(f<1&&(f=1),p=0;p<r.length;p++){for(y=0;y<r[p].exdata.length-1;y++)for(g=0;g<f;g++)A.push({x:g/f*1+y,y:(r[p].exdata[y+1]-r[p].exdata[y])*(g/f)+r[p].exdata[y]});A.push({x:y,y:r[p].exdata[y]}),x[p]=A,A=[]}}for(p in k=[],x)for(y in x[p])x[p][y].x=(x[p][y].x+.5)*d,x[p][y].y=x[p][y].y*u*-1,"stacked area"!==l&&"percent area"!==l||(t.isUndefined(k[y])&&(k[y]=0),x[p][y].y+=k[y],k[y]=x[p][y].y);v=0,b=setInterval(()=>{let t=[],a=[],i=[];for(v+=w,v>=x[0].length&&(v=x[0].length,clearInterval(b)),p=0;p<r.length;p++){if(t=x[p].slice(0,v),"basic area"===l)i=[],i[0]={x:t[0].x,y:0},i=i.concat(t),i.push({x:t[t.length-1].x,y:0});else for(0!==parseInt(p,10)&&(a=x[parseInt(p,10)-1].slice(0,v)),i=[],i=i.concat(t),y=v;y>0;y--)0===parseInt(p,10)?i.push({x:t[y-1].x,y:0}):i.push({x:a[y-1].x,y:a[y-1].y-0});m.select(`.line.n${p}`).attr("d",e.getLine(x[p].slice(0,v),!1)).parent().select(`.area.n${p}`).attr("d",e.getLine(i,!1)).parent()}},s)}(a,r,i)}};r.extend(r.src.charts.classic.area.renderer,a)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util2;const a={init(e,a){!function(e,a){t.extend(a,{xAxis:{type:"categories"},highlight:{enabled:!0}}),e.forEach(t=>{t.style.fillColor="slategrey",t.style.stroke="slategrey"})}(e,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"area",data:[3,6,7,9,10,8,7,5,9,11,6,10]},{label:"Item 2",type:"area",data:[2,3,5,8,7,6,6,3,8,7,5,8]},{label:"Item 3",type:"area",data:[1,2,3,2,5,2,4,1,2,4,3,5]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.xAxis.categories.data=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],a.title.label="Demo Chart"}(e,a)},postInit(t,e){!function(t,e){"basic area"!==e.chart.type&&(e.cursor.enabled=!0)}(0,e)},computeAxisSettings(a,r){!function(e,a){const r=[];switch(a.chart.type){case"basic area":case"stacked area":break;case"percent area":for(let t=0;t<e.length;t++)e[t].exdata=[];for(let a=0;a<e.length;a++)for(let i=0;i<e[a].data.length;i++)t.isNumber(r[i])||(r[i]=0),r[i]+=e[a].data[i];for(let t=0;t<e.length;t++)for(let a=0;a<e[t].data.length;a++)e[t].exdata.push(100/r[a]*e[t].data[a])}}(a,r),function(a,r){const{type:i}=r.chart;r.xAxis.data.min=0,r.xAxis.data.max=r.chart.grid.width-r.xAxis.data.min/2,r.xAxis.data.width=r.chart.grid.width,r.xAxis.data.scale=r.chart.grid.width/r.xAxis.categories.data.length,r.xAxis.data.numberOfElements=r.xAxis.categories.data.length,r.yAxis.title.x=null===r.yAxis.title.x?r.chart.grid.margin.left-10:r.yAxis.title.x,r.yAxis.title.y=null===r.yAxis.title.y?r.chart.grid.height/2:r.yAxis.title.y,"percent area"===r.chart.type&&(r.yAxis.max=100,r.yAxis.minor=25,r.yAxis.title.label="Percent"),r.yAxis.max=null===r.yAxis.max?function(){const r=[];let n;return a.forEach((t,e)=>{r[e]=t.data}),n="basic area"!==i?e.ceil10(t.max(e.arSum(r))):e.ceil10(t.max(t.flatten(r,!0))),n}():r.yAxis.max,r.yAxis.min=null===r.yAxis.min?function(){const r=[];return a.forEach((t,e)=>{r[e]=t.data}),e.floor10(t.min(t.flatten(r,!0)))}():r.yAxis.min,r.yAxis.minor=null===r.yAxis.minor?(r.yAxis.max-r.yAxis.min)/4:r.yAxis.minor,r.yAxis.exp=e.toPrecision(r.yAxis.min)+1,r.yAxis.scale=r.chart.grid.height/(r.yAxis.max-r.yAxis.min),r.yAxis.interval={number:Math.round((r.yAxis.max-r.yAxis.min)/r.yAxis.minor),height:r.chart.grid.height/((r.yAxis.max-r.yAxis.min)/r.yAxis.minor)}}(a,r)},findMatch:(t,e,a)=>(function(t,e,a){const{type:r}=e.chart,i=(e.xAxis.data.scale,e.yAxis.scale),{numberOfElements:n}=e.xAxis.data,s={};let l,o,c,h;const d=a.x-e.xAxis.data.min;for(s.point=Math.floor(d/e.xAxis.data.width*n),s.point>=n&&(s.point-=1),l=2*e.chart.grid.height,s.serie=0,o=0,h=0;h<t.length;h++)"basic area"===r?o=t[h].data[s.point]:o+="stacked area"===r?t[h].data[s.point]:t[h].exdata[s.point],c=Math.abs(a.y+(o-e.yAxis.min)*i),l>c&&(l=c,s.serie=h);return s})(t,e,a),setLights:(t,e,a)=>(function(t,e,a){const{type:r}=e.chart,i=e.xAxis.data.scale,n=e.yAxis.scale;let s,l,o;switch(r){case"basic area":s=[],s[0]={x:(a.point+.5)*i,y:t[a.serie].data[a.point]*n*-1,color:t[a.serie].style.fillColor};break;case"stacked area":case"percent area":for(l=0,s=[],o=0;o<t.length;o++)l+="stacked area"===r?t[o].data[a.point]:t[o].exdata[a.point],s[o]={x:(a.point+.5)*i,y:l*n*-1,color:t[o].style.fillColor};break;default:throw new Error(`_setLights: the type "${r}" is unknown!`)}return s})(t,e,a),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const{type:n}=e.chart,s=e.xAxis.data.scale,l=e.yAxis.scale;switch(n){case"basic area":t.orientation.type="horizontal",t.frameColor=a[i.serie].style.fillColor,t.anchor={x:(i.point+.5)*s,y:a[i.serie].data[i.point]*l*-1-6},t.title=e.xAxis.categories.data[i.point],t.content[0]={label:a[i.serie].label,value:a[i.serie].data[i.point],suffix:a[i.serie].suffix,color:a[i.serie].style.fillColor},t.limits={max:{x:e.chart.grid.width,y:1.5*e.chart.grid.height},min:{x:0,y:0}};break;case"stacked area":case"percent area":t.orientation.type="vertical",t.animate=!1,t.frameColor=a[i.serie].style.fillColor,t.anchor={x:r.x,y:t=>{const a=t.bbox.height/2,i=Math.abs(r.y)-e.chart.grid.height/2,n=e.chart.grid.height/2;return r.y+a*i/n}},t.title=e.xAxis.categories.data[i.point];for(let e=0;e<a.length;e++)t.content[e]={label:a[e].label,value:a[e].data[i.point],suffix:a[e].suffix,color:a[e].style.fillColor},"percent area"===n&&(t.content[e].value=`${a[e].exdata[i.point].toFixed(1)}% (${a[e].data[i.point]})`);t.limits={max:{x:e.chart.width-e.chart.grid.x,y:e.chart.grid.height},min:{x:0,y:0}}}})(t,e,a,r,i)};r.extend(r.src.charts.classic.area.util,a)}(),function(){const{Chart:t}=r.src.libin,e=r.src.charts._chart.main,a=r.src.charts._chart.mouseevents,i=r.src.charts.classic.bar.renderer,n=r.src.charts.classic.bar.util;let s;s={_init(){n.init(this._db.series,this._db.opts)},_addDemo(t,e){n.addDemo(t,e)},_computeAxisSettings(t,e){n.computeAxisSettings(t,e)},_drawChart(t,e,a){i.drawChart(t,e,a)},_addActiveArea(e,r){t.dom.drawActiveArea(e,r),t.dom.addEvents2ActiveArea(e,r,a.onMouseOver.bind(this),a.onMouseOut.bind(this))},_findMatch:(t,e,a)=>n.findMatch(t,e,a),_setTooltip(t,e,a,r,i){n.setTooltip(t,e,a,r,i)}},r.extend(r.src.charts.classic.bar.main,{Bar:function(t,a,r){const i=e.GChart(t,s,"bar");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib;function e(e,a,r){switch(r.chart.type){case"basic bar":!function(e,a,r){const i=r.constants.element.edge,n=r.constants.element.gap,s=e.$(),l=r.chart.grid.x,o=r.chart.grid.y,c=r.yAxis.data.numberOfElements,h=(r.yAxis.data.width/c-2*i)/a.length-2*n,d=t.easeInOutCubic,u=r.constants.timeToScale,x=r.constants.framesPerSecond,p=r.xAxis.scale,y=r.yAxis.data.scale;let g,m,f,b;r.xAxis.max<0?(m=r.chart.grid.width,g=r.xAxis.max):r.xAxis.min<0?(m=r.xAxis.min*p*-1,g=0):(m=0,g=r.xAxis.min),s.select(".series").attr("transform",`translate(${l}, ${o}) scale(1, 1)`).append("g").attr("class","plus").attr("transform",`translate(${m}, 0.1) scale(1, 1)`).parent().append("g").attr("class","minus").attr("transform",`translate(${m}, 0.1), scale(1, 0)`).parent(),s.select(".plus");for(let t=0;t<a.length;t++){f=parseInt(t,10);for(let e=0;e<a[t].data.length;e++)b=parseInt(e,10),a[t].data[e]>=0&&s.append("rect").attr("class",`element n${f} i${b}`).attr("fill",a[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[t].style.fillOpacity?a[t].style.fillOpacity:"inherit").attr("stroke",a[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[t].style.strokeOpacity?a[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[t].style.strokeWidth?a[t].style.strokeWidth:"inherit").attr("x",0).attr("y",-1*(i+(h+2*n)*(f+1)-n+b*y)).attr("width",(a[t].data[e]-g)*p).attr("height",h).parent()}s.parent(),s.select(".minus");for(let t=0;t<a.length;t++){f=parseInt(t,10);for(let e=0;e<a[t].data.length;e++)b=parseInt(e,10),a[t].data[e]<0&&s.append("rect").attr("class",`element n${f} i${b}`).attr("fill",a[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[t].style.fillOpacity?a[t].style.fillOpacity:"inherit").attr("stroke",a[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[t].style.strokeOpacity?a[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[t].style.strokeWidth?a[t].style.strokeWidth:"inherit").attr("x",0).attr("y",-1*(i+(h+2)*n*(f+1)-n+b*y)).attr("width",(a[t].data[e]-g)*p*-1).attr("height",h).parent()}s.parent();const A={type:"scale",start:null,stop:null,duration:u,easing:d,frequency:x};A.start={x:0,y:1},A.stop={x:1,y:1},s.select(".plus").attr("transform",A).parent(),A.start={x:0,y:1},A.stop={x:-1,y:1},s.select(".minus").attr("transform",A)}(e,a,r);break;case"stacked bar":!function(e,a,r){const i=r.constants.element.edge,n=e.$(),s=r.chart.grid.x,l=r.chart.grid.y,o=r.yAxis.data.numberOfElements,c=r.yAxis.data.width/o,h=t.easeInOutCubic,d=r.constants.timeToScale,u=r.constants.framesPerSecond,x=r.xAxis.scale;r.yAxis.data.scale,n.select(".series").attr("transform",`translate(${s}, ${l}) scale(0, 1)`);for(let t=0;t<o;t++){let e=0,s=0;for(let l=0;l<a.length;l++)e=a[l].data[t],s+e>r.xAxis.max&&(e=r.xAxis.max-s),n.append("rect").attr("class",`element n${parseInt(l,10)} i${t}`).attr("fill",a[l].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[l].style.fillOpacity?a[l].style.fillOpacity:"inherit").attr("stroke",a[l].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[l].style.strokeOpacity?a[l].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[l].style.strokeWidth?a[l].style.strokeWidth:"inherit").attr("x",s*x).attr("y",-1*(c*(t+1)-i)).attr("width",e*x).attr("height",c-2*i).parent(),s+=e}const p={type:"scale",start:{x:0,y:1},stop:{x:1,y:1},duration:d,easing:h,frequency:u};n.attr("transform",p)}(e,a,r);break;default:throw new Error(`_drawChart: the type "${r.chart.type}" is unknown!`)}}const a={drawChart(t,a,r){e(t,a,r)}};r.extend(r.src.charts.classic.bar.renderer,a)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util1,a=r.src.util.util2;const i={init(e,a){!function(e,a){delete a.xAxis,delete a.yAxis,t.extend(a,{xAxis:{min:null,max:null,minor:null,exp:null,scale:null,title:{label:"Label here",x:null,y:null},interval:{number:null,height:null}},yAxis:{type:"categories",categories:{data:[]},data:{min:null,max:null,width:null,scale:null,numberOfElements:null}}}),e.forEach(t=>{t.style.fillColor="slategrey",t.style.stroke="slategrey"})}(e,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"bar",data:[3,4,7,2,10,8,7,5,9,10,6,1]},{label:"Item 2",type:"bar",data:[1,6,8,9,5,6,4,8,9,7,7,5]},{label:"Item 3",type:"bar",data:[3,4,3,3,1,2,10,1,2,4,10,8]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.yAxis.categories.data=["Q1","Q2","Q3","Q4","Q5"],a.title.label="Demo Chart"}(e,a)},computeAxisSettings(r,i){!function(r,i){const{type:n}=i.chart;i.xAxis.title.x=null===i.xAxis.title.x?i.chart.grid.width/2:i.xAxis.title.x,i.xAxis.title.y=null===i.xAxis.title.y?-i.chart.grid.margin.bottom:i.xAxis.title.y,i.xAxis.max=null===i.xAxis.max?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),"stacked bar"===n?i=a.ceil10(t.max(a.arSum(e))):(i=t.max(t.flatten(e,!0)),i=i<0?-a.floor10(Math.abs(i)):a.ceil10(i)),i}():i.xAxis.max,i.xAxis.min=null===i.xAxis.min?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),i=t.min(t.flatten(e,!0)),i=i<0?-a.ceil10(Math.abs(i)):a.floor10(i),"stacked bar"===n&&(i=0),i}():"stacked bar"===n?0:i.xAxis.min,i.xAxis.minor=null===i.xAxis.minor?(i.xAxis.max-i.xAxis.min)/4:i.xAxis.minor;const s=e.computeAxisRange(i.xAxis.max,i.xAxis.min,i.xAxis.minor);i.xAxis.max=s.max,i.xAxis.min=s.min,i.xAxis.minor=s.minor,i.xAxis.exp=a.toPrecision(i.xAxis.min)+1,i.xAxis.scale=i.chart.grid.width/(i.xAxis.max-i.xAxis.min),i.xAxis.interval={number:Math.round((i.xAxis.max-i.xAxis.min)/i.xAxis.minor),width:i.chart.grid.width/((i.xAxis.max-i.xAxis.min)/i.xAxis.minor)},i.yAxis.data.min=0,i.yAxis.data.max=i.chart.grid.height-i.yAxis.data.min/2,i.yAxis.data.width=i.chart.grid.height,i.yAxis.data.scale=i.chart.grid.height/i.yAxis.categories.data.length,i.yAxis.data.numberOfElements=i.yAxis.categories.data.length}(r,i)},findMatch:(t,e,a)=>(function(t,e,a){const{numberOfElements:r}=e.yAxis.data,i={},n=Math.abs(a.y-e.yAxis.data.min);return i.point=Math.floor(n/e.yAxis.data.width*r),i.point>=r&&(i.point-=1),i})(0,e,a),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const n=e.constants.element.edge,s=e.constants.element.gap,{type:l}=e.chart,o=e.yAxis.data.numberOfElements,c=e.yAxis.data.width/o-2*n,h=c/a.length-2*s,d=e.xAxis.scale,u=e.yAxis.data.scale;switch(t.orientation.type="vertical",t.frameColor=a[0].style.fillColor,l){case"basic bar":t.anchor={x:(a[0].data[i.point]-e.xAxis.min)*d,y:-1*(i.point*u+n+s+h/2)};break;case"stacked bar":t.anchor={x:0,y:-1*(i.point*u+n+s+c/2)};for(let e=0;e<a.length;e++)t.anchor.x+=a[e].data[i.point]*d}t.title=e.yAxis.categories.data[i.point];for(let e=0;e<a.length;e++)t.content[e]={label:a[e].label,value:a[e].data[i.point],suffix:a[e].suffix,color:a[e].style.fillColor};t.limits={max:{x:e.chart.width-e.chart.grid.x,y:e.chart.grid.height+e.constants.top},min:{x:0,y:0}}})(t,e,a,0,i)};r.extend(r.src.charts.classic.bar.util,i)}(),function(){const{Chart:t}=r.src.libin,e=r.src.charts._chart.main,a=r.src.charts.classic.barchartrace.renderer,i=r.src.charts.classic.barchartrace.util;let n;n={_init(){i.init(this._db.series,this._db.opts)},_addDemo(t,e){i.addDemo(t,e)},_normalizeSeries(t,e,a){i.normalizeSeries(t,e,a)},_computeAxisSettings(t,e){i.computeAxisSettings(t,e)},_drawGrid(){return this},_drawChart(t,e,r){a.drawChart(t,e,r)},_addActiveArea(e,a){t.dom.drawActiveArea(e,a),t.dom.addClickEvents2ActiveArea(e,a,this._onMouseClick.bind(this))},_setActiveArea:t=>({x0:t.chart.grid.x,y0:t.chart.grid.y-t.chart.grid.height,width:t.chart.grid.width,height:t.chart.grid.height}),_onMouseClick(){const{counter:t}=this._db.opts;return t.running?this.fire("click","running"):this.fire("click","stopped"),this},start(){return this._db.opts.counter.running||a.restartRace(this._svg,this._db.series,this._db.opts),this},stop(){return this._db.opts.counter.running&&a.stopRace(this._db.opts),this}},r.extend(r.src.charts.classic.barchartrace.main,{BarChartRace:function(t,a,r){const i=e.GChart(t,n,"barchartrace");return i._draw(a,r),i}})}(),function(){const t=r.src.charts.classic.barchartrace.bar,e=r.src.charts.classic.barchartrace.counter;let a;function i(t,e,a){const r=[],i=[];let n;for(let e=0;e<t.length;e++)r.push(t[e].data[a]),i.push(t[e].data[a]);i.sort((t,e)=>e-t),e.serierank=[];for(let a=0;a<i.length;a++)n=r.indexOf(i[a]),r[n]="a",e.serierank.push(n),t[n].previousrank=t[n].rank,t[n].rank=a}function n(e,a,r,i){const n=[];let s,l;for(let o=0;o<r.bars.number;o++)l=r.serierank[o],s=a[l],s.obar?s.obar.updateValues(s,r,i):(s.obar=t.Bar(e,s,r),s.obar.unpark(s,r,i)),n.push(l);for(let t=0;t<a.length;t++)s=a[t],s.rank>=r.bars.number&&s.previousrank<r.bars.number&&(s.obar.park(s,r),n.push(t));r.series2update=n}function s(t,e,a,r,i){let n,s;for(let l=0;l<e.series2update.length;l++)s=e.series2update[l],n=t[s],n.obar.updatePosition(n.obar.bsvg,n,e,a,r,i)}function l(r,n,l,o){!function(t,e){const{width:a}=e.chart.grid,{height:r}=e.chart.grid,i=e.chart.grid.x,n=e.chart.grid.y-e.chart.grid.height;t.$().select("defs").append("clipPath").attr("id","clipPathSeries").append("rect").attr("x",0).attr("y",0).attr("width",a).attr("height",r).parent().parent().parent(),t.$().select(".series").attr("transform",`translate(${i}, ${n}) scale(1, 1)`).attr("style","clip-path: url(#clipPathSeries)").parent()}(r,l),a=e.Counter(r,l),a.update(r,l.counter.values[0]),function(e,a,r,n){const l=1e3*r.counter.duration/2,o=[];let c,h,d=0;for(i(a,r,0),h=0;h<r.bars.number;h++)c=a[r.serierank[h]],c.obar=t.Bar(e,c,r),c.obar.init(c,r,0),o.push(r.serierank[h]);r.series2update=o,c=a[o[0]],c.obar.computeMaxTextSize(c.obar.bsvg,a);const u=setInterval(()=>{d+=20,d>=l?(clearInterval(u),n()):s(a,r,d,l,1)},20)}(r,n,l,o)}function o(t,e,r,l){const{counter:o}=r,c=1e3*o.duration;let h=0;o.index=l&&l<=o.values.length-2?l:0,i(e,r,o.index+1),n(t,e,r,o.index),o.running=!0;const d=setInterval(()=>{h+=20,s(e,r,h,c,4),h>=c&&(o.index+=1,h=0,a.update(t,o.values[o.index]),o.index>=o.values.length-1||o.race.stop?(o.running=!1,o.race.stop=!1,clearInterval(d)):(i(e,r,o.index+1),n(t,e,r,o.index)))},20)}const c={drawChart(t,e,a){l(t,e,a,()=>{o(t,e,a,0)})},restartRace(t,e,a){return o(t,e,a,a.counter.index),this},stopRace(t){return t.counter.race.stop=!0,this}};r.extend(r.src.charts.classic.barchartrace.renderer,c)}(),function(){const{Chart:t}=r.src.libin,e=5,a=.7;let i,n;i={init(t,e){return function(t,e){t.start={x:t.data[0],y:e.chart.grid.height,value:t.data[0]},t.end={x:t.data[0],y:e.bars.interval+(e.bars.height+e.bars.interval)*t.rank,value:t.data[0]}}(t,e),this},updatePosition(t,a,r,i,s,l){return function(t,a,r,i,s,l){const o=1.1*n,{height:c}=r.bars,h=(a.end.x-a.start.x)*(i/s)+a.start.x,d=l?i*l:i;let u;u=d<s?(a.end.y-a.start.y)*(d/s)+a.start.y:a.end.y,0===a.rank&&(r.bars.scale=(r.chart.grid.width-o)/h),t.attr("transform",`translate(0, ${u})`).select("rect").attr("width",h*r.bars.scale).attr("height",c).parent().select(".label").attr("x",h*r.bars.scale-e).parent().select(".value").attr("x",h*r.bars.scale+e).text(Math.round(h).toLocaleString("en-US")).parent()}(t,a,r,i,s,l),this},updateValues(t,e,a){return function(t,e,a){let r;t.start={x:t.data[a],y:t.end.y,value:t.data[a]},r=e.bars.interval+(e.bars.height+e.bars.interval)*t.rank,r>e.chart.grid.height&&(r=e.chart.grid.height),t.end={x:t.data[a+1],y:r,value:t.data[a+1]}}(t,e,a),this},unpark(t,e,a){return function(t,e,a){t.start={x:t.data[a],y:e.chart.grid.height,value:t.data[a]},t.end={x:t.data[a+1],y:e.bars.interval+(e.bars.height+e.bars.interval)*t.rank,value:t.data[a+1]}}(t,e,a),this},park(t,e){return function(t,e){t.start.y=t.end.y,t.end.y=e.chart.grid.height}(t,e),this},computeMaxTextSize(t,e){return function(t,e){let a=-9999;for(let t=0;t<e.length;t++)for(let r=0;r<e[t].data.length;r++)e[t].data[r]>a&&(a=e[t].data[r]);t.select(".value").text(Math.round(a).toLocaleString("en-US")),n=t.getSize().width||100,t.parent()}(t,e),this}},r.extend(r.src.charts.classic.barchartrace.bar,{Bar:function(e,r,n){const s=Object.create(i);return s.bsvg=e.$(),function(e,r,i){const{height:n}=i.bars;e.select(".series").append("g").attr("class","bar").attr("transform","translate(0, 9999)").append("rect").attr("style",r.bar?t.util.getStyle(r.bar.style):"inherit").attr("x",0).attr("y",0).attr("width",0).attr("height",n).parent().append("text").attr("class","label").attr("style",t.util.getStyle(r.title.style)).attr("x",0).attr("y",n*a).text(r.title.label).parent().append("text").attr("class","value").attr("style",r.value?t.util.getStyle(r.value.style):"inherit").attr("x",0).attr("y",n*a).text(r.data[0]).parent(),e._root=e[0]}(s.bsvg,r,n),s}})}(),function(){const{Chart:t}=r.src.libin;let e;e={update(t,e){return function(t,e){t.$().select(".counter").select(".value").text(e)}(t,e),this}},r.extend(r.src.charts.classic.barchartrace.counter,{Counter:function(a,r){const i=Object.create(e);return function(e,a){const{counter:r}=a,{width:i}=a.chart.grid,{height:n}=a.chart.grid,s=a.chart.grid.x,l=a.chart.grid.y-a.chart.grid.height;e.$().appendAfter("g",".series").attr("class","counter").attr("transform",`translate(${s+i}, ${l+n})`).append("text").attr("class","value").attr("style",t.util.getStyle(r.style)||"inherit").attr("x",0).attr("y",0).text("-")}(a,r),i}})}(),function(){const t=r.src.lib.overslash,e=r.src.util.util1,a=r.src.util.util2;const i={init(e,a){!function(e,a){delete a.xAxis,delete a.yAxis,t.extend(a,{legend:{enabled:!1},tooltip:{enabled:!1},footer:{label:null,x:null,y:null,style:{}},bars:{number:1,height:20,interval:3,scale:null},counter:{style:{},duration:1,animation:"auto",values:null,index:null,running:!1,race:{stop:!1}},rank:null,serierank:null,series2update:null,xAxis:{min:null,max:null,minor:null,exp:null,scale:null,title:{label:"Label here",x:null,y:null},interval:{number:null,height:null}},yAxis:{type:"categories",categories:{data:[]},data:{min:null,max:null,width:null,scale:null,numberOfElements:null}}}),e.length=0,e.push({title:{label:null,style:{}},bar:{style:{}},value:{prefix:"",suffix:"",style:{}},data:[],style:{},obar:null,rank:null,previousrank:null})}(e,a)},addDemo(e,a){!function(e,a){const r=[{title:{label:"Item 1"},data:[10,20,30,40,50,60,70,80,90]},{title:{label:"Item 1"},data:[5,15,12,20,10,8,34,15,30]},{title:{label:"Item 1"},data:[2,4,6,25,35,20,25,10,2]}],i=t.clone(e[0]);r.forEach((a,r)=>{e[r]=t.extend({},i,a)}),a.counter.values=[2010,2011,2012,2013,2014,2015,2016,2017,2018],a.bars.number=r.length,a.title.label="Demo Chart"}(e,a)},normalizeSeries(e,a,r){!function(e,a){const{counter:r}=a;let i;for(let a=0;a<e.length;a++)for(let i=0;i<r.values.length;i++)e[a].data[i]&&t.isNumber(e[a].data[i])||(e[a].data[i]=0);const n=r.values.length;for(let t=0;t<e.length;t++)i=e[t].data.length,e[t].data.splice(n,i-n)}(e,a)},computeAxisSettings(r,i){!function(r,i){const{type:n}=i.chart;i.xAxis.title.x=null===i.xAxis.title.x?i.chart.grid.width/2:i.xAxis.title.x,i.xAxis.title.y=null===i.xAxis.title.y?-i.chart.grid.margin.bottom:i.xAxis.title.y,i.xAxis.max=null===i.xAxis.max?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),"stacked bar"===n?i=a.ceil10(t.max(a.arSum(e))):(i=t.max(t.flatten(e,!0)),i=i<0?-a.floor10(Math.abs(i)):a.ceil10(i)),i}():i.xAxis.max,i.xAxis.min=null===i.xAxis.min?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),i=t.min(t.flatten(e,!0)),i=i<0?-a.ceil10(Math.abs(i)):a.floor10(i),"stacked bar"===n&&(i=0),i}():"stacked bar"===n?0:i.xAxis.min,i.xAxis.minor=null===i.xAxis.minor?(i.xAxis.max-i.xAxis.min)/4:i.xAxis.minor;const s=e.computeAxisRange(i.xAxis.max,i.xAxis.min,i.xAxis.minor);i.xAxis.max=s.max,i.xAxis.min=s.min,i.xAxis.minor=s.minor,i.xAxis.exp=a.toPrecision(i.xAxis.min)+1,i.xAxis.scale=i.chart.grid.width/(i.xAxis.max-i.xAxis.min),i.xAxis.interval={number:Math.round((i.xAxis.max-i.xAxis.min)/i.xAxis.minor),width:i.chart.grid.width/((i.xAxis.max-i.xAxis.min)/i.xAxis.minor)},i.yAxis.data.min=0,i.yAxis.data.max=i.chart.grid.height-i.yAxis.data.min/2,i.yAxis.data.width=i.chart.grid.height,i.yAxis.data.scale=i.chart.grid.height/i.yAxis.categories.data.length,i.yAxis.data.numberOfElements=i.yAxis.categories.data.length}(r,i)}};r.extend(r.src.charts.classic.barchartrace.util,i)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts.classic.circle.renderer,a=r.src.charts.classic.circle.util;let i;i={_init(){a.init(this._db.series,this._db.opts)},_addDemo(t,e){a.addDemo(t,e)},_normalizeSeries(){return this},_computeAxisSettings(t,e){a.computeAxisSettings(t,e)},_drawGrid(){return this},_drawChart(t,a,r){return e.drawChart(t,this._taskQ,a,r),this},_addActiveArea(){return this},_setActiveArea(){return this},_update(t){return e.update(this._svg,this._taskQ,this._db.opts,t),this}},r.extend(r.src.charts.classic.circle.main,{Circle:function(e,a,r){const n=t.GChart(e,i,"circle");return n._draw(a,r),n}})}(),function(){const{Easing:t}=r.src.lib,{SVG:e}=r.src.lib;function a(t,a,r,i,n){if(r.end===r.start)return i&&i(),void(n&&n());const s=setInterval(()=>{r.t+=r.period,r.t>r.duration&&(r.t=r.duration),a.data.value=r.easing(r.t,r.start,r.end-r.start,r.duration),function(t,e){t.$().select(".series").select(".digitaldisplay").select(".display").text(Math.round(e))}(t,a.data.value),function(t,a,r){const{radius:i}=a.chart,{thickness:n}=a.chart,s=(a.chart.angle.end-a.chart.angle.start)/(a.yAxis.max-a.yAxis.min),l=Math.PI/180*(s*(r.min-a.yAxis.min)+a.chart.angle.start),o=Math.PI/180*(s*(a.data.value-a.yAxis.min)+a.chart.angle.start);t.$().select(".series").select(".lineardisplay").select(`.${r.color}`).attr("d",e.getArc(l,o,i,i-n))}(t,a,r),r.t===r.duration&&(clearInterval(s),i&&i(),n&&n())},r.period)}function i(t,e,a,r,i){t.start=e<r?r:e>=r&&e<=i?e:i,t.end=a<r?r:a>=r&&a<=i?a:i,t.min=r,t.duration*=Math.abs(t.end-t.start)}function n(e,a,r,i){return{color:e,start:null,end:null,t:0,easing:t.easeInOutCubic,duration:a.constants.timeToScale/(r-i),period:1e3/a.constants.framesPerSecond||40}}function s(t,e,r,s){e.pushQ("update",l=>{!function(t,e,r,s,l){const o=r.data.value,c=r.yAxis.min,h=r.yAxis.maxGreen,d=r.yAxis.maxOrange,u=r.yAxis.max,x=[],p=n("green",r,u,c);i(p,o,s,c,h);const y=n("orange",r,u,c);i(y,o,s,h,d);const g=n("red",r,u,c);i(g,o,s,d,u),s>o?(x.push(p),x.push(y),x.push(g)):(x.push(g),x.push(y),x.push(p));const m=x.length;for(let i=0;i<m;i++)e.pushQ("moveto",e=>{x.length>1?a(t,r,x.shift(),e):a(t,r,x.shift(),e,l)})}(t,e,r,s,l)})}function l(t,a,r,i){!function(t,a){const r=t.$(),i=a.chart.grid.x+a.chart.grid.width/2,n=a.chart.grid.y-a.chart.grid.height/2,s=a.chart.radius,l=a.chart.radius-a.chart.thickness,o=Math.PI/180*a.chart.angle.start,c=Math.PI/180*a.chart.angle.end;r.select(".series").attr("transform",`translate(${i}, ${n}) scale(1, 1)`).append("g").attr("class","shape"),a.chart.angle.end-a.chart.angle.start==360?r.append("path").attr("class","body").attr("d",e.getArc(o,c-2e-5,s,l)).attr("style","stroke-width: 0").parent().append("path").attr("class","inlay").attr("d",e.getArc(o,c-2e-5,s,s)).parent().append("path").attr("class","inlay").attr("d",e.getArc(o,c-2e-5,l,l)):r.append("path").attr("class","body").attr("d",e.getArc(o,c,s,l))}(t,i),function(t){t.$().select(".series").append("g").attr("class","lineardisplay").append("path").attr("class","green").attr("d","").parent().append("path").attr("class","orange").attr("d","").parent().append("path").attr("class","red").attr("d","")}(t),function(t,e){const a=t.$(),{counter:r}=e;a.select(".series").append("g").attr("class","digitaldisplay"),a.append("text").attr("class","display").attr("x",r.x).attr("y",r.y).text("0").parent().append("text").attr("class","suffix").attr("x",r.x).attr("y",r.y+15).text(r.suffix)}(t,i);const n=i.data.value;i.data.value=i.yAxis.min,s(t,a,i,n)}const o={drawChart(t,e,a,r){l(t,e,0,r)},update(t,e,a,r){s(t,e,a,r)}};r.extend(r.src.charts.classic.circle.renderer,o)}(),function(){const t=r.src.lib.overslash;const e={init(e,a){!function(e,a){delete a.xAxis,delete a.yAxis,t.extend(a,{chart:{width:null,height:null,radius:80,thickness:30,angle:{start:-90,end:270},grid:{margin:{top:50,left:25,right:25,bottom:25}}},legend:{enabled:!1},tooltip:{enabled:!1},yAxis:{min:null,max:null,maxGreen:null,maxOrange:null,title:{label:"Label here",x:null,y:null}},counter:{x:null,y:null,suffix:"-"},data:{value:0},constants:{zero:-Math.PI/2}}),a.chart.width=a.chart.grid.margin.left+2*a.chart.radius+a.chart.grid.margin.right,a.chart.height=a.chart.grid.margin.top+2*a.chart.radius+a.chart.grid.margin.bottom}(0,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"circle",color:null,value:25}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.title.label="Demo Chart"}(e,a)},computeAxisSettings(t,e){!function(t,e){e.counter.x=e.counter.x?e.counter.x:0,e.counter.y=e.counter.y?e.counter.y:0}(0,e),function(t,e){e.yAxis.max=null===e.yAxis.max?100:e.yAxis.max,e.yAxis.min=null===e.yAxis.min?0:e.yAxis.min,e.yAxis.maxGreen=null===e.yAxis.maxGreen?70:e.yAxis.maxGreen,e.yAxis.maxOrange=null===e.yAxis.maxOrange?90:e.yAxis.maxOrange,t[0].value=t[0].value>e.yAxis.max?e.yAxis.max:t[0].value,t[0].value=t[0].value<e.yAxis.min?e.yAxis.min:t[0].value,e.data.value=t[0].value}(t,e)}};r.extend(r.src.charts.classic.circle.util,e)}(),function(){const{Chart:t}=r.src.libin,e=r.src.charts._chart.main,a=r.src.charts._chart.mouseevents,i=r.src.charts.classic.column.renderer,n=r.src.charts.classic.column.util;let s;s={_init(){n.init(this._db.series,this._db.opts)},_addDemo(t,e){n.addDemo(t,e)},_computeAxisSettings(t,e){n.computeAxisSettings(t,e)},_drawChart(t,e,a){i.drawChart(t,e,a)},_addActiveArea(e,r){t.dom.drawActiveArea(e,r),t.dom.addEvents2ActiveArea(e,r,a.onMouseOver.bind(this),a.onMouseOut.bind(this))},_findMatch:(t,e,a)=>n.findMatch(t,e,a),_setTooltip(t,e,a,r,i){n.setTooltip(t,e,a,r,i)}},r.extend(r.src.charts.classic.column.main,{Column:function(t,a,r){const i=e.GChart(t,s,"column");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib;function e(e,a,r){switch(r.chart.type){case"basic column":!function(e,a,r){const i=r.constants.element.edge,n=r.constants.element.gap,s=e.$(),l=r.chart.grid.x,o=r.chart.grid.y,c=r.xAxis.data.numberOfElements,h=(r.xAxis.data.width/c-2*i)/a.length-2*n,d=t.easeInOutCubic,u=r.constants.timeToScale,x=r.constants.framesPerSecond,p=r.xAxis.data.scale,y=r.yAxis.scale;let g,m,f,b;r.yAxis.max<0?(m=-1*r.chart.grid.height,g=r.yAxis.max):r.yAxis.min<0?(m=r.yAxis.min*y,g=0):(m=0,g=r.yAxis.min),s.select(".series").attr("transform",`translate(${l}, ${o}) scale(1, 1)`).append("g").attr("class","plus").attr("transform",`translate(0, ${m}) scale(1, 0)`).parent().append("g").attr("class","minus").attr("transform",`translate(0, ${m}) scale(1, 0)`).parent(),s.select(".plus");for(let t=0;t<a.length;t++){f=parseInt(t,10);for(let e=0;e<a[t].data.length;e++)b=parseInt(e,10),a[t].data[e]>=0&&s.append("rect").attr("class",`element n${f} i${b}`).attr("fill",a[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[t].style.fillOpacity?a[t].style.fillOpacity:"inherit").attr("stroke",a[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[t].style.strokeOpacity?a[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[t].style.strokeWidth?a[t].style.strokeWidth:"inherit").attr("x",i+(h+2*n)*f+n+b*p).attr("y",(a[t].data[e]-g)*y*-1).attr("width",h).attr("height",(a[t].data[e]-g)*y).parent()}s.parent(),s.select(".minus");for(let t=0;t<a.length;t++){f=parseInt(t,10);for(let e=0;e<a[t].data.length;e++)b=parseInt(e,10),a[t].data[e]<0&&s.append("rect").attr("class",`element n${f} i${b}`).attr("fill",a[t].style.fillColor||"inherit").attr("fill",a[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[t].style.fillOpacity?a[t].style.fillOpacity:"inherit").attr("stroke",a[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[t].style.strokeOpacity?a[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[t].style.strokeWidth?a[t].style.strokeWidth:"inherit").attr("x",i+(h+2*n)*f+n+b*p).attr("y",(a[t].data[e]-g)*y).attr("width",h).attr("height",(a[t].data[e]-g)*y*-1).parent()}s.parent();const A={type:"scale",start:null,stop:null,duration:u,easing:d,frequency:x};A.start={x:1,y:0},A.stop={x:1,y:1},s.select(".plus").attr("transform",A).parent(),A.start={x:1,y:0},A.stop={x:1,y:-1},s.select(".minus").attr("transform",A)}(e,a,r);break;case"stacked column":!function(e,a,r){const i=r.constants.element.edge,n=e.$(),s=r.chart.grid.x,l=r.chart.grid.y,o=r.xAxis.data.numberOfElements,c=r.xAxis.data.width/o-2*i,h=t.easeInOutCubic,d=r.constants.timeToScale,u=r.constants.framesPerSecond,x=(r.xAxis.data.scale,r.yAxis.scale);let p,y,g,m;for(n.select(".series").attr("transform",`translate(${s}, ${l}) scale(1, 0)`),g=0;g<o;g++)for(p=0,y=0,m=0;m<a.length;m++)p=a[m].data[g],y+p>r.yAxis.max&&(p=r.yAxis.max-y),n.append("rect").attr("class",`element n${parseInt(m,10)} i${g}`).attr("fill",a[m].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[m].style.fillOpacity?a[m].style.fillOpacity:"inherit").attr("stroke",a[m].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[m].style.strokeOpacity?a[m].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[m].style.strokeWidth?a[m].style.strokeWidth:"inherit").attr("x",i+(c+2*i)*g).attr("y",(y+p)*x*-1).attr("width",c).attr("height",p*x).parent(),y+=p;const f={type:"scale",start:{x:1,y:0},stop:{x:1,y:1},duration:d,easing:h,frequency:u};n.attr("transform",f)}(e,a,r);break;default:throw new Error(`_drawChart: the type "${r.chart.type}" is unknown!`)}}const a={drawChart(t,a,r){e(t,a,r)}};r.extend(r.src.charts.classic.column.renderer,a)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util1,a=r.src.util.util2;const i={init(t,e){!function(t,e){e.xAxis.type="categories",t.forEach(t=>{t.style.fillColor="slategrey",t.style.stroke="slategrey"})}(t,e)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"column",data:[3,6,7,9,10,8,7,5,9,11,6,10]},{label:"Item 2",type:"column",data:[2,3,5,8,7,6,6,3,8,7,5,8]},{label:"Item 3",type:"column",data:[1,2,3,2,5,2,4,1,2,4,3,5]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.xAxis.categories.data=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],a.title.label="Demo Chart"}(e,a)},computeAxisSettings(r,i){!function(r,i){const{type:n}=i.chart;i.xAxis.data.min=0,i.xAxis.data.max=i.chart.grid.width-i.xAxis.data.min/2,i.xAxis.data.width=i.chart.grid.width,i.xAxis.data.scale=i.chart.grid.width/i.xAxis.categories.data.length,i.xAxis.data.numberOfElements=i.xAxis.categories.data.length,i.yAxis.title.x=null===i.yAxis.title.x?i.constants.left-10:i.yAxis.title.x,i.yAxis.title.y=null===i.yAxis.title.y?i.chart.grid.height/2:i.yAxis.title.y,i.yAxis.max=null===i.yAxis.max?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),"stacked column"===n?i=a.ceil10(t.max(a.arSum(e))):(i=t.max(t.flatten(e,!0)),i=i<0?-a.floor10(Math.abs(i)):a.ceil10(i)),i}():i.yAxis.max,i.yAxis.min=null===i.yAxis.min?function(){const e=[];let i;return r.forEach((t,a)=>{e[a]=t.data}),i=t.min(t.flatten(e,!0)),i=i<0?-a.ceil10(Math.abs(i)):a.floor10(i),"stacked column"===n&&(i=0),i}():"stacked column"===n?0:i.yAxis.min,i.yAxis.minor=null===i.yAxis.minor?(i.yAxis.max-i.yAxis.min)/4:i.yAxis.minor;const s=e.computeAxisRange(i.yAxis.max,i.yAxis.min,i.yAxis.minor);i.yAxis.max=s.max,i.yAxis.min=s.min,i.yAxis.minor=s.minor,i.yAxis.exp=a.toPrecision(i.yAxis.min)+1,i.yAxis.scale=i.chart.grid.height/(i.yAxis.max-i.yAxis.min),i.yAxis.interval={number:Math.round((i.yAxis.max-i.yAxis.min)/i.yAxis.minor),height:i.chart.grid.height/((i.yAxis.max-i.yAxis.min)/i.yAxis.minor)}}(r,i)},findMatch:(t,e,a)=>(function(t,e,a){const{numberOfElements:r}=e.xAxis.data,i={},n=a.x-e.xAxis.data.min;return i.point=Math.floor(n/e.xAxis.data.width*r),i.point>=r&&(i.point-=1),i})(0,e,a),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const n=e.constants.element.edge,s=e.constants.element.gap,{type:l}=e.chart,o=e.xAxis.data.numberOfElements,c=e.xAxis.data.width/o-2*n,h=c/a.length-2*s,d=e.xAxis.data.scale,u=e.yAxis.scale;switch(t.orientation.type="basic column"===l?"vertical":"horizontal",t.frameColor=a[0].style.fillColor,l){case"basic column":t.anchor={x:i.point*d+n+s+h,y:(a[0].data[i.point]-e.yAxis.min)*u*-1};break;case"stacked column":t.anchor={x:i.point*d+n+c/2,y:0};for(let e=0;e<a.length;e++)t.anchor.y+=a[e].data[i.point]*u*-1}t.title=e.xAxis.categories.data[i.point];for(let e=0;e<a.length;e++)t.content[e]={label:a[e].label,value:a[e].data[i.point],suffix:a[e].suffix,color:a[e].style.fillColor};t.limits={max:{x:e.chart.width-e.chart.grid.x,y:e.chart.grid.height+e.constants.top},min:{x:0,y:0}}})(t,e,a,0,i)};r.extend(r.src.charts.classic.column.util,i)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts.classic.gauge.renderer,a=r.src.charts.classic.gauge.util;let i;i={_init(){a.init(this._db.series,this._db.opts)},_addDemo(t,e){a.addDemo(t,e)},_normalizeSeries(){return this},_computeAxisSettings(t,e){a.computeAxisSettings(t,e)},_drawGrid(){return this},_drawChart(t,a,r){return e.drawChart(t,this._taskQ,a,r),this},_addActiveArea(){return this},_setActiveArea(){return this},_update(t){return e.update(this._svg,this._taskQ,this._db.opts,t),this}},r.extend(r.src.charts.classic.gauge.main,{Gauge:function(e,a,r){const n=t.GChart(e,i,"gauge");return n._draw(a,r),n}})}(),function(){const{Easing:t}=r.src.lib,e=r.src.lib.overslash,{SVG:a}=r.src.lib;function i(t,e,a,r){if(a.end===a.start)return void(r&&r());const i=setInterval(()=>{a.t+=a.frequency,a.t>a.duration&&(a.t=a.duration),e.data.value=a.easing(a.t,a.start,a.end-a.start,a.duration),function(t,e){t.$().select(".series").select(".display").select(".digit").text(Math.round(e))}(t,e.data.value),function(t,e,a){const r=(e.chart.angle.end-e.chart.angle.start)/(e.yAxis.max-e.yAxis.min)*(a-e.yAxis.min)+e.chart.angle.start;t.$().select(".series").select(".needle").attr("transform",`rotate(${r})`)}(t,e,e.data.value),a.t===a.duration&&(clearInterval(i),r&&r())},a.frequency)}function n(a,r,n,s){let l;l=e.isNumber(s)?s>n.yAxis.max?n.yAxis.max:s<n.yAxis.min?n.yAxis.min:s:n.data.value,r.pushQ("update",e=>{!function(e,a,r,n){const s=t.easeInOutCubic,l=a.constants.timeToScale,o=1e3/a.constants.framesPerSecond||40;i(e,a,{start:a.data.value,end:r,t:0,easing:s,duration:l,frequency:o},n)}(a,n,l,e)})}function s(t,e,r,i){!function(t,e){const{radius:a}=e.chart,r=e.chart.grid.x+e.chart.grid.width/2,i=e.chart.grid.y-e.chart.grid.height/2;t.$().select(".series").attr("transform",`translate(${r}, ${i}) scale(1, 1)`).append("g").attr("class","shape").append("circle").attr("class","body").attr("cx",0).attr("cy",0).attr("r",a).parent().append("text").attr("class","title").attr("x",e.yAxis.title.x).attr("y",e.yAxis.title.y).text(e.yAxis.title.label)}(t,i),function(t,e){const{radius:r}=e.chart,{start:i}=e.chart.angle,{gap:n}=e.constants.band,{width:s}=e.constants.band,l=(e.chart.angle.end-i)/(e.yAxis.max-e.yAxis.min),o=l*(e.yAxis.maxGreen-e.yAxis.min),c=l*(e.yAxis.maxOrange-e.yAxis.min),h=l*(e.yAxis.max-e.yAxis.min);t.$().select(".series").append("g").attr("class","bandzone").append("path").attr("class","green").attr("d",a.getArc(Math.PI/180*i,Math.PI/180*(o+i),r-(n+s),r-n)).parent().append("path").attr("class","orange").attr("d",a.getArc(Math.PI/180*(i+o),Math.PI/180*(c+i),r-(n+s),r-n)).parent().append("path").attr("class","red").attr("d",a.getArc(Math.PI/180*(i+c),Math.PI/180*(h+i),r-(n+s),r-n))}(t,i),function(t,e){const a=t.$(),{textTicks:r}=e.yAxis.textTicks,i=e.chart.angle.end-e.chart.angle.start,n=(e.yAxis.max-e.yAxis.min)/e.yAxis.mainUnit,s=(e.yAxis.max-e.yAxis.min)/e.yAxis.minorUnit,l=(e.yAxis.max-e.yAxis.min)/s,o=Math.PI/180*e.chart.angle.start;let c,h,d,u,x,p,y;a.select(".series").append("g").attr("class","grid"),c=0,h=Math.PI/180*i/s,d=e.chart.radius-e.constants.tick.gap,u=d-e.constants.tick.minor.length;for(let t=0;t<=s;t++)0!==c&&a.append("line").attr("class","minor").attr("x1",u*Math.cos(h*t+o)).attr("y1",u*Math.sin(h*t+o)).attr("x2",d*Math.cos(h*t+o)).attr("y2",d*Math.sin(h*t+o)).parent(),c+=l,c===n&&(c=0);h=Math.PI/180*i/n,d=e.chart.radius-e.constants.tick.gap,u=d-e.constants.tick.major.length;for(let t=0;t<=n;t++)a.append("line").attr("class","major").attr("x1",u*Math.cos(h*t+o)).attr("y1",u*Math.sin(h*t+o)).attr("x2",d*Math.cos(h*t+o)).attr("y2",d*Math.sin(h*t+o)).parent();if(d=e.chart.radius-e.constants.tick.gap,u=d-e.constants.tick.major.length,"mainUnits"===r){h=Math.PI/180*i/n,u-=e.constants.tick.text.gap;for(let t=0;t<=n;t++)x=u*Math.cos(h*t+o),p=u*Math.sin(h*t+o),y=i/n*t+e.chart.angle.start+90,a.append("text").attr("transform",`rotate(${y}, ${x}, ${p})`).attr("class","middle").attr("x",x).attr("y",p).text(e.yAxis.mainUnit*t+e.yAxis.min).parent()}else a.append("text").attr("class","left").attr("x",u*Math.cos(Math.PI/180*e.chart.angle.start)).attr("y",u*Math.sin(Math.PI/180*e.chart.angle.start)).text(e.yAxis.min).parent().append("text").attr("class","right").attr("x",u*Math.cos(Math.PI/180*e.chart.angle.end)).attr("y",u*Math.sin(Math.PI/180*e.chart.angle.end)).text(e.yAxis.max).parent()}(t,i),function(t,e){const{counter:a}=e;t.$().select(".series").append("g").attr("class","display").append("text").attr("class","digit").attr("x",a.x).attr("y",a.y).text("0").parent().append("text").attr("class","suffix").attr("x",a.x).attr("y",a.y+15).text(a.suffix)}(t,i),function(t,e){const{needle:r}=e.constants,i=e.chart.angle.start;t.$().select(".series").append("g").attr("class","needle").attr("transform",`rotate(${i})`).append("path").attr("class","pointer").attr("d",a.getLine(r.shape)).parent().append("circle").attr("class","center").attr("cx",0).attr("cy",0).attr("r",r.button)}(t,i);const s=i.data.value;i.data.value=i.yAxis.min,n(t,e,i,s)}const l={drawChart(t,e,a,r){s(t,e,0,r)},update(t,e,a,r){n(t,e,a,r)}};r.extend(r.src.charts.classic.gauge.renderer,l)}(),function(){const t=r.src.lib.overslash;const e={init(e,a){!function(e,a){delete a.xAxis,delete a.yAxis,t.extend(a,{chart:{width:null,height:null,radius:68,angle:{start:-225,end:45},grid:{margin:{top:50,left:25,right:25,bottom:25}}},legend:{enabled:!1},yAxis:{min:null,max:null,mainUnit:null,minorUnit:null,maxGreen:null,maxOrange:null,textTicks:null,exp:null,scale:null,title:{label:"Name",x:null,y:null}},counter:{x:null,y:null,suffix:"-"},data:{value:0},constants:{band:{gap:3,width:7},tick:{gap:3,minor:{length:7},major:{length:10},text:{gap:10}},needle:{gap:3,button:5,shape:[]}}}),a.chart.width=a.chart.grid.margin.left+2*a.chart.radius+a.chart.grid.margin.right,a.chart.height=a.chart.grid.margin.top+2*a.chart.radius+a.chart.grid.margin.bottom,a.constants.needle.shape=[{x:0,y:-1.5},{x:a.chart.radius-a.constants.needle.gap,y:0},{x:0,y:1.5},{x:-12,y:0}]}(0,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"circle",color:null,value:70}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.title.label="Demo Chart"}(e,a)},computeAxisSettings(t,e){!function(t,e){e.counter.x=e.counter.x?e.counter.x:0,e.counter.y=e.counter.y?e.counter.y:.6*e.chart.radius}(0,e),function(t,e){e.yAxis.min=null===e.yAxis.min?0:e.yAxis.min,e.yAxis.max=null===e.yAxis.max?100:e.yAxis.max,e.yAxis.mainUnit=null===e.yAxis.mainUnit?10:e.yAxis.mainUnit,e.yAxis.minorUnit=null===e.yAxis.minorUnit?2:e.yAxis.minorUnit,e.yAxis.maxGreen=null===e.yAxis.maxGreen?.7*e.yAxis.max:e.yAxis.maxGreen>=e.yAxis.min&&e.yAxis.maxGreen<=e.yAxis.max?e.yAxis.maxGreen:e.yAxis.maxGreen<e.yAxis.min?e.yAxis.min:e.yAxis.max,e.yAxis.maxOrange=null===e.yAxis.maxOrange?.9*e.yAxis.max:e.yAxis.maxOrange>=e.yAxis.maxGreen&&e.yAxis.maxOrange<=e.yAxis.max?e.yAxis.maxOrange:e.yAxis.maxOrange<e.yAxis.maxGreen?e.yAxis.maxGreen:e.yAxis.max,e.yAxis.title.x=null===e.yAxis.title.x?0:e.yAxis.title.x,e.yAxis.title.y=null===e.yAxis.title.y?1*e.chart.radius/3*-1:e.yAxis.title.y,e.yAxis.textTicks=null===e.yAxis.textTicks?"limits":e.yAxis.textTicks,t[0].value=t[0].value>e.yAxis.max?e.yAxis.max:t[0].value,t[0].value=t[0].value<e.yAxis.min?e.yAxis.min:t[0].value,e.data.value=t[0].value}(t,e)}};r.extend(r.src.charts.classic.gauge.util,e)}(),function(){const{Chart:t}=r.src.libin,e=r.src.charts._chart.main,a=r.src.charts._chart.mouseevents,i=r.src.charts.classic.line.renderer,n=r.src.charts.classic.line.util;let s;s={_init(){n.init(this._db.series,this._db.opts)},_addDemo(t,e){n.addDemo(t,e)},_computeAxisSettings(t,e){n.computeAxisSettings(t,e)},_drawChart(t,e,a){i.drawChart(t,e,a)},_addActiveArea(e,r){t.dom.drawActiveArea(e,r),t.dom.addEvents2ActiveArea(e,r,a.onMouseOver.bind(this),a.onMouseOut.bind(this))},_findMatch:(t,e,a)=>n.findMatch(t,e,a),_setLights:(t,e,a)=>n.setLights(t,e,a),_setTooltip(t,e,a,r,i){n.setTooltip(t,e,a,r,i)}},r.extend(r.src.charts.classic.line.main,{Line:function(t,a,r){const i=e.GChart(t,s,"line");return i._draw(a,r),i}})}(),function(){const{SVG:t}=r.src.lib;function e(t,e,a,r){let i,n,s,l,o;if(a>1)return n=1,r/a%1!=0&&(n=r/a-Math.floor(r/a)),i=(r-1)/a-Math.floor((r-1)/a),l=e.data[Math.ceil(r/a)],s=e.data[Math.floor((r-1)/a)],[{x:(r-1)/a,y:(l-s)*i+s},{x:r/a,y:(l-s)*n+s}];o=Math.round(1/a);const c=(r-1)*o;r*o>t-1&&(o=t-1-c);const h=[];for(let t=0;t<=o;t++)h[t]={x:c+t,y:e.data[c+t]};return h}function a(t,e){return e.forEach(e=>{e.x*=t.xAxis.data.scale,e.y=(e.y-t.yAxis.min)*t.yAxis.scale*-1}),e}const i={drawChart(r,i,n){!function(r,i,n){const{numberOfElements:s}=n.xAxis.data,l=1e3/n.constants.framesPerSecond,o=n.constants.timeToScale/l,c=n.chart.grid.x+n.xAxis.data.min,h=n.chart.grid.y;let d=1,u=0,x=0,p=0;r.$().select(".series").attr("transform",`translate(${c}, ${h}) scale(1, 1)`),o>s?(d=Math.floor(o/s),p=(s-1)*d):(d=o/s,p=Math.ceil((s-1)/Math.round(1/d)));const y=r.$().select(".series");x=setInterval(()=>{if(u+=1,u>p)clearInterval(x);else for(let r=0;r<i.length;r++)y.append("path").attr("class",`sharp line n${r}`).attr("fill",i[r].style.fillColor||"inherit").attr("fill-opacity",void 0!==i[r].style.fillOpacity?i[r].style.fillOpacity:"inherit").attr("stroke",i[r].style.stroke||"inherit").attr("stroke-opacity",void 0!==i[r].style.strokeOpacity?i[r].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==i[r].style.strokeWidth?i[r].style.strokeWidth:"inherit").attr("d",t.getLine(a(n,e(s,i[r],d,u)),!1)).parent()},l)}(r,i,n)}};r.extend(r.src.charts.classic.line.renderer,i)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util1,a=r.src.util.util2;const i={init(e,a){!function(e,a){t.extend(a,{cursor:{enabled:!0},highlight:{enabled:!0}})}(0,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"line",color:null,data:[3,6,7,9,10,8,7,5,9,11,6,10]},{label:"Item 2",type:"line",color:null,data:[2,3,5,8,7,6,6,3,8,7,5,8]},{label:"Item 3",type:"line",color:null,data:[1,2,3,2,5,2,4,1,2,4,3,5]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.xAxis.categories.data=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],a.title.label="Demo Chart"}(e,a)},computeAxisSettings(e,r){!function(e,r){switch(null!==r.xAxis.plot.start?(r.xAxis.type="plot",r.xAxis.categories.data=[]):r.xAxis.type="categories",r.xAxis.plot.increment=null===r.xAxis.plot.increment?864e5:r.xAxis.plot.increment,r.xAxis.type){case"plot":r.xAxis.data.min=r.xAxis.plot.margin.left,r.xAxis.data.max=r.chart.grid.width-r.xAxis.plot.margin.right,r.xAxis.data.width=r.xAxis.data.max-r.xAxis.data.min,r.xAxis.data.scale=(r.xAxis.data.max-r.xAxis.data.min)/e[0].data.length,r.xAxis.data.numberOfElements=e[0].data.length;break;case"categories":r.xAxis.cursor.enabled=!0,r.xAxis.data.min=r.chart.grid.width/r.xAxis.categories.data.length/2,r.xAxis.data.max=r.chart.grid.width-r.xAxis.data.min/2,r.xAxis.data.width=r.chart.grid.width,r.xAxis.data.scale=r.chart.grid.width/r.xAxis.categories.data.length,r.xAxis.data.numberOfElements=r.xAxis.categories.data.length;break;default:throw new Error(`_computeAxisSettings: the type "${r.xAxis.type}" is unknown!`)}r.yAxis.title.x=null===r.yAxis.title.x?35:r.yAxis.title.x,r.yAxis.title.y=null===r.yAxis.title.y?r.chart.grid.height/2:r.yAxis.title.y,r.yAxis.max=null===r.yAxis.max?function(){const r=[];return e.forEach((t,e)=>{r[e]=t.data}),a.ceil10(t.max(t.flatten(r,!0)))}():r.yAxis.max,r.yAxis.min=null===r.yAxis.min?function(){const r=[];return e.forEach((t,e)=>{r[e]=t.data}),a.floor10(t.min(t.flatten(r,10)))}():r.yAxis.min,r.yAxis.minor=null===r.yAxis.minor?(r.yAxis.max-r.yAxis.min)/4:r.yAxis.minor,r.yAxis.exp=a.toPrecision(r.yAxis.min)+1,r.yAxis.scale=r.chart.grid.height/(r.yAxis.max-r.yAxis.min),r.yAxis.interval={number:Math.round((r.yAxis.max-r.yAxis.min)/r.yAxis.minor),height:r.chart.grid.height/((r.yAxis.max-r.yAxis.min)/r.yAxis.minor)}}(e,r)},findMatch:(t,e,a)=>(function(t,e,a){const{numberOfElements:r}=e.xAxis.data,i={};let n,s;const l=a.x-e.xAxis.data.min;i.point=Math.round(l/e.xAxis.data.width*r),i.point>=r&&(i.point-=1),n=2*e.chart.grid.height,i.serie=0;for(let r=0;r<t.length;r++)s=Math.abs((a.y+(t[r].data[i.point]-e.yAxis.min))*e.yAxis.scale),n>s&&(n=s,i.serie=r);return i})(t,e,a),setLights:(t,e,a)=>(function(t,e,a){const r=e.xAxis.data.scale,i=(e.yAxis.scale,[]);for(let n=0;n<t.length;n++)i[n]={x:a.point*r+e.xAxis.data.min,y:(t[n].data[a.point]-e.yAxis.min)*e.yAxis.scale*-1,color:t[n].style.stroke};return i})(t,e,a),setTooltip:(t,a,r,i,n)=>(function(t,a,r,i,n){const{type:s}=a.xAxis;t.orientation.type="categories"===s?"vertical":"horizontal",t.animate=!1,t.frameColor=r[0].style.stroke;for(let e=0;e<r.length;e++)t.content[e]={label:r[e].label,value:r[e].data[n.point],suffix:r[e].suffix,color:r[e].style.stroke};switch(t.limits={max:{x:a.chart.width-a.chart.grid.x,y:"categories"===s?a.chart.grid.height:1.5*a.chart.grid.height},min:{x:0,y:0}},s){case"categories":t.anchor={x:i.x,y(t){const e=t.bbox.height/2,r=Math.abs(i.y)-a.chart.grid.height/2,n=a.chart.grid.height/2;return i.y+e*r/n}};break;case"plot":"datetime"===a.xAxis.plot.type?t.title=e.matchDate(a.xAxis.plot.start,r[0].data.length,a.xAxis.plot.increment,n.point):t.title=n.point+a.xAxis.plot.start,t.anchor={x:i.x,y:(r[0].data[n.point]-a.yAxis.min)*a.yAxis.scale*-1-10};break;default:throw new Error(`_setTooltip: the type "${s}" is unknown!`)}})(t,a,r,i,n)};r.extend(r.src.charts.classic.line.util,i)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts._chart.mouseevents,a=r.src.charts.classic.pie.renderer,i=r.src.charts.classic.pie.util;let n;n={_init(){i.init(this._db.series,this._db.opts)},_addDemo(t,e){i.addDemo(t,e)},_normalizeSeries(t,e,a){return i.normalizeSeries(t,e,a),this},_computeAxisSettings(t,e){i.computeAxisSettings(t,e)},_drawGrid(){return this},_drawChart(t,e,r){return a.drawChart(t,this._taskQ,e,r),this},_addActiveArea(t){return a.drawActiveArea(t,this._db.series,this._db.opts,e.onMouseOver.bind(this),e.onMouseOut.bind(this)),this},_setActiveArea(){return this},_findMatch:(t,e,a,r)=>i.findMatch(t,e,a,r),_setLights:(t,e,a)=>i.setLights(t,e,a),_highlightSelectedPoints(t,e,r){a.turnHaloOn(t,this._db.series,e,r)},_setTooltip(t,e,a,r,n){i.setTooltip(t,e,a,r,n)}},r.extend(r.src.charts.classic.pie.main,{Pie:function(e,a,r){const i=t.GChart(e,n,"pie");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib,{SVG:e}=r.src.lib;function a(t,a,r,i){const n=t.$();n.select(".series").select(".shape").append("path").attr("class",`slice n${r.i}`).attr("fill",a[r.i].style.fillColor||"inherit").attr("fill-opacity",void 0!==a[r.i].style.fillOpacity?a[r.i].style.fillOpacity:"inherit").attr("stroke",a[r.i].style.stroke||"inherit").attr("stroke-opacity",void 0!==a[r.i].style.strokeOpacity?a[r.i].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==a[r.i].style.strokeWidth?a[r.i].style.strokeWidth:"inherit");const s=setInterval(()=>{r.t+=r.period,r.t>r.duration&&(r.t=r.duration);const t=r.easing(r.t,r.start,r.end-r.start,r.duration);n.attr("d",e.getArc(r.start,t,r.outer,r.inner)),r.t===r.duration&&(clearInterval(s),i&&i())},r.period)}const i={drawChart(e,r,i,n){!function(e,r,i,n){const{radius:s}=n.chart.grid,{cx:l}=n.chart.grid,{cy:o}=n.chart.grid,c=n.chart.grid.x,h=n.chart.grid.y,d=1*s,u=n.chart.hole*s,x=t.linear,p=n.constants.timeToScale,y=1e3/n.constants.framesPerSecond||40;let g=0,m=n.constants.zero;for(let t=0;t<i.length;t++)g+=i[t].value;const f=2*Math.PI/g;e.$().select(".series").attr("transform",`translate(${c+l}, ${h+o}) scale(1, 1)`).append("g").attr("class","shape");for(let t=0;t<i.length;t++){const n={i:t,start:m,end:m+i[t].value*f,t:0,easing:x,duration:p*(i[t].value/g),period:y,outer:d,inner:u};r.pushQ("slice",t=>{a(e,i,n,t)}),m+=i[t].value*f}}(e,r,i,n),function(t,e,a){const r=a.constants.zero,i=Math.PI/4,n=t.$(),{radius:s}=a.chart.grid,l=s*(1-a.chart.hole);let o,c,h,d,u,x;d=0;for(let t=0;t<e.length;t++)d+=e[t].value;const p=2*Math.PI/d;n.select(".series").append("g").attr("class","incrust").append("text").attr("x",0).attr("y",0).text("55.5%");const y=n.getSize();n.remove(),l<1.2*y.width?(o=!1,c=s,h=0):(o=!0,c=s-1.2*y.width/2,h=y.height/2),u=r;for(let t=0;t<e.length;t++)!0===o&&e[t].value*p>=i&&(x=u+e[t].value*p/2,n.append("text").attr("x",(c+h*Math.sin(x))*Math.cos(x)).attr("y",(c+h*Math.sin(x))*Math.sin(x)).text(e[t].percent).parent()),u+=e[t].value*p}(e,i,n)},drawActiveArea(t,a,r,i,n){!function(t,a,r,i,n){const s=r.constants.zero,l=t.$(),{radius:o}=r.chart.grid,{cx:c}=r.chart.grid,{cy:h}=r.chart.grid,d=r.chart.grid.x,u=r.chart.grid.y,x=1*o,p=r.chart.hole*o;l.select(".activearea").attr("transform",`translate(${d+c}, ${u+h}) scale(1, 1)`);let y,g=0;for(let t=0;t<a.length;t++)g+=a[t].value;const m=2*Math.PI/g;y=s;for(let t=0;t<a.length;t++)l.append("path").attr("class",`slice n${t}`).attr("d",e.getArc(y,y+a[t].value*m,x,p)).listen("mouseover",i).listen("mouseout",n).parent(),y+=a[t].value*m}(t,a,r,i,n)},turnHaloOn(t,a,r,i){!function(t,a,r,i){const n=r.constants.zero,s=t.$(),{radius:l}=r.chart.grid,{cx:o}=r.chart.grid,{cy:c}=r.chart.grid,h=r.chart.grid.x,d=r.chart.grid.y,u=1.1*l,x=l;let p,y=0;for(let t=0;t<a.length;t++)y+=a[t].value;const g=2*Math.PI/y;p=n;for(let t=0;t<i;t++)p+=a[t].value*g;s.select(".highlight").attr("transform",`translate(${h+o}, ${d+c})`).removeAllChilds(),s.append("path").attr("fill",a[i].style.fillColor).attr("d",e.getArc(p,p+a[i].value*g,u,x)).parent(),s.attr("display","inherit")}(t,a,r,i)}};r.extend(r.src.charts.classic.pie.renderer,i)}(),function(){const t=r.src.lib.overslash;const e={init(e,a){!function(e,a){t.extend(e,{value:0,percent:0}),t.extend(a,{chart:{hole:0,width:350,height:250,grid:{radius:null,cx:null,cy:null}},highlight:{enabled:!0},xAxis:null,yAxis:null,constants:{zero:-Math.PI/2}})}(e,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"pie",value:12},{label:"Item 2",type:"pie",value:4},{label:"Item 3",type:"pie",value:7},{label:"Item 4",type:"pie",value:2},{label:"Item 5",type:"pie",value:11}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.title.label="Demo Chart"}(e,a)},normalizeSeries(t,e,a){!function(t){let e=0;for(let a=0;a<t.length;a++)e+=t[a].value;for(let a=0;a<t.length;a++)t[a].percent=`${(t[a].value/e*100).toFixed(1)}%`}(t)},computeAxisSettings(e,a){!function(e,a){a.chart.grid.cx=a.chart.grid.width/2,a.chart.grid.cy=a.chart.grid.height/2*-1,a.chart.grid.radius=t.min([a.chart.grid.width,a.chart.grid.height])/2,a.chart.hole=!t.isNumber(a.chart.hole)||a.chart.hole<0||a.chart.hole>1?0:a.chart.hole}(0,a)},findMatch:(t,e,a,r)=>(function(t,e,a,r){return{point:parseInt(r.target.className.baseVal.match(/\d+/)[0],10)}})(0,0,0,r),setLights:(t,e,a)=>a.point,setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){t.orientation.type="horizontal",t.animate=!1,t.frameColor=a[i.point].style.fillColor,t.anchor={x:r.x,y:r.y-2},t.content[0]={label:a[i.point].label,value:`${a[i.point].value} (${a[i.point].percent})`,suffix:a[i.point].suffix,color:a[i.point].style.fillColor},t.limits={max:{x:e.chart.width,y:e.chart.height},min:{x:0,y:0}}})(t,e,a,r,i)};r.extend(r.src.charts.classic.pie.util,e)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts._chart.mouseevents,a=r.src.charts.classic.polar.renderer,i=r.src.charts.classic.polar.util;let n;n={_init(){i.init(this._db.series,this._db.opts)},_addDemo(t,e){i.addDemo(t,e)},_normalizeSeries(t,e,a){i.normalizeSeries(t,e,a)},_computeAxisSettings(t,e){i.computeAxisSettings(t,e)},_drawGrid(t,e,r){return a.drawGrid(t,e,r),this},_drawChart(t,e,r){a.drawChart(t,e,r)},_addActiveArea(t){a.addActiveArea(t,this._db.opts,e.onMouseOver.bind(this),e.onMouseOut.bind(this))},_setActiveArea(){},_findMatch:(t,e,a)=>i.findMatch(t,e,a),_setLights:(t,e,a)=>i.setLights(t,e,a),_setTooltip(t,e,a,r,n){i.setTooltip(t,e,a,r,n)}},r.extend(r.src.charts.classic.polar.main,{Polar:function(e,a,r){const i=t.GChart(e,n,"polar");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib,e=r.src.lib.overslash,{SVG:a}=r.src.lib;const i={drawGrid(t,a,r){!function(t,a,r){const i=r.constants.zero,n=t.$(),s=r.xAxis.max/r.xAxis.tick,l=2*Math.PI/s,o=r.yAxis.max/r.yAxis.minor,c=r.chart.grid.x,h=r.chart.grid.y,d=r.chart.grid.width/2,u=r.chart.grid.height/2*-1,x=e.min([r.chart.grid.width,r.chart.grid.height])/2;let p,y;r.chart.grid.radius=x,r.chart.grid.cx=d,r.chart.grid.cy=u;const g=[];for(let t=0;t<s;t++)g[t]={x:x*Math.cos(l*t+i),y:x*Math.sin(l*t+i),a:l*t+i};n.select(".grid").attr("transform",`translate(${c}, ${h}) scale(1, 1)`).append("circle").attr("cx",d).attr("cy",u).attr("r",x).parent();for(let t=0;t<g.length;t++)n.append("line").attr("class","x-axis").attr("x1",d).attr("y1",u).attr("x2",d+g[t].x).attr("y2",u+g[t].y).parent();for(let t=0;t<g.length;t++)p="middle",g[t].a>-Math.PI/2&&g[t].a<Math.PI/2?p="start":g[t].a>Math.PI/2&&g[t].a<3*Math.PI/2&&(p="end"),n.append("text").attr("class","x-axis").attr("style",`text-anchor: ${p}`).attr("x",d+1.1*g[t].x).attr("y",u+1.1*g[t].y).text(r.xAxis.tick*parseInt(t,10)+r.xAxis.suffix).parent();for(let t=0;t<o;t++)y=t*(r.yAxis.minor/r.yAxis.max),n.append("circle").attr("class","y-axis").attr("cx",d).attr("cy",u).attr("r",x*y).parent().append("text").attr("class","y-axis").attr("x",d-2).attr("y",u+x*y*-1).text((r.yAxis.max*y).toFixed(1)).parent()}(t,0,r)},drawChart(e,r,i){!function(e,r,i){const n=i.constants.zero,s=e.$(),l=i.chart.grid.x+i.chart.grid.width/2,o=i.chart.grid.y-i.chart.grid.height/2,{radius:c}=i.chart.grid,h=2*Math.PI/(i.xAxis.max/i.xAxis.tick),d=t.easeInOutCubic,u=i.constants.timeToScale,x=i.constants.framesPerSecond;let p,y;s.select(".series").attr("transform",`translate(${l}, ${o}) scale(0, 0)`);for(let t=0;t<r.length;t++){p=[];for(let e=0;e<r[t].data.length;e++)y=c/(i.yAxis.max-i.yAxis.min)*r[t].data[e],p[e]={x:y*Math.cos(h*e+n),y:y*Math.sin(h*e+n),r:y,a:h*e+n};if("line"===r[t].type||"area"===r[t].type)s.append("path").attr("class",`${r[t].type} n${t}`).attr("fill",r[t].style.fillColor||"inherit").attr("fill",r[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==r[t].style.fillOpacity?r[t].style.fillOpacity:"inherit").attr("stroke",r[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==r[t].style.strokeOpacity?r[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==r[t].style.strokeWidth?r[t].style.strokeWidth:"inherit").attr("d",a.getLine(p,!0)).parent();else if("column"===r[t].type){s.append("g").attr("class",`column n${t}`).attr("fill",r[t].style.fillColor||"inherit").attr("fill-opacity",void 0!==r[t].style.fillOpacity?r[t].style.fillOpacity:"inherit").attr("stroke",r[t].style.stroke||"inherit").attr("stroke-opacity",void 0!==r[t].style.strokeOpacity?r[t].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==r[t].style.strokeWidth?r[t].style.strokeWidth:"inherit");for(let t=0;t<p.length;t++)s.append("path").attr("d",a.getArc(p[t].a,p[t].a+h,p[t].r,0)).parent();s.parent()}}const g={type:"scale",start:{x:0,y:0},stop:{x:1,y:1},duration:u,easing:d,frequency:x};s.attr("transform",g)}(e,r,i)},addActiveArea(t,a,r,i){!function(t,a,r,i){const n=a.chart.grid.x+a.chart.grid.width/2,s=a.chart.grid.y-a.chart.grid.height/2,l=e.min([a.chart.grid.width,a.chart.grid.height])/2;t.$().select(".activearea").attr("transform",`translate(${n}, ${s}) scale(1, 1)`).append("circle").attr("cx",0).attr("cy",0).attr("r",l).listen("mouseover",r).listen("mouseout",i)}(t,a,r,i)}};r.extend(r.src.charts.classic.polar.renderer,i)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util2;const a={init(e,a){!function(e,a){t.extend(a,{chart:{width:420,height:330,radius:null,cx:null,cy:null},highlight:{enabled:!0},plotOptions:{plotStart:0,pointInterval:45},constants:{zero:-Math.PI/2}}),delete a.xAxis,t.extend(a,{xAxis:{min:0,max:360,tick:45,suffix:"?"}}),e.forEach(t=>{t.style.fillColor="slategrey",t.style.stroke="slategrey"})}(e,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Series 1",type:"column",data:[9,8,7,6,5,4,3,2]},{label:"Series 2",type:"area",data:[9,8,7,6,5,4,3,1]},{label:"Series 3",type:"line",data:[1,2,3,4,5,6,7,8,9]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.title.label="Demo Chart"}(e,a)},normalizeSeries(t,e,a){!function(t,e){const a=e.xAxis.max/e.xAxis.tick;let r=0;for(let e=0;e<t.length;e++)for(let r=0;r<a;r++)void 0===t[e].data[r]&&(t[e].data[r]=0);for(let e=0;e<t.length;e++)r=t[e].data.length,t[e].data.splice(a,r-a)}(t,e)},computeAxisSettings(a,r){!function(a,r){r.yAxis.max=null===r.yAxis.max?function(){const r=[];return a.forEach((t,e)=>{r[e]=t.data}),e.ceil10(t.max(t.flatten(r,!0)))}():r.yAxis.max,r.yAxis.min=null===r.yAxis.min?function(){const r=[];return a.forEach((t,e)=>{r[e]=t.data}),e.floor10(t.min(t.flatten(r,!0)))}():r.yAxis.min,r.yAxis.minor=null===r.yAxis.minor?r.yAxis.max/4:r.yAxis.minor,r.yAxis.exp=e.toPrecision(r.yAxis.min)+1,r.yAxis.scale=r.chart.grid.height/(r.yAxis.max-r.yAxis.min),r.yAxis.interval={number:Math.round((r.yAxis.max-r.yAxis.min)/r.yAxis.minor),height:r.chart.grid.height/((r.yAxis.max-r.yAxis.min)/r.yAxis.minor)}}(a,r)},findMatch:(t,e,a)=>(function(t,e,a){const r=e.constants.zero,{radius:i}=e.chart.grid,{cx:n}=e.chart.grid,{cy:s}=e.chart.grid,l=2*Math.PI/(e.xAxis.max/e.xAxis.tick),o={};let c,h,d,u,x;a.x-=n,a.y-=s;const p=[];for(let a=0;a<t.length;a++)for(let n=0;n<t[a].data.length;n++)h=i/(e.yAxis.max-e.yAxis.min)*t[a].data[n],d=t[a].data.length,x=0,"column"===t[a].type&&(x=l/2),p[d*a+n]={x:h*Math.cos(l*n+x+r),y:h*Math.sin(l*n+x+r)};o.path=p,c=2*i;for(let t=0;t<p.length;t++)u=Math.sqrt(Math.pow(p[t].x-a.x,2)+Math.pow(p[t].y-a.y,2)),u<c&&(c=u,o.point=t);return o.serie=Math.floor(o.point/t[0].data.length),o.index=o.point%t[0].data.length,o.color="line"===t[o.serie].type?t[o.serie].style.stroke:t[o.serie].style.fillColor,o})(t,e,a),setLights:(t,e,a)=>(function(t,e,a){const{cx:r}=e.chart.grid,{cy:i}=e.chart.grid,n=[];return n[0]={x:r+a.path[a.point].x,y:i+a.path[a.point].y,color:a.color},n})(0,e,a),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const{radius:n}=e.chart.grid,{cx:s}=e.chart.grid,{cy:l}=e.chart.grid;t.orientation.type="horizontal",t.frameColor=i.color,t.anchor={x:s+i.path[i.point].x,y:l+i.path[i.point].y-6},t.title=e.xAxis.tick*parseInt(i.index,10)+e.xAxis.suffix,t.content[0]={label:a[i.serie].label,value:a[i.serie].data[i.index],suffix:a[i.serie].suffix,color:i.color},t.limits={max:{x:e.chart.grid.width,y:e.chart.grid.height+n/2},min:{x:0,y:0}}})(t,e,a,0,i)};r.extend(r.src.charts.classic.polar.util,a)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts._chart.mouseevents,a=r.src.charts.classic.radar.renderer,i=r.src.charts.classic.radar.util;let n;n={_init(){i.init(this._db.series,this._db.opts)},_addDemo(t,e){i.addDemo(t,e)},_computeAxisSettings(t,e){i.computeAxisSettings(t,e)},_drawGrid(t,e,r){return a.drawGrid(t,e,r),this},_drawChart(t,e,r){a.drawChart(t,e,r)},_addActiveArea(t){a.addActiveArea(t,this._db.opts,e.onMouseOver.bind(this),e.onMouseOut.bind(this))},_setActiveArea(){},_findMatch:(t,e,a)=>i.findMatch(t,e,a),_setLights:(t,e,a)=>i.setLights(t,e,a),_setTooltip(t,e,a,r,n){i.setTooltip(t,e,a,r,n)}},r.extend(r.src.charts.classic.radar.main,{Radar:function(e,a,r){const i=t.GChart(e,n,"radar");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib,e=r.src.lib.overslash,{SVG:a}=r.src.lib;const i={drawGrid(t,r,i){!function(t,r,i){const n=i.constants.zero,s=t.$(),l=i.xAxis.data.numberOfElements,o=i.chart.grid.x,c=i.chart.grid.y,h=i.chart.grid.width/2,d=i.chart.grid.height/2*-1,u=e.min([i.chart.grid.width,i.chart.grid.height])/2,x=2*Math.PI/l,p=i.yAxis.max/i.yAxis.minor;let y,g;i.chart.grid.radius=u,i.chart.grid.cx=h,i.chart.grid.cy=d;const m=[];for(let t=0;t<l;t++)m[t]={x:u*Math.cos(x*t+n),y:u*Math.sin(x*t+n),a:x*t+n};s.select(".grid").attr("transform",`translate(${o}, ${c}) scale(1, 1)`).append("path").attr("transform",`translate(${h}, ${d})`).attr("d",a.getLine(m,!0)).parent();for(let t=0;t<p;t++)y=t*(i.yAxis.minor/i.yAxis.max),s.append("path").attr("transform",`translate(${h}, ${d}) scale(${y}, ${y})`).attr("d",a.getLine(m,!0)).append("text").attr("class","y-axis").attr("x",h-2).attr("y",d+u*y*-1).text((i.yAxis.max*y).toFixed(1)).parent().parent();for(let t=0;t<m.length;t++)s.append("line").attr("class","x-axis").attr("x1",h).attr("y1",d).attr("x2",h+m[t].x).attr("y2",d+m[t].y).parent();for(let t=0;t<m.length;t++)g="middle",m[t].a>-Math.PI/2&&m[t].a<Math.PI/2?g="start":m[t].a>Math.PI/2&&m[t].a<3*Math.PI/2&&(g="end"),s.append("text").attr("class","x-axis").attr("style",`text-anchor: ${g}`).attr("x",h+1.1*m[t].x).attr("y",d+1.1*m[t].y).text(i.xAxis.categories.data[t]).parent()}(t,0,i)},drawChart(e,r,i){!function(e,r,i){const n=i.constants.zero,s=e.$(),l=i.chart.grid.x+i.chart.grid.width/2,o=i.chart.grid.y-i.chart.grid.height/2,{radius:c}=i.chart.grid,h=i.xAxis.data.numberOfElements,d=2*Math.PI/h,u=t.easeInOutCubic,x=i.constants.timeToScale,p=i.constants.framesPerSecond;let y,g,m,f;for(s.select(".series").attr("transform",`translate(${l}, ${o}) scale(0, 0)`),m=0;m<r.length;m++){for(y=[],f=0;f<r[m].data.length;f++)g=c/(i.yAxis.max-i.yAxis.min)*r[m].data[f],y[f]={x:g*Math.cos(d*f+n),y:g*Math.sin(d*f+n)};s.append("path").attr("class",`${r[m].type} n${m}`).attr("fill",r[m].style.fillColor||"inherit").attr("fill-opacity",void 0!==r[m].style.fillOpacity?r[m].style.fillOpacity:"inherit").attr("stroke",r[m].style.stroke||"inherit").attr("stroke-opacity",void 0!==r[m].style.strokeOpacity?r[m].style.strokeOpacity:"inherit").attr("stroke-width",void 0!==r[m].style.strokeWidth?r[m].style.strokeWidth:"inherit").attr("d",a.getLine(y,!0)).parent()}const b={type:"scale",start:{x:0,y:0},stop:{x:1,y:1},duration:x,easing:u,frequency:p};s.attr("transform",b)}(e,r,i)},addActiveArea(t,e,r,i){!function(t,e,r,i){const n=t.$(),{cx:s}=e.chart.grid,{cy:l}=e.chart.grid,{radius:o}=e.chart.grid,c=e.chart.grid.x,h=e.chart.grid.y,d=e.xAxis.data.numberOfElements,u=2*Math.PI/d,x=[];for(let t=0;t<d;t++)x[t]={x:s+o*Math.cos(u*t),y:l+o*Math.sin(u*t)};n.select(".activearea").attr("transform",`translate(${c}, ${h}) scale(1, 1)`).append("path").attr("d",a.getLine(x,!0)).listen("mouseover",r).listen("mouseout",i)}(t,e,r,i)}};r.extend(r.src.charts.classic.radar.renderer,i)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util2;const a={init(e,a){!function(e,a){t.extend(a,{chart:{width:420,height:330,radius:null,cx:null,cy:null},highlight:{enabled:!0},constants:{zero:-Math.PI/2}})}(0,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"line",data:[9,8,7,8,9,6,9,9]},{label:"Item 2",type:"line",data:[8,7,6,5,7,8,7,8]},{label:"Item 3",type:"area",data:[6,5,4,4,7,6,5,6]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.xAxis.categories.data=["Index 1","Index 2","Index 3","Index 4","Index 5","Index 6","Index 7","Index 8"],a.title.label="Demo Chart"}(e,a)},computeAxisSettings(a,r){!function(a,r){r.xAxis.data.min=0,r.xAxis.data.max=r.chart.grid.width-r.xAxis.data.min/2,r.xAxis.data.width=r.chart.grid.width,r.xAxis.data.scale=r.chart.grid.width/r.xAxis.categories.data.length,r.xAxis.data.numberOfElements=r.xAxis.categories.data.length,r.yAxis.max=null===r.yAxis.max?function(){const r=[];return a.forEach((t,e)=>{r[e]=t.data}),e.ceil10(t.max(t.flatten(r,!0)))}():r.yAxis.max,r.yAxis.min=null===r.yAxis.min?function(){const r=[];return a.forEach((t,e)=>{r[e]=t.data}),e.floor10(t.min(t.flatten(r,!0)))}():r.yAxis.min,r.yAxis.minor=null===r.yAxis.minor?(r.yAxis.max-r.yAxis.min)/4:r.yAxis.minor,r.yAxis.exp=e.toPrecision(r.yAxis.min)+1,r.yAxis.scale=r.chart.grid.height/(r.yAxis.max-r.yAxis.min),r.yAxis.interval={number:Math.round((r.yAxis.max-r.yAxis.min)/r.yAxis.minor),height:r.chart.grid.height/((r.yAxis.max-r.yAxis.min)/r.yAxis.minor)}}(a,r)},findMatch:(t,e,a)=>(function(t,e,a){const r=e.constants.zero,{radius:i}=e.chart.grid,{cx:n}=e.chart.grid,{cy:s}=e.chart.grid,l=e.xAxis.data.numberOfElements,o=2*Math.PI/l,c={};let h,d,u,x;a.x-=n,a.y-=s;const p=[];for(let a=0;a<t.length;a++)for(let n=0;n<t[a].data.length;n++)h=i/(e.yAxis.max-e.yAxis.min)*t[a].data[n],d=t[a].data.length,p[d*a+n]={x:h*Math.cos(o*n+r),y:h*Math.sin(o*n+r)};c.coord=p,u=2*i;for(let t=0;t<p.length;t++)x=Math.sqrt(Math.pow(p[t].x-a.x,2)+Math.pow(p[t].y-a.y,2)),x<u&&(u=x,c.point=t);return c.serie=Math.floor(c.point/t[0].data.length),c.index=c.point%t[0].data.length,c.color="area"===t[c.serie].type?t[c.serie].style.fillColor:t[c.serie].style.stroke,c})(t,e,a),setLights:(t,e,a)=>(function(t,e,a){const{cx:r}=e.chart.grid,{cy:i}=e.chart.grid,n=[];return n[0]={x:r+a.coord[a.point].x,y:i+a.coord[a.point].y,color:a.color},n})(0,e,a),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const{radius:n}=e.chart.grid,{cx:s}=e.chart.grid,{cy:l}=e.chart.grid;t.orientation.type="horizontal",t.frameColor=i.color,t.anchor={x:s+i.coord[i.point].x,y:l+i.coord[i.point].y-6},t.title=e.xAxis.categories.data[i.index],t.content[0]={label:a[i.serie].label,value:a[i.serie].data[i.index],suffix:a[i.serie].suffix,color:i.color},t.limits={max:{x:e.chart.grid.width,y:e.chart.grid.height+n/2},min:{x:0,y:0}}})(t,e,a,0,i)};r.extend(r.src.charts.classic.radar.util,a)}(),function(){const t=r.src.charts._chart.main,e=r.src.charts._chart.mouseevents,a=r.src.charts.financial.waterfall.renderer,i=r.src.charts.financial.waterfall.util;let n;n={_init(){i.init(this._db.series,this._db.opts)},_addDemo(t,e){i.addDemo(t,e)},_normalizeSeries(t,e,a){i.normalizeSeries(t,e,a)},_computeAxisSettings(t,e){i.computeAxisSettings(t,e)},_drawChart(t,r,i){a.drawChart(t,r,i,e.onMouseOver.bind(this),e.onMouseOut.bind(this))},_findMatch:(t,e,a,r)=>i.findMatch(t,e,a,r),_setTooltip(t,e,a,r,n){i.setTooltip(t,e,a,r,n)}},r.extend(r.src.charts.financial.waterfall.main,{Waterfall:function(e,a,r){const i=t.GChart(e,n,"waterfall");return i._draw(a,r),i}})}(),function(){const{Easing:t}=r.src.lib,e=r.src.lib.overslash;const a={drawChart(a,r,i,n,s){!function(a,r,i,n,s){const l=i.constants.element.gap,o=a.$(),c=i.chart.grid.x,h=i.chart.grid.y,d=i.xAxis.data.numberOfElements,u=i.xAxis.data.width/d,x=u-2*l,p=t.easeInOutCubic,y=i.constants.timeToScale,g=i.constants.framesPerSecond,m=(i.xAxis.data.scale,i.yAxis.scale);let f,b,A,w,v,k,M;o.select(".series").attr("transform",`translate(${c}, ${h}) scale(1, 1)`).append("text").attr("visibility","hidden").text(123);const _=o.getSize();o.parent().removeAllChilds().attr("transform",`translate(${c}, ${h}) scale(1, 0)`),k=0;for(let t=0;t<d;t++)b=u*t+l,w=x,0===t?(f=`start n${t}`,A=r[t].data[0]*m*-1,v=r[t].data[0]*m):t===d-1?(f=`end n${t}`,A=r[t].data[0]*m*-1,v=r[t].data[0]*m):r[t].data[0]>=0?(f=`pos n${t}`,A=(k+r[t].data[0])*m*-1,v=r[t].data[0]*m):(f=`neg n${t}`,A=k*m*-1,v=Math.abs(r[t].data[0]*m)),r[t].private.pos={x:b,y:A,width:w,height:v},M=r[t].visible?r[t].data[0]>0?r[t].prefix+r[t].data[0]+r[t].suffix:`-${r[t].prefix+Math.abs(r[t].data[0])+r[t].suffix}`:"",r[t].style=e.isLiteralObject(r[t].style)?r[t].style:{},o.append("rect").attr("class",f).attr("x",b).attr("y",A).attr("width",w).attr("height",v).attr("fill",r[t].style.fillColor||"inherit").attr("fill-opacity",r[t].style.fillOpacity||"inherit").attr("stroke",r[t].style.stroke||"inherit").attr("stroke-opacity",r[t].style.strokeOpacity||"inherit").attr("stroke-width",r[t].style.strokeWidth||"inherit").listen("mouseover",n).listen("mouseout",s).parent().append("text").attr("class",f).attr("x",b+w/2).attr("y",r[t].data[0]>0?A-5:A+v+(_.height-2)).attr("fill",r[t].style.fillColor||"inherit").text(M).parent(),k+=r[t].data[0];const S={type:"scale",start:{x:1,y:0},stop:{x:1,y:1},duration:y,easing:p,frequency:g};o.attr("transform",S)}(a,r,i,n,s)}};r.extend(r.src.charts.financial.waterfall.renderer,a)}(),function(){const t=r.src.lib.overslash,e=r.src.util.util1,a=r.src.util.util2;const i={init(e,a){!function(e,a){t.extend(a,{legend:{enabled:!1},xAxis:{type:"categories"}}),e.forEach(t=>{t.visible=!0,t.style.fillColor="slategrey",t.style.stroke="slategrey"})}(e,a)},addDemo(e,a){!function(e,a){const r=t.clone(e[0]);[{label:"Item 1",type:"start",data:[10]},{label:"Item 2",type:"",data:[6]},{label:"Item 3",type:"",data:[2]},{label:"Item 4",type:"",data:[-5]},{label:"Item 5",type:"",data:[2]},{label:"Item 6",type:"",data:[-2]},{label:"Item 7",type:"end",data:[0]}].forEach((a,i)=>{e[i]=t.extend({},r,a)}),a.title.label="Demo Chart"}(e,a)},normalizeSeries(t,e,r){!function(t,e){const{categories:r}=e.xAxis;let i=[];"start"!==t[0].type&&(i=[],t.forEach((t,e)=>{i[e]=t.data}),t.unshift({label:"Undefined!",type:"start",color:null,data:a.arSum(i)})),"end"!==t[t.length-1].type&&(i=[],t.forEach((t,e)=>{i[e]=t.data}),t.push({label:"Undefined!",type:"end",color:null,data:a.arSum(i)})),r.data=[];for(let e=0;e<t.length;e++)r.data[e]=t[e].label;i=[],t[t.length-1].data[0]=0,t.forEach((t,e)=>{i[e]=t.data}),t[t.length-1].data[0]=a.arSum(i)[0],t.forEach(t=>{t.private={}})}(t,e)},computeAxisSettings(t,r){!function(t,r){r.xAxis.data.min=0,r.xAxis.data.max=r.chart.grid.width-r.xAxis.data.min/2,r.xAxis.data.width=r.chart.grid.width,r.xAxis.data.scale=r.chart.grid.width/r.xAxis.categories.data.length,r.xAxis.data.numberOfElements=r.xAxis.categories.data.length,r.yAxis.title.x=null===r.yAxis.title.x?r.constants.left-10:r.yAxis.title.x,r.yAxis.title.y=null===r.yAxis.title.y?r.chart.grid.height/2:r.yAxis.title.y,r.yAxis.max=null===r.yAxis.max?function(){const e=[];let r=0,i=0;return t.forEach((t,a)=>{e[a]=t.data[0]}),e.pop(),e.forEach(t=>{i+=t,r=i>r?i:r}),a.ceil10(r)}():r.yAxis.max,r.yAxis.min=null===r.yAxis.min?0:r.yAxis.min,r.yAxis.minor=null===r.yAxis.minor?(r.yAxis.max-r.yAxis.min)/4:r.yAxis.minor;const i=e.computeAxisRange(r.yAxis.max,r.yAxis.min,r.yAxis.minor);r.yAxis.max=i.max,r.yAxis.min=i.min,r.yAxis.minor=i.minor,r.yAxis.exp=a.toPrecision(r.yAxis.min)+1,r.yAxis.scale=r.chart.grid.height/(r.yAxis.max-r.yAxis.min),r.yAxis.interval={number:Math.round((r.yAxis.max-r.yAxis.min)/r.yAxis.minor),height:r.chart.grid.height/((r.yAxis.max-r.yAxis.min)/r.yAxis.minor)}}(t,r)},findMatch:(t,e,a,r)=>(function(t,e,a,r){return{point:r.target.classList.value.match(/\d+/g)[0]}})(0,0,0,r),setTooltip:(t,e,a,r,i)=>(function(t,e,a,r,i){const n=i.point;t.orientation.type="horizontal",t.frameColor=a[n].style.fillColor||"inherit",t.anchor={x:a[n].private.pos.x+a[n].private.pos.width/2,y:a[n].private.pos.y},t.title=e.xAxis.categories.data[n];const s=a[n].prefix?a[n].prefix:"",l=a[n].suffix?a[n].suffix:"";t.content[0]={label:"",value:a[n].data[0]>0?s+a[n].data[0]+l:`-${s+Math.abs(a[n].data[0])+l}`,suffix:a[n].suffix,color:a[n].style.fillColor||"inherit"},t.limits={max:{x:e.chart.width-e.chart.grid.x,y:e.chart.height},min:{x:0,y:0}}})(t,e,a,0,i)};r.extend(r.src.charts.financial.waterfall.util,i)}(),function(){const t={matchDate(t,e,a,r){var i,n,s,l,o;if("number"==typeof t&&"number"==typeof e&&"number"==typeof a&&"number"==typeof r)return n=(n=(i=new Date(t+r*a)).toUTCString().split(" "))[0]+" "+n[1]+" "+n[2]+" "+n[3],s=c(i.getUTCHours()),l=c(i.getUTCMinutes()),o=c(i.getUTCSeconds()),a>=864e5?n:e*a>864e5?n+" "+s+":"+l:e*a>36e5?s+":"+l:e*a>6e4?s+":"+l+":"+o:e*a>1e3?o+"."+r*a:r*a+" milliseconds";function c(t){return t<10&&(t="0"+t),t}},periods(t){const e=t/31536e6;return"number"!=typeof t?t:{ms:t,sec:t/1e3,min:t/6e4,h:t/36e5,d:t/864e5,w:t/432e6,m:12*e,q:4*e,s:2*e,y:e}},closestPeriod(t,e){let a,r=100,i=null;if("object"!=typeof t||"number"!=typeof e)return t;for(a in t)Math.abs(t[a]-e)<r&&(r=Math.abs(t[a]-e),i=a);return"d"===i&&t.d<1&&(i="h"),"h"===i&&t.h<1&&(i="min"),"min"===i&&t.min<1&&(i="sec"),"sec"===i&&t.sec<1&&(i="ms"),i},intervalPeriod(t,e){const a=this.closestPeriod(t,e),r=t[a];return"object"!=typeof t||"number"!=typeof e?t:{type:a,nbr:Math.floor(r/Math.ceil(r/e)),multiplier:Math.ceil(r/e)}},addMil:(t,e)=>"number"!=typeof t||"number"!=typeof e||e<0?t:t+e,addSec:(t,e)=>"number"!=typeof t||"number"!=typeof e||e<0?t:t+1e3*e,addMin:(t,e)=>"number"!=typeof t||"number"!=typeof e||e<0?t:t+6e4*e,addHour:(t,e)=>"number"!=typeof t||"number"!=typeof e||e<0?t:t+36e5*e,addDay:(t,e)=>"number"!=typeof t||"number"!=typeof e||e<0?t:t+864e5*e,addMonth(t,e){let a,r,i=new Date(t),n=i.getFullYear(),s=i.getMonth(),l=i.getDate();if("number"!=typeof t||"number"!=typeof e||e<0)return t;s+=e;do{s>12&&(s-=12,n+=1)}while(s>12);return a=Date.UTC(n,s,l),r=new Date(a),r.getDate()!==l?a-864e5*r.getDate():a},buildMarkers(t,e,a){let r,i,n;if("number"!=typeof t||"number"!=typeof e||"number"!=typeof a)return null;for(r={pos:[],label:[]},i=Math.floor(e/a),n=0;n<=a;n++)r.pos.push(i*n),r.label.push(i*n+t);return r},buildDateMarkers(t,e,a){var r,i,n,s,l=this.intervalPeriod(this.periods(e),a),o=l.type;if("number"!=typeof t||"number"!=typeof e||"number"!=typeof a)return null;function c(e,a){for(l.time.hour=[],l.time.min=[],l.time.ms=[],s=0;s<=l.nbr;s++)0,i=0,n=[],r=e(t,a*s),l.pos.push(r-t),i=new Date(r),n=i.toUTCString().split(" "),l.time.hour.push(n[4].slice(0,5)),l.time.min.push(n[4]),l.time.ms.push(r-t),l.fullLabel.push(n[1]+" "+n[2]+" '"+n[3].slice(2,4)),l.label.push(n[2]+" '"+n[3].slice(2,4))}switch(l.pos=[],l.time=[],l.label=[],l.fullLabel=[],o){case"ms":c(this.addMil,l.multiplier),l.label=l.time.ms;break;case"sec":c(this.addSec,l.multiplier),l.label=l.time.min;break;case"min":c(this.addMin,l.multiplier),l.label=l.time.min;break;case"h":c(this.addHour,l.multiplier),l.label=l.time.hour;break;case"d":c(this.addDay,l.multiplier),l.label=l.fullLabel;break;case"w":c(this.addDay,5*l.multiplier),l.label=l.fullLabel;break;case"m":c(this.addMonth,l.multiplier);break;case"q":c(this.addMonth,3*l.multiplier);break;case"s":c(this.addMonth,6*l.multiplier);break;case"y":c(this.addMonth,12*l.multiplier)}return l},computeAxisRange:(t,e,a)=>t>0&&e>=0||t<0&&e<=0?{max:t,min:e,minor:a}:(t>Math.abs(e)?e=t/Math.floor(t/e):t=e/Math.floor(e/t),{max:t,min:e,minor:a=0===e?t/Math.floor(t/a):0===t?e/Math.floor(e/a):t>Math.abs(e)?e/Math.floor(e/a):t/Math.floor(t/a)})};r.extend(r.src.util.util1,t)}(),function(){const t=r.src.lib.overslash,e={_decimalAdjust:(t,e,a)=>void 0===a||0==+a?Math[t](e):(e=+e,a=+a,isNaN(e)||"number"!=typeof a||a%1!=0?NaN:(e=e.toString().split("e"),+((e=(e=Math[t](+(e[0]+"e"+(e[1]?+e[1]-a:-a)))).toString().split("e"))[0]+"e"+(e[1]?+e[1]+a:a)))),_exp(t){let e=0;if(t>=1||0===t)return 1;do{t*=10,e-=1}while(Math.floor(t)<1);return e},arSum(e){var a,r,i=[],n=0;if(t.isArray(e)){for(a=0;a<e.length;a++)n<e[a].length&&(n=e[a].length);for(a=0;a<n;a++)for(r=0;r<e.length;r++)!t.isUndefined(i[a])&&t.isNumber(i[a])||(i[a]=0),!t.isUndefined(e[r][a])&&t.isNumber(e[r][a])||(e[r][a]=0),i[a]+=e[r][a];return i}return[0]},floor10(t){return"number"!=typeof t?t:this._decimalAdjust("floor",t,this._exp(t))},ceil10(t){return"number"!=typeof t?t:this._decimalAdjust("ceil",t,this._exp(t))},round10(t){return"number"!=typeof t?t:this._decimalAdjust("round",t,this._exp(t))},toPrecision(t){let e=0;if("number"!=typeof t)return t;if(t%1==0)for(;Math.floor(t)>0;)e+=1,t/=10;else{0!==Math.floor(t)&&(e=this.toPrecision(Math.floor(t)));do{t*=10,e+=1}while(t%1!=0)}return e},toRound:(t,e)=>"number"!=typeof t?t:"number"!=typeof e||e<=0||e%1?"error":Math.round(t*Math.pow(10,e))/Math.pow(10,e)};r.extend(r.src.util.util2,e)}(),e});